/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.utils;

import fr.atesab.act.ACTMod;
import fr.atesab.act.utils.ItemUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class ChatUtils {
    public static final char MODIFIER = '\u00a7';

    public static void error(String error) {
        ChatUtils.send((ITextComponent)ChatUtils.getErrorPrefix().func_240702_b_(error));
    }

    public static IFormattableTextComponent getErrorPrefix() {
        return ChatUtils.getPrefix((ITextComponent)new TranslationTextComponent("gui.act.error").func_240699_a_(TextFormatting.RED), TextFormatting.WHITE);
    }

    public static IFormattableTextComponent getPrefix() {
        return ChatUtils.getPrefix(null, null);
    }

    private static IFormattableTextComponent getPrefix(ITextComponent notif, TextFormatting endColor) {
        IFormattableTextComponent p = new StringTextComponent("").func_240699_a_(endColor != null ? endColor : TextFormatting.WHITE).func_230529_a_((ITextComponent)new StringTextComponent("[").func_240699_a_(TextFormatting.RED).func_230529_a_((ITextComponent)new StringTextComponent("ACT-Mod").func_240699_a_(TextFormatting.GOLD)));
        if (notif != null) {
            p.func_230529_a_((ITextComponent)new StringTextComponent("/").func_240699_a_(TextFormatting.WHITE)).func_230529_a_(notif);
        }
        return p.func_230529_a_((ITextComponent)new StringTextComponent("]").func_240699_a_(TextFormatting.RED)).func_230529_a_((ITextComponent)new StringTextComponent(" "));
    }

    public static void itemStack(ItemStack itemStack) {
        if (itemStack != null) {
            CompoundNBT item = new CompoundNBT();
            item.func_74778_a("id", itemStack.func_77973_b().getRegistryName().toString());
            item.func_74768_a("Count", itemStack.func_190916_E());
            if (itemStack.func_77978_p() != null) {
                item.func_218657_a("tag", (INBT)itemStack.func_77978_p());
            }
            ChatUtils.send((ITextComponent)ChatUtils.getPrefix().func_230529_a_((ITextComponent)new TranslationTextComponent("gui.act.give.msg").func_240702_b_(": ").func_240699_a_(TextFormatting.GOLD).func_230529_a_((ITextComponent)itemStack.func_151000_E().func_230532_e_().func_240700_a_(style -> {
                style.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230551_b_, (Object)new HoverEvent.ItemHover(itemStack)));
                style.func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + ACTMod.ACT_COMMAND.getName() + " " + ACTMod.ACT_COMMAND.SC_OPEN_GIVER.getName() + " " + ItemUtils.getGiveCode(itemStack)));
                return style;
            }))));
        } else {
            ChatUtils.error(I18n.func_135052_a((String)"gui.act.give.fail2", (Object[])new Object[0]));
        }
    }

    public static void send(ITextComponent message) {
        ClientPlayerEntity plr = Minecraft.func_71410_x().field_71439_g;
        if (plr != null) {
            plr.func_145747_a(message, plr.func_110124_au());
        }
    }

    public static void show(String message) {
        ChatUtils.send((ITextComponent)ChatUtils.getPrefix().func_240702_b_(message));
    }

    private ChatUtils() {
    }
}

