/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.utils;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import fr.atesab.act.ACTMod;
import fr.atesab.act.utils.Tuple;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class GuiUtils {
    public static final Button.IPressable EMPTY_PRESS = b -> {};

    public static void addToClipboard(String text) {
        StringSelection select = new StringSelection(text);
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        cb.setContents(select, select);
    }

    public static void displayScreen(Screen screen) {
        GuiUtils.displayScreen(screen, false);
    }

    public static void displayScreen(Screen screen, boolean forceDelay) {
        Minecraft mc = Minecraft.func_71410_x();
        if (forceDelay || mc.field_71462_r instanceof ChatScreen) {
            new DelayScreen(screen, 20L);
        } else {
            mc.func_147108_a(screen);
        }
    }

    public static void drawBox(int x, int y, int width, int height, float zLevel) {
        RenderSystem.disableRescaleNormal();
        RenderHelper.func_74518_a();
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
        GuiUtils.drawGradientRect(x - 3, y - 4, x + width + 3, y - 3, -267386864, -267386864, zLevel -= 50.0f);
        GuiUtils.drawGradientRect(x - 3, y + height + 3, x + width + 3, y + height + 4, -267386864, -267386864, zLevel);
        GuiUtils.drawGradientRect(x - 3, y - 3, x + width + 3, y + height + 3, -267386864, -267386864, zLevel);
        GuiUtils.drawGradientRect(x - 4, y - 3, x - 3, y + height + 3, -267386864, -267386864, zLevel);
        GuiUtils.drawGradientRect(x + width + 3, y - 3, x + width + 4, y + height + 3, -267386864, -267386864, zLevel);
        GuiUtils.drawGradientRect(x - 3, y - 3 + 1, x - 3 + 1, y + height + 3 - 1, 0x505000FF, 1344798847, zLevel);
        GuiUtils.drawGradientRect(x + width + 2, y - 3 + 1, x + width + 3, y + height + 3 - 1, 0x505000FF, 1344798847, zLevel);
        GuiUtils.drawGradientRect(x - 3, y - 3, x + width + 3, y - 3 + 1, 0x505000FF, 0x505000FF, zLevel);
        GuiUtils.drawGradientRect(x - 3, y + height + 2, x + width + 3, y + height + 3, 1344798847, 1344798847, zLevel);
        RenderSystem.enableLighting();
        RenderSystem.enableDepthTest();
        RenderHelper.func_227780_a_();
        RenderSystem.enableRescaleNormal();
    }

    public static void color3f(float r, float g, float b) {
        GL11.glColor3f((float)r, (float)g, (float)b);
    }

    public static void drawCenterString(FontRenderer font, String text, int x, int y, int color) {
        font.getClass();
        GuiUtils.drawCenterString(font, text, x, y, color, 9);
    }

    public static void drawCenterString(FontRenderer font, String text, int x, int y, int color, int height) {
        GuiUtils.drawString(font, text, x - font.func_78256_a(text) / 2, y, color, height);
    }

    public static void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor, float zLevel) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_225582_a_((double)right, (double)top, (double)zLevel).func_227885_a_(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_225582_a_((double)left, (double)top, (double)zLevel).func_227885_a_(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_225582_a_((double)left, (double)bottom, (double)zLevel).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        bufferbuilder.func_225582_a_((double)right, (double)bottom, (double)zLevel).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void drawGradientRect(int left, int top, int right, int bottom, int leftColor, int topColor, int rightColor, int bottomColor, float zLevel) {
        float f = (float)(leftColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(leftColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(leftColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(leftColor & 0xFF) / 255.0f;
        float f4 = (float)(topColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(topColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(topColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(topColor & 0xFF) / 255.0f;
        float f8 = (float)(rightColor >> 24 & 0xFF) / 255.0f;
        float f9 = (float)(rightColor >> 16 & 0xFF) / 255.0f;
        float f10 = (float)(rightColor >> 8 & 0xFF) / 255.0f;
        float f11 = (float)(rightColor & 0xFF) / 255.0f;
        float f12 = (float)(bottomColor >> 24 & 0xFF) / 255.0f;
        float f13 = (float)(bottomColor >> 16 & 0xFF) / 255.0f;
        float f14 = (float)(bottomColor >> 8 & 0xFF) / 255.0f;
        float f15 = (float)(bottomColor & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_225582_a_((double)right, (double)top, (double)zLevel).func_227885_a_(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_225582_a_((double)left, (double)top, (double)zLevel).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        bufferbuilder.func_225582_a_((double)left, (double)bottom, (double)zLevel).func_227885_a_(f9, f10, f11, f8).func_181675_d();
        bufferbuilder.func_225582_a_((double)right, (double)bottom, (double)zLevel).func_227885_a_(f13, f14, f15, f12).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void drawItemStack(ItemRenderer itemRender, ItemStack itemstack, int x, int y) {
        if (itemstack == null || itemstack.func_190926_b()) {
            return;
        }
        RenderSystem.enableDepthTest();
        itemRender.func_180450_b(itemstack, x, y);
        itemRender.func_180453_a(Minecraft.func_71410_x().field_71466_p, itemstack, x, y, null);
        RenderSystem.disableBlend();
        RenderSystem.disableLighting();
    }

    public static void drawItemStack(ItemRenderer itemRender, Screen screen, ItemStack itemstack, int x, int y) {
        if (itemstack == null || itemstack.func_190926_b()) {
            return;
        }
        RenderSystem.enableDepthTest();
        itemRender.func_180450_b(itemstack, x, y);
        itemRender.func_180453_a(screen.getMinecraft().field_71466_p, itemstack, x, y, null);
        RenderSystem.disableBlend();
        RenderSystem.disableLighting();
    }

    public static void drawRect(MatrixStack stack, int left, int top, int right, int bottom, int color) {
        AbstractGui.func_238467_a_((MatrixStack)stack, (int)left, (int)top, (int)right, (int)bottom, (int)color);
    }

    public static void drawRelative(MatrixStack stack, Widget field, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        field.field_230690_l_ += offsetX;
        field.field_230691_m_ += offsetY;
        field.func_230430_a_(stack, mouseX + offsetX, mouseY + offsetY, partialTicks);
        field.field_230690_l_ -= offsetX;
        field.field_230691_m_ -= offsetY;
    }

    public static void drawRelativeToolTip(MatrixStack stack, Widget widget, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        widget.field_230690_l_ += offsetX;
        widget.field_230691_m_ += offsetY;
        widget.func_230443_a_(stack, mouseX + offsetX, mouseY + offsetY);
        widget.field_230690_l_ -= offsetX;
        widget.field_230691_m_ -= offsetY;
    }

    public static void drawRightString(FontRenderer font, String text, int x, int y, int color) {
        font.getClass();
        GuiUtils.drawCenterString(font, text, x, y, color, 9);
    }

    public static void drawRightString(FontRenderer font, String text, int x, int y, int color, int height) {
        GuiUtils.drawString(font, text, x - font.func_78256_a(text), y, color, height);
    }

    public static void drawRightString(FontRenderer font, String text, Widget field, int color) {
        GuiUtils.drawRightString(font, text, field.field_230690_l_, field.field_230691_m_, color, field.func_238483_d_());
    }

    public static void drawRightString(FontRenderer font, String text, Widget field, int color, int offsetX, int offsetY) {
        GuiUtils.drawRightString(font, text, field.field_230690_l_ + offsetX, field.field_230691_m_ + offsetY, color, field.func_238483_d_());
    }

    public static void drawScaledCustomSizeModalRect(int x, int y, float u, float v, int uWidth, int vHeight, int width, int height, float tileWidth, float tileHeight) {
        float scaleX = 1.0f / tileWidth;
        float scaleY = 1.0f / tileHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_((double)x, (double)(y + height), 0.0).func_225583_a_(u * scaleX, (v + (float)vHeight) * scaleY).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)(y + height), 0.0).func_225583_a_((u + (float)uWidth) * scaleX, (v + (float)vHeight) * scaleY).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)y, 0.0).func_225583_a_((u + (float)uWidth) * scaleX, v * scaleY).func_181675_d();
        bufferbuilder.func_225582_a_((double)x, (double)y, 0.0).func_225583_a_(u * scaleX, v * scaleY).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawString(FontRenderer font, String text, int x, int y, int color, int height) {
        int n = y + height / 2;
        font.getClass();
        ACTMod.drawString(font, text, x, n - 9 / 2, color);
    }

    public static void drawTextBox(FontRenderer font, int x, int y, int parentWidth, int parentHeight, float zLevel, String ... args) {
        List<String> text = Arrays.asList(args);
        int width = text.isEmpty() ? 0 : text.stream().mapToInt(arg_0 -> ((FontRenderer)font).func_78256_a(arg_0)).max().getAsInt();
        int n = text.size();
        font.getClass();
        int height = n * (1 + 9);
        Tuple<Integer, Integer> pos = GuiUtils.getRelativeBoxPos(x, y, width, height, parentWidth, parentHeight);
        GuiUtils.drawBox((Integer)pos.a, (Integer)pos.b, width, height, zLevel);
        text.forEach(l -> {
            ACTMod.drawString(font, l, (Integer)pos.a, (Integer)pos.b, -1);
            int n = (Integer)pos.b;
            font.getClass();
            pos.b = n + (1 + 9);
        });
    }

    public static int getRedGreen(boolean value) {
        return value ? -8913033 : -34953;
    }

    public static Tuple<Integer, Integer> getRelativeBoxPos(int x, int y, int width, int height, int parentWidth, int parentHeight) {
        if (x + width > parentWidth) {
            if ((x -= width + 5) < 0) {
                x = 0;
            }
        } else {
            x += 12;
        }
        if (y + height > parentHeight) {
            if ((y -= height + 5) < 0) {
                y = 0;
            }
        } else {
            y += 12;
        }
        return new Tuple<Integer, Integer>(x, y);
    }

    public static boolean isHover(Widget button, int mouseX, int mouseY) {
        return GuiUtils.isHover(button.field_230690_l_, button.field_230691_m_, button.func_230998_h_(), button.func_238483_d_(), mouseX, mouseY);
    }

    public static boolean isHover(int X, int Y, int sizeX, int sizeY, int mouseX, int mouseY) {
        return mouseX >= X && mouseX <= X + sizeX && mouseY >= Y && mouseY <= Y + sizeY;
    }

    private static class DelayScreen {
        private Screen screen;
        private long delay;

        DelayScreen(Screen screen, long delay) {
            this.screen = screen;
            this.delay = delay;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void onTick(TickEvent ev) {
            if (this.delay < 0L) {
                Minecraft.func_71410_x().func_147108_a(this.screen);
                MinecraftForge.EVENT_BUS.unregister((Object)this);
            } else {
                --this.delay;
            }
        }
    }
}

