/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.utils;

import com.google.common.collect.Multimap;
import com.google.gson.JsonParseException;
import com.google.gson.internal.LinkedTreeMap;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import fr.atesab.act.ACTMod;
import fr.atesab.act.utils.ChatUtils;
import fr.atesab.act.utils.CommandUtils;
import fr.atesab.act.utils.ItemReader;
import fr.atesab.act.utils.Tuple;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemUtils {
    public static final String NBT_CHILD_DISPLAY = "display";
    public static final String NBT_CHILD_ENCHANTMENTS = "Enchantments";
    public static final String NBT_CHILD_BOOK_ENCHANTMENTS = "StoredEnchantments";
    public static final String NBT_CHILD_EXPLOSIONS = "Explosions";
    public static final String NBT_CHILD_FIREWORKS = "Fireworks";
    public static final String NBT_CHILD_ATTRIBUTE_MODIFIER = "AttributeModifiers";
    private static final ItemReader ITEM_READER = new ItemReader();
    private static final Random RANDOM = ACTMod.RANDOM;
    private static final Map<String, Tuple<Long, CompoundNBT>> SKIN_CACHE = new HashMap<String, Tuple<Long, CompoundNBT>>();
    private static final Map<String, Tuple<Long, String>> UUID_CACHE = new HashMap<String, Tuple<Long, String>>();
    private static final Character[] RANDOM_CHAR = new Character[]{Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('M'), Character.valueOf('Z')};

    private static String addHyphen(String uuid) {
        if (uuid.length() < 20) {
            return uuid;
        }
        return uuid.substring(0, 8) + "-" + uuid.substring(8, 12) + "-" + uuid.substring(12, 16) + "-" + uuid.substring(16, 20) + "-" + uuid.substring(20, uuid.length());
    }

    public static ItemStack buildStack(Block block, int count, @Nullable String name, @Nullable String[] lore, @Nullable Tuple<Enchantment, Integer>[] enchantments) {
        return ItemUtils.buildStack(block.func_199767_j(), count, name, lore, enchantments);
    }

    public static ItemStack buildStack(Item item, int count, @Nullable String name, @Nullable String[] lore, @Nullable Tuple<Enchantment, Integer>[] enchantments) {
        ItemStack is = new ItemStack((IItemProvider)item, count);
        if (name != null) {
            is.func_200302_a((ITextComponent)new StringTextComponent(name));
        }
        if (lore != null) {
            ItemUtils.setLore(is, lore);
        }
        if (enchantments != null) {
            ItemUtils.setEnchantments(Arrays.asList(enchantments), is, is.func_77973_b().equals(Items.field_151134_bR));
        }
        return is;
    }

    public static boolean canGive(Minecraft mc) {
        for (int i = 0; i < 9; ++i) {
            if (mc.field_71439_g.field_71071_by.func_70301_a(i) != null && !mc.field_71439_g.field_71071_by.func_70301_a(i).func_77973_b().equals(Items.field_190931_a)) continue;
            return true;
        }
        return false;
    }

    public static List<AttributeData> getAttributes(ItemStack stack) {
        ArrayList<AttributeData> l = new ArrayList<AttributeData>();
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            stack.func_111283_C(slot).forEach((attribute, modifier) -> l.add(new AttributeData(slot, (AttributeModifier)modifier, (Attribute)attribute)));
        }
        return l;
    }

    public static int getColor(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        return tag == null || !tag.func_74764_b(NBT_CHILD_DISPLAY) || !tag.func_74775_l(NBT_CHILD_DISPLAY).func_74764_b("color") ? 10511680 : tag.func_74775_l(NBT_CHILD_DISPLAY).func_74762_e("color");
    }

    public static String getCustomTag(ItemStack stack, String key, String defaultValue) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return defaultValue;
        }
        return tag.func_74764_b(key) ? tag.func_74779_i(key) : defaultValue;
    }

    public static List<Tuple<Enchantment, Integer>> getEnchantments(ItemStack stack) {
        return ItemUtils.getEnchantments(stack, false);
    }

    public static List<Tuple<Enchantment, Integer>> getEnchantments(ItemStack stack, boolean book) {
        LinkedTreeMap map = new LinkedTreeMap((e1, e2) -> e2.func_77320_a().compareToIgnoreCase(e1.func_77320_a()));
        Registry.field_212628_q.forEach(e -> {
            Integer cfr_ignored_0 = (Integer)map.put(e, (Object)0);
        });
        String key = book ? NBT_CHILD_BOOK_ENCHANTMENTS : NBT_CHILD_ENCHANTMENTS;
        ListNBT list = stack.func_77978_p() != null && stack.func_77978_p().func_74764_b(key) ? stack.func_77978_p().func_150295_c(key, 10) : new ListNBT();
        for (int i = 0; i < list.size(); ++i) {
            Enchantment ench;
            CompoundNBT tag = list.func_150305_b(i);
            if (!tag.func_74764_b("id") || (ench = (Enchantment)Registry.field_212628_q.func_82594_a(ResourceLocation.func_208304_a((String)tag.func_74779_i("id")))) == null) continue;
            map.put((Object)ench, (Object)(tag.func_74764_b("lvl") ? tag.func_74762_e("lvl") : 0));
        }
        ArrayList<Tuple<Enchantment, Integer>> result = new ArrayList<Tuple<Enchantment, Integer>>();
        map.keySet().forEach(e -> result.add(new Tuple<Enchantment, Object>((Enchantment)e, map.get(e))));
        return result;
    }

    public static ExplosionInformation getExplosionInformation(@Nullable CompoundNBT explosion) {
        return explosion == null ? new ExplosionInformation() : new ExplosionInformation(explosion);
    }

    public static ItemStack getFromGiveCode(String code) {
        if (code == null || code.isEmpty()) {
            return null;
        }
        return ITEM_READER.readItem(code);
    }

    public static String getGiveCode(ItemStack itemStack) {
        return ItemUtils.getGiveCode(itemStack, true);
    }

    public static String getGiveCode(ItemStack itemStack, boolean showCount) {
        boolean noTag;
        boolean bl = noTag = itemStack.func_77978_p() != null && !itemStack.func_77978_p().isEmpty();
        return itemStack == null ? "" : Registry.field_212630_s.func_177774_c((Object)itemStack.func_77973_b()).toString() + (noTag ? itemStack.func_77978_p().toString() : "") + (itemStack.func_190916_E() == 1 && showCount ? "" : " " + itemStack.func_190916_E());
    }

    public static ItemStack getHead(ItemStack is, String name) throws IOException, CommandSyntaxException, NoSuchElementException {
        CompoundNBT skullOwner = is.func_190925_c("SkullOwner");
        String uuid = (String)((Tuple)ItemUtils.getUUIDByNames((String[])new String[]{name}).stream().findFirst().get()).b;
        skullOwner.func_197643_a(ItemUtils.getSkinInformationFromUUID(uuid));
        skullOwner.func_74778_a("Name", name);
        skullOwner.func_74778_a("Id", ItemUtils.addHyphen(uuid));
        return is;
    }

    public static ItemStack getHead(ItemStack is, String uuid, String url, String name) {
        CompoundNBT skullOwner = is.func_190925_c("SkullOwner");
        skullOwner.func_74778_a("Id", ItemUtils.addHyphen(uuid.replaceAll("-", "")));
        ListNBT textures = new ListNBT();
        CompoundNBT texture = new CompoundNBT();
        texture.func_74778_a("Value", Base64.getEncoder().encodeToString(("{\"textures\":{\"SKIN\":{\"url\":\"" + url + "\"}}}").getBytes()));
        textures.add((Object)texture);
        ItemUtils.getOrCreateSubCompound(skullOwner, "Properties").func_218657_a("textures", (INBT)textures);
        if (name != null) {
            skullOwner.func_74778_a("Name", name);
        } else if (skullOwner.func_74764_b("Name")) {
            skullOwner.func_82580_o("Name");
        }
        return is;
    }

    public static ItemStack getHead(String name) throws IOException, CommandSyntaxException, NoSuchElementException {
        return ItemUtils.getHead(new ItemStack((IItemProvider)Items.field_196184_dx, 1), name);
    }

    public static ItemStack getHead(String uuid, String url, String name) {
        return ItemUtils.getHead(new ItemStack((IItemProvider)Items.field_196184_dx, 1), uuid, url, name);
    }

    public static List<ItemStack> getHeads(Collection<ClientPlayerEntity> players) throws IOException, CommandSyntaxException, NoSuchElementException {
        return ItemUtils.getHeads((String[])players.stream().map(PlayerEntity::func_195047_I_).toArray(String[]::new));
    }

    public static List<ItemStack> getHeads(String ... names) throws IOException, CommandSyntaxException, NoSuchElementException {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ItemUtils.getUUIDByNames(names).stream().forEach(tuple -> {
            try {
                ItemStack stack = new ItemStack((IItemProvider)Items.field_196184_dx, 1);
                CompoundNBT skullOwner = stack.func_190925_c("SkullOwner");
                String uuid = (String)tuple.b;
                skullOwner.func_197643_a(ItemUtils.getSkinInformationFromUUID(uuid));
                skullOwner.func_74778_a("Name", (String)tuple.a);
                skullOwner.func_74778_a("Id", ItemUtils.addHyphen(uuid));
                stacks.add(stack);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return stacks;
    }

    private static String unformatLore(String format) {
        return format.startsWith("\"") && format.endsWith("\"") && format.length() > 1 ? format.substring(1, format.length() - 1) : format;
    }

    public static String[] getLore(ItemStack stack) {
        CompoundNBT display = stack.func_190925_c(NBT_CHILD_DISPLAY);
        ListNBT nbtTagList = display.func_150295_c("Lore", 8);
        String[] array = new String[nbtTagList.size()];
        for (int j = 0; j < nbtTagList.size(); ++j) {
            String s = nbtTagList.func_150307_f(j);
            array[j] = "";
            try {
                IFormattableTextComponent iformattabletextcomponent1 = ITextComponent.Serializer.func_240643_a_((String)s);
                if (iformattabletextcomponent1 == null) continue;
                array[j] = iformattabletextcomponent1.getString();
                continue;
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
        }
        return array;
    }

    private static CompoundNBT getOrCreateSubCompound(CompoundNBT compound, String key) {
        if (compound.func_150297_b(key, 10)) {
            return compound.func_74775_l(key);
        }
        CompoundNBT nbttagcompound = new CompoundNBT();
        compound.func_218657_a(key, (INBT)nbttagcompound);
        return nbttagcompound;
    }

    public static PotionInformation getPotionInformation(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        List customEffects = PotionUtils.func_185192_b((CompoundNBT)tag);
        return new PotionInformation(tag != null && tag.func_74764_b("CustomPotionColor") ? tag.func_74762_e("CustomPotionColor") : -1, PotionUtils.func_185187_c((CompoundNBT)tag), customEffects);
    }

    public static ItemStack getRandomFireworks() {
        CompoundNBT fwt = new CompoundNBT();
        int flight = RANDOM.nextInt(3);
        fwt.func_74768_a("Flight", flight + 1);
        ListNBT explosions = new ListNBT();
        int exp = RANDOM.nextInt(7 - flight) + 1;
        for (int i = 0; i < exp; ++i) {
            explosions.add((Object)new ExplosionInformation().getTag());
        }
        fwt.func_218657_a(NBT_CHILD_EXPLOSIONS, (INBT)explosions);
        ItemStack fw = new ItemStack((IItemProvider)Items.field_196152_dE);
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a(NBT_CHILD_FIREWORKS, (INBT)fwt);
        fw.func_77982_d(tag);
        List list = ForgeRegistries.ENTITIES.getValues().stream().filter(EntityType::func_200720_b).collect(Collectors.toList());
        fw.func_200302_a((ITextComponent)new TranslationTextComponent(((EntityType)list.get(RANDOM.nextInt(list.size()))).func_210760_d()).func_240699_a_(TextFormatting.values()[RANDOM.nextInt(16)]).func_240702_b_(" " + CommandUtils.getRandomElement(RANDOM_CHAR) + RANDOM.nextInt(1000)));
        ItemUtils.setLore(fw, new String[]{TextFormatting.YELLOW + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"cmd.act.rfw", (Object[])new Object[0])});
        return fw;
    }

    public static CompoundNBT getSkinInformationFromUUID(String uuid) throws IOException, CommandSyntaxException {
        if (SKIN_CACHE.containsKey(uuid) && (Long)ItemUtils.SKIN_CACHE.get((Object)uuid).a + 60000L > System.currentTimeMillis()) {
            return ((CompoundNBT)ItemUtils.SKIN_CACHE.get((Object)uuid).b).func_74737_b();
        }
        CompoundNBT requestCompound = JsonToNBT.func_180713_a((String)ItemUtils.sendRequest("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid.replaceAll("-", ""), null, null, null));
        CompoundNBT newTag = new CompoundNBT();
        if (requestCompound.func_150297_b("properties", 9)) {
            ListNBT properties = requestCompound.func_150295_c("properties", 10);
            ListNBT textures = new ListNBT();
            properties.forEach(base -> {
                CompoundNBT tex = (CompoundNBT)base;
                CompoundNBT newTex = new CompoundNBT();
                if (tex.func_150297_b("value", 8)) {
                    newTex.func_74778_a("Value", tex.func_74779_i("value"));
                }
                textures.add((Object)newTex);
            });
            newTag.func_218657_a("Properties", (INBT)new CompoundNBT());
            newTag.func_74778_a("Id", ItemUtils.addHyphen(uuid.replaceAll("-", "")));
            newTag.func_74775_l("Properties").func_218657_a("textures", (INBT)textures);
        }
        SKIN_CACHE.put(uuid, new Tuple<Long, CompoundNBT>(System.currentTimeMillis(), newTag.func_74737_b()));
        return newTag;
    }

    public static List<Tuple<String, String>> getUUIDByNames(String ... names) throws IOException, CommandSyntaxException {
        CompoundNBT tag;
        ArrayList<Tuple<String, String>> list = new ArrayList<Tuple<String, String>>();
        String query = Arrays.stream(names).map(n -> {
            if (UUID_CACHE.containsKey(n) && (Long)ItemUtils.UUID_CACHE.get((Object)n).a + 60000L > System.currentTimeMillis()) {
                list.add(new Tuple((String)n, ItemUtils.UUID_CACHE.get((Object)n).b));
                return null;
            }
            return '\"' + n + '\"';
        }).filter(s -> s != null).collect(Collectors.joining(","));
        if (!query.isEmpty() && (tag = JsonToNBT.func_180713_a((String)("{data:" + ItemUtils.sendRequest("https://api.mojang.com/profiles/minecraft", "POST", "application/json", "[" + query + "]") + "}"))).func_150297_b("data", 9)) {
            tag.func_150295_c("data", 10).forEach(base -> {
                CompoundNBT data = (CompoundNBT)base;
                if (data.func_150297_b("id", 8) && data.func_150297_b("name", 8)) {
                    String name = data.func_74779_i("name");
                    String id = data.func_74779_i("id");
                    list.add(new Tuple<String, String>(name, id));
                    UUID_CACHE.put(name, new Tuple<Long, String>(System.currentTimeMillis(), id));
                }
            });
        }
        return list;
    }

    public static void give(ItemStack stack) {
        ItemUtils.give(Minecraft.func_71410_x(), stack);
    }

    public static void give(ItemStack stack, int slot) {
        ItemUtils.give(Minecraft.func_71410_x(), stack, slot);
    }

    public static void give(List<ItemStack> stack) {
        ItemUtils.give(Minecraft.func_71410_x(), stack);
    }

    @Deprecated
    public static void give(Minecraft mc, ItemStack stack) {
        if (mc.field_71439_g != null && mc.field_71439_g.func_184812_l_()) {
            if (stack != null) {
                for (int i = 0; i < 9; ++i) {
                    if (!((ItemStack)mc.field_71439_g.field_71071_by.field_70462_a.get(i)).func_190926_b()) continue;
                    ItemUtils.give(mc, stack, 36 + i);
                    ChatUtils.itemStack(stack);
                    return;
                }
            }
            ChatUtils.error(I18n.func_135052_a((String)"gui.act.give.fail", (Object[])new Object[0]));
        } else {
            ChatUtils.error(I18n.func_135052_a((String)"gui.act.nocreative", (Object[])new Object[0]));
        }
    }

    @Deprecated
    public static void give(Minecraft mc, ItemStack stack, int slot) {
        if (mc.field_71439_g.func_184812_l_()) {
            mc.field_71442_b.func_78761_a(stack, slot);
        } else {
            ChatUtils.error(I18n.func_135052_a((String)"gui.act.nocreative", (Object[])new Object[0]));
        }
    }

    @Deprecated
    public static void give(Minecraft mc, List<ItemStack> stack) {
        if (mc.field_71439_g != null && mc.field_71439_g.func_184812_l_()) {
            int i = 0;
            block0: for (int j = 0; j < stack.size(); ++j) {
                ItemStack is = stack.get(j);
                while (i < 9) {
                    if (((ItemStack)mc.field_71439_g.field_71071_by.field_70462_a.get(i)).func_190926_b()) {
                        ItemUtils.give(mc, is, 36 + i);
                        ChatUtils.itemStack(is);
                        ++i;
                        continue block0;
                    }
                    ++i;
                }
                ChatUtils.error(I18n.func_135052_a((String)"gui.act.give.fail", (Object[])new Object[0]));
                return;
            }
        } else {
            ChatUtils.error(I18n.func_135052_a((String)"gui.act.nocreative", (Object[])new Object[0]));
        }
    }

    public static boolean isUnbreakable(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        return tag != null && tag.func_74767_n("Unbreakable");
    }

    private static String sendRequest(String url, String method, String contentType, String content) throws IOException {
        String line;
        Proxy proxy;
        Proxy proxy2 = proxy = Minecraft.func_71410_x() == null ? null : Minecraft.func_71410_x().func_110437_J();
        if (proxy == null) {
            proxy = Proxy.NO_PROXY;
        }
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection(proxy);
        if (method != null) {
            connection.setRequestMethod(method);
        }
        if (contentType != null) {
            connection.setRequestProperty("Content-Type", contentType);
        }
        connection.setRequestProperty("Content-Language", "en-US");
        connection.setDoOutput(true);
        if (content != null) {
            connection.setRequestProperty("Content-Length", "" + content.getBytes().length);
            connection.setUseCaches(false);
            connection.setDoInput(true);
            DataOutputStream output = new DataOutputStream(connection.getOutputStream());
            output.writeBytes(content);
            output.flush();
            output.close();
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuffer buffer = new StringBuffer();
        while ((line = bufferedReader.readLine()) != null) {
            buffer.append("\n" + line);
        }
        return buffer.length() > 0 ? buffer.toString().substring(1) : "";
    }

    public static ItemStack setAttributes(List<AttributeData> attributes, ItemStack stack) {
        attributes.forEach(data -> stack.func_185129_a(((AttributeData)data).attribute, ((AttributeData)data).modifier, ((AttributeData)data).slot));
        return stack;
    }

    public static ItemStack setColor(ItemStack stack, int color) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new CompoundNBT());
        }
        CompoundNBT display = stack.func_190925_c(NBT_CHILD_DISPLAY);
        if (color == 10511680 && display.func_74764_b("color")) {
            display.func_82580_o("color");
        } else {
            display.func_74768_a("color", color);
        }
        return stack;
    }

    public static ItemStack setCustomTag(ItemStack stack, String key, String value) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            tag = new CompoundNBT();
            stack.func_77982_d(tag);
        }
        tag.func_74778_a(key, value);
        return stack;
    }

    public static ItemStack setEnchantments(List<Tuple<Enchantment, Integer>> enchantments, ItemStack stack) {
        return ItemUtils.setEnchantments(enchantments, stack, false);
    }

    public static ItemStack setEnchantments(List<Tuple<Enchantment, Integer>> enchantments, ItemStack stack, boolean book) {
        ListNBT nbttaglist = new ListNBT();
        enchantments.forEach(tuple -> {
            if ((Integer)tuple.b == 0) {
                return;
            }
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.func_74778_a("id", ((Enchantment)tuple.a).getRegistryName().toString());
            nbttagcompound.func_74768_a("lvl", ((Integer)tuple.b).intValue());
            nbttaglist.add((Object)nbttagcompound);
        });
        stack.func_196082_o().func_218657_a(book ? NBT_CHILD_BOOK_ENCHANTMENTS : NBT_CHILD_ENCHANTMENTS, (INBT)nbttaglist);
        return stack;
    }

    public static ItemStack setItem(Item item, ItemStack stack) {
        ItemStack is = new ItemStack((IItemProvider)item, stack.func_190916_E());
        is.func_77982_d(stack.func_77978_p());
        return is;
    }

    public static ItemStack setLore(ItemStack stack, String[] lore) {
        ListNBT nbtTagList = new ListNBT();
        for (String l : lore) {
            nbtTagList.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)new StringTextComponent(l))));
        }
        CompoundNBT display = stack.func_190925_c(NBT_CHILD_DISPLAY);
        display.func_218657_a("Lore", (INBT)nbtTagList);
        return stack;
    }

    public static ItemStack setPotionInformation(ItemStack stack, PotionInformation info) {
        ListNBT nbttaglist = new ListNBT();
        info.getCustomEffects().forEach(effect -> nbttaglist.add((Object)effect.func_82719_a(new CompoundNBT())));
        CompoundNBT tag = stack.func_196082_o();
        tag.func_74778_a("Potion", info.getMain().getRegistryName().toString());
        if (info.customColor != -1) {
            tag.func_74768_a("CustomPotionColor", info.customColor);
        } else if (tag.func_74764_b("CustomPotionColor")) {
            tag.func_82580_o("CustomPotionColor");
        }
        tag.func_218657_a("CustomPotionEffects", (INBT)nbttaglist);
        return stack;
    }

    public static ItemStack setUnbreakable(ItemStack stack, boolean value) {
        if (value) {
            stack.func_196082_o().func_74757_a("Unbreakable", true);
        } else {
            CompoundNBT tag = stack.func_77978_p();
            if (tag != null) {
                tag.func_82580_o("Unbreakable");
            }
        }
        return stack;
    }

    public static class AttributeModifierBuilder {
        private static final List<AttributeModifierBuilder> BUILDERS_INTERNAL = new ArrayList<AttributeModifierBuilder>();
        public static final List<AttributeModifierBuilder> BUILDERS = Collections.unmodifiableList(BUILDERS_INTERNAL);
        public static final AttributeModifierBuilder ARMOR;
        public static final AttributeModifierBuilder ARMOR_TOUGHNESS;
        public static final AttributeModifierBuilder KNOCKBACK_RESISTANCE;
        public static final AttributeModifierBuilder TOOL_ATTACK_DAMAGE;
        public static final AttributeModifierBuilder TOOL_ATTACK_SPEED;
        public static final AttributeModifierBuilder SWORD_ATTACK_DAMAGE;
        public static final AttributeModifierBuilder SWORD_ATTACK_SPEED;
        private AttributeModifier clone;
        private Attribute attribute;

        private AttributeModifierBuilder(Attribute attribute, AttributeModifier modifier) {
            this.clone = modifier;
            this.attribute = attribute;
            BUILDERS_INTERNAL.add(this);
        }

        public UUID getId() {
            return this.clone.func_111167_a();
        }

        public String getName() {
            return this.clone.func_111166_b();
        }

        public AttributeModifier build(double val, AttributeModifier.Operation op) {
            return new AttributeModifier(this.clone.func_111167_a(), this.clone.func_111166_b(), val, op);
        }

        public String getDescriptionId() {
            return this.attribute.func_233754_c_();
        }

        public AttributeData buildData(EquipmentSlotType slot, double val, AttributeModifier.Operation op) {
            return new AttributeData(slot, this.build(val, op), this.attribute);
        }

        static {
            ArmorItem armor = (ArmorItem)Items.field_234764_lt_;
            ToolItem tool = (ToolItem)Items.field_234756_kK_;
            SwordItem sword = (SwordItem)Items.field_234754_kI_;
            Multimap poolArmor = armor.func_111205_h(armor.func_185083_B_());
            Multimap poolTool = tool.func_111205_h(EquipmentSlotType.MAINHAND);
            Multimap poolSword = sword.func_111205_h(EquipmentSlotType.MAINHAND);
            ARMOR = new AttributeModifierBuilder(Attributes.field_233826_i_, (AttributeModifier)poolArmor.get((Object)Attributes.field_233826_i_).stream().findAny().get());
            ARMOR_TOUGHNESS = new AttributeModifierBuilder(Attributes.field_233827_j_, (AttributeModifier)poolArmor.get((Object)Attributes.field_233827_j_).stream().findAny().get());
            KNOCKBACK_RESISTANCE = new AttributeModifierBuilder(Attributes.field_233820_c_, (AttributeModifier)poolArmor.get((Object)Attributes.field_233820_c_).stream().findAny().get());
            TOOL_ATTACK_DAMAGE = new AttributeModifierBuilder(Attributes.field_233823_f_, (AttributeModifier)poolTool.get((Object)Attributes.field_233823_f_).stream().findAny().get());
            TOOL_ATTACK_SPEED = new AttributeModifierBuilder(Attributes.field_233825_h_, (AttributeModifier)poolTool.get((Object)Attributes.field_233825_h_).stream().findAny().get());
            SWORD_ATTACK_DAMAGE = new AttributeModifierBuilder(Attributes.field_233823_f_, (AttributeModifier)poolSword.get((Object)Attributes.field_233823_f_).stream().findAny().get());
            SWORD_ATTACK_SPEED = new AttributeModifierBuilder(Attributes.field_233825_h_, (AttributeModifier)poolSword.get((Object)Attributes.field_233825_h_).stream().findAny().get());
        }
    }

    public static final class PotionInformation {
        private int customColor;
        private List<EffectInstance> customEffects;
        private Potion main;

        public PotionInformation(int customColor, Potion main, List<EffectInstance> customEffects) {
            this.customColor = customColor;
            this.main = main;
            this.customEffects = customEffects;
        }

        public int getCustomColor() {
            return this.customColor;
        }

        public List<EffectInstance> getCustomEffects() {
            return this.customEffects;
        }

        public Potion getMain() {
            return this.main;
        }

        public PotionInformation customColor(int customColor) {
            this.customColor = customColor;
            return this;
        }

        public PotionInformation customEffects(List<EffectInstance> customEffects) {
            this.customEffects = customEffects;
            return this;
        }

        public PotionInformation main(Potion main) {
            this.main = main;
            return this;
        }
    }

    public static final class ExplosionInformation
    implements Cloneable {
        private int[] colors;
        private int[] fadeColors;
        private boolean trail;
        private boolean flicker;
        private FireworkRocketItem.Shape type;

        public ExplosionInformation() {
            this(CommandUtils.getRandomElement(FireworkRocketItem.Shape.values()), RANDOM.nextBoolean(), RANDOM.nextBoolean(), new int[RANDOM.nextInt(6) + 1], new int[RANDOM.nextInt(7)]);
            int i;
            this.colors = new int[RANDOM.nextInt(6 - ((this.trail ? 1 : 0) + (this.flicker ? 1 : 0))) + 1];
            for (i = 0; i < this.colors.length; ++i) {
                this.colors[i] = DyeColor.values()[RANDOM.nextInt(DyeColor.values().length)].func_196060_f();
            }
            for (i = 0; i < this.fadeColors.length; ++i) {
                this.fadeColors[i] = DyeColor.values()[RANDOM.nextInt(DyeColor.values().length)].func_196060_f();
            }
        }

        public ExplosionInformation(int type, boolean trail, boolean flicker, int[] colors, int[] fadeColors) {
            this(FireworkRocketItem.Shape.func_196070_a((int)type), trail, flicker, colors, fadeColors);
        }

        public ExplosionInformation(FireworkRocketItem.Shape type, boolean trail, boolean flicker, int[] colors, int[] fadeColors) {
            this.type = type;
            this.trail = trail;
            this.flicker = flicker;
            this.colors = colors;
            this.fadeColors = fadeColors;
        }

        public ExplosionInformation(CompoundNBT explosion) {
            this(explosion.func_74771_c("Type"), explosion.func_74767_n("Trail"), explosion.func_74767_n("Flicker"), explosion.func_74759_k("Colors"), explosion.func_74759_k("FadeColors"));
        }

        public ExplosionInformation clone() {
            return new ExplosionInformation(this.type, this.trail, this.flicker, this.colors, this.fadeColors);
        }

        public ExplosionInformation colors(int[] colors) {
            this.colors = colors;
            return this;
        }

        public ExplosionInformation fadeColors(int[] fadeColors) {
            this.fadeColors = fadeColors;
            return this;
        }

        public ExplosionInformation flicker(boolean flicker) {
            this.flicker = flicker;
            return this;
        }

        public int[] getColors() {
            return this.colors;
        }

        public int[] getFadeColors() {
            return this.fadeColors;
        }

        public CompoundNBT getTag() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74774_a("Type", (byte)this.type.func_196071_a());
            if (this.trail) {
                tag.func_74757_a("Trail", true);
            }
            if (this.flicker) {
                tag.func_74757_a("Flicker", true);
            }
            if (this.colors.length != 0) {
                tag.func_74783_a("Colors", this.colors);
            }
            if (this.fadeColors.length != 0) {
                tag.func_74783_a("FadeColors", this.fadeColors);
            }
            return tag;
        }

        public FireworkRocketItem.Shape getType() {
            return this.type;
        }

        public boolean isFlicker() {
            return this.flicker;
        }

        public boolean isTrail() {
            return this.trail;
        }

        public ExplosionInformation trail(boolean trail) {
            this.trail = trail;
            return this;
        }

        public ExplosionInformation type(FireworkRocketItem.Shape type) {
            this.type = type;
            return this;
        }
    }

    public static class AttributeData {
        private EquipmentSlotType slot;
        private AttributeModifier modifier;
        private Attribute attribute;

        public AttributeData(EquipmentSlotType slot, AttributeModifier modifier, Attribute attribute) {
            this.slot = slot;
            this.modifier = modifier;
            this.attribute = attribute;
        }

        public void setSlot(EquipmentSlotType slot) {
            this.slot = slot;
        }

        public void setModifier(AttributeModifier modifier) {
            this.modifier = modifier;
        }

        public void setAttribute(Attribute attribute) {
            this.attribute = attribute;
        }

        public Attribute getAttribute() {
            return this.attribute;
        }

        public AttributeModifier getModifier() {
            return this.modifier;
        }

        public EquipmentSlotType getSlot() {
            return this.slot;
        }
    }
}

