/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import fr.atesab.act.AdvancedCreativeTab;
import fr.atesab.act.StringModifier;
import fr.atesab.act.command.ModdedCommand;
import fr.atesab.act.command.ModdedCommandACT;
import fr.atesab.act.command.ModdedCommandGamemode;
import fr.atesab.act.command.ModdedCommandGamemodeQuick;
import fr.atesab.act.config.Configuration;
import fr.atesab.act.gui.GuiACT;
import fr.atesab.act.gui.GuiGiver;
import fr.atesab.act.gui.GuiMenu;
import fr.atesab.act.gui.modifier.GuiColorModifier;
import fr.atesab.act.gui.modifier.GuiItemStackModifier;
import fr.atesab.act.gui.modifier.GuiModifier;
import fr.atesab.act.gui.modifier.nbt.GuiNBTModifier;
import fr.atesab.act.gui.selector.GuiButtonListSelector;
import fr.atesab.act.utils.CommandUtils;
import fr.atesab.act.utils.GuiUtils;
import fr.atesab.act.utils.ItemUtils;
import fr.atesab.act.utils.Tuple;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.fmlclient.ConfigGuiHandler;
import net.minecraftforge.fmlclient.gui.screen.ModListScreen;
import net.minecraftforge.fmlclient.gui.widget.ModListWidget;
import net.minecraftforge.fmlclient.registry.ClientRegistry;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
@Mod(value="act")
public class ACTMod {
    public static final ACTState MOD_STATE = ACTState.RELEASE;
    public static final String MOD_ID = "act";
    public static final String MOD_NAME = "Advanced Creative 2";
    public static final String MOD_VERSION = "2.4.0";
    public static final String MOD_LITTLE_NAME = "ACT-Mod";
    public static final String MOD_AUTHORS = "ATE47";
    public static final String MOD_LICENCE = "GNU GPL 3";
    public static final String MOD_LICENCE_LINK = "https://www.gnu.org/licenses/gpl-3.0.en.html";
    public static final String MOD_LINK = "https://www.curseforge.com/minecraft/mc-mods/advanced-extended-creative-mode";
    @Deprecated
    public static final String MOD_FACTORY = "fr.atesab.act.gui.ModGuiFactory";
    public static final ModdedCommandACT ACT_COMMAND = new ModdedCommandACT();
    public static final AdvancedCreativeTab ADVANCED_CREATIVE_TAB = new AdvancedCreativeTab();
    public static final String TEMPLATE_TAG_NAME = "TemplateData";
    public static final Random RANDOM = new Random();
    private static final PoseStack STACK = new PoseStack();
    public static final String[] DEFAULT_CUSTOM_ITEMS = new String[]{ItemUtils.getGiveCode(ItemUtils.buildStack(Blocks.f_50100_, 42, ChatFormatting.LIGHT_PURPLE + "Pink verity", new String[]{ChatFormatting.GOLD + ChatFormatting.BOLD + "42 is life", ChatFormatting.GOLD + ChatFormatting.BOLD + "wait what ?"}, new Tuple[0]))};
    public static final Logger LOGGER = LogManager.getLogger((String)"act".toUpperCase());
    private static KeyMapping giver;
    private static KeyMapping menu;
    private static KeyMapping edit;
    private static List<ItemStack> templates;
    private static HashSet<Attribute> attributes;
    private static Map<String, Map<String, Consumer<StringModifier>>> stringModifier;
    private static Configuration config;
    private static CommandDispatcher<CommandSourceStack> dispatcher;
    private static Set<String> commandSet;
    private static CommandDispatcher<SharedSuggestionProvider> SharedSuggestionProvider;

    public static boolean doesDisableToolTip() {
        return config.doesDisableToolTip();
    }

    public static Set<Attribute> getAttributes() {
        return attributes;
    }

    public static List<String> getCustomItems() {
        return config.getCustomitems();
    }

    public static CommandDispatcher<CommandSourceStack> getDispatcher() {
        return dispatcher;
    }

    public static Map<String, Map<String, Consumer<StringModifier>>> getStringModifier() {
        return stringModifier;
    }

    public static String getTemplateData(ItemStack template) {
        return ItemUtils.getCustomTag(template, TEMPLATE_TAG_NAME, null);
    }

    public static Stream<ItemStack> getTemplates() {
        return templates.stream().map(is -> {
            String lang = ItemUtils.getCustomTag(is, "TemplateDataLang", null);
            TranslatableComponent display = lang != null ? new TranslatableComponent(lang) : is.m_41611_();
            display.m_6881_().m_130940_(ChatFormatting.AQUA);
            return is.m_41777_().m_41714_((Component)display);
        });
    }

    public static boolean isKeyDown(int key) {
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key);
    }

    public static void openGiver() {
        Minecraft mc = Minecraft.m_91087_();
        int slot = mc.f_91074_.m_150109_().f_35977_;
        GuiUtils.displayScreen(new GuiItemStackModifier(null, mc.f_91074_.m_21205_().m_41777_(), is -> ItemUtils.give(is, 36 + slot)));
    }

    public static void registerCommand(ModdedCommand command) {
        commandSet.addAll(command.getAliases());
        command.register(dispatcher);
    }

    public static void registerStringModifier(String name, Consumer<StringModifier> modifier) {
        ACTMod.registerStringModifier(name, "", modifier);
    }

    public static void registerStringModifier(String name, String category, Consumer<StringModifier> modifier) {
        Map<String, Consumer<StringModifier>> map = stringModifier.get(category);
        if (map == null) {
            map = new HashMap<String, Consumer<StringModifier>>();
            stringModifier.put(category, map);
        }
        map.put(name, modifier);
    }

    public static void registerTemplate(String lang, ItemStack icon, String data) {
        templates.add(ItemUtils.setCustomTag(ItemUtils.setCustomTag(icon.m_41777_(), TEMPLATE_TAG_NAME, data), "TemplateDataLang", lang));
    }

    public static void saveConfigs() {
        config.save();
    }

    public static void saveItem(String code) {
        LOGGER.info("Adding : " + code);
        config.getCustomitems().add(0, code);
    }

    public static void setDoesDisableToolTip(boolean doesDisableToolTip) {
        config.setDoesDisableToolTip(doesDisableToolTip);
    }

    public static void drawString(Font renderer, String str, int x, int y, int color) {
        renderer.m_92883_(STACK, str, (float)x, (float)y, color);
    }

    public ACTMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        config = new Configuration();
        config.sync(FMLPaths.CONFIGDIR.get().resolve("act.toml").toFile());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void checkModList(Screen screen) {
        Optional op;
        ModInfo info;
        ModListWidget.ModEntry entry;
        if (screen != null && screen instanceof ModListScreen && (entry = this.getFirstFieldOfTypeInto(ModListWidget.ModEntry.class, screen)) != null && (info = this.getFirstFieldOfTypeInto(ModInfo.class, entry)) != null && (op = ModList.get().getModContainerById(info.getModId())).isPresent()) {
            boolean value = ((ModContainer)op.get()).getCustomExtension(ConfigGuiHandler.ConfigGuiFactory.class).isPresent();
            String config = I18n.m_118938_((String)"fml.menu.mods.config", (Object[])new Object[0]);
            for (Object b : screen.m_6702_()) {
                if (!(b instanceof Button) || !((Button)b).m_6035_().getString().equals(config)) continue;
                ((Button)b).f_93623_ = value;
            }
        }
    }

    private void commandSetup() {
        ACTMod.registerCommand(new ModdedCommandACT());
        ACTMod.registerCommand(new ModdedCommandGamemode("gm"));
        ACTMod.registerCommand(new ModdedCommandGamemodeQuick("gmc", GameType.CREATIVE));
        ACTMod.registerCommand(new ModdedCommandGamemodeQuick("gma", GameType.ADVENTURE));
        ACTMod.registerCommand(new ModdedCommandGamemodeQuick("gms", GameType.SURVIVAL));
        ACTMod.registerCommand(new ModdedCommandGamemodeQuick("gmsp", GameType.SPECTATOR));
        LOGGER.info("Commands registered.");
    }

    private void commonSetup(FMLCommonSetupEvent ev) {
        ModList.get().getModContainerById(MOD_ID).ifPresent(con -> con.registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory((mc, parent) -> new GuiMenu((Screen)parent))));
        this.commandSetup();
        giver = new KeyMapping("key.act.giver", 89, MOD_NAME);
        ClientRegistry.registerKeyBinding((KeyMapping)giver);
        menu = new KeyMapping("key.act.menu", 78, MOD_NAME);
        ClientRegistry.registerKeyBinding((KeyMapping)menu);
        edit = new KeyMapping("key.act.edit", 72, MOD_NAME);
        ClientRegistry.registerKeyBinding((KeyMapping)edit);
        for (Field field : Attributes.class.getDeclaredFields()) {
            if (field.getType() != Attribute.class) continue;
            try {
                field.setAccessible(true);
                attributes.add((Attribute)field.get(null));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ACTMod.registerTemplate("gui.act.menu.template.empty", new ItemStack((ItemLike)Items.f_42516_), "");
        ACTMod.registerTemplate("gui.act.menu.template.stone", new ItemStack((ItemLike)Blocks.f_50069_), ItemUtils.getGiveCode(new ItemStack((ItemLike)Blocks.f_50069_)));
        ACTMod.registerTemplate("gui.act.menu.template.potion", new ItemStack((ItemLike)Items.f_42589_), ItemUtils.getGiveCode(new ItemStack((ItemLike)Items.f_42589_)));
        ACTMod.registerTemplate("gui.act.menu.template.fireworks", new ItemStack((ItemLike)Items.f_42688_), ItemUtils.getGiveCode(new ItemStack((ItemLike)Items.f_42688_)));
        ACTMod.registerTemplate(Items.f_42680_.m_5524_(), new ItemStack((ItemLike)Items.f_42680_), ItemUtils.getGiveCode(new ItemStack((ItemLike)Items.f_42680_)));
        ACTMod.registerTemplate("gui.act.menu.template.command", new ItemStack((ItemLike)Blocks.f_50272_), ItemUtils.getGiveCode(new ItemStack((ItemLike)Blocks.f_50272_)));
        ACTMod.registerTemplate(Items.f_42521_.m_5524_(), new ItemStack((ItemLike)Items.f_42521_), ItemUtils.getGiveCode(new ItemStack((ItemLike)Items.f_42521_)));
        Registry.f_122827_.forEach(i -> {
            ACTMod.registerStringModifier(i.m_5524_() + ".name", "registry.items", sm -> sm.setString(i.getRegistryName().toString()));
            if (i.getCreativeTabs() == null || i.getCreativeTabs().isEmpty() || i.m_41471_() == null) {
                ADVANCED_CREATIVE_TAB.addSubitem((Item)i);
            } else {
                NonNullList sub = NonNullList.m_122779_();
                i.m_6787_(CreativeModeTab.f_40754_, sub);
                if (sub.stream().noneMatch(is -> is.m_41720_().equals(i) && (is.m_41783_() == null || is.m_41783_().m_128456_() || is.m_41783_().m_128440_() != 1 || !is.m_41783_().m_128441_("damage")))) {
                    ADVANCED_CREATIVE_TAB.addSubitem((Item)i);
                }
            }
        });
        Registry.f_122824_.forEach(b -> ACTMod.registerStringModifier(b.m_49954_().getString(), "registry.blocks", sm -> sm.setString(b.getRegistryName().toString())));
        Registry.f_122828_.forEach(p -> ACTMod.registerStringModifier(p.m_43492_(""), "registry.potions", sm -> sm.setString(p.getRegistryName().toString())));
        ForgeRegistries.BIOMES.forEach(b -> ACTMod.registerStringModifier(b.m_47567_().m_47645_(), "registry.biomes", sm -> sm.setString(b.getRegistryName().toString())));
        Registry.f_122821_.forEach(s -> ACTMod.registerStringModifier(s.getRegistryName().toString(), "registry.sounds", sm -> sm.setString(s.getRegistryName().toString())));
        Registry.f_122869_.forEach(vp -> ACTMod.registerStringModifier(vp.getRegistryName().toString(), "registry.villagerProfessions", sm -> sm.setString(vp.getRegistryName().toString())));
        Registry.f_122826_.forEach(ee -> ACTMod.registerStringModifier(ee.m_20675_(), "registry.entities", sm -> sm.setString(ee.getRegistryName().toString())));
        attributes.forEach(at -> ACTMod.registerStringModifier(at.m_22087_(), "attributes", sm -> sm.setString(at.getRegistryName().toString())));
        for (Field field : EquipmentSlot.values()) {
            ACTMod.registerStringModifier("item.modifiers." + field.m_20751_(), "attributes.slot", arg_0 -> ACTMod.lambda$commonSetup$22((EquipmentSlot)field, arg_0));
        }
        ACTMod.registerStringModifier("gui.act.modifier.string.giver", "", sm -> sm.setNextScreen(new GuiGiver(sm.getNextScreen(), sm.getString(), sm::setString, false)));
        ACTMod.registerStringModifier("gui.act.modifier.string.nbt", "", sm -> {
            try {
                sm.setNextScreen(new GuiNBTModifier(sm.getNextScreen(), nbt -> sm.setString(nbt.toString()), TagParser.m_129359_((String)sm.getString())));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        ACTMod.registerStringModifier("gui.act.modifier.string.players", "", sm -> {
            List<String> plr;
            try {
                plr = CommandUtils.getPlayerList();
            }
            catch (Exception e) {
                plr = new ArrayList<String>();
                plr.add(Minecraft.m_91087_().m_91094_().m_92546_());
            }
            ArrayList btn = new ArrayList();
            plr.forEach(pn -> btn.add(new Tuple<String, String>((String)pn, (String)pn)));
            sm.setNextScreen(new GuiButtonListSelector<String>(sm.getNextScreen(), (Component)new TranslatableComponent("gui.act.modifier.string.players"), btn, s -> {
                sm.setString((String)s);
                return null;
            }));
        });
        ACTMod.registerStringModifier("gui.act.modifier.string.b64.encode", "b64", sm -> {
            try {
                sm.setString(new String(Base64.getEncoder().encode(sm.getString().getBytes())));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ACTMod.registerStringModifier("gui.act.modifier.string.b64.decode", "b64", sm -> {
            try {
                sm.setString(new String(Base64.getDecoder().decode(sm.getString().getBytes())));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        GuiColorModifier.registerPickerImage();
    }

    private void createSuggestion(CommandNode<CommandSourceStack> dispatcher, CommandNode<SharedSuggestionProvider> rootCommandNode, CommandSourceStack player, Map<CommandNode<CommandSourceStack>, CommandNode<SharedSuggestionProvider>> suggestions) {
        for (CommandNode child : dispatcher.getChildren()) {
            RequiredArgumentBuilder requiredargumentbuilder;
            ArgumentBuilder argumentbuilder = child.createBuilder();
            argumentbuilder.requires(ctx -> true);
            if (argumentbuilder.getCommand() != null) {
                argumentbuilder.executes(ctx -> 0);
            }
            if (argumentbuilder instanceof RequiredArgumentBuilder && (requiredargumentbuilder = (RequiredArgumentBuilder)argumentbuilder).getSuggestionsProvider() != null) {
                requiredargumentbuilder.suggests(SuggestionProviders.m_121664_((SuggestionProvider)requiredargumentbuilder.getSuggestionsProvider()));
            }
            if (argumentbuilder.getRedirect() != null) {
                argumentbuilder.redirect(suggestions.get(argumentbuilder.getRedirect()));
            }
            CommandNode commandnode1 = argumentbuilder.build();
            suggestions.put((CommandNode<CommandSourceStack>)child, (CommandNode<SharedSuggestionProvider>)commandnode1);
            rootCommandNode.addChild(commandnode1);
            if (child.getChildren().isEmpty()) continue;
            this.createSuggestion((CommandNode<CommandSourceStack>)child, (CommandNode<SharedSuggestionProvider>)commandnode1, player, suggestions);
        }
    }

    private <T> T getFirstFieldOfTypeInto(Class<T> cls, Object obj) {
        for (Field f : obj.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            if (f.getType() != cls) continue;
            try {
                return (T)f.get(obj);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    private void injectSuggestions() {
        CommandDispatcher current;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && mc.f_91074_.f_108617_ != null && (current = mc.f_91074_.f_108617_.m_105146_()) != SharedSuggestionProvider) {
            SharedSuggestionProvider = current;
            if (current != null) {
                HashMap map = Maps.newHashMap();
                RootCommandNode root = SharedSuggestionProvider.getRoot();
                map.put(dispatcher.getRoot(), root);
                this.createSuggestion((CommandNode<CommandSourceStack>)dispatcher.getRoot(), (CommandNode<SharedSuggestionProvider>)root, mc.f_91074_.m_20203_(), map);
            }
        }
    }

    @SubscribeEvent
    public void onChatMessage(ClientChatEvent ev) {
        String msg = ev.getMessage();
        if (!msg.startsWith("/")) {
            return;
        }
        String command = msg.substring(1);
        if (!commandSet.contains(command.split(" ", 2)[0])) {
            return;
        }
        ev.setCanceled(true);
        Minecraft.m_91087_().f_91065_.m_93076_().m_93783_(msg);
        StringReader reader = new StringReader(msg);
        if (reader.canRead()) {
            reader.skip();
        }
        CommandSourceStack source = Minecraft.m_91087_().f_91074_.m_20203_();
        try {
            ParseResults parse = dispatcher.parse(reader, (Object)source);
            dispatcher.execute(parse);
        }
        catch (CommandSyntaxException e) {
            source.m_81352_(ComponentUtils.m_130729_((Message)e.getRawMessage()));
            if (e.getInput() != null && e.getCursor() >= 0) {
                int messageSize = Math.min(e.getInput().length(), e.getCursor());
                MutableComponent error = new TextComponent("").m_130940_(ChatFormatting.GRAY).m_130938_(s -> s.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, msg)));
                if (messageSize > 10) {
                    error.m_130946_("...");
                }
                error.m_130946_(e.getInput().substring(Math.max(0, messageSize - 10), messageSize));
                if (messageSize < e.getInput().length()) {
                    MutableComponent Component2 = new TextComponent(e.getInput().substring(messageSize)).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.UNDERLINE});
                    error.m_7220_((Component)Component2);
                }
                error.m_7220_((Component)new TranslatableComponent("command.context.here").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC}));
                source.m_81352_((Component)error);
            }
        }
        catch (Exception e) {
            TextComponent error = new TextComponent(e.getMessage() == null ? e.getClass().getName() : e.getMessage());
            if (LOGGER.isDebugEnabled()) {
                StackTraceElement[] trace = e.getStackTrace();
                for (int j = 0; j < Math.min(trace.length, 3); ++j) {
                    error.m_130946_("\n\n").m_130946_(trace[j].getMethodName()).m_130946_("\n ").m_130946_(trace[j].getFileName()).m_130946_(":").m_130946_(String.valueOf(trace[j].getLineNumber()));
                }
            }
            source.m_81352_((Component)new TranslatableComponent("command.failed").m_130938_(arg_0 -> ACTMod.lambda$onChatMessage$34((MutableComponent)error, arg_0)));
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent ev) {
        if (ev.phase == TickEvent.Phase.END) {
            this.checkModList(Minecraft.m_91087_().f_91080_);
        }
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post ev) {
        if (ev.getGui() instanceof GuiACT && MOD_STATE.isShow()) {
            ACTMod.drawString(Minecraft.m_91087_().f_91062_, "Warning! Currently in " + MOD_STATE.getColor() + MOD_STATE.name(), 5, 5, -1);
        }
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post ev) {
        this.injectSuggestions();
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent ev) {
        if (Minecraft.m_91087_().f_91080_ != null) {
            return;
        }
        if (giver.m_90859_()) {
            GuiUtils.displayScreen(new GuiGiver(null));
        } else if (menu.m_90859_()) {
            GuiUtils.displayScreen(new GuiMenu(null));
        } else if (edit.m_90859_()) {
            ACTMod.openGiver();
        }
    }

    @SubscribeEvent
    public void onRenderTooltip(ItemTooltipEvent ev) {
        Minecraft mc = Minecraft.m_91087_();
        if ((mc.f_91080_ instanceof GuiGiver || mc.f_91080_ instanceof GuiModifier || giver.getKey().m_84873_() == 0 || !ACTMod.isKeyDown(340)) && mc.f_91080_ instanceof GuiMenu) {
            ev.getToolTip().add(ModdedCommand.createPrefix(I18n.m_118938_((String)"gui.act.leftClick", (Object[])new Object[0]), ChatFormatting.YELLOW, ChatFormatting.GOLD).m_7220_((Component)ModdedCommand.createText(I18n.m_118938_((String)(ACTMod.isKeyDown(340) ? "gui.act.give.copy" : "gui.act.give.editor"), (Object[])new Object[0]), ChatFormatting.YELLOW)));
            if (ACTMod.isKeyDown(340)) {
                ev.getToolTip().add(ModdedCommand.createPrefix(I18n.m_118938_((String)"gui.act.rightClick", (Object[])new Object[0]), ChatFormatting.YELLOW, ChatFormatting.GOLD).m_7220_((Component)ModdedCommand.createText(I18n.m_118938_((String)"gui.act.delete", (Object[])new Object[0]), ChatFormatting.YELLOW)));
            } else if (mc.f_91074_ != null && mc.f_91074_.m_7500_()) {
                ev.getToolTip().add(ModdedCommand.createPrefix(I18n.m_118938_((String)"gui.act.rightClick", (Object[])new Object[0]), ChatFormatting.YELLOW, ChatFormatting.GOLD).m_7220_((Component)ModdedCommand.createText(I18n.m_118938_((String)"gui.act.give.give", (Object[])new Object[0]), ChatFormatting.YELLOW)));
            }
        }
        if (config.doesDisableToolTip() && !ev.getFlags().m_7050_()) {
            return;
        }
        if (ACTMod.isKeyDown(340)) {
            double maxdmg;
            int dmg;
            Object s;
            CompoundTag compound = ev.getItemStack().m_41783_();
            Object object = s = !ev.getFlags().m_7050_() ? ev.getItemStack().m_41720_().getRegistryName().toString() : "";
            if (!(mc.f_91080_ != null && mc.f_91080_ instanceof CreativeModeInventoryScreen && ((CreativeModeInventoryScreen)mc.f_91080_).m_98628_() == CreativeModeTab.f_40754_.m_40775_() || ev.getItemStack().m_41720_().getCreativeTabs() == null)) {
                s = (String)s + ChatFormatting.WHITE + (((String)s).isEmpty() ? "" : " ") + ev.getItemStack().m_41720_().getCreativeTabs().stream().filter(Objects::nonNull).map(i -> i.m_40786_().getString()).collect(Collectors.joining(", "));
            }
            if (!((String)s).isEmpty()) {
                ev.getToolTip().add(new TextComponent((String)s));
            }
            if (compound != null && compound.m_128425_("CustomPotionColor", 99)) {
                ev.getToolTip().add(ModdedCommand.createText(I18n.m_118938_((String)"item.color", (Object[])new Object[]{ChatFormatting.YELLOW + String.format("#%06X", compound.m_128451_("CustomPotionColor"))}), ChatFormatting.GOLD));
            }
            if (!ev.getFlags().m_7050_()) {
                if (ev.getToolTip().size() != 0) {
                    ev.getToolTip().set(0, new TextComponent("").m_7220_((Component)ev.getToolTip().get(0)).m_130946_(" (#" + Item.m_41393_((Item)ev.getItemStack().m_41720_()) + (String)(ev.getItemStack().m_41773_() != 0 && !ev.getItemStack().m_41768_() ? "/" + ev.getItemStack().m_41773_() : "") + ")").m_130940_(ChatFormatting.WHITE));
                }
                if (compound != null && compound.m_128425_("display", 10) && compound.m_128469_("display").m_128425_("color", 99)) {
                    ev.getToolTip().add(ModdedCommand.createText(I18n.m_118938_((String)"item.color", (Object[])new Object[]{ChatFormatting.YELLOW + String.format("#%06X", compound.m_128469_("display").m_128451_("color"))}), ChatFormatting.GOLD));
                }
                if (ev.getItemStack().m_41768_()) {
                    dmg = Math.abs(ev.getItemStack().m_41773_() - ev.getItemStack().m_41776_()) + 1;
                    maxdmg = ev.getItemStack().m_41776_() + 1;
                    ev.getToolTip().add(ModdedCommand.createText("RepairCost: ", ChatFormatting.YELLOW).m_7220_((Component)ModdedCommand.createText(String.valueOf(dmg), dmg < (int)(0.1 * maxdmg) ? ChatFormatting.DARK_GREEN : (dmg < (int)(0.25 * maxdmg) ? ChatFormatting.GREEN : (dmg < (int)(0.5 * maxdmg) ? ChatFormatting.GOLD : (dmg < (int)(0.75 * maxdmg) ? ChatFormatting.RED : (dmg < (int)(1.0 * maxdmg) ? ChatFormatting.DARK_RED : ChatFormatting.DARK_GREEN)))))));
                    ev.getToolTip().add(ModdedCommand.createText(I18n.m_118938_((String)"item.durability", (Object[])new Object[]{(dmg < (int)(0.1 * maxdmg) ? ChatFormatting.DARK_GREEN : (dmg < (int)(0.25 * maxdmg) ? ChatFormatting.GREEN : (dmg < (int)(0.5 * maxdmg) ? ChatFormatting.GOLD : (dmg < (int)(0.75 * maxdmg) ? ChatFormatting.RED : (dmg < (int)(1.0 * maxdmg) ? ChatFormatting.DARK_RED : ChatFormatting.DARK_GREEN))))).toString() + dmg, ev.getItemStack().m_41776_() + 1}), ChatFormatting.YELLOW));
                }
            }
            if (compound != null && compound.m_128440_() != 0) {
                if (ev.getItemStack().m_41783_().m_128441_("RepairCost")) {
                    dmg = ev.getItemStack().m_41783_().m_128451_("RepairCost");
                    maxdmg = 31.0;
                    ev.getToolTip().add(ModdedCommand.createText("RepairCost: ", ChatFormatting.YELLOW).m_7220_((Component)ModdedCommand.createText(String.valueOf(dmg), dmg < (int)(0.1 * maxdmg) ? ChatFormatting.DARK_GREEN : (dmg < (int)(0.25 * maxdmg) ? ChatFormatting.GREEN : (dmg < (int)(0.5 * maxdmg) ? ChatFormatting.GOLD : (dmg < (int)(0.75 * maxdmg) ? ChatFormatting.RED : (dmg < (int)(1.0 * maxdmg) ? ChatFormatting.DARK_RED : ChatFormatting.DARK_GREEN)))))));
                }
                MutableComponent tags = ModdedCommand.createText(I18n.m_118938_((String)"gui.act.tags", (Object[])new Object[0]) + "(" + compound.m_128440_() + "): ", ChatFormatting.GOLD);
                int count = 0;
                for (String tag : compound.m_128431_()) {
                    if (count != 0) {
                        tags.m_7220_((Component)ModdedCommand.createText(", ", ChatFormatting.GOLD));
                    }
                    tags.m_7220_((Component)ModdedCommand.createText(tag, ChatFormatting.YELLOW));
                    ++count;
                }
                ev.getToolTip().add(tags);
            }
            if (!(mc.f_91080_ instanceof GuiGiver) && !(mc.f_91080_ instanceof GuiModifier)) {
                if (giver.getKey().m_84873_() != 0 && ACTMod.isKeyDown(340)) {
                    if (ACTMod.isKeyDown(giver.getKey().m_84873_())) {
                        mc.m_91152_((Screen)new GuiGiver(mc.f_91080_, ev.getItemStack()));
                    }
                    ev.getToolTip().add(ModdedCommand.createPrefix(giver.getKey().m_84875_().getString(), ChatFormatting.YELLOW, ChatFormatting.GOLD).m_7220_((Component)ModdedCommand.createTranslatedText("cmd.act.opengiver", ChatFormatting.YELLOW, new Object[0])));
                }
                if (menu.getKey().m_84873_() != 0) {
                    if (ACTMod.isKeyDown(menu.getKey().m_84873_())) {
                        String code = ItemUtils.getGiveCode(ev.getItemStack()).replace('\u00a7', '&');
                        ACTMod.saveItem(code);
                        mc.m_91152_((Screen)new GuiMenu(mc.f_91080_));
                    }
                    ev.getToolTip().add(ModdedCommand.createPrefix(menu.getKey().m_84875_().getString(), ChatFormatting.YELLOW, ChatFormatting.GOLD).m_7220_((Component)ModdedCommand.createTranslatedText("gui.act.save", ChatFormatting.YELLOW, new Object[0])));
                }
            }
        }
        if (!ACTMod.isKeyDown(340)) {
            ev.getToolTip().add(new TextComponent("SHIFT ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)new TranslatableComponent("gui.act.shift")).m_130940_(ChatFormatting.GOLD));
        }
    }

    private static /* synthetic */ Style lambda$onChatMessage$34(MutableComponent error, Style style) {
        style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)error));
        return style;
    }

    private static /* synthetic */ void lambda$commonSetup$22(EquipmentSlot slot, StringModifier sm) {
        sm.setString(slot.m_20751_());
    }

    static {
        templates = new ArrayList<ItemStack>();
        attributes = new HashSet();
        stringModifier = new HashMap<String, Map<String, Consumer<StringModifier>>>();
        dispatcher = new CommandDispatcher();
        commandSet = new HashSet<String>();
    }

    public static enum ACTState {
        RELEASE(null),
        BETA(ChatFormatting.GOLD),
        ALPHA(ChatFormatting.DARK_RED);

        private ChatFormatting color;

        private ACTState(ChatFormatting color) {
            this.color = color;
        }

        public ChatFormatting getColor() {
            return this.color;
        }

        public boolean isShow() {
            return this.color != null;
        }
    }
}

