/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import fr.atesab.act.command.ModdedCommandHelp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class ModdedCommand {
    public static final int MAX_EXAMPLE = 6;
    private final Map<String, ModdedCommand> NAME_TO_COMMAND = new TreeMap<String, ModdedCommand>();
    private final List<ModdedCommand> SUB_COMMANDS = new ArrayList<ModdedCommand>();
    private List<String> subCommandTitleExample = new ArrayList<String>(6);
    private ModdedCommand parent;
    public ModdedCommand defaultCommand;
    private String name;
    private String description;
    private ModdedCommandHelp.CommandClickOption clickOption;
    private boolean displayInHelp;
    private List<String> aliases;
    protected LiteralCommandNode<CommandSourceStack> node;
    private CommandDispatcher<CommandSourceStack> dispatcher;
    private boolean registered = false;

    public static MutableComponent createPrefix(String text, ChatFormatting color, ChatFormatting border) {
        return ModdedCommand.createText("[", border).m_7220_((Component)ModdedCommand.createText(text, color)).m_7220_((Component)ModdedCommand.createText("] ", border));
    }

    public static MutableComponent createText(String text, ChatFormatting color) {
        return new TextComponent(Objects.requireNonNull(text)).m_130940_(color);
    }

    public static MutableComponent createTranslatedPrefix(String text, ChatFormatting color, ChatFormatting border, Object ... args) {
        return ModdedCommand.createText("[", border).m_7220_((Component)ModdedCommand.createTranslatedText(text, color, args)).m_7220_((Component)ModdedCommand.createText("] ", border));
    }

    public static MutableComponent createTranslatedText(String lang, ChatFormatting color, Object ... args) {
        return new TranslatableComponent(Objects.requireNonNull(lang), args).m_130940_(color);
    }

    public ModdedCommand(String name) {
        this(name, "", ModdedCommandHelp.CommandClickOption.doCommand);
    }

    public ModdedCommand(String name, String description, ModdedCommandHelp.CommandClickOption clickOption) {
        this(name, description, clickOption, true);
    }

    public ModdedCommand(String name, String description, ModdedCommandHelp.CommandClickOption clickOption, boolean displayInHelp) {
        this.description = description;
        this.clickOption = clickOption;
        this.displayInHelp = displayInHelp;
        this.name = name.toLowerCase();
        this.aliases = new ArrayList<String>(1);
        this.addAlias(this.getName());
    }

    public ModdedCommand addAlias(String alias) {
        this.aliases.add(alias.toLowerCase());
        return this;
    }

    public List<String> getAliases() {
        return Collections.unmodifiableList(this.aliases);
    }

    public ModdedCommandHelp.CommandClickOption getClickOption() {
        return this.clickOption;
    }

    public String getDescription() {
        return I18n.m_118938_((String)this.getDescriptionTranslationKey(), (Object[])new Object[0]);
    }

    public String getDescriptionTranslationKey() {
        return this.description;
    }

    public CommandDispatcher<CommandSourceStack> getDispatcher() {
        return this.dispatcher;
    }

    public String getGlobalName() {
        return this.parent != null ? this.parent.getGlobalName() + " " + this.getName() : this.getName();
    }

    public String getName() {
        return this.name;
    }

    public LiteralCommandNode<CommandSourceStack> getNode() {
        return this.node;
    }

    public ModdedCommand getParent() {
        return this.parent;
    }

    public List<ModdedCommand> getSubCommands() {
        return Collections.unmodifiableList(this.SUB_COMMANDS);
    }

    public Map<String, ModdedCommand> getSubCommandsMap() {
        return Collections.unmodifiableMap(this.NAME_TO_COMMAND);
    }

    public boolean isDisplayInHelp() {
        return this.displayInHelp;
    }

    protected LiteralArgumentBuilder<CommandSourceStack> onArgument(LiteralArgumentBuilder<CommandSourceStack> command) {
        return command;
    }

    protected Command<CommandSourceStack> onNoArgument() {
        return this.defaultCommand != null ? this.defaultCommand.onNoArgument() : c -> {
            ((CommandSourceStack)c.getSource()).m_81352_((Component)new TranslatableComponent("cmd.act.error.noargument").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC}));
            return 1;
        };
    }

    private void register() {
        if (this.registered) {
            throw new IllegalStateException("A command can't be registered more than once");
        }
        this.registered = true;
    }

    public void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        this.register();
        this.dispatcher = dispatcher;
        this.register((CommandNode<CommandSourceStack>)dispatcher.getRoot());
    }

    private void register(CommandNode<CommandSourceStack> node) {
        for (String alias : this.aliases) {
            Command<CommandSourceStack> noArgument = this.onNoArgument();
            LiteralArgumentBuilder<CommandSourceStack> bld = this.onArgument((LiteralArgumentBuilder<CommandSourceStack>)Commands.m_82127_((String)alias));
            if (noArgument != null) {
                bld.executes(noArgument);
            }
            this.node = bld.build();
            this.NAME_TO_COMMAND.forEach((salias, cmd) -> {
                cmd.dispatcher = this.dispatcher;
                cmd.register((CommandNode<CommandSourceStack>)this.node);
            });
            node.addChild(this.node);
        }
    }

    public ModdedCommand registerDefaultSubCommand(ModdedCommand subCommand) {
        subCommand.register();
        for (String alias : subCommand.getAliases()) {
            this.NAME_TO_COMMAND.put(alias, subCommand);
        }
        if (this.subCommandTitleExample.size() < 6) {
            this.subCommandTitleExample.add(0, subCommand.getName());
        } else {
            this.subCommandTitleExample.remove(5);
            this.subCommandTitleExample.add(0, subCommand.getName());
        }
        this.SUB_COMMANDS.add(subCommand);
        this.defaultCommand = subCommand;
        return this;
    }

    public ModdedCommand registerSubCommand(ModdedCommand subCommand) {
        subCommand.register();
        subCommand.parent = this;
        for (String alias : subCommand.getAliases()) {
            this.NAME_TO_COMMAND.put(alias, subCommand);
        }
        if (this.subCommandTitleExample.size() < 6) {
            this.subCommandTitleExample.add(subCommand.getName());
        }
        this.SUB_COMMANDS.add(subCommand);
        return this;
    }
}

