/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import fr.atesab.act.command.ModdedCommand;
import fr.atesab.act.command.arguments.StringListArgumentType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;

public class ModdedCommandHelp
extends ModdedCommand {
    private final ChatFormatting titleColor;
    private final ChatFormatting commandColor;
    private final ChatFormatting textColor;
    private final String title;
    private final ModdedCommand mainCommand;

    public ModdedCommandHelp(ModdedCommand mainCommand, String title, ChatFormatting titleColor, ChatFormatting commandColor, ChatFormatting textColor) {
        super("help", "cmd.act.help.cmd", CommandClickOption.suggestCommand);
        this.title = title;
        this.mainCommand = mainCommand;
        this.titleColor = titleColor;
        this.commandColor = commandColor;
        this.textColor = textColor;
        this.addAlias("?");
    }

    public List<ModdedCommand> getVisibleSubCommand(ModdedCommand mainCommand) {
        ArrayList<ModdedCommand> sc = new ArrayList<ModdedCommand>();
        for (ModdedCommand c : mainCommand.getSubCommands()) {
            if (!c.isDisplayInHelp()) continue;
            sc.add(c);
        }
        return sc;
    }

    @Override
    protected LiteralArgumentBuilder<CommandSourceStack> onArgument(LiteralArgumentBuilder<CommandSourceStack> command) {
        return (LiteralArgumentBuilder)command.then(Commands.m_82129_((String)"commandforhelp", (ArgumentType)StringListArgumentType.stringList(this.mainCommand.getSubCommandsMap().keySet(), Arrays.asList(this.getName()), true)).executes(c -> {
            int count = 0;
            for (String commandName : StringListArgumentType.getStringList(c, "commandforhelp")) {
                ModdedCommand cmd = this.mainCommand.getSubCommandsMap().get(commandName);
                CommandSourceStack src = (CommandSourceStack)c.getSource();
                String parentName = this.mainCommand.getGlobalName();
                if (cmd != null) {
                    count += 3;
                    src.m_81354_((Component)ModdedCommandHelp.createText("-- " + I18n.m_118938_((String)"cmd.act.help", (Object[])new Object[]{cmd.getName()}) + " --", this.titleColor), false);
                    src.m_81354_((Component)ModdedCommandHelp.createTranslatedText(cmd.getDescriptionTranslationKey(), this.textColor, new Object[0]), false);
                    src.m_81354_((Component)ModdedCommandHelp.createTranslatedText("cmd.act.aliases", this.titleColor, new Object[0]).m_7220_((Component)ModdedCommandHelp.createText(": ", ChatFormatting.DARK_GRAY)).m_7220_((Component)ModdedCommandHelp.createText(cmd.getAliases().stream().filter(s -> !s.equals(cmd.getName())).collect(Collectors.joining(", ")), this.textColor)), false);
                    Map usages = this.getDispatcher().getSmartUsage(cmd.getNode(), (Object)src);
                    if (usages.isEmpty()) {
                        this.showCommand(cmd, src, "/" + parentName + " " + cmd.getName(), "", false);
                        ++count;
                        continue;
                    }
                    for (String usage : usages.values()) {
                        this.showCommand(cmd, src, "/" + parentName + " " + cmd.getName(), usage, false);
                        ++count;
                    }
                    continue;
                }
                src.m_81352_((Component)ModdedCommandHelp.createText(I18n.m_118938_((String)"cmd.act.mc.invalid", (Object[])new Object[]{"/" + parentName + " " + this.getName()}), ChatFormatting.RED));
                return count + 1;
            }
            return count;
        }));
    }

    @Override
    protected Command<CommandSourceStack> onNoArgument() {
        return c -> {
            CommandSourceStack src = (CommandSourceStack)c.getSource();
            int count = 1;
            src.m_81354_((Component)ModdedCommandHelp.createText("-- " + I18n.m_118938_((String)"cmd.act.help", (Object[])new Object[]{this.title}) + " --", this.titleColor), false);
            String parentName = this.mainCommand.getGlobalName();
            for (ModdedCommand command : this.mainCommand.getSubCommands()) {
                if (!command.isDisplayInHelp()) continue;
                Map usages = this.getDispatcher().getSmartUsage(command.getNode(), (Object)src);
                if (usages.isEmpty()) {
                    this.showCommand(command, src, "/" + parentName + " " + command.getName(), "", true);
                    ++count;
                    continue;
                }
                for (String usage : usages.values()) {
                    this.showCommand(command, src, "/" + parentName + " " + command.getName(), usage, true);
                    ++count;
                }
            }
            return count;
        };
    }

    private void showCommand(ModdedCommand command, CommandSourceStack src, String name, String usage, boolean showDescription) {
        MutableComponent component = usage.isEmpty() ? ModdedCommandHelp.createText(name, this.commandColor) : ModdedCommandHelp.createText(name + " " + usage, this.commandColor);
        component = command.getClickOption() == CommandClickOption.doCommand ? component.m_130938_(s -> s.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)ModdedCommandHelp.createTranslatedText("cmd.act.help.do", this.titleColor, new Object[0]))).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, name))) : component.m_130938_(s -> s.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)ModdedCommandHelp.createTranslatedText("cmd.act.help.click", this.titleColor, new Object[0]))).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, name + " ")));
        if (showDescription) {
            src.m_81354_((Component)component.m_7220_((Component)ModdedCommandHelp.createText(": ", ChatFormatting.DARK_GRAY)).m_7220_((Component)ModdedCommandHelp.createTranslatedText(command.getDescriptionTranslationKey(), this.textColor, new Object[0])), false);
        } else {
            src.m_81354_((Component)component, false);
        }
    }

    public static enum CommandClickOption {
        doCommand,
        suggestCommand;

    }
}

