/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import fr.atesab.act.ACTMod;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Configuration {
    private CommentedFileConfig config;
    private List<String> customItems = new ArrayList<String>(Arrays.asList(ACTMod.DEFAULT_CUSTOM_ITEMS));
    private boolean disableToolTip = false;

    public boolean doesDisableToolTip() {
        return this.disableToolTip;
    }

    public List<String> getCustomitems() {
        return this.customItems;
    }

    public void save() {
        this.config.set("general.items", this.customItems);
        this.config.set("general.disableToolTip", (Object)this.disableToolTip);
        this.config.save();
    }

    public void setDoesDisableToolTip(boolean doesDisableToolTip) {
        this.disableToolTip = doesDisableToolTip;
    }

    public void sync(File path) {
        this.config = (CommentedFileConfig)CommentedFileConfig.builder((File)path).sync().writingMode(WritingMode.REPLACE).build();
        this.config.load();
        this.config.setComment("general.items", "the custom items");
        this.customItems = (List)this.config.getOrElse("general.items", this.customItems);
        this.config.setComment("general.disableToolTip", "Disable the tool tip without F3+H");
        this.disableToolTip = (Boolean)this.config.getOrElse("general.disableToolTip", (Object)this.disableToolTip);
        this.config.save();
    }
}

