/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui.modifier;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.atesab.act.ACTMod;
import fr.atesab.act.gui.modifier.GuiListModifier;
import fr.atesab.act.gui.selector.GuiButtonListSelector;
import fr.atesab.act.utils.GuiUtils;
import fr.atesab.act.utils.ItemUtils;
import fr.atesab.act.utils.Tuple;
import java.awt.Color;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class GuiAttributeModifier
extends GuiListModifier<List<ItemUtils.AttributeData>> {
    private final Supplier<GuiListModifier.ListElement> supplier = () -> new AttributeListElement(this, ItemUtils.AttributeModifierBuilder.ARMOR.buildData(EquipmentSlot.MAINHAND, 0.0, AttributeModifier.Operation.ADDITION));

    public GuiAttributeModifier(Screen parent, List<ItemUtils.AttributeData> attributes, Consumer<List<ItemUtils.AttributeData>> setter) {
        super(parent, (Component)new TranslatableComponent("gui.act.modifier.attr"), new ArrayList<GuiListModifier.ListElement>(), setter, new Tuple[0]);
        attributes.forEach(attribute -> this.addListElement(new AttributeListElement(this, (ItemUtils.AttributeData)attribute)));
        this.addListElement(new GuiListModifier.AddElementList(this, this.supplier));
    }

    @Override
    protected List<ItemUtils.AttributeData> get() {
        ArrayList<ItemUtils.AttributeData> result = new ArrayList<ItemUtils.AttributeData>();
        this.getElements().stream().filter(le -> le instanceof AttributeListElement).map(le -> (AttributeListElement)le).forEach(ale -> result.add(ale.getData()));
        return result;
    }

    static class AttributeListElement
    extends GuiListModifier.ListElement {
        private EditBox amount;
        private boolean errAmount = false;
        private double amountValue;
        private ItemUtils.AttributeData data;
        private int operationValue;
        private Button slotButton;
        private Button typeButton;
        private Button operationButton;

        public AttributeListElement(GuiAttributeModifier parent, ItemUtils.AttributeData data) {
            super(400, 50);
            this.data = data;
            int l = 5 + this.font.m_92895_(I18n.m_118938_((String)"gui.act.modifier.attr.amount", (Object[])new Object[0]) + " : ");
            this.amount = new EditBox(this.font, 202 + l, 1, 154 - l, 18, (Component)new TextComponent(""));
            this.amount.m_94199_(8);
            this.amountValue = data.getModifier().m_22218_();
            this.amount.m_94144_(String.valueOf(this.amountValue));
            this.operationValue = data.getModifier().m_22217_().m_22235_();
            this.slotButton = new Button(2, 0, 198, 20, (Component)new TextComponent(""), b -> {
                ArrayList slots = new ArrayList();
                slots.add(new Tuple<String, Object>(I18n.m_118938_((String)"gui.act.none", (Object[])new Object[0]), null));
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    String s2 = I18n.m_118938_((String)("item.modifiers." + slot.m_20751_()), (Object[])new Object[0]);
                    slots.add(new Tuple<String, EquipmentSlot>(s2.endsWith(":") ? s2.substring(0, s2.length() - 1) : s2, slot));
                }
                this.mc.m_91152_(new GuiButtonListSelector<EquipmentSlot>(parent, (Component)new TranslatableComponent("gui.act.modifier.attr.slot"), slots, s -> {
                    data.setSlot((EquipmentSlot)s);
                    this.defineButtonText();
                    return null;
                }));
            });
            this.buttonList.add(this.slotButton);
            this.typeButton = new Button(2, 21, 198, 20, (Component)new TextComponent(""), b -> {
                ArrayList attributes = new ArrayList();
                ACTMod.getAttributes().forEach(atr -> attributes.add(new Tuple<String, Attribute>(I18n.m_118938_((String)atr.m_22087_(), (Object[])new Object[0]), (Attribute)atr)));
                this.mc.m_91152_(new GuiButtonListSelector<Attribute>(parent, (Component)new TranslatableComponent("gui.act.modifier.attr.type"), attributes, atr -> {
                    data.setAttribute((Attribute)atr);
                    this.defineButtonText();
                    return null;
                }));
            });
            this.buttonList.add(this.typeButton);
            this.operationButton = new Button(202, 21, 157, 20, (Component)new TextComponent(""), b -> {
                ArrayList operations = new ArrayList();
                operations.add(new Tuple<CallSite, Integer>((CallSite)((Object)(I18n.m_118938_((String)"gui.act.modifier.attr.operation.0", (Object[])new Object[0]) + " (0)")), 0));
                operations.add(new Tuple<CallSite, Integer>((CallSite)((Object)(I18n.m_118938_((String)"gui.act.modifier.attr.operation.1", (Object[])new Object[0]) + " (1)")), 1));
                operations.add(new Tuple<CallSite, Integer>((CallSite)((Object)(I18n.m_118938_((String)"gui.act.modifier.attr.operation.2", (Object[])new Object[0]) + " (2)")), 2));
                this.mc.m_91152_(new GuiButtonListSelector<Integer>(parent, (Component)new TranslatableComponent("gui.act.modifier.attr.operation"), operations, i -> {
                    this.operationValue = i;
                    this.defineButtonText();
                    return null;
                }));
            });
            this.buttonList.add(this.operationButton);
            this.buttonList.add(new GuiListModifier.RemoveElementButton(parent, 359, 0, 20, 20, this));
            this.buttonList.add(new GuiListModifier.AddElementButton(parent, 381, 0, 20, 20, this, parent.supplier));
            this.buttonList.add(new GuiListModifier.AddElementButton(parent, 359, 21, 43, 20, (Component)new TranslatableComponent("gui.act.give.copy"), (GuiListModifier.ListElement)this, () -> new AttributeListElement(parent, this.getData())));
            this.defineButtonText();
        }

        private void defineButtonText() {
            String s = this.data.getSlot() == null ? I18n.m_118938_((String)"gui.act.none", (Object[])new Object[0]) : I18n.m_118938_((String)("item.modifiers." + this.data.getSlot().m_20751_()), (Object[])new Object[0]);
            this.slotButton.m_93666_((Component)new TranslatableComponent("gui.act.modifier.attr.slot").m_130946_(" - ").m_130946_(s.endsWith(":") ? s.substring(0, s.length() - 1) : s));
            this.typeButton.m_93666_((Component)new TranslatableComponent("gui.act.modifier.attr.type").m_130946_(" - ").m_7220_((Component)new TranslatableComponent(this.data.getModifier().m_22214_())));
            this.operationButton.m_93666_((Component)new TranslatableComponent("gui.act.modifier.attr.operation").m_130946_(" - ").m_7220_((Component)new TranslatableComponent("gui.act.modifier.attr.operation." + this.operationValue)).m_130946_(" (").m_130946_(String.valueOf(this.operationValue)).m_130946_(")"));
        }

        @Override
        public void draw(PoseStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
            GuiUtils.drawRelative(matrixStack, (AbstractWidget)this.amount, offsetX, offsetY, mouseX, mouseY, partialTicks);
            GuiUtils.drawRightString(this.font, I18n.m_118938_((String)"gui.act.modifier.attr.amount", (Object[])new Object[0]) + " : ", (AbstractWidget)this.amount, (this.errAmount ? Color.RED : Color.WHITE).getRGB(), offsetX, offsetY);
            super.draw(matrixStack, offsetX, offsetY, mouseX, mouseY, partialTicks);
        }

        @Override
        public void init() {
            this.amount.m_94178_(false);
        }

        @Override
        public boolean isFocused() {
            return this.amount.m_93696_();
        }

        @Override
        public boolean charTyped(char key, int modifiers) {
            return this.amount.m_5534_(key, modifiers);
        }

        @Override
        public boolean keyPressed(int key, int scanCode, int modifiers) {
            this.amount.m_7933_(key, scanCode, modifiers);
            return super.keyPressed(key, scanCode, modifiers);
        }

        @Override
        public boolean match(String search) {
            return this.slotButton.m_6035_().getString().toLowerCase().contains(search.toLowerCase()) || this.typeButton.m_6035_().getString().toLowerCase().contains(search.toLowerCase()) || this.operationButton.m_6035_().getString().toLowerCase().contains(search.toLowerCase());
        }

        @Override
        public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
            this.amount.m_6375_((double)mouseX, (double)mouseY, mouseButton);
            if (mouseButton == 1 && GuiUtils.isHover((AbstractWidget)this.amount, mouseX, mouseY)) {
                this.amount.m_94144_("");
            }
            super.mouseClicked(mouseX, mouseY, mouseButton);
        }

        @Override
        public void update() {
            this.amount.m_94120_();
            try {
                this.amountValue = this.amount.m_94155_().isEmpty() ? 0.0 : Double.parseDouble(this.amount.m_94155_());
                this.errAmount = false;
            }
            catch (NumberFormatException e) {
                this.errAmount = true;
            }
            super.update();
        }

        public ItemUtils.AttributeData getData() {
            this.data.setModifier(new AttributeModifier(this.data.getModifier().m_22209_(), this.data.getModifier().m_22214_(), this.amountValue, AttributeModifier.Operation.m_22236_((int)this.operationValue)));
            return this.data;
        }
    }
}

