/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui.modifier;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fr.atesab.act.gui.GuiACT;
import fr.atesab.act.gui.modifier.GuiModifier;
import fr.atesab.act.utils.GuiUtils;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class GuiColorModifier
extends GuiModifier<OptionalInt> {
    private static final int PICKER_SIZE_Y = 200;
    private static final int PICKER_S_SIZE_X = 20;
    private static final int PICKER_HL_SIZE_X = 200;
    private static final ResourceLocation PICKER_S_RESOURCE = new ResourceLocation("act", "picker_hl");
    private static final ResourceLocation PICKER_HL_RESOURCE = new ResourceLocation("act", "picker_s");
    private static final DynamicTexture PICKER_IMAGE_S = new DynamicTexture(new NativeImage(NativeImage.Format.RGBA, 20, 200, false));
    private static final DynamicTexture PICKER_IMAGE_HL = new DynamicTexture(new NativeImage(NativeImage.Format.RGBA, 200, 200, false));
    private static final ItemStack RANDOM_PICKER = (ItemStack)Util.m_137469_((Object)new ItemStack((ItemLike)Items.f_42589_), it -> it.m_41784_());
    private static final int RANDOM_PICKER_FREQUENCY = 3600;
    private static int pickerHue;
    private static int pickerSaturation;
    private static int pickerLightness;
    private int oldAlphaLayer;
    private boolean transparentAsDefault;
    private int color;
    private DragState drag = DragState.NONE;
    private boolean advanced = false;
    private Button advButton;
    private EditBox tfr;
    private EditBox tfg;
    private EditBox tfb;
    private EditBox tfh;
    private EditBox tfs;
    private EditBox tfl;
    private EditBox intColor;
    private EditBox hexColor;
    private int defaultColor;
    private int localHue;
    private int localSaturation;
    private int localLightness;

    private static ItemStack updatePicker() {
        CompoundTag tag = RANDOM_PICKER.m_41783_();
        tag.m_128405_("CustomPotionColor", GuiUtils.getTimeColor(3600, 100, 50));
        RANDOM_PICKER.m_41751_(tag);
        return RANDOM_PICKER;
    }

    private static void setPickerState(int hue, int saturation, int lightness) {
        NativeImage pixels;
        if (hue != pickerHue || lightness != pickerLightness) {
            pickerHue = hue;
            pickerLightness = lightness;
            pixels = PICKER_IMAGE_S.m_117991_();
            for (int y = 0; y < pixels.m_85084_(); ++y) {
                int color = GuiUtils.fromHSL(hue, y * 100 / pixels.m_85084_(), lightness);
                for (int x = 0; x < pixels.m_84982_(); ++x) {
                    pixels.m_84988_(x, y, GuiUtils.blueToRed(color));
                }
            }
            PICKER_IMAGE_S.m_117985_();
        }
        if (saturation != pickerSaturation) {
            pickerSaturation = saturation;
            pixels = PICKER_IMAGE_HL.m_117991_();
            for (int x = 0; x < pixels.m_84982_(); ++x) {
                for (int y = 0; y < pixels.m_85084_(); ++y) {
                    pixels.m_84988_(x, y, GuiUtils.blueToRed(GuiUtils.fromHSL(x * 360 / pixels.m_84982_(), saturation, y * 100 / pixels.m_85084_())));
                }
            }
            PICKER_IMAGE_HL.m_117985_();
        }
    }

    public static void registerPickerImage() {
        TextureManager tm = Minecraft.m_91087_().m_91097_();
        GuiColorModifier.setPickerState(0, 0, 100);
        tm.m_118495_(PICKER_S_RESOURCE, (AbstractTexture)PICKER_IMAGE_S);
        tm.m_118495_(PICKER_HL_RESOURCE, (AbstractTexture)PICKER_IMAGE_HL);
    }

    public GuiColorModifier(Screen parent, Consumer<Integer> setter, int color) {
        this(parent, cd -> setter.accept(cd.getAsInt()), OptionalInt.of(color), 10511680, false);
    }

    public GuiColorModifier(Screen parent, Consumer<Integer> setter, int color, int defaultColor) {
        this(parent, cd -> setter.accept(cd.getAsInt()), OptionalInt.of(color), defaultColor, false);
    }

    public GuiColorModifier(Screen parent, Consumer<OptionalInt> setter, OptionalInt color, boolean transparentAsDefault) {
        this(parent, setter, color, color.orElse(0), transparentAsDefault);
    }

    private GuiColorModifier(Screen parent, Consumer<OptionalInt> setter, OptionalInt color, int defaultColor, boolean transparentAsDefault) {
        super(parent, (Component)new TranslatableComponent("gui.act.modifier.meta.setColor"), setter);
        int rgba = color.orElse(defaultColor);
        this.color = rgba & 0xFFFFFF;
        this.oldAlphaLayer = rgba & 0xFF000000;
        if (transparentAsDefault && !color.isPresent()) {
            this.color |= 0xFF000000;
        }
        this.defaultColor = defaultColor;
        this.transparentAsDefault = transparentAsDefault;
        GuiUtils.HSLResult hsl = GuiUtils.hslFromRGBA(rgba, pickerHue, pickerSaturation);
        boolean fullblack = (rgba & 0xFFFFFF) == 0;
        this.localHue = hsl.hue();
        this.localSaturation = fullblack ? 100 : hsl.saturation();
        this.localLightness = hsl.lightness();
    }

    public void m_96624_() {
        this.tfr.m_94120_();
        this.tfg.m_94120_();
        this.tfb.m_94120_();
        this.tfh.m_94120_();
        this.tfs.m_94120_();
        this.tfl.m_94120_();
        this.hexColor.m_94120_();
        this.intColor.m_94120_();
        super.m_96624_();
    }

    @Override
    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        GuiColorModifier.setPickerState(this.localHue, this.localSaturation, this.localLightness);
        this.m_7333_(matrixStack);
        if (!this.advanced) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)PICKER_S_RESOURCE);
            GuiUtils.drawScaledCustomSizeModalRect(this.f_96543_ / 2 + 180, this.f_96544_ / 2 - 76, 0.0f, 0.0f, 20, 200, 20, 152, 20.0f, 200.0f);
            int saturationDelta = pickerSaturation * 76 * 2 / 100;
            GuiUtils.drawRect(matrixStack, this.f_96543_ / 2 + 178, this.f_96544_ / 2 - 76 + saturationDelta - 2, this.f_96543_ / 2 + 178 + 22, this.f_96544_ / 2 - 76 + saturationDelta + 2, -14540254);
            GuiUtils.drawRect(matrixStack, this.f_96543_ / 2 + 180, this.f_96544_ / 2 - 76 + saturationDelta - 1, this.f_96543_ / 2 + 180 + 20, this.f_96544_ / 2 - 76 + saturationDelta + 1, -6710887);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)PICKER_HL_RESOURCE);
            GuiUtils.drawScaledCustomSizeModalRect(this.f_96543_ / 2 - 158, this.f_96544_ / 2 - 76, 0.0f, 0.0f, 200, 200, 334, 152, 200.0f, 200.0f);
            int hueDelta = pickerHue * 334 / 360;
            int lightnessDelta = pickerLightness * 152 / 100;
            GuiUtils.drawRect(matrixStack, this.f_96543_ / 2 - 158 + hueDelta - 5, this.f_96544_ / 2 - 76 + lightnessDelta - 2, this.f_96543_ / 2 - 158 + hueDelta - 5 + 10, this.f_96544_ / 2 - 76 + lightnessDelta - 2 + 4, -14540254);
            GuiUtils.drawRect(matrixStack, this.f_96543_ / 2 - 158 + hueDelta - 2, this.f_96544_ / 2 - 76 + lightnessDelta - 5, this.f_96543_ / 2 - 158 + hueDelta - 2 + 4, this.f_96544_ / 2 - 76 + lightnessDelta - 5 + 10, -14540254);
            GuiUtils.drawRect(matrixStack, this.f_96543_ / 2 - 158 + hueDelta - 4, this.f_96544_ / 2 - 76 + lightnessDelta - 1, this.f_96543_ / 2 - 158 + hueDelta - 4 + 8, this.f_96544_ / 2 - 76 + lightnessDelta - 1 + 2, -6710887);
            GuiUtils.drawRect(matrixStack, this.f_96543_ / 2 - 158 + hueDelta - 1, this.f_96544_ / 2 - 76 + lightnessDelta - 4, this.f_96543_ / 2 - 158 + hueDelta - 1 + 2, this.f_96544_ / 2 - 76 + lightnessDelta - 4 + 8, -6710887);
        } else {
            GuiUtils.drawRect(matrixStack, this.f_96543_ / 2 - 158, this.f_96544_ / 2 - 76, this.f_96543_ / 2 + 200, this.f_96544_ / 2 + 76, -2013265920);
            GuiUtils.drawRightString(this.f_96547_, I18n.m_118938_((String)"gui.act.red", (Object[])new Object[0]) + ": ", (AbstractWidget)this.tfr, -1);
            GuiUtils.drawRightString(this.f_96547_, I18n.m_118938_((String)"gui.act.green", (Object[])new Object[0]) + ": ", (AbstractWidget)this.tfg, -1);
            GuiUtils.drawRightString(this.f_96547_, I18n.m_118938_((String)"gui.act.blue", (Object[])new Object[0]) + ": ", (AbstractWidget)this.tfb, -1);
            GuiUtils.drawRightString(this.f_96547_, I18n.m_118938_((String)"gui.act.modifier.meta.setColor.hue", (Object[])new Object[0]) + ": ", (AbstractWidget)this.tfh, -1);
            GuiUtils.drawRightString(this.f_96547_, I18n.m_118938_((String)"gui.act.modifier.meta.setColor.lightness", (Object[])new Object[0]) + ": ", (AbstractWidget)this.tfl, -1);
            GuiUtils.drawRightString(this.f_96547_, I18n.m_118938_((String)"gui.act.modifier.meta.setColor.saturation", (Object[])new Object[0]) + ": ", (AbstractWidget)this.tfs, -1);
            GuiUtils.drawString(this.f_96547_, I18n.m_118938_((String)"gui.act.modifier.meta.setColor.intColor", (Object[])new Object[0]) + ":", this.intColor.f_93620_, this.intColor.f_93621_ - 4 - 10, -1, 10);
            GuiUtils.drawString(this.f_96547_, I18n.m_118938_((String)"gui.act.modifier.meta.setColor.hexColor", (Object[])new Object[0]) + ":", this.hexColor.f_93620_, this.hexColor.f_93621_ - 4 - 10, -1, 10);
            this.tfr.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            this.tfg.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            this.tfb.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            this.tfh.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            this.tfl.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            this.tfs.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            this.intColor.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            this.hexColor.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        }
        if ((this.color & 0xFF000000) == 0) {
            GuiUtils.drawRect(matrixStack, this.f_96543_ / 2 - 158, this.f_96544_ / 2 - 100, this.f_96543_ / 2 + 176, this.f_96544_ / 2 - 80, this.color | 0xFF000000);
        }
        Runnable show = () -> {};
        for (int i = 0; i < DyeColor.values().length; ++i) {
            DyeColor color = DyeColor.values()[i];
            int x = this.f_96543_ / 2 - 200 + i % 2 * 19;
            int y = this.f_96544_ / 2 - 76 + i / 2 * 19;
            GuiUtils.drawRect(matrixStack, x, y, x + 19, y + 19, 0xFF000000 | color.m_41070_());
            if (GuiUtils.isHover(x, y, 19, 19, mouseX, mouseY)) {
                show = () -> GuiUtils.drawTextBox(matrixStack, this.f_96547_, mouseX, mouseY, this.f_96543_, this.f_96544_, this.getZLevel(), I18n.m_118938_((String)("item.minecraft.firework_star." + color.m_41065_()), (Object[])new Object[0]));
            }
            GuiUtils.drawItemStack(this.f_96542_, this, new ItemStack((ItemLike)DyeItem.m_41082_((DyeColor)color)), x + 1, y + 1);
        }
        GuiUtils.drawHoverableRect(matrixStack, this.f_96543_ / 2 - 200, this.f_96544_ / 2 - 100, this.f_96543_ / 2 - 162, this.f_96544_ / 2 - 80, -12303292, GuiUtils.getTimeColor(3600, 50, 15), mouseX, mouseY);
        GuiUtils.drawItemStack(this.f_96542_, this, GuiColorModifier.updatePicker(), this.f_96543_ / 2 - 200 + 19 - 8, this.f_96544_ / 2 - 100 + 10 - 8);
        if (GuiUtils.isHover(this.f_96543_ / 2 - 200, this.f_96544_ / 2 - 100, 38, 20, mouseX, mouseY)) {
            show = () -> GuiUtils.drawTextBox(matrixStack, this.f_96547_, mouseX, mouseY, this.f_96543_, this.f_96544_, this.getZLevel(), I18n.m_118938_((String)"gui.act.modifier.meta.setColor.random", (Object[])new Object[0]));
        }
        GuiUtils.drawHoverableRect(matrixStack, this.f_96543_ / 2 + 180, this.f_96544_ / 2 - 100, this.f_96543_ / 2 + 200, this.f_96544_ / 2 - 80, -2276284, -48060, mouseX, mouseY);
        GuiUtils.drawCenterString(this.f_96547_, "x", this.f_96543_ / 2 + 190, this.f_96544_ / 2 - 100, -1, 20);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.setZLever(this.getZLevel() + 75.0f);
        show.run();
        this.setZLever(this.getZLevel() - 75.0f);
    }

    private void complete() {
        this.set((this.color & 0xFF000000) != 0 ? OptionalInt.empty() : OptionalInt.of(this.color | this.oldAlphaLayer));
    }

    public void m_7856_() {
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 200, this.f_96544_ / 2 + 80, 130, 20, (Component)new TranslatableComponent("gui.done"), b -> {
            this.complete();
            this.getMinecraft().m_91152_(this.parent);
        }));
        this.advButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 66, this.f_96544_ / 2 + 80, 132, 20, (Component)new TranslatableComponent("gui.act.advanced"), b -> {
            this.advanced ^= true;
            this.advButton.m_93666_((Component)new TranslatableComponent(this.advanced ? "gui.act.modifier.meta.setColor.picker" : "gui.act.advanced"));
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 70, this.f_96544_ / 2 + 80, 130, 20, (Component)new TranslatableComponent("gui.act.cancel"), b -> this.getMinecraft().m_91152_(this.parent)));
        int advWidth = 358;
        int midAdv = this.f_96543_ / 2 + 21;
        this.tfr = new EditBox(this.f_96547_, midAdv - 56, this.f_96544_ / 2 - 54, 56, 18, (Component)new TextComponent(""));
        this.tfg = new EditBox(this.f_96547_, midAdv - 56, this.f_96544_ / 2 - 26, 56, 18, (Component)new TextComponent(""));
        this.tfb = new EditBox(this.f_96547_, midAdv - 56, this.f_96544_ / 2 + 2, 56, 18, (Component)new TextComponent(""));
        int rightAdv = this.f_96543_ / 2 + 200;
        this.tfh = new EditBox(this.f_96547_, rightAdv - 56, this.f_96544_ / 2 - 54, 56, 18, (Component)new TextComponent(""));
        this.tfl = new EditBox(this.f_96547_, rightAdv - 56, this.f_96544_ / 2 - 26, 56, 18, (Component)new TextComponent(""));
        this.tfs = new EditBox(this.f_96547_, rightAdv - 56, this.f_96544_ / 2 + 2, 56, 18, (Component)new TextComponent(""));
        int intHexWidth = (advWidth - 4 - 4) / 2;
        this.intColor = new EditBox(this.f_96547_, midAdv - intHexWidth, this.f_96544_ / 2 + 40, intHexWidth, 18, (Component)new TextComponent(""));
        this.hexColor = new EditBox(this.f_96547_, midAdv + 4, this.f_96544_ / 2 + 40, intHexWidth, 18, (Component)new TextComponent(""));
        this.tfr.m_94199_(4);
        this.tfg.m_94199_(4);
        this.tfb.m_94199_(4);
        this.tfh.m_94199_(4);
        this.tfl.m_94199_(4);
        this.tfs.m_94199_(4);
        this.updateColor(this.color);
        super.m_7856_();
    }

    public boolean m_5534_(char key, int modifiers) {
        if (this.advanced) {
            this.tfr.m_5534_(key, modifiers);
            this.tfg.m_5534_(key, modifiers);
            this.tfb.m_5534_(key, modifiers);
            this.tfh.m_5534_(key, modifiers);
            this.tfl.m_5534_(key, modifiers);
            this.tfs.m_5534_(key, modifiers);
            this.hexColor.m_5534_(key, modifiers);
            this.intColor.m_5534_(key, modifiers);
            if (this.tfr.m_93696_()) {
                try {
                    this.updateRed(this.tfr.m_94155_().isEmpty() ? 0 : Integer.valueOf(this.tfr.m_94155_()));
                }
                catch (Exception exception) {}
            } else if (this.tfg.m_93696_()) {
                try {
                    this.updateGreen(this.tfg.m_94155_().isEmpty() ? 0 : Integer.valueOf(this.tfg.m_94155_()));
                }
                catch (Exception exception) {}
            } else if (this.tfb.m_93696_()) {
                try {
                    this.updateBlue(this.tfb.m_94155_().isEmpty() ? 0 : Integer.valueOf(this.tfb.m_94155_()));
                }
                catch (Exception exception) {}
            } else if (this.tfh.m_93696_()) {
                try {
                    this.updateHue(this.tfh.m_94155_().isEmpty() ? 0 : Integer.valueOf(this.tfh.m_94155_()));
                }
                catch (Exception exception) {}
            } else if (this.tfs.m_93696_()) {
                try {
                    this.updateSaturation(this.tfs.m_94155_().isEmpty() ? 0 : Integer.valueOf(this.tfs.m_94155_()));
                }
                catch (Exception exception) {}
            } else if (this.tfl.m_93696_()) {
                try {
                    this.updateLightness(this.tfl.m_94155_().isEmpty() ? 0 : Integer.valueOf(this.tfl.m_94155_()));
                }
                catch (Exception exception) {}
            } else if (this.hexColor.m_93696_()) {
                try {
                    String s = this.hexColor.m_94155_().substring(1);
                    this.updateColor(s.isEmpty() ? 0 : Integer.valueOf(s, 16));
                }
                catch (Exception exception) {}
            } else if (this.intColor.m_93696_()) {
                try {
                    this.updateColor(this.intColor.m_94155_().isEmpty() ? 0 : Integer.valueOf(this.intColor.m_94155_()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return super.m_5534_(key, modifiers);
    }

    @Override
    public boolean m_7933_(int key, int scanCode, int modifiers) {
        if (this.advanced) {
            this.tfr.m_7933_(key, scanCode, modifiers);
            this.tfg.m_7933_(key, scanCode, modifiers);
            this.tfb.m_7933_(key, scanCode, modifiers);
            this.tfh.m_7933_(key, scanCode, modifiers);
            this.tfl.m_7933_(key, scanCode, modifiers);
            this.tfs.m_7933_(key, scanCode, modifiers);
            this.hexColor.m_7933_(key, scanCode, modifiers);
            this.intColor.m_7933_(key, scanCode, modifiers);
            if (this.tfr.m_93696_()) {
                try {
                    this.updateRed(this.tfr.m_94155_().isEmpty() ? 0 : Integer.valueOf(this.tfr.m_94155_()));
                }
                catch (Exception exception) {}
            } else if (this.tfg.m_93696_()) {
                try {
                    this.updateGreen(this.tfg.m_94155_().isEmpty() ? 0 : Integer.valueOf(this.tfg.m_94155_()));
                }
                catch (Exception exception) {}
            } else if (this.tfb.m_93696_()) {
                try {
                    this.updateBlue(this.tfb.m_94155_().isEmpty() ? 0 : Integer.valueOf(this.tfb.m_94155_()));
                }
                catch (Exception exception) {}
            } else if (this.tfh.m_93696_()) {
                try {
                    this.updateHue(this.tfh.m_94155_().isEmpty() ? 0 : Integer.valueOf(this.tfh.m_94155_()));
                }
                catch (Exception exception) {}
            } else if (this.tfs.m_93696_()) {
                try {
                    this.updateSaturation(this.tfs.m_94155_().isEmpty() ? 0 : Integer.valueOf(this.tfs.m_94155_()));
                }
                catch (Exception exception) {}
            } else if (this.tfl.m_93696_()) {
                try {
                    this.updateLightness(this.tfl.m_94155_().isEmpty() ? 0 : Integer.valueOf(this.tfl.m_94155_()));
                }
                catch (Exception exception) {}
            } else if (this.hexColor.m_93696_()) {
                try {
                    String s = this.hexColor.m_94155_().substring(1);
                    this.updateColor(s.isEmpty() ? 0 : Integer.valueOf(s, 16));
                }
                catch (Exception exception) {}
            } else if (this.intColor.m_93696_()) {
                try {
                    this.updateColor(this.intColor.m_94155_().isEmpty() ? 0 : Integer.valueOf(this.intColor.m_94155_()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return super.m_7933_(key, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.advanced) {
            if (mouseButton == 1) {
                if (GuiUtils.isHover((AbstractWidget)this.tfr, (int)mouseX, (int)mouseY)) {
                    this.tfr.m_94144_("");
                    return true;
                }
                if (GuiUtils.isHover((AbstractWidget)this.tfg, (int)mouseX, (int)mouseY)) {
                    this.tfg.m_94144_("");
                    return true;
                }
                if (GuiUtils.isHover((AbstractWidget)this.tfb, (int)mouseX, (int)mouseY)) {
                    this.tfb.m_94144_("");
                    return true;
                }
                if (GuiUtils.isHover((AbstractWidget)this.tfh, (int)mouseX, (int)mouseY)) {
                    this.tfh.m_94144_("");
                    return true;
                }
                if (GuiUtils.isHover((AbstractWidget)this.tfl, (int)mouseX, (int)mouseY)) {
                    this.tfl.m_94144_("");
                    return true;
                }
                if (GuiUtils.isHover((AbstractWidget)this.tfs, (int)mouseX, (int)mouseY)) {
                    this.tfs.m_94144_("");
                    return true;
                }
                if (GuiUtils.isHover((AbstractWidget)this.intColor, (int)mouseX, (int)mouseY)) {
                    this.intColor.m_94144_("");
                    return true;
                }
                if (GuiUtils.isHover((AbstractWidget)this.hexColor, (int)mouseX, (int)mouseY)) {
                    this.hexColor.m_94144_("#");
                    return true;
                }
            }
            this.tfr.m_6375_(mouseX, mouseY, mouseButton);
            this.tfg.m_6375_(mouseX, mouseY, mouseButton);
            this.tfb.m_6375_(mouseX, mouseY, mouseButton);
            this.tfh.m_6375_(mouseX, mouseY, mouseButton);
            this.tfl.m_6375_(mouseX, mouseY, mouseButton);
            this.tfs.m_6375_(mouseX, mouseY, mouseButton);
            this.intColor.m_6375_(mouseX, mouseY, mouseButton);
            this.hexColor.m_6375_(mouseX, mouseY, mouseButton);
        }
        this.drag = DragState.NONE;
        if (mouseButton == 0) {
            if (!this.advanced && GuiUtils.isHover(this.f_96543_ / 2 - 158, this.f_96544_ / 2 - 76, 334, 152, (int)mouseX, (int)mouseY)) {
                this.setColor((int)mouseX, (int)mouseY, DragState.HL);
            } else if (!this.advanced && GuiUtils.isHover(this.f_96543_ / 2 + 180, this.f_96544_ / 2 - 76, 20, 152, (int)mouseX, (int)mouseY)) {
                this.setColor((int)mouseX, (int)mouseY, DragState.S);
            } else {
                if (GuiUtils.isHover(this.f_96543_ / 2 + 180, this.f_96544_ / 2 - 100, 20, 20, (int)mouseX, (int)mouseY)) {
                    if (this.transparentAsDefault) {
                        this.color |= 0xFF000000;
                    } else {
                        this.oldAlphaLayer = this.defaultColor & 0xFF000000;
                        this.updateColor(this.defaultColor & 0xFFFFFF);
                    }
                    GuiColorModifier.playClick();
                    return true;
                }
                if (GuiUtils.isHover(this.f_96543_ / 2 - 200, this.f_96544_ / 2 - 100, 38, 20, (int)mouseX, (int)mouseY)) {
                    this.updateColor(GuiUtils.getRandomColor() & 0xFFFFFF);
                    GuiColorModifier.playClick();
                    return true;
                }
                for (int i = 0; i < DyeColor.values().length; ++i) {
                    if (!GuiUtils.isHover(this.f_96543_ / 2 - 200 + i % 2 * 19, this.f_96544_ / 2 - 76 + i / 2 * 19, 19, 19, (int)mouseX, (int)mouseY)) continue;
                    this.updateColor(DyeColor.values()[i].m_41070_());
                    GuiColorModifier.playClick();
                    return true;
                }
            }
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int clickedMouseButton, double dx, double dy) {
        this.setColor((int)mouseX, (int)mouseY, this.drag);
        return super.m_7979_(mouseX, mouseY, clickedMouseButton, dx, dy);
    }

    private void updateColor(int h, int s, int l) {
        this.updateColor(h % 360, s, l, GuiUtils.fromHSL(h % 360, s, l));
    }

    private void updateColor(int rgba) {
        GuiUtils.HSLResult hsl = GuiUtils.hslFromRGBA(rgba, this.localHue, this.localSaturation);
        this.updateColor(hsl.hue(), hsl.saturation(), hsl.lightness(), rgba);
    }

    private void updateColor(int h, int s, int l, int rgba) {
        this.localHue = h;
        this.localSaturation = s;
        this.localLightness = l;
        this.tfh.m_94144_("" + this.localHue);
        this.tfs.m_94144_("" + this.localSaturation);
        this.tfl.m_94144_("" + this.localLightness);
        GuiColorModifier.setPickerState(this.localHue, this.localSaturation, this.localLightness);
        this.color = rgba & 0xFFFFFF;
        this.tfr.m_94144_("" + (this.color >> 16 & 0xFF));
        this.tfg.m_94144_("" + (this.color >> 8 & 0xFF));
        this.tfb.m_94144_("" + (this.color >> 0 & 0xFF));
        this.intColor.m_94144_("" + this.color);
        this.hexColor.m_94144_("#" + Integer.toHexString(this.color));
    }

    private void setColor(int mouseX, int mouseY, DragState dragState) {
        this.drag = dragState;
        if (this.drag == DragState.NONE) {
            return;
        }
        switch (this.drag) {
            case HL: {
                int hue = GuiUtils.clamp(mouseX - (this.f_96543_ / 2 - 158), 0, 334) * 360 / 335;
                int lightness = GuiUtils.clamp(mouseY - (this.f_96544_ / 2 - 76), 0, 152) * 100 / 152;
                this.updateColor(hue, pickerSaturation, lightness);
                break;
            }
            case S: {
                int saturation = GuiUtils.clamp(mouseY - (this.f_96544_ / 2 - 76), 0, 152) * 100 / 152;
                this.updateColor(pickerHue, saturation, pickerLightness);
                break;
            }
        }
    }

    private void updateRed(int v) {
        this.updateColor((v & 0xFF) << 16 | (this.color >> 8 & 0xFF & 0xFF) << 8 | (this.color >> 0 & 0xFF & 0xFF) << 0);
    }

    private void updateGreen(int v) {
        this.updateColor((this.color >> 16 & 0xFF & 0xFF) << 16 | (v & 0xFF) << 8 | (this.color >> 0 & 0xFF & 0xFF) << 0);
    }

    private void updateBlue(int v) {
        this.updateColor((this.color >> 16 & 0xFF & 0xFF) << 16 | (this.color >> 8 & 0xFF & 0xFF) << 8 | (v & 0xFF) << 0);
    }

    private void updateHue(int v) {
        if ((v %= 360) < 0) {
            v += 360;
        }
        this.updateColor(v, pickerSaturation, pickerLightness);
    }

    private void updateSaturation(int v) {
        v = GuiUtils.clamp(v, 0, 100);
        this.updateColor(pickerHue, v, pickerLightness);
    }

    private void updateLightness(int v) {
        v = GuiUtils.clamp(v, 0, 100);
        this.updateColor(pickerHue, pickerSaturation, v);
    }

    @Override
    protected void generateDev(List<GuiACT.ACTDevInfo> entries, int mouseX, int mouseY) {
        entries.add(GuiColorModifier.devInfo("HEX", "#" + Integer.toHexString(this.color & 0xFFFFFF | 0xF000000).substring(1)));
        entries.add(GuiColorModifier.devInfo("HSL", pickerHue + "/" + pickerSaturation + "/" + pickerLightness));
        GuiUtils.RGBResult res = GuiUtils.rgbaFromRGBA(this.color);
        entries.add(GuiColorModifier.devInfo("RGB", res.red() + "/" + res.green() + "/" + res.blue()));
        super.generateDev(entries, mouseX, mouseY);
    }

    private static enum DragState {
        HL,
        S,
        NONE;

    }
}

