/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui.modifier;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.atesab.act.gui.modifier.GuiListModifier;
import fr.atesab.act.utils.GuiUtils;
import fr.atesab.act.utils.Tuple;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.enchantment.Enchantment;

public class GuiEnchModifier
extends GuiListModifier<List<Tuple<Enchantment, Integer>>> {
    public GuiEnchModifier(Screen parent, List<Tuple<Enchantment, Integer>> ench, Consumer<List<Tuple<Enchantment, Integer>>> setter) {
        super(parent, (Component)new TranslatableComponent("gui.act.modifier.ench"), new ArrayList<GuiListModifier.ListElement>(), setter, null);
        this.buttons = new Tuple[]{new Tuple<String, Tuple<Runnable, Runnable>>(I18n.m_118938_((String)"gui.act.modifier.ench.max", (Object[])new Object[0]), new Tuple<Runnable, Runnable>(() -> this.getElements().stream().map(le -> (EnchListElement)le).forEach(ele -> {
            ele.level = ele.enchantment.m_6586_();
            ele.textField.m_94144_(String.valueOf(ele.level));
        }), () -> this.getElements().stream().map(le -> (EnchListElement)le).forEach(ele -> {
            ele.textField.m_94144_("");
            ele.level = 0;
        })))};
        ench.forEach(e -> this.addListElement(new EnchListElement((Enchantment)e.a, (int)((Integer)e.b))));
    }

    @Override
    protected List<Tuple<Enchantment, Integer>> get() {
        ArrayList<Tuple<Enchantment, Integer>> list = new ArrayList<Tuple<Enchantment, Integer>>();
        this.getElements().forEach(le -> {
            EnchListElement ele = (EnchListElement)le;
            list.add(new Tuple<Enchantment, Integer>(ele.enchantment, ele.level));
        });
        return list;
    }

    static class EnchListElement
    extends GuiListModifier.ListElement {
        private Enchantment enchantment;
        private int level;
        private EditBox textField;
        private boolean err = false;

        public EnchListElement(Enchantment enchantment, int level) {
            super(200, 21);
            this.enchantment = enchantment;
            this.level = level;
            this.textField = new EditBox(this.font, 112, 1, 46, 18, (Component)new TextComponent(""));
            this.textField.m_94199_(6);
            this.textField.m_94144_(String.valueOf(level == 0 ? "" : Integer.valueOf(level)));
            this.buttonList.add(new Button(160, 0, 40, 20, (Component)new TranslatableComponent("gui.act.modifier.ench.max"), b -> this.textField.m_94144_(String.valueOf(enchantment.m_6586_()))));
        }

        @Override
        public void draw(PoseStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
            GuiUtils.drawRelative(matrixStack, (AbstractWidget)this.textField, offsetX, offsetY, mouseY, mouseY, partialTicks);
            GuiUtils.drawRightString(this.font, I18n.m_118938_((String)this.enchantment.m_44704_(), (Object[])new Object[0]) + " : ", offsetX + this.textField.f_93620_, offsetY + this.textField.f_93621_, (this.err ? Color.RED : (this.level == 0 ? Color.GRAY : Color.WHITE)).getRGB(), this.textField.m_93694_());
            super.draw(matrixStack, offsetX, offsetY, mouseX, mouseY, partialTicks);
        }

        @Override
        public void init() {
            this.textField.m_94178_(false);
        }

        @Override
        public boolean isFocused() {
            return this.textField.m_93696_();
        }

        @Override
        public boolean charTyped(char key, int modifiers) {
            return this.textField.m_5534_(key, modifiers) || super.charTyped(key, modifiers);
        }

        @Override
        public boolean keyPressed(int key, int scanCode, int modifiers) {
            return this.textField.m_7933_(key, scanCode, modifiers) || super.keyPressed(key, scanCode, modifiers);
        }

        @Override
        public boolean match(String search) {
            return I18n.m_118938_((String)this.enchantment.m_44704_(), (Object[])new Object[0]).toLowerCase().contains(search.toLowerCase());
        }

        @Override
        public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
            this.textField.m_6375_((double)mouseX, (double)mouseY, mouseButton);
            if (mouseButton == 1 && GuiUtils.isHover((AbstractWidget)this.textField, mouseX, mouseY)) {
                this.textField.m_94144_("");
            }
            super.mouseClicked(mouseX, mouseY, mouseButton);
        }

        @Override
        public void update() {
            this.textField.m_94120_();
            try {
                this.level = this.textField.m_94155_().isEmpty() ? 0 : Integer.valueOf(this.textField.m_94155_());
                this.err = false;
            }
            catch (NumberFormatException e) {
                this.err = true;
            }
            super.update();
        }
    }
}

