/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui.modifier;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.atesab.act.gui.ColorList;
import fr.atesab.act.gui.modifier.GuiBooleanButton;
import fr.atesab.act.gui.modifier.GuiListModifier;
import fr.atesab.act.gui.modifier.GuiModifier;
import fr.atesab.act.gui.selector.GuiButtonListSelector;
import fr.atesab.act.utils.GuiUtils;
import fr.atesab.act.utils.ItemUtils;
import fr.atesab.act.utils.Tuple;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.FireworkRocketItem;

public class GuiFireworksModifer
extends GuiListModifier<CompoundTag> {
    private FireworkMainListElement main;
    private Supplier<GuiListModifier.ListElement> builder = () -> new ExplosionListElement(this, null);

    public GuiFireworksModifer(Screen parent, Consumer<CompoundTag> setter, CompoundTag tag) {
        super(parent, (Component)new TranslatableComponent("gui.act.modifier.meta.fireworks"), new ArrayList<GuiListModifier.ListElement>(), setter, new Tuple[0]);
        this.main = new FireworkMainListElement(tag.m_128441_("Flight") ? tag.m_128451_("Flight") : 1);
        this.addListElement(this.main);
        tag.m_128437_("Explosions", 10).forEach(base -> this.addListElement(new ExplosionListElement(this, (CompoundTag)base)));
        this.addListElement(new GuiListModifier.AddElementList(this, this.builder));
    }

    @Override
    protected CompoundTag get() {
        CompoundTag newTag = new CompoundTag();
        newTag.m_128405_("Flight", this.main.value);
        ListTag explosions = new ListTag();
        this.getElements().stream().filter(le -> le instanceof ExplosionListElement).forEach(le -> explosions.add((Object)((ExplosionListElement)le).exp.getTag()));
        newTag.m_128365_("Explosions", (Tag)explosions);
        return newTag;
    }

    private static class FireworkMainListElement
    extends GuiListModifier.ListElement {
        private EditBox flight;
        private int value;
        private boolean err;
        private String title = I18n.m_118938_((String)"item.minecraft.firework_rocket.flight", (Object[])new Object[0]);

        public FireworkMainListElement(int flight) {
            super(200, 29);
            if (this.title.endsWith(":")) {
                this.title = this.title.substring(0, this.title.length() - 1);
            }
            this.title = this.title + " : ";
            int l = this.font.m_92895_(this.title + " : ") + 5;
            this.flight = new EditBox(this.font, l, 2, 196 - l, 16, (Component)new TextComponent(""));
            this.flight.m_94199_(6);
            this.flight.m_94144_("" + flight);
        }

        @Override
        public void init() {
            this.flight.m_94178_(false);
            super.init();
        }

        @Override
        public boolean isFocused() {
            return this.flight.m_93696_();
        }

        @Override
        public void draw(PoseStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
            GuiUtils.drawRelative(matrixStack, (AbstractWidget)this.flight, offsetX, offsetY, mouseY, mouseY, partialTicks);
            GuiUtils.drawString(this.font, this.title, offsetX, offsetY, (this.err ? Color.RED : Color.WHITE).getRGB(), this.flight.m_93694_());
            super.draw(matrixStack, offsetX, offsetY, mouseX, mouseY, partialTicks);
        }

        @Override
        public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
            this.flight.m_6375_((double)mouseX, (double)mouseY, mouseButton);
            if (GuiUtils.isHover((AbstractWidget)this.flight, mouseX, mouseY) && mouseButton == 1) {
                this.flight.m_94144_("");
            }
            super.mouseClicked(mouseX, mouseY, mouseButton);
        }

        @Override
        public void update() {
            this.flight.m_94120_();
            try {
                this.value = this.flight.m_94155_().isEmpty() ? 0 : Integer.valueOf(this.flight.m_94155_());
                this.err = false;
            }
            catch (NumberFormatException e) {
                this.err = true;
            }
            super.update();
        }

        @Override
        public boolean charTyped(char key, int modifiers) {
            return this.flight.m_5534_(key, modifiers) || super.charTyped(key, modifiers);
        }

        @Override
        public boolean keyPressed(int key, int scanCode, int modifiers) {
            return this.flight.m_7933_(key, scanCode, modifiers) || super.keyPressed(key, scanCode, modifiers);
        }
    }

    private static class ExplosionListElement
    extends GuiListModifier.ListElement {
        private ItemUtils.ExplosionInformation exp;
        private GuiFireworksModifer parent;

        public ExplosionListElement(GuiFireworksModifer parent, CompoundTag expData) {
            super(204, 29);
            this.exp = ItemUtils.getExplosionInformation(expData);
            this.parent = parent;
            this.buttonList.add(new Button(0, 0, 100, 20, (Component)new TranslatableComponent("gui.act.modifier.meta.explosion"), b -> this.mc.m_91152_((Screen)new GuiExplosionModifier((Screen)parent, exp -> {
                this.exp = exp;
            }, this.exp))));
            this.buttonList.add(new GuiListModifier.RemoveElementButton(parent, 101, 0, 20, 20, this));
            this.buttonList.add(new GuiListModifier.AddElementButton(parent, 122, 0, 20, 20, this, parent.builder));
            this.buttonList.add(new GuiListModifier.AddElementButton(parent, 143, 0, 60, 20, (Component)new TranslatableComponent("gui.act.give.copy"), (GuiListModifier.ListElement)this, () -> new ExplosionListElement(parent, this.exp.getTag())));
        }

        @Override
        public boolean match(String search) {
            String s = search.toLowerCase();
            return I18n.m_118938_((String)"gui.act.modifier.type", (Object[])new Object[0]).toLowerCase().contains(s) || I18n.m_118938_((String)("item.minecraft.firework_star.shape." + this.exp.getType().m_41236_()), (Object[])new Object[0]).toLowerCase().contains(s) || I18n.m_118938_((String)"item.minecraft.firework_star.trail", (Object[])new Object[0]).toLowerCase().contains(s) || I18n.m_118938_((String)"item.minecraft.firework_star.flicker", (Object[])new Object[0]).toLowerCase().contains(s) || I18n.m_118938_((String)"gui.act.modifier.meta.explosion.color", (Object[])new Object[0]).toLowerCase().contains(s) || I18n.m_118938_((String)"gui.act.modifier.meta.explosion.fadeColor", (Object[])new Object[0]).toLowerCase().contains(s);
        }

        @Override
        public void drawNext(PoseStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
            if (GuiUtils.isHover(0, 0, 200, 20, mouseX, mouseY)) {
                int j;
                int y;
                int i;
                ArrayList<Object> data = new ArrayList<Object>();
                String type = I18n.m_118938_((String)"gui.act.modifier.type", (Object[])new Object[0]) + " : " + ChatFormatting.YELLOW + I18n.m_118938_((String)("item.minecraft.firework_star.shape." + this.exp.getType().m_41241_()), (Object[])new Object[0]);
                String trail = I18n.m_118938_((String)"item.minecraft.firework_star.trail", (Object[])new Object[0]);
                String flicker = I18n.m_118938_((String)"item.minecraft.firework_star.flicker", (Object[])new Object[0]);
                String color = I18n.m_118938_((String)"gui.act.modifier.meta.explosion.color", (Object[])new Object[0]) + " : ";
                String fadeColor = I18n.m_118938_((String)"gui.act.modifier.meta.explosion.fadeColor", (Object[])new Object[0]) + " : ";
                data.add(type);
                int width = this.font.m_92895_(type);
                if (this.exp.isTrail()) {
                    data.add(trail);
                    width = Math.max(width, this.font.m_92895_(trail));
                }
                if (this.exp.isFlicker()) {
                    data.add(flicker);
                    width = Math.max(width, this.font.m_92895_(flicker));
                }
                if (this.exp.getColors().length != 0) {
                    data.add(color);
                    Objects.requireNonNull(this.font);
                    width = Math.max(width, (9 + 1) * this.exp.getColors().length + this.font.m_92895_(color));
                }
                if (this.exp.getFadeColors().length != 0) {
                    data.add(fadeColor);
                    Objects.requireNonNull(this.font);
                    width = Math.max(width, (9 + 1) * this.exp.getFadeColors().length + this.font.m_92895_(fadeColor));
                }
                int n = data.size();
                Objects.requireNonNull(this.font);
                int height = n * (1 + 9) + 2;
                Tuple<Integer, Integer> pos = GuiUtils.getRelativeBoxPos(mouseX + offsetX, mouseY + offsetY, width += 2, height, this.parent.f_96543_, this.parent.f_96544_);
                GuiUtils.drawBox(matrixStack, (Integer)pos.a, (Integer)pos.b, width, height, this.parent.getZLevel());
                Tuple<Integer, Integer> tuple = pos;
                Integer n2 = (Integer)tuple.a;
                tuple.a = (Integer)tuple.a + 1;
                tuple = pos;
                tuple.b = (Integer)tuple.b + 2;
                for (i = 0; i < data.size(); ++i) {
                    String string = (String)data.get(i);
                    float f = ((Integer)pos.a).intValue();
                    int n3 = (Integer)pos.b;
                    Objects.requireNonNull(this.font);
                    this.font.m_92883_(matrixStack, string, f, (float)(n3 + i * (9 + 1)), -1);
                }
                if (this.exp.getFadeColors().length != 0) {
                    int x = (Integer)pos.a + this.font.m_92895_(fadeColor);
                    int n4 = (Integer)pos.b;
                    Objects.requireNonNull(this.font);
                    y = n4 + --i * (9 + 1);
                    for (j = 0; j < this.exp.getFadeColors().length; ++j) {
                        Objects.requireNonNull(this.font);
                        Objects.requireNonNull(this.font);
                        GuiUtils.drawGradientRect(matrixStack, x, y, x + 9, y + 9, 0xFF000000 | this.exp.getFadeColors()[j], 0xFF000000 | this.exp.getFadeColors()[j], this.parent.getZLevel());
                        Objects.requireNonNull(this.font);
                        x += 9 + 1;
                    }
                }
                if (this.exp.getColors().length != 0) {
                    int x = (Integer)pos.a + this.font.m_92895_(color);
                    int n5 = (Integer)pos.b;
                    Objects.requireNonNull(this.font);
                    y = n5 + --i * (9 + 1);
                    for (j = 0; j < this.exp.getColors().length; ++j) {
                        Objects.requireNonNull(this.font);
                        Objects.requireNonNull(this.font);
                        GuiUtils.drawGradientRect(matrixStack, x, y, x + 9, y + 9, 0xFF000000 | this.exp.getColors()[j], 0xFF000000 | this.exp.getColors()[j], this.parent.getZLevel());
                        Objects.requireNonNull(this.font);
                        x += 9 + 1;
                    }
                }
            }
            super.drawNext(matrixStack, offsetX, offsetY, mouseX, mouseY, partialTicks);
        }
    }

    public static class GuiExplosionModifier
    extends GuiModifier<ItemUtils.ExplosionInformation> {
        private ItemUtils.ExplosionInformation exp;
        private ColorList colors;
        private ColorList fadeColors;
        private Button type;

        public GuiExplosionModifier(Screen parent, Consumer<ItemUtils.ExplosionInformation> setter, ItemUtils.ExplosionInformation exp) {
            super(parent, (Component)new TranslatableComponent("gui.act.modifier.meta.fireworks"), setter);
            this.exp = exp.clone();
            this.colors = new ColorList(this, 0, 0, 6, exp.getColors(), I18n.m_118938_((String)"gui.act.modifier.meta.explosion.color", (Object[])new Object[0]), 24);
            this.fadeColors = new ColorList(this, 0, 0, 6, exp.getFadeColors(), I18n.m_118938_((String)"gui.act.modifier.meta.explosion.fadeColor", (Object[])new Object[0]), 24);
        }

        private void defineButton() {
            this.type.m_93666_((Component)new TranslatableComponent("item.minecraft.firework_star.shape." + this.exp.getType().m_41241_()));
        }

        public void m_7856_() {
            this.colors.x = this.f_96543_ / 2;
            this.colors.y = this.f_96544_ / 2 - 42;
            this.fadeColors.x = this.f_96543_ / 2 + 100;
            this.fadeColors.y = this.f_96544_ / 2 - 42;
            this.type = new Button(this.f_96543_ / 2 - 200, this.f_96544_ / 2 - 42, 199, 20, (Component)new TextComponent(""), b -> {
                ArrayList elements = new ArrayList(FireworkRocketItem.Shape.values().length);
                for (FireworkRocketItem.Shape s2 : FireworkRocketItem.Shape.values()) {
                    elements.add(new Tuple<String, FireworkRocketItem.Shape>(I18n.m_118938_((String)("item.minecraft.firework_star.shape." + s2.m_41241_()), (Object[])new Object[0]), s2));
                }
                this.mc.m_91152_(new GuiButtonListSelector<FireworkRocketItem.Shape>(this, (Component)new TranslatableComponent("gui.act.modifier.meta.explosion.shape"), elements, s -> {
                    this.exp.type((FireworkRocketItem.Shape)s);
                    this.defineButton();
                    return null;
                }));
            });
            this.m_142416_((GuiEventListener)this.type);
            this.m_142416_((GuiEventListener)new GuiBooleanButton(this.f_96543_ / 2 - 200, this.f_96544_ / 2 - 21, 199, 20, (Component)new TranslatableComponent("item.minecraft.firework_star.trail"), this.exp::trail, this.exp::isTrail));
            this.m_142416_((GuiEventListener)new GuiBooleanButton(this.f_96543_ / 2 - 200, this.f_96544_ / 2, 199, 20, (Component)new TranslatableComponent("item.minecraft.firework_star.flicker"), this.exp::flicker, this.exp::isFlicker));
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ / 2 + 21, 99, 20, (Component)new TranslatableComponent("gui.done"), b -> {
                this.set(this.exp.colors(this.colors.getColors()).fadeColors(this.fadeColors.getColors()));
                this.getMinecraft().m_91152_(this.parent);
            }));
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 200, this.f_96544_ / 2 + 21, 99, 20, (Component)new TranslatableComponent("gui.act.cancel"), b -> this.getMinecraft().m_91152_(this.parent)));
            this.defineButton();
            super.m_7856_();
        }

        @Override
        public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            this.m_7333_(matrixStack);
            this.colors.draw(matrixStack, mouseX, mouseY, this.getZLevel());
            this.fadeColors.draw(matrixStack, mouseX, mouseY, this.getZLevel());
            super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            this.colors.drawNext(matrixStack, mouseX, mouseY, this.getZLevel());
            this.fadeColors.drawNext(matrixStack, mouseX, mouseY, this.getZLevel());
        }

        public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
            this.colors.mouseClick((int)mouseX, (int)mouseY, mouseButton);
            this.fadeColors.mouseClick((int)mouseX, (int)mouseY, mouseButton);
            return super.m_6375_(mouseX, mouseY, mouseButton);
        }
    }
}

