/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui.modifier;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.atesab.act.gui.modifier.GuiModifier;
import fr.atesab.act.utils.GuiUtils;
import fr.atesab.act.utils.ItemUtils;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;

public class GuiHeadModifier
extends GuiModifier<ItemStack> {
    private ItemStack stack;
    private EditBox name;
    private EditBox uuid;
    private EditBox link;
    private Button save;
    private Button loadName;
    private Button loadLink;
    private Thread saveThread = null;
    private AtomicReference<String> errType = new AtomicReference<Object>(null);
    private AtomicReference<String> err = new AtomicReference<Object>(null);

    public GuiHeadModifier(Screen parent, Consumer<ItemStack> setter, ItemStack stack) {
        super(parent, (Component)new TranslatableComponent("gui.act.modifier.head"), setter);
        this.stack = stack.m_41777_();
    }

    @Override
    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        boolean flagName;
        this.m_7333_(matrixStack);
        ArrayList<Object> err = new ArrayList<Object>();
        boolean flagLink = (this.link.m_94155_().isEmpty() || !this.link.m_94155_().matches("http://textures.minecraft.net/texture/[a-zA-Z0-9]+")) && !this.link.m_94155_().isEmpty();
        boolean flagUuid = (this.uuid.m_94155_().isEmpty() || !this.uuid.m_94155_().matches("[0-9A-Fa-f]+-[0-9A-Fa-f]+-[0-9A-Fa-f]+-[0-9A-Fa-f]+-[0-9A-Fa-f]+")) && !this.uuid.m_94155_().isEmpty();
        boolean bl = flagName = (this.name.m_94155_().isEmpty() || !this.name.m_94155_().matches("([0-9A-Za-z_]|(-))+")) && !this.name.m_94155_().isEmpty();
        if (flagLink) {
            err.add(I18n.m_118938_((String)"gui.act.modifier.head.link.warning", (Object[])new Object[0]));
        }
        if (flagUuid) {
            err.add(I18n.m_118938_((String)"gui.act.modifier.head.uuid.warning", (Object[])new Object[0]));
        }
        if (flagName) {
            err.add(I18n.m_118938_((String)"gui.act.modifier.head.name.warning", (Object[])new Object[0]));
        }
        if (this.err.get() != null) {
            err.add(this.err.get());
        }
        if (this.errType.get() != null) {
            err.add(this.errType.get() + ": ");
        }
        for (int i = 0; i < err.size(); ++i) {
            String string = (String)err.get(i);
            int n = this.f_96543_ / 2;
            int n2 = this.name.f_93621_ - 2;
            Objects.requireNonNull(this.f_96547_);
            GuiUtils.drawCenterString(this.f_96547_, string, n, n2 - (9 + 1) * (i + 1), Color.RED.getRGB());
        }
        String string = I18n.m_118938_((String)"gui.act.config.name", (Object[])new Object[0]) + " : ";
        float f = this.f_96543_ / 2 - 178;
        int n = this.name.f_93621_ + 10;
        Objects.requireNonNull(this.f_96547_);
        this.f_96547_.m_92883_(matrixStack, string, f, (float)(n - 9 / 2), (flagName ? Color.RED : Color.WHITE).getRGB());
        String string2 = I18n.m_118938_((String)"gui.act.uuid", (Object[])new Object[0]) + " : ";
        float f2 = this.f_96543_ / 2 - 178;
        int n3 = this.uuid.f_93621_ + 10;
        Objects.requireNonNull(this.f_96547_);
        this.f_96547_.m_92883_(matrixStack, string2, f2, (float)(n3 - 9 / 2), (flagUuid ? Color.RED : Color.WHITE).getRGB());
        String string3 = I18n.m_118938_((String)"gui.act.link", (Object[])new Object[0]) + " : ";
        float f3 = this.f_96543_ / 2 - 178;
        int n4 = this.link.f_93621_ + 10;
        Objects.requireNonNull(this.f_96547_);
        this.f_96547_.m_92883_(matrixStack, string3, f3, (float)(n4 - 9 / 2), (flagLink ? Color.RED : Color.WHITE).getRGB());
        this.name.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.uuid.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.link.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        GuiUtils.drawItemStack(this.f_96542_, this, this.stack, this.uuid.f_93620_ + this.uuid.m_5711_() + 10, this.uuid.f_93621_ + this.uuid.m_93694_() / 2 - 8);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        if (GuiUtils.isHover(this.uuid.f_93620_ + this.uuid.m_5711_() + 10, this.uuid.f_93621_ + this.uuid.m_93694_() / 2 - 8, 16, 16, mouseX, mouseY)) {
            this.m_6057_(matrixStack, this.stack, mouseX, mouseY);
        }
    }

    public void m_7856_() {
        int l = Math.max(this.f_96547_.m_92895_(I18n.m_118938_((String)"gui.act.config.name", (Object[])new Object[0]) + " : "), Math.max(this.f_96547_.m_92895_(I18n.m_118938_((String)"gui.act.uuid", (Object[])new Object[0]) + " : "), this.f_96547_.m_92895_(I18n.m_118938_((String)"gui.act.link", (Object[])new Object[0]) + " : "))) + 3;
        this.name = new EditBox(this.f_96547_, this.f_96543_ / 2 - 178 + l, this.f_96544_ / 2 - 61, 356 - l, 16, (Component)new TextComponent(""));
        this.uuid = new EditBox(this.f_96547_, this.f_96543_ / 2 - 178 + l, this.f_96544_ / 2 - 40, 356 - l, 16, (Component)new TextComponent(""));
        this.link = new EditBox(this.f_96547_, this.f_96543_ / 2 - 178 + l, this.f_96544_ / 2 - 19, 356 - l, 16, (Component)new TextComponent(""));
        this.name.m_94199_(16);
        this.link.m_94199_(Integer.MAX_VALUE);
        this.uuid.m_94199_(Integer.MAX_VALUE);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 180, this.f_96544_ / 2, 180, 20, (Component)new TranslatableComponent("gui.act.modifier.head.me"), b -> this.name.m_94144_(this.getMinecraft().m_91094_().m_92546_())));
        this.save = new Button(this.f_96543_ / 2 + 1, this.f_96544_ / 2, 179, 20, (Component)new TranslatableComponent("gui.act.modifier.head.saveSkin"), b -> {
            if (this.saveThread == null || !this.saveThread.isAlive()) {
                this.saveThread = new Thread(() -> {
                    try {
                        this.err.set(ChatFormatting.GOLD + I18n.m_118938_((String)"gui.act.modifier.head.loading", (Object[])new Object[0]) + "...");
                        URL url = new URL(this.link.m_94155_());
                        InputStream stream = url.openStream();
                        byte[] buffer = new byte[stream.available()];
                        stream.read(buffer);
                        File f = new File(this.mc.f_91069_, "skin_" + this.name.m_94155_() + ".png");
                        FileOutputStream writer = new FileOutputStream(f);
                        ((OutputStream)writer).write(buffer);
                        ((OutputStream)writer).close();
                        this.errType.set(ChatFormatting.GREEN + I18n.m_118938_((String)"gui.act.modifier.head.fileSaved", (Object[])new Object[0]));
                        String s = this.mc.f_91069_.getCanonicalFile().getName() + File.separator + f.getName();
                        if (s.length() > 200) {
                            s = s.substring(0, 50) + "...";
                        }
                        this.err.set(ChatFormatting.GREEN + s);
                    }
                    catch (Exception e) {
                        this.errType.set(e instanceof FileNotFoundException ? I18n.m_118938_((String)"gui.act.modifier.head.fileNotFound", (Object[])new Object[0]) : e.getClass().getSimpleName());
                        Object s = e.getMessage();
                        if (((String)s).length() > 50) {
                            s = ((String)s).substring(0, 50) + "...";
                        }
                        this.err.set((String)s);
                    }
                });
                this.saveThread.start();
            }
        });
        this.m_142416_((GuiEventListener)this.save);
        this.loadName = new Button(this.f_96543_ / 2 - 180, this.f_96544_ / 2 + 21, 180, 20, (Component)new TranslatableComponent("gui.act.modifier.head.load.name"), b -> {
            try {
                this.err.set(ChatFormatting.GOLD + I18n.m_118938_((String)"gui.act.modifier.head.loading", (Object[])new Object[0]) + "...");
                ItemUtils.getHead(this.stack, this.name.m_94155_());
                this.loadHead();
            }
            catch (Exception e) {
                this.errType.set(e.getClass().getSimpleName());
                Object s = e.getMessage();
                if (((String)s).length() > 50) {
                    s = ((String)s).substring(0, 50) + "...";
                }
                this.err.set((String)s);
            }
        });
        this.m_142416_((GuiEventListener)this.loadName);
        this.loadLink = new Button(this.f_96543_ / 2 + 1, this.f_96544_ / 2 + 21, 179, 20, (Component)new TranslatableComponent("gui.act.modifier.head.load.link"), b -> {
            this.err.set(ChatFormatting.GOLD + I18n.m_118938_((String)"gui.act.modifier.head.loading", (Object[])new Object[0]) + "...");
            ItemUtils.getHead(this.stack, this.uuid.m_94155_(), this.link.m_94155_(), this.name.m_94155_().isEmpty() ? null : this.name.m_94155_());
            this.loadHead();
        });
        this.m_142416_((GuiEventListener)this.loadLink);
        if (this.setter != null) {
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 180, this.f_96544_ / 2 + 42, 180, 20, (Component)new TranslatableComponent("gui.act.cancel"), b -> this.getMinecraft().m_91152_(this.parent)));
        }
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 1, this.f_96544_ / 2 + 42, 179, 20, (Component)new TranslatableComponent("gui.done"), b -> {
            this.set(this.stack);
            this.getMinecraft().m_91152_(this.parent);
        }));
        this.loadHead();
        super.m_7856_();
    }

    public boolean m_5534_(char key, int modifiers) {
        return this.link.m_5534_(key, modifiers) || this.name.m_5534_(key, modifiers) || this.uuid.m_5534_(key, modifiers) || super.m_5534_(key, modifiers);
    }

    @Override
    public boolean m_7933_(int key, int scanCode, int modifiers) {
        return this.link.m_7933_(key, scanCode, modifiers) || this.name.m_7933_(key, scanCode, modifiers) || this.uuid.m_7933_(key, scanCode, modifiers) || super.m_7933_(key, scanCode, modifiers);
    }

    private void loadHead() {
        CompoundTag tag = this.stack.m_41698_("SkullOwner");
        if (tag.m_128425_("Name", 8)) {
            this.name.m_94144_(tag.m_128461_("Name"));
        }
        if (tag.m_128425_("Id", 8)) {
            this.uuid.m_94144_(tag.m_128461_("Id"));
            if (tag.m_128425_("Properties", 10) && tag.m_128469_("Properties").m_128425_("textures", 9)) {
                ListTag list = tag.m_128469_("Properties").m_128437_("textures", 10);
                for (int i = 0; i < list.size(); ++i) {
                    CompoundTag text = list.m_128728_(i);
                    if (!text.m_128425_("Value", 8)) continue;
                    try {
                        String s = new String(Base64.getDecoder().decode(text.m_128461_("Value")));
                        CompoundTag texCompound = TagParser.m_129359_((String)s);
                        if (texCompound.m_128425_("profileName", 8)) {
                            this.name.m_94144_(texCompound.m_128461_("profileName"));
                        }
                        if (!texCompound.m_128425_("textures", 10) || !texCompound.m_128469_("textures").m_128425_("SKIN", 10) || !texCompound.m_128469_("textures").m_128469_("SKIN").m_128425_("url", 8)) continue;
                        this.link.m_94144_(texCompound.m_128469_("textures").m_128469_("SKIN").m_128461_("url"));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        this.err.set(null);
        this.errType.set(null);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        this.link.m_6375_(mouseX, mouseY, mouseButton);
        this.uuid.m_6375_(mouseX, mouseY, mouseButton);
        this.name.m_6375_(mouseX, mouseY, mouseButton);
        if (GuiUtils.isHover((AbstractWidget)this.link, (int)mouseX, (int)mouseY) && mouseButton == 1) {
            this.link.m_94144_("");
        }
        if (GuiUtils.isHover((AbstractWidget)this.uuid, (int)mouseX, (int)mouseY) && mouseButton == 1) {
            this.uuid.m_94144_("");
        }
        if (GuiUtils.isHover((AbstractWidget)this.name, (int)mouseX, (int)mouseY) && mouseButton == 1) {
            this.name.m_94144_("");
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public void m_96624_() {
        this.name.m_94120_();
        this.uuid.m_94120_();
        this.name.m_94120_();
        this.loadName.f_93623_ = !this.name.m_94155_().isEmpty();
        this.loadLink.f_93623_ = !this.uuid.m_94155_().isEmpty() && !this.link.m_94155_().isEmpty();
        this.save.f_93623_ = !this.link.m_94155_().isEmpty();
        super.m_96624_();
    }
}

