/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui.modifier;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.atesab.act.gui.GuiACT;
import fr.atesab.act.gui.GuiValueButton;
import fr.atesab.act.gui.modifier.GuiModifier;
import fr.atesab.act.utils.GuiUtils;
import fr.atesab.act.utils.Tuple;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public abstract class GuiListModifier<T>
extends GuiModifier<T> {
    private List<ListElement> elements;
    private List<ListElement> searchedElements = new ArrayList<ListElement>();
    private List<ListElement>[] visibleElements;
    private boolean doneButton;
    private boolean cancelButton;
    private int page;
    private int maxPage;
    private int sizeX;
    private Button lastPage;
    private Button nextPage;
    private EditBox search;
    protected Tuple<String, Tuple<Runnable, Runnable>>[] buttons;
    private boolean needRedefine = false;
    private int dSize = 42;
    private int paddingLeft = 0;
    private int paddingTop = 0;
    private boolean noAdaptativeSize = false;
    private boolean justStart = true;

    public GuiListModifier(Screen parent, Component name, List<ListElement> elements, Consumer<T> setter, boolean doneButton, boolean cancelButton, Tuple<String, Tuple<Runnable, Runnable>>[] buttons) {
        super(parent, name, setter);
        this.elements = elements;
        this.buttons = buttons;
        this.doneButton = doneButton;
        this.cancelButton = cancelButton;
        this.setter = setter;
        this.parent = parent;
        this.search = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, 0, 0, (Component)new TextComponent(""));
    }

    public GuiListModifier(Screen parent, Component name, List<ListElement> elements, Consumer<T> setter, boolean doneButton, Tuple<String, Tuple<Runnable, Runnable>>[] buttons) {
        this(parent, name, elements, setter, doneButton, true, buttons);
    }

    public GuiListModifier(Screen parent, Component name, List<ListElement> elements, Consumer<T> setter, Tuple<String, Tuple<Runnable, Runnable>>[] buttons) {
        this(parent, name, elements, setter, true, buttons);
    }

    public void addListElement(int i, ListElement elem) {
        this.elements.add(i, elem);
        this.needRedefine = true;
    }

    public void addListElement(ListElement elem) {
        this.elements.add(elem);
        this.needRedefine = true;
    }

    public boolean m_5534_(char key, int modifiers) {
        boolean flag = false;
        block0: for (List<ListElement> lel : this.visibleElements) {
            for (ListElement le2 : lel) {
                if (!le2.isFocused()) continue;
                flag = true;
                continue block0;
            }
        }
        for (List<ListElement> lel : this.visibleElements) {
            lel.forEach(le -> le.charTyped(key, modifiers));
        }
        if (!flag && !this.justStart) {
            this.search.m_94178_(true);
        } else {
            this.justStart = false;
        }
        if (this.search.m_93696_()) {
            this.search.m_5534_(key, modifiers);
            this.page = 0;
            this.define();
        }
        return super.m_5534_(key, modifiers);
    }

    private void define() {
        int j;
        boolean add;
        block10: {
            this.searchedElements.clear();
            this.elements.stream().filter(le -> le.match(this.search.m_94155_())).forEach(this.searchedElements::add);
            this.sizeX = this.searchedElements.stream().mapToInt(ListElement::getSizeX).max().orElse(this.f_96543_ - 20 - this.paddingLeft) + this.paddingLeft;
            this.visibleElements = new ArrayList[Math.max(1, (this.f_96543_ - 20) / this.sizeX)];
            for (int i = 0; i < this.visibleElements.length; ++i) {
                this.visibleElements[i] = new ArrayList<ListElement>();
            }
            this.maxPage = 0;
            int pageHeight = this.f_96544_ - 63;
            int currentSize = 0;
            int i = 0;
            for (ListElement elm : this.searchedElements) {
                int sy = this.paddingTop + elm.sizeY;
                if (currentSize + sy > pageHeight) {
                    if ((i = (i + 1) % this.visibleElements.length) == 0) {
                        ++this.maxPage;
                    }
                    currentSize = sy;
                } else {
                    currentSize += sy;
                }
                if (this.page != this.maxPage) continue;
                this.visibleElements[i].add(elm);
            }
            this.maxPage = Math.max(1, this.maxPage + (currentSize == 0 ? 0 : 1));
            if (this.page >= this.maxPage) {
                this.page = this.maxPage - 1;
                this.define();
            }
            add = false;
            if (this.page == 0) {
                for (j = 0; j < this.visibleElements.length && !this.visibleElements[j].isEmpty(); ++j) {
                    for (ListElement le2 : this.visibleElements[j]) {
                        if (!(le2 instanceof AddElementList)) continue;
                        add = true;
                        break block10;
                    }
                }
            } else {
                j = this.visibleElements.length;
            }
        }
        this.dSize = (!add && !this.noAdaptativeSize && j == 1 && this.maxPage == 1 ? this.f_96544_ / 2 - this.visibleElements[0].stream().mapToInt(ListElement::getSizeY).sum() / 2 : 42) + this.paddingTop;
        this.lastPage.f_93623_ = this.page != 0;
        this.nextPage.f_93623_ = this.page + 1 < this.maxPage;
    }

    protected abstract T get();

    public List<ListElement> getElements() {
        return Collections.unmodifiableList(this.elements);
    }

    private int getOffsetX() {
        int i;
        if (this.page == 0) {
            for (i = 0; i < this.visibleElements.length && !this.visibleElements[i].isEmpty(); ++i) {
            }
        } else {
            i = this.visibleElements.length;
        }
        return (this.f_96543_ - this.sizeX * (i - 1) + this.paddingLeft) / 2;
    }

    public int getPaddingLeft() {
        return this.paddingLeft;
    }

    public int getPaddingTop() {
        return this.paddingTop;
    }

    public void m_7856_() {
        int i;
        this.page = 0;
        int l = this.doneButton ? 1 : 0;
        int d = (this.buttons.length + l + (this.cancelButton ? 1 : 0)) * 50;
        int dl = this.f_96543_ / 2 - d;
        int dr = this.f_96543_ / 2 + d;
        if (this.doneButton) {
            this.m_142416_((GuiEventListener)new Button(dl, this.f_96544_ - 21, 99, 20, (Component)new TranslatableComponent("gui.done"), b -> {
                this.set(this.get());
                this.getMinecraft().m_91152_(this.parent);
            }));
        }
        for (i = 0; i < this.buttons.length; ++i) {
            this.m_142416_((GuiEventListener)new GuiValueButton<Tuple>(dl + 100 * (i + l), this.f_96544_ - 21, 99, 20, (Component)new TextComponent((String)this.buttons[i].a), (Tuple)this.buttons[i].b, b -> ((Runnable)((Tuple)b.getValue()).a).run()));
        }
        if (this.cancelButton) {
            this.m_142416_((GuiEventListener)new Button(dl + 100 * (i + l), this.f_96544_ - 21, 99, 20, (Component)new TranslatableComponent("gui.act.cancel"), b -> this.getMinecraft().m_91152_(this.parent)));
        }
        this.lastPage = new Button(dl - 21, this.f_96544_ - 21, 20, 20, (Component)new TextComponent("<-"), b -> {
            --this.page;
            this.define();
        }){

            protected MutableComponent m_5646_() {
                return new TranslatableComponent("gui.narrate.button", new Object[]{I18n.m_118938_((String)"gui.act.leftArrow", (Object[])new Object[0])});
            }
        };
        this.m_142416_((GuiEventListener)this.lastPage);
        this.nextPage = new Button(dr, this.f_96544_ - 21, 20, 20, (Component)new TextComponent("->"), b -> {
            ++this.page;
            this.define();
        }){

            protected MutableComponent m_5646_() {
                return new TranslatableComponent("gui.narrate.button", new Object[]{I18n.m_118938_((String)"gui.act.rightArrow", (Object[])new Object[0])});
            }
        };
        this.m_142416_((GuiEventListener)this.nextPage);
        int m = this.f_96547_.m_92895_(I18n.m_118938_((String)"gui.act.search", (Object[])new Object[0]) + " : ");
        int n = Math.min(600, this.f_96543_ - 20);
        this.search.f_93620_ = (this.f_96543_ - n) / 2 + 6 + m;
        this.search.f_93621_ = 18;
        this.search.m_93674_(n - 18 - m);
        this.search.setHeight(18);
        this.elements.forEach(ListElement::init);
        this.define();
        super.m_7856_();
    }

    public boolean isNoAdaptativeSize() {
        return this.noAdaptativeSize;
    }

    @Override
    public boolean m_7933_(int key, int scanCode, int modifiers) {
        boolean flag = false;
        block0: for (List<ListElement> lel : this.visibleElements) {
            for (ListElement le2 : lel) {
                if (!le2.isFocused()) continue;
                flag = true;
                continue block0;
            }
        }
        for (List<ListElement> lel : this.visibleElements) {
            lel.forEach(le -> le.keyPressed(key, scanCode, modifiers));
        }
        if (!flag) {
            this.search.m_94178_(true);
        }
        if (this.search.m_93696_()) {
            this.search.m_7933_(key, scanCode, modifiers);
            this.page = 0;
            this.define();
        }
        return super.m_7933_(key, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        for (int i = 0; i < this.visibleElements.length; ++i) {
            int currentSize = this.dSize;
            for (ListElement le : this.visibleElements[i]) {
                int offsetX = this.getOffsetX() + this.sizeX * i - le.getSizeX() / 2;
                le.mouseClicked((int)mouseX - offsetX, (int)mouseY - currentSize, mouseButton);
                currentSize += le.getSizeY() + this.paddingTop;
            }
        }
        this.search.m_6375_(mouseX, mouseY, mouseButton);
        if (mouseButton == 1) {
            if (GuiUtils.isHover(this.search.f_93620_, this.search.f_93621_, this.search.m_5711_(), this.search.m_93694_(), (int)mouseX, (int)mouseY)) {
                this.search.m_94144_("");
                this.page = 0;
                this.define();
            } else {
                this.m_6702_().stream().filter(button -> button instanceof GuiValueButton && GuiUtils.isHover((AbstractWidget)((Button)button), (int)mouseX, (int)mouseY)).map(b -> (GuiValueButton)((Object)b)).forEach(b -> ((Runnable)((Tuple)b.getValue()).b).run());
            }
        }
        if (this.needRedefine) {
            this.needRedefine = false;
            this.define();
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public void removeListElement(ListElement elem) {
        this.elements.remove(elem);
        this.needRedefine = true;
    }

    @Override
    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int offsetX;
        int currentSize;
        int i;
        this.m_7333_(matrixStack);
        for (i = 0; i < this.visibleElements.length; ++i) {
            currentSize = this.dSize;
            for (ListElement le : this.visibleElements[i]) {
                offsetX = this.getOffsetX() + this.sizeX * i - le.getSizeX() / 2;
                le.draw(matrixStack, offsetX, currentSize, mouseX - offsetX, mouseY - currentSize, partialTicks);
                currentSize += le.getSizeY() + this.paddingTop;
            }
        }
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.search.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        GuiUtils.drawCenterString(this.f_96547_, this.getStringTitle(), this.f_96543_ / 2, 2, -1, 10);
        GuiUtils.drawRightString(this.f_96547_, I18n.m_118938_((String)"gui.act.search", (Object[])new Object[0]) + " : ", this.search.f_93620_, this.search.f_93621_, Color.ORANGE.getRGB(), this.search.m_93694_());
        if (this.getMinecraft().f_91080_.equals(this)) {
            for (i = 0; i < this.visibleElements.length; ++i) {
                currentSize = this.dSize;
                for (ListElement le : this.visibleElements[i]) {
                    offsetX = this.getOffsetX() + this.sizeX * i - le.getSizeX() / 2;
                    le.drawNext(matrixStack, offsetX, currentSize, mouseX - offsetX, mouseY - currentSize, partialTicks);
                    currentSize += le.getSizeY() + this.paddingTop;
                }
            }
        }
    }

    public void setNoAdaptativeSize(boolean noAdaptativeSize) {
        this.noAdaptativeSize = noAdaptativeSize;
    }

    public void setPaddingLeft(int paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public void setPaddingTop(int paddingTop) {
        this.paddingTop = paddingTop;
    }

    public void m_96624_() {
        this.search.m_94120_();
        for (List<ListElement> lel : this.visibleElements) {
            lel.forEach(ListElement::update);
        }
        super.m_96624_();
    }

    @Override
    protected void generateDev(List<GuiACT.ACTDevInfo> entries, int mouseX, int mouseY) {
        entries.add(GuiListModifier.devInfo("List", this.elements.size() + " element(s)", this.page + 1 + "/" + this.maxPage));
        super.generateDev(entries, mouseX, mouseY);
    }

    public static abstract class ListElement {
        protected Font font;
        protected Minecraft mc;
        protected List<AbstractWidget> buttonList = new ArrayList<AbstractWidget>();
        protected List<EditBox> fieldList = new ArrayList<EditBox>();
        private int sizeX;
        private int sizeY;

        public ListElement(int sizeX, int sizeY) {
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.mc = Minecraft.m_91087_();
            this.font = this.mc.f_91062_;
        }

        public boolean charTyped(char key, int modifiers) {
            for (EditBox field : this.fieldList) {
                if (!field.m_94213_() || !field.m_5534_(key, modifiers)) continue;
                return true;
            }
            return false;
        }

        public void draw(PoseStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
            this.buttonList.forEach(b -> GuiUtils.drawRelative(matrixStack, b, offsetX, offsetY, mouseX, mouseY, partialTicks));
            this.fieldList.stream().filter(EditBox::m_94213_).forEach(tf -> GuiUtils.drawRelative(matrixStack, (AbstractWidget)tf, offsetX, offsetY, mouseX, mouseY, partialTicks));
        }

        public void drawNext(PoseStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
            this.buttonList.stream().filter(AbstractWidget::m_5702_).forEach(b -> GuiUtils.drawRelativeToolTip(matrixStack, b, offsetX, offsetY, mouseX, mouseY, partialTicks));
        }

        public int getSizeX() {
            return this.sizeX;
        }

        public int getSizeY() {
            return this.sizeY;
        }

        public void init() {
            this.fieldList.forEach(tf -> tf.m_94178_(false));
        }

        public boolean isFocused() {
            for (EditBox field : this.fieldList) {
                if (!field.m_93696_()) continue;
                return true;
            }
            return false;
        }

        public boolean keyPressed(int key, int scanCode, int modifiers) {
            for (EditBox field : this.fieldList) {
                if (!field.m_94213_() || !field.m_7933_(key, scanCode, modifiers)) continue;
                return true;
            }
            return false;
        }

        public boolean match(String search) {
            return true;
        }

        public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
            this.buttonList.forEach(b -> {
                if (GuiUtils.isHover(b, mouseX, mouseY)) {
                    if (b instanceof RunElementButton) {
                        if (((RunElementButton)((Object)b)).getLeft() != null && mouseButton == 0) {
                            GuiACT.playClick();
                            ((RunElementButton)((Object)b)).getLeft().run();
                        } else if (((RunElementButton)((Object)b)).getLeft() != null && mouseButton == 1) {
                            GuiACT.playClick();
                            ((RunElementButton)((Object)b)).getRight().run();
                        }
                    } else if (mouseButton == 0) {
                        GuiACT.playClick();
                        b.m_5716_((double)mouseX, (double)mouseY);
                    } else {
                        this.otherActionPerformed((Widget)b, mouseButton);
                    }
                }
            });
            this.fieldList.stream().filter(EditBox::m_94213_).forEach(tf -> {
                if (mouseButton == 1 && GuiUtils.isHover((AbstractWidget)tf, mouseX, mouseY)) {
                    tf.m_94144_("");
                    tf.m_94178_(true);
                } else {
                    tf.m_6375_((double)mouseX, (double)mouseY, mouseButton);
                }
            });
        }

        protected void otherActionPerformed(Widget button, int mouseButton) {
        }

        public void setSizeX(int sizeX) {
            this.sizeX = sizeX;
        }

        public void setSizeY(int sizeY) {
            this.sizeY = sizeY;
        }

        public void update() {
            this.fieldList.stream().filter(EditBox::m_94213_).forEach(EditBox::m_94120_);
        }
    }

    public static class AddElementList
    extends ListElement {
        public AddElementList(GuiListModifier<?> parent, Supplier<ListElement> builder) {
            this(parent, builder, Math.min(200, parent.elements.stream().mapToInt(ListElement::getSizeX).max().orElse(100)), 21);
        }

        public AddElementList(GuiListModifier<?> parent, Supplier<ListElement> builder, int sizeX, int sizeY) {
            super(sizeX, Math.max(21, sizeY));
            this.buttonList.add(new AddElementButton(parent, 0, (this.getSizeY() - 20) / 2, this.getSizeX(), 20, this, builder));
        }
    }

    public static class RunElementButton
    extends Button {
        private Runnable left;
        private Runnable right;

        public RunElementButton(int x, int y, int widthIn, int heightIn, Component text, Runnable left, Runnable right) {
            super(x, y, widthIn, heightIn, text, b -> {});
            this.left = left;
            this.right = right;
        }

        public Runnable getLeft() {
            return this.left;
        }

        public Runnable getRight() {
            return this.right;
        }
    }

    public static class RemoveElementButton
    extends RunElementButton {
        public RemoveElementButton(GuiListModifier<?> parent, int x, int y, int widthIn, int heightIn, ListElement element) {
            super(x, y, widthIn, heightIn, (Component)new TextComponent("-"), () -> {
                parent.elements.remove(element);
                parent.needRedefine = true;
            }, null);
            this.setFGColor(ChatFormatting.RED.m_126665_());
        }

        public RemoveElementButton(GuiListModifier<?> parent, int x, int y, ListElement element) {
            this(parent, x, y, 200, 20, element);
        }

        protected MutableComponent m_5646_() {
            return new TranslatableComponent("gui.narrate.button", new Object[]{I18n.m_118938_((String)"gui.act.delete", (Object[])new Object[0])});
        }
    }

    public static class ButtonElementList
    extends ListElement {
        private Runnable right;

        public ButtonElementList(int sizeX, int sizeY, int buttonSizeX, int buttonSizeY, Component buttonText, Runnable leftAction, Runnable rightAction) {
            super(sizeX, sizeY);
            this.buttonList.add(new Button(0, 0, buttonSizeX, buttonSizeY, buttonText, b -> {
                if (leftAction != null) {
                    leftAction.run();
                }
            }));
            this.right = rightAction;
        }

        @Override
        protected void otherActionPerformed(Widget button, int mouseButton) {
            if (mouseButton == 1 && this.right != null) {
                this.right.run();
            }
            super.otherActionPerformed(button, mouseButton);
        }
    }

    public static class AddElementButton
    extends RunElementButton {
        public AddElementButton(GuiListModifier<?> parent, int x, int y, int widthIn, int heightIn, ListElement element, Supplier<ListElement> builder) {
            this(parent, x, y, widthIn, heightIn, (Component)new TextComponent("+"), element, builder);
        }

        public AddElementButton(GuiListModifier<?> parent, int x, int y, int widthIn, int heightIn, Component text, ListElement element, Function<Integer, ListElement> builder) {
            super(x, y, widthIn, heightIn, text, () -> {
                for (int i = 0; i < parent.elements.size(); ++i) {
                    if (!parent.elements.get(i).equals(element)) continue;
                    ListElement elm = (ListElement)builder.apply(i);
                    if (elm == null) break;
                    parent.addListElement(i, elm);
                    break;
                }
            }, null);
            this.setFGColor(ChatFormatting.GREEN.m_126665_());
        }

        public AddElementButton(GuiListModifier<?> parent, int x, int y, int widthIn, int heightIn, Component text, ListElement element, Supplier<ListElement> builder) {
            this(parent, x, y, widthIn, heightIn, text, element, (Integer i) -> (ListElement)builder.get());
        }

        protected MutableComponent m_5646_() {
            return new TranslatableComponent("gui.narrate.button", new Object[]{I18n.m_118938_((String)"gui.act.new", (Object[])new Object[0])});
        }
    }
}

