/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui.modifier;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.atesab.act.gui.modifier.GuiBooleanButton;
import fr.atesab.act.gui.modifier.GuiColorModifier;
import fr.atesab.act.gui.modifier.GuiListModifier;
import fr.atesab.act.gui.selector.GuiButtonListSelector;
import fr.atesab.act.utils.GuiUtils;
import fr.atesab.act.utils.ItemUtils;
import fr.atesab.act.utils.Tuple;
import java.awt.Color;
import java.util.ArrayList;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.alchemy.Potion;

public class GuiPotionModifier
extends GuiListModifier<ItemUtils.PotionInformation> {
    private OptionalInt customColor;
    private Potion main;
    private final Supplier<GuiListModifier.ListElement> supplier = () -> new CustomPotionListElement(this, new MobEffectInstance(MobEffects.f_19596_));

    public GuiPotionModifier(Screen parent, Consumer<ItemUtils.PotionInformation> setter, ItemUtils.PotionInformation info) {
        super(parent, (Component)new TranslatableComponent("gui.act.modifier.meta.potion"), new ArrayList<GuiListModifier.ListElement>(), setter, new Tuple[0]);
        this.customColor = info.getCustomColor();
        this.main = info.getMain();
        this.addListElement(new MainPotionListElement(this));
        info.getCustomEffects().forEach(t -> this.addListElement(new CustomPotionListElement(this, (MobEffectInstance)t)));
        this.addListElement(new GuiListModifier.AddElementList(this, this.supplier));
    }

    @Override
    protected ItemUtils.PotionInformation get() {
        ArrayList<MobEffectInstance> customEffects = new ArrayList<MobEffectInstance>();
        this.getElements().stream().filter(le -> le instanceof CustomPotionListElement).map(le -> (CustomPotionListElement)le).forEach(cpl -> customEffects.add(cpl.getEffect()));
        return new ItemUtils.PotionInformation(this.customColor, this.main, customEffects);
    }

    private static class MainPotionListElement
    extends GuiListModifier.ListElement {
        private GuiPotionModifier parent;
        private Button type;

        private static String getPotionName(Potion pot) {
            String name = pot.m_43492_("");
            return name + (String)(pot.getRegistryName().toString().contains("long_") ? " (" + I18n.m_118938_((String)"gui.act.modifier.meta.potion.long", (Object[])new Object[0]) + ")" : (pot.getRegistryName().toString().contains("strong_") ? " II" : ""));
        }

        public MainPotionListElement(GuiPotionModifier parent) {
            super(400, 29);
            this.parent = parent;
            this.buttonList.add(new Button(0, 0, 200, 20, (Component)new TranslatableComponent("gui.act.modifier.meta.setColor"), b -> this.mc.m_91152_((Screen)new GuiColorModifier((Screen)parent, i -> {
                parent.customColor = i;
            }, parent.customColor, true))));
            this.type = new Button(201, 0, 199, 20, (Component)new TextComponent(""), b -> {
                ArrayList pots = new ArrayList();
                Registry.f_122828_.forEach(type -> pots.add(new Tuple<String, Potion>(MainPotionListElement.getPotionName(type), (Potion)type)));
                this.mc.m_91152_(new GuiButtonListSelector<Potion>(parent, (Component)new TranslatableComponent("gui.act.modifier.meta.potion.type"), pots, pot -> {
                    parent.main = pot;
                    this.defineButton();
                    return null;
                }));
            });
            this.buttonList.add(this.type);
            this.defineButton();
        }

        private void defineButton() {
            this.type.m_93666_((Component)new TranslatableComponent("gui.act.modifier.meta.potion.type").m_130946_(" (").m_130946_(MainPotionListElement.getPotionName(this.parent.main)).m_130946_(")"));
        }
    }

    private static class CustomPotionListElement
    extends GuiListModifier.ListElement {
        private EditBox duration;
        private EditBox amplifier;
        private MobEffect potion;
        private int durationTime;
        private int amplifierValue;
        private boolean ambient;
        private boolean showIcon;
        private boolean showParticles;
        private boolean errDur = false;
        private boolean errAmp = false;
        private Button type;

        public CustomPotionListElement(GuiPotionModifier parent, MobEffectInstance potionEffect) {
            super(400, 50);
            int l = 5 + Math.max(this.font.m_92895_(I18n.m_118938_((String)"gui.act.modifier.meta.potion.duration", (Object[])new Object[0]) + " : "), this.font.m_92895_(I18n.m_118938_((String)"gui.act.modifier.meta.potion.amplifier", (Object[])new Object[0]) + " : "));
            this.potion = potionEffect.m_19544_();
            this.durationTime = potionEffect.m_19557_();
            this.amplifierValue = potionEffect.m_19564_();
            this.ambient = potionEffect.m_19571_();
            this.showIcon = potionEffect.m_19575_();
            this.showParticles = potionEffect.m_19572_();
            this.duration = new EditBox(this.font, l, 1, 150 - l, 18, (Component)new TextComponent(""));
            this.duration.m_94144_(String.valueOf(this.durationTime));
            this.amplifier = new EditBox(this.font, l, 22, 150 - l, 18, (Component)new TextComponent(""));
            this.amplifier.m_94144_(String.valueOf(this.amplifierValue));
            this.type = new Button(153, 0, 200, 20, (Component)new TranslatableComponent("gui.act.modifier.meta.potion.type"), b -> {
                ArrayList pots = new ArrayList();
                Registry.f_122823_.forEach(pot -> pots.add(new Tuple<String, MobEffect>(I18n.m_118938_((String)pot.m_19481_(), (Object[])new Object[0]), (MobEffect)pot)));
                this.mc.m_91152_(new GuiButtonListSelector<MobEffect>(parent, (Component)new TranslatableComponent("gui.act.modifier.meta.potion.type"), pots, pot -> {
                    this.potion = pot;
                    this.setButtonText();
                    return null;
                }));
            });
            this.buttonList.add(this.type);
            this.buttonList.add(new GuiBooleanButton(153, 21, 100, 20, (Component)new TranslatableComponent("gui.act.modifier.meta.potion.ambient"), b -> {
                this.ambient = b;
            }, () -> this.ambient));
            this.buttonList.add(new GuiBooleanButton(255, 21, 99, 20, (Component)new TranslatableComponent("gui.act.modifier.meta.potion.showParticles"), b -> {
                this.showParticles = b;
            }, () -> this.showParticles));
            this.buttonList.add(new GuiListModifier.RemoveElementButton(parent, 355, 0, 20, 20, this));
            this.buttonList.add(new GuiListModifier.AddElementButton(parent, 377, 0, 20, 20, this, parent.supplier));
            this.buttonList.add(new GuiListModifier.AddElementButton(parent, 355, 21, 43, 20, (Component)new TranslatableComponent("gui.act.give.copy"), (GuiListModifier.ListElement)this, () -> new CustomPotionListElement(parent, this.getEffect())));
            this.setButtonText();
        }

        @Override
        public void draw(PoseStack stack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
            GuiUtils.drawRelative(stack, (AbstractWidget)this.amplifier, offsetX, offsetY, mouseY, mouseY, partialTicks);
            GuiUtils.drawRelative(stack, (AbstractWidget)this.duration, offsetX, offsetY, mouseY, mouseY, partialTicks);
            GuiUtils.drawRightString(this.font, I18n.m_118938_((String)"gui.act.modifier.meta.potion.duration", (Object[])new Object[0]) + " : ", (AbstractWidget)this.duration, (this.errDur ? Color.RED : Color.WHITE).getRGB(), offsetX, offsetY);
            GuiUtils.drawRightString(this.font, I18n.m_118938_((String)"gui.act.modifier.meta.potion.amplifier", (Object[])new Object[0]) + " : ", (AbstractWidget)this.amplifier, (this.errAmp ? Color.RED : Color.WHITE).getRGB(), offsetX, offsetY);
            super.draw(stack, offsetX, offsetY, mouseX, mouseY, partialTicks);
        }

        public MobEffectInstance getEffect() {
            return new MobEffectInstance(this.potion, this.durationTime, this.amplifierValue, this.ambient, this.showParticles, this.showIcon);
        }

        @Override
        public void init() {
            this.amplifier.m_94178_(false);
            this.duration.m_94178_(false);
            super.init();
        }

        @Override
        public boolean isFocused() {
            return this.amplifier.m_93696_() || this.duration.m_93696_();
        }

        @Override
        public boolean charTyped(char key, int modifiers) {
            return this.amplifier.m_5534_(key, modifiers) || this.duration.m_5534_(key, modifiers) || super.charTyped(key, modifiers);
        }

        @Override
        public boolean keyPressed(int key, int scanCode, int modifiers) {
            return this.amplifier.m_7933_(key, scanCode, modifiers) || this.duration.m_7933_(key, scanCode, modifiers) || super.keyPressed(key, scanCode, modifiers);
        }

        @Override
        public boolean match(String search) {
            return (this.potion == null ? "" : I18n.m_118938_((String)this.potion.m_19481_(), (Object[])new Object[0]).toLowerCase()).contains(search.toLowerCase());
        }

        @Override
        public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
            this.amplifier.m_6375_((double)mouseX, (double)mouseY, mouseButton);
            this.duration.m_6375_((double)mouseX, (double)mouseY, mouseButton);
            super.mouseClicked(mouseX, mouseY, mouseButton);
        }

        private void setButtonText() {
            this.type.m_93666_((Component)new TranslatableComponent("gui.act.modifier.meta.potion.type").m_130946_(" (").m_7220_((Component)(this.potion == null ? new TextComponent("null") : new TranslatableComponent(this.potion.m_19481_()))).m_130946_(")"));
        }

        @Override
        public void update() {
            this.amplifier.m_94120_();
            this.duration.m_94120_();
            try {
                this.durationTime = Integer.parseInt(this.duration.m_94155_());
                this.errDur = false;
            }
            catch (Exception e) {
                this.errDur = true;
            }
            try {
                int i = Integer.parseInt(this.amplifier.m_94155_());
                this.errAmp = i < -128 || i > 127;
                if (!this.errAmp) {
                    this.amplifierValue = i;
                }
            }
            catch (Exception e) {
                this.errAmp = true;
            }
            super.update();
        }
    }
}

