/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui.modifier.nbtelement;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.atesab.act.gui.modifier.GuiListModifier;
import fr.atesab.act.gui.modifier.GuiStringModifier;
import fr.atesab.act.gui.modifier.nbt.GuiNBTModifier;
import fr.atesab.act.gui.modifier.nbtelement.NBTByteElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTDoubleElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTFloatElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTIntArrayElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTIntegerElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTListElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTLongArrayElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTLongElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTShortElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTStringElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTTagElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTUnknownElement;
import fr.atesab.act.utils.GuiUtils;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public abstract class NBTElement
extends GuiListModifier.ListElement
implements Cloneable {
    protected String key;
    protected GuiListModifier<?> parent;

    private static boolean isList(Object object) {
        return object.getClass().isAnnotationPresent(GuiNBTList.class);
    }

    public NBTElement(GuiListModifier<?> parent, String key, int sizeX, int sizeY) {
        super(sizeX + 82, Math.max(NBTElement.isList(parent) ? 22 : 43, sizeY));
        this.key = key;
        this.parent = parent;
        this.buttonList.add(new GuiListModifier.RemoveElementButton(parent, sizeX + 1, 0, 20, 20, this));
        this.buttonList.add(new GuiListModifier.AddElementButton(parent, sizeX + 22, 0, 20, 20, (Component)new TextComponent("+").m_130940_(ChatFormatting.GREEN), (GuiListModifier.ListElement)this, i -> {
            GuiNBTModifier.ADD_ELEMENT.accept((Integer)i, parent);
            return null;
        }));
        this.buttonList.add(new GuiListModifier.AddElementButton(parent, sizeX + 43, 0, 37, 20, (Component)new TranslatableComponent("gui.act.give.copy"), (GuiListModifier.ListElement)this, i -> {
            parent.addListElement((int)i, NBTElement.getElementByBase(parent, key, this.get()));
            return null;
        }));
        if (!NBTElement.isList(parent)) {
            this.buttonList.add(new GuiListModifier.RunElementButton(sizeX + 1, 21, 79, 20, (Component)new TranslatableComponent("gui.act.config.name"), () -> this.mc.m_91152_((Screen)new GuiStringModifier(parent, (Component)new TranslatableComponent("gui.act.config.name"), this.getKey(), nk -> {
                this.key = nk;
            })), null));
        }
    }

    public abstract NBTElement clone();

    @Override
    public void draw(PoseStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        Objects.requireNonNull(this.font);
        GuiUtils.drawGradientRect(matrixStack, offsetX - 2, offsetY - (6 + 9), offsetX + this.getSizeX() - 1, offsetY - 2, -1998725667, -2002081110, this.parent.getZLevel());
        GuiUtils.drawGradientRect(matrixStack, offsetX - 2, offsetY - 2, offsetX + this.getSizeX() - 1, offsetY + this.getSizeY() + 2, -2013265920, -2013265920, this.parent.getZLevel());
        Object s = this.getType();
        if (!NBTElement.isList(this.parent)) {
            s = this.key + " (" + (String)s + ")";
        }
        Objects.requireNonNull(this.font);
        Objects.requireNonNull(this.font);
        GuiUtils.drawString(this.font, (String)s, offsetX + 2, offsetY - 9 - 4, -1, 9 + 2);
        super.draw(matrixStack, offsetX, offsetY, mouseX, mouseY, partialTicks);
    }

    public abstract Tag get();

    public String getKey() {
        return this.key;
    }

    public abstract String getType();

    @Override
    public boolean match(String search) {
        return (this.key + " (" + I18n.m_118938_((String)("gui.act.modifier.tag.editor." + this.getType()), (Object[])new Object[0]) + ")").toLowerCase().contains(search.toLowerCase());
    }

    public static NBTElement getElementByBase(GuiListModifier<?> parent, String key, Tag base) {
        return switch (base.m_7060_()) {
            case 0 -> new NBTTagElement(parent, key, new CompoundTag());
            case 1 -> new NBTByteElement(parent, key, ((ByteTag)base).m_7063_());
            case 2 -> new NBTShortElement(parent, key, ((ShortTag)base).m_7053_());
            case 3 -> new NBTIntegerElement(parent, key, ((IntTag)base).m_7047_());
            case 4 -> new NBTLongElement(parent, key, ((LongTag)base).m_7046_());
            case 5 -> new NBTFloatElement(parent, key, Float.valueOf(((FloatTag)base).m_7057_()));
            case 6 -> new NBTDoubleElement(parent, key, ((DoubleTag)base).m_7061_());
            case 8 -> new NBTStringElement(parent, key, ((StringTag)base).m_7916_());
            case 9 -> new NBTListElement(parent, key, (ListTag)base);
            case 10 -> new NBTTagElement(parent, key, (CompoundTag)base);
            case 11 -> new NBTIntArrayElement(parent, key, (IntArrayTag)base);
            case 12 -> new NBTLongArrayElement(parent, key, (LongArrayTag)base);
            default -> new NBTUnknownElement(parent, key, base);
        };
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface GuiNBTList {
    }
}

