/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui.modifier.nbtelement;

import fr.atesab.act.gui.modifier.GuiListModifier;
import fr.atesab.act.gui.modifier.nbtelement.NBTElement;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public abstract class NBTNumericElement<T extends Number>
extends NBTElement {
    private T value;
    private EditBox field;
    private String type;

    public NBTNumericElement(String type, GuiListModifier<?> parent, String key, int sizeX, int sizeY, T value) {
        super(parent, key, Math.max(sizeX, 200), Math.max(sizeY, 21));
        this.value = value;
        this.type = type;
        this.field = new EditBox(this.font, 2, 2, 196, 16, (Component)new TextComponent(""));
        this.fieldList.add(this.field);
        this.field.m_94144_(String.valueOf(value));
    }

    public NBTNumericElement(String type, GuiListModifier<?> parent, String key, T value) {
        this(type, parent, key, 200, 21, value);
    }

    @Override
    public NBTElement clone() {
        return new NBTNumericElement<T>(this.type, this.parent, this.key, (Number)this.value){

            @Override
            public Tag get(T value) {
                return NBTNumericElement.this.get(value);
            }

            @Override
            public T parseValue(String text) throws NumberFormatException {
                return NBTNumericElement.this.parseValue(text);
            }

            @Override
            public void setNull() {
                NBTNumericElement.this.setNull();
            }
        };
    }

    @Override
    public Tag get() {
        return this.get(this.value);
    }

    public abstract Tag get(T var1);

    @Override
    public String getType() {
        return I18n.m_118938_((String)("gui.act.modifier.tag.editor." + this.type), (Object[])new Object[0]);
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    @Override
    public boolean match(String search) {
        return this.field.m_94155_().toLowerCase().contains(search.toLowerCase()) || super.match(search);
    }

    @Override
    public boolean charTyped(char key, int modifiers) {
        if (super.charTyped(key, modifiers)) {
            try {
                if (this.field.m_94155_().isEmpty()) {
                    this.setNull();
                } else {
                    this.value = this.parseValue(this.field.m_94155_());
                }
                this.field.m_94202_(-1);
            }
            catch (NumberFormatException e) {
                this.field.m_94202_(-65536);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (super.keyPressed(key, scanCode, modifiers)) {
            try {
                if (this.field.m_94155_().isEmpty()) {
                    this.setNull();
                } else {
                    this.value = this.parseValue(this.field.m_94155_());
                }
                this.field.m_94202_(-1);
            }
            catch (NumberFormatException e) {
                this.field.m_94202_(-65536);
            }
            return true;
        }
        return false;
    }

    public abstract void setNull();

    public abstract T parseValue(String var1) throws NumberFormatException;

    public void updateValue(T value) {
        this.value = value;
        this.field.m_94144_("" + value);
        this.field.m_94202_(-1);
    }
}

