/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.utils;

import com.mojang.blaze3d.pipeline.RenderCall;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import fr.atesab.act.ACTMod;
import fr.atesab.act.utils.Tuple;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class GuiUtils {
    public static final Button.OnPress EMPTY_PRESS = b -> {};

    public static void runOnGameThread(RenderCall call) {
        RenderSystem.m_69879_((RenderCall)call);
    }

    public static int blueToRed(int color) {
        return color & 0xFF00FF00 | (color & 0xFF) << 16 | (color & 0xFF0000) >> 16;
    }

    public static boolean hasAlpha(int rgba) {
        return (rgba & 0xFF000000) != 0;
    }

    public static int asRGBA(int r, int g, int b, int a) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int asRGBA(float r, float g, float b, float a) {
        return (int)(a * 255.0f) << 24 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
    }

    public static int fromHSL(int h, int s, int l) {
        return GuiUtils.fromHSL(h, (float)s / 100.0f, (float)l / 100.0f);
    }

    public static int fromHSL(int h, float s, float l) {
        float c = (1.0f - Math.abs(2.0f * l - 1.0f)) * s;
        float hh = (float)h / 60.0f;
        float x = c * (1.0f - Math.abs(hh % 2.0f - 1.0f));
        float m = l - c / 2.0f;
        return (switch ((int)hh) {
            case 0 -> GuiUtils.asRGBA(c, x, 0.0f, 1.0f);
            case 1 -> GuiUtils.asRGBA(x, c, 0.0f, 1.0f);
            case 2 -> GuiUtils.asRGBA(0.0f, c, x, 1.0f);
            case 3 -> GuiUtils.asRGBA(0.0f, x, c, 1.0f);
            case 4 -> GuiUtils.asRGBA(x, 0.0f, c, 1.0f);
            case 5 -> GuiUtils.asRGBA(c, 0.0f, x, 1.0f);
            default -> -16777216;
        }) + 65793 * (int)(m * 255.0f);
    }

    public static HSLResult hslFromRGBA(int rgba) {
        return GuiUtils.hslFromRGBA(rgba, 0, 0);
    }

    public static RGBResult rgbaFromRGBA(int rgba) {
        int alpha = rgba >> 24 & 0xFF;
        int red = rgba >> 16 & 0xFF;
        int green = rgba >> 8 & 0xFF;
        int blue = rgba & 0xFF;
        return new RGBResult(red, green, blue, alpha);
    }

    public static HSLResult hslFromRGBA(int rgba, int oldHue, int oldSaturation) {
        float lightness;
        float min;
        int alpha = rgba >> 24 & 0xFF;
        float red = (float)(rgba >> 16 & 0xFF) / 255.0f;
        float green = (float)(rgba >> 8 & 0xFF) / 255.0f;
        float blue = (float)(rgba & 0xFF) / 255.0f;
        float max = Math.max(Math.max(red, green), blue);
        float chroma = max - (min = Math.min(Math.min(red, green), blue));
        int hue = chroma == 0.0f ? oldHue : (max == red ? (int)((green - blue) / chroma % 6.0f * 60.0f) : (max == green ? (int)(((blue - red) / chroma + 2.0f) % 6.0f * 60.0f) : (int)(((red - green) / chroma + 4.0f) % 6.0f * 60.0f)));
        if (hue < 0) {
            hue += 360;
        }
        float saturation = (lightness = (max + min) / 2.0f) == 1.0f ? (float)oldSaturation : chroma / (1.0f - Math.abs(2.0f * lightness - 1.0f));
        return new HSLResult(hue, (int)(saturation * 100.0f), (int)(lightness * 100.0f), alpha);
    }

    public static void addToClipboard(String text) {
        StringSelection select = new StringSelection(text);
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        cb.setContents(select, select);
    }

    public static void displayScreen(Screen screen) {
        GuiUtils.displayScreen(screen, false);
    }

    public static void displayScreen(Screen screen, boolean forceDelay) {
        Minecraft mc = Minecraft.m_91087_();
        if (forceDelay || mc.f_91080_ instanceof ChatScreen) {
            new DelayScreen(screen, 20L);
        } else {
            mc.m_91152_(screen);
        }
    }

    public static int getRandomColor() {
        return 0xFF000000 | ACTMod.RANDOM.nextInt(0x1000000);
    }

    public static int getTimeColor(int frequency, int saturation, int lightness) {
        return 0xFF000000 | GuiUtils.fromHSL((int)(System.currentTimeMillis() % (long)frequency * 360L / (long)frequency), saturation, lightness);
    }

    public static void drawBox(PoseStack p, int x, int y, int width, int height, float z) {
        GuiUtils.drawGradientRect(p, x - 3, y - 4, x + width + 3, y - 3, -267386864, -267386864, z -= 50.0f);
        GuiUtils.drawGradientRect(p, x - 3, y + height + 3, x + width + 3, y + height + 4, -267386864, -267386864, z);
        GuiUtils.drawGradientRect(p, x - 3, y - 3, x + width + 3, y + height + 3, -267386864, -267386864, z);
        GuiUtils.drawGradientRect(p, x - 4, y - 3, x - 3, y + height + 3, -267386864, -267386864, z);
        GuiUtils.drawGradientRect(p, x + width + 3, y - 3, x + width + 4, y + height + 3, -267386864, -267386864, z);
        GuiUtils.drawGradientRect(p, x - 3, y - 3 + 1, x - 3 + 1, y + height + 3 - 1, 0x505000FF, 1344798847, z);
        GuiUtils.drawGradientRect(p, x + width + 2, y - 3 + 1, x + width + 3, y + height + 3 - 1, 0x505000FF, 1344798847, z);
        GuiUtils.drawGradientRect(p, x - 3, y - 3, x + width + 3, y - 3 + 1, 0x505000FF, 0x505000FF, z);
        GuiUtils.drawGradientRect(p, x - 3, y + height + 2, x + width + 3, y + height + 3, 1344798847, 1344798847, z);
    }

    @Deprecated
    public static void color3f(float r, float g, float b) {
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
    }

    public static void drawCenterString(Font font, String text, int x, int y, int color) {
        Objects.requireNonNull(font);
        GuiUtils.drawCenterString(font, text, x, y, color, 9);
    }

    public static void drawCenterString(Font font, String text, int x, int y, int color, int height) {
        GuiUtils.drawString(font, text, x - font.m_92895_(text) / 2, y, color, height);
    }

    public static void drawGradientRect(PoseStack stack, int left, int top, int right, int bottom, int startColor, int endColor, float zLevel) {
        GuiUtils.drawGradientRect(stack, left, top, right, bottom, startColor, startColor, endColor, endColor, zLevel);
    }

    public static void drawGradientRect(PoseStack stack, int left, int top, int right, int bottom, int rightTopColor, int leftTopColor, int leftBottomColor, int rightBottomColor, float zLevel) {
        float alphaRightTop = (float)(rightTopColor >> 24 & 0xFF) / 255.0f;
        float redRightTop = (float)(rightTopColor >> 16 & 0xFF) / 255.0f;
        float greenRightTop = (float)(rightTopColor >> 8 & 0xFF) / 255.0f;
        float blueRightTop = (float)(rightTopColor & 0xFF) / 255.0f;
        float alphaLeftTop = (float)(leftTopColor >> 24 & 0xFF) / 255.0f;
        float redLeftTop = (float)(leftTopColor >> 16 & 0xFF) / 255.0f;
        float greenLeftTop = (float)(leftTopColor >> 8 & 0xFF) / 255.0f;
        float blueLeftTop = (float)(leftTopColor & 0xFF) / 255.0f;
        float alphaLeftBottom = (float)(leftBottomColor >> 24 & 0xFF) / 255.0f;
        float redLeftBottom = (float)(leftBottomColor >> 16 & 0xFF) / 255.0f;
        float greenLeftBottom = (float)(leftBottomColor >> 8 & 0xFF) / 255.0f;
        float blueLeftBottom = (float)(leftBottomColor & 0xFF) / 255.0f;
        float alphaRightBottom = (float)(rightBottomColor >> 24 & 0xFF) / 255.0f;
        float redRightBottom = (float)(rightBottomColor >> 16 & 0xFF) / 255.0f;
        float greenRightBottom = (float)(rightBottomColor >> 8 & 0xFF) / 255.0f;
        float blueRightBottom = (float)(rightBottomColor & 0xFF) / 255.0f;
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f mat = stack.m_85850_().m_85861_();
        bufferbuilder.m_85982_(mat, (float)right, (float)top, zLevel).m_85950_(redRightTop, greenRightTop, blueRightTop, alphaRightTop).m_5752_();
        bufferbuilder.m_85982_(mat, (float)left, (float)top, zLevel).m_85950_(redLeftTop, greenLeftTop, blueLeftTop, alphaLeftTop).m_5752_();
        bufferbuilder.m_85982_(mat, (float)left, (float)bottom, zLevel).m_85950_(redLeftBottom, greenLeftBottom, blueLeftBottom, alphaLeftBottom).m_5752_();
        bufferbuilder.m_85982_(mat, (float)right, (float)bottom, zLevel).m_85950_(redRightBottom, greenRightBottom, blueRightBottom, alphaRightBottom).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public static void drawItemStack(ItemRenderer itemRender, ItemStack itemstack, int x, int y) {
        if (itemstack == null || itemstack.m_41619_()) {
            return;
        }
        RenderSystem.m_69482_();
        itemRender.m_115203_(itemstack, x, y);
        itemRender.m_115174_(Minecraft.m_91087_().f_91062_, itemstack, x, y, null);
        RenderSystem.m_69461_();
    }

    public static void drawItemStack(ItemRenderer itemRender, Screen screen, ItemStack itemstack, int x, int y) {
        if (itemstack == null || itemstack.m_41619_()) {
            return;
        }
        RenderSystem.m_69482_();
        itemRender.m_115203_(itemstack, x, y);
        itemRender.m_115174_(screen.getMinecraft().f_91062_, itemstack, x, y, null);
        RenderSystem.m_69461_();
    }

    public static void drawRect(PoseStack stack, int left, int top, int right, int bottom, int color) {
        Gui.m_93172_((PoseStack)stack, (int)left, (int)top, (int)right, (int)bottom, (int)color);
    }

    public static void drawHoverableRect(PoseStack stack, int left, int top, int right, int bottom, int color, int colorHovered, int mouseX, int mouseY) {
        int c = GuiUtils.isHover(left, top, right - left, bottom - top, mouseX, mouseY) ? colorHovered : color;
        Gui.m_93172_((PoseStack)stack, (int)left, (int)top, (int)right, (int)bottom, (int)c);
    }

    public static void drawRelative(PoseStack stack, AbstractWidget field, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        field.f_93620_ += offsetX;
        field.f_93621_ += offsetY;
        field.m_6305_(stack, mouseX + offsetX, mouseY + offsetY, partialTicks);
        field.f_93620_ -= offsetX;
        field.f_93621_ -= offsetY;
    }

    public static void drawRelativeToolTip(PoseStack stack, AbstractWidget widget, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        widget.f_93620_ += offsetX;
        widget.f_93621_ += offsetY;
        widget.m_7428_(stack, mouseX + offsetX, mouseY + offsetY);
        widget.f_93620_ -= offsetX;
        widget.f_93621_ -= offsetY;
    }

    public static void drawRightString(Font font, String text, int x, int y, int color) {
        Objects.requireNonNull(font);
        GuiUtils.drawRightString(font, text, x, y, color, 9);
    }

    public static void drawRightString(Font font, String text, int x, int y, int color, int height) {
        GuiUtils.drawString(font, text, x - font.m_92895_(text), y, color, height);
    }

    public static void drawRightString(Font font, String text, AbstractWidget field, int color) {
        GuiUtils.drawRightString(font, text, field.f_93620_, field.f_93621_, color, field.m_93694_());
    }

    public static void drawRightString(Font font, String text, AbstractWidget field, int color, int offsetX, int offsetY) {
        GuiUtils.drawRightString(font, text, field.f_93620_ + offsetX, field.f_93621_ + offsetY, color, field.m_93694_());
    }

    public static void drawScaledCustomSizeModalRect(int x, int y, float u, float v, int uWidth, int vHeight, int width, int height, float tileWidth, float tileHeight) {
        GuiUtils.drawScaledCustomSizeModalRect(x, y, u, v, uWidth, vHeight, width, height, tileWidth, tileHeight, 0xFFFFFF);
    }

    public static void drawScaledCustomSizeModalRect(int x, int y, float u, float v, int uWidth, int vHeight, int width, int height, float tileWidth, float tileHeight, int color) {
        GuiUtils.drawScaledCustomSizeModalRect(x, y, u, v, uWidth, vHeight, width, height, tileWidth, tileHeight, color, false);
    }

    public static void drawScaledCustomSizeModalRect(int x, int y, float u, float v, int uWidth, int vHeight, int width, int height, float tileWidth, float tileHeight, int color, boolean useAlpha) {
        float scaleX = 1.0f / tileWidth;
        float scaleY = 1.0f / tileHeight;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int alpha = useAlpha ? color >> 24 : 255;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferbuilder.m_5483_((double)x, (double)(y + height), 0.0).m_7421_(u * scaleX, (v + (float)vHeight) * scaleY).m_6122_(red, green, blue, alpha).m_5752_();
        bufferbuilder.m_5483_((double)(x + width), (double)(y + height), 0.0).m_7421_((u + (float)uWidth) * scaleX, (v + (float)vHeight) * scaleY).m_6122_(red, green, blue, alpha).m_5752_();
        bufferbuilder.m_5483_((double)(x + width), (double)y, 0.0).m_7421_((u + (float)uWidth) * scaleX, v * scaleY).m_6122_(red, green, blue, alpha).m_5752_();
        bufferbuilder.m_5483_((double)x, (double)y, 0.0).m_7421_(u * scaleX, v * scaleY).m_6122_(red, green, blue, alpha).m_5752_();
        tesselator.m_85914_();
    }

    public static void drawString(Font font, String text, int x, int y, int color, int height) {
        int n = y + height / 2;
        Objects.requireNonNull(font);
        ACTMod.drawString(font, text, x, n - 9 / 2, color);
    }

    public static void drawString(Font font, String text, int x, int y, int color) {
        Objects.requireNonNull(font);
        GuiUtils.drawString(font, text, x, y, color, 9);
    }

    public static void drawTextBox(PoseStack matrixStack, Font font, int x, int y, int parentWidth, int parentHeight, float zLevel, String ... args) {
        List<String> text = Arrays.asList(args);
        int width = text.isEmpty() ? 0 : text.stream().mapToInt(arg_0 -> ((Font)font).m_92895_(arg_0)).max().getAsInt();
        int n = text.size();
        Objects.requireNonNull(font);
        int height = n * (1 + 9);
        Tuple<Integer, Integer> pos = GuiUtils.getRelativeBoxPos(x, y, width, height, parentWidth, parentHeight);
        GuiUtils.drawBox(matrixStack, (Integer)pos.a, (Integer)pos.b, width, height, zLevel);
        text.forEach(l -> {
            ACTMod.drawString(font, l, (Integer)pos.a, (Integer)pos.b, -1);
            int n = (Integer)pos.b;
            Objects.requireNonNull(font);
            pos.b = n + (1 + 9);
        });
    }

    public static int getRedGreen(boolean value) {
        return value ? -8913033 : -34953;
    }

    public static Tuple<Integer, Integer> getRelativeBoxPos(int x, int y, int width, int height, int parentWidth, int parentHeight) {
        if (x + width > parentWidth) {
            if ((x -= width + 5) < 0) {
                x = 0;
            }
        } else {
            x += 12;
        }
        if (y + height > parentHeight) {
            if ((y -= height + 5) < 0) {
                y = 0;
            }
        } else {
            y += 12;
        }
        return new Tuple<Integer, Integer>(x, y);
    }

    public static boolean isHover(AbstractWidget widget, int mouseX, int mouseY) {
        return GuiUtils.isHover(widget.f_93620_, widget.f_93621_, widget.m_5711_(), widget.m_93694_(), mouseX, mouseY);
    }

    public static boolean isHover(int x, int y, int sizeX, int sizeY, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + sizeX && mouseY >= y && mouseY <= y + sizeY;
    }

    public static float clamp(float v, float min, float max) {
        return v < min ? min : (v > max ? max : v);
    }

    public static int clamp(int v, int min, int max) {
        return v < min ? min : (v > max ? max : v);
    }

    public record HSLResult(int hue, int saturation, int lightness, int alpha) {
    }

    public record RGBResult(int red, int green, int blue, int alpha) {
    }

    private static class DelayScreen {
        private Screen screen;
        private long delay;

        DelayScreen(Screen screen, long delay) {
            this.screen = screen;
            this.delay = delay;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        void renderScreen() {
            Minecraft.m_91087_().m_91152_(this.screen);
        }

        @SubscribeEvent
        public void onTick(TickEvent ev) {
            if (this.delay < 0L) {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
                GuiUtils.runOnGameThread(this::renderScreen);
            } else {
                --this.delay;
            }
        }
    }
}

