/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.utils;

import com.google.common.collect.Multimap;
import com.google.gson.JsonParseException;
import com.google.gson.internal.LinkedTreeMap;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import fr.atesab.act.ACTMod;
import fr.atesab.act.utils.ChatUtils;
import fr.atesab.act.utils.CommandUtils;
import fr.atesab.act.utils.ItemReader;
import fr.atesab.act.utils.Tuple;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.OptionalInt;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemUtils {
    public static final String NBT_CHILD_DISPLAY = "display";
    public static final String NBT_CHILD_ENCHANTMENTS = "Enchantments";
    public static final String NBT_CHILD_BOOK_ENCHANTMENTS = "StoredEnchantments";
    public static final String NBT_CHILD_EXPLOSIONS = "Explosions";
    public static final String NBT_CHILD_FIREWORKS = "Fireworks";
    public static final String NBT_CHILD_ATTRIBUTE_MODIFIER = "AttributeModifiers";
    private static final ItemReader ITEM_READER = new ItemReader();
    private static final Random RANDOM = ACTMod.RANDOM;
    private static final Map<String, Tuple<Long, CompoundTag>> SKIN_CACHE = new HashMap<String, Tuple<Long, CompoundTag>>();
    private static final Map<String, Tuple<Long, String>> UUID_CACHE = new HashMap<String, Tuple<Long, String>>();
    private static final Character[] RANDOM_CHAR = new Character[]{Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('M'), Character.valueOf('Z')};

    private static String addHyphen(String uuid) {
        if (uuid.length() < 20) {
            return uuid;
        }
        return uuid.substring(0, 8) + "-" + uuid.substring(8, 12) + "-" + uuid.substring(12, 16) + "-" + uuid.substring(16, 20) + "-" + uuid.substring(20, uuid.length());
    }

    public static ItemStack buildStack(Block block, int count, @Nullable String name, @Nullable String[] lore, @Nullable Tuple<Enchantment, Integer>[] enchantments) {
        return ItemUtils.buildStack(block.m_5456_(), count, name, lore, enchantments);
    }

    public static ItemStack buildStack(Item item, int count, @Nullable String name, @Nullable String[] lore, @Nullable Tuple<Enchantment, Integer>[] enchantments) {
        ItemStack is = new ItemStack((ItemLike)item, count);
        if (name != null) {
            is.m_41714_((Component)new TextComponent(name));
        }
        if (lore != null) {
            ItemUtils.setLore(is, lore);
        }
        if (enchantments != null) {
            ItemUtils.setEnchantments(Arrays.asList(enchantments), is, is.m_41720_().equals(Items.f_42690_));
        }
        return is;
    }

    public static boolean canGive(Minecraft mc) {
        for (int i = 0; i < 9; ++i) {
            ItemStack it = mc.f_91074_.m_150109_().m_8020_(i);
            if (it != null && !it.equals(Items.f_41852_)) continue;
            return true;
        }
        return false;
    }

    public static List<AttributeData> getAttributes(ItemStack stack) {
        ArrayList<AttributeData> l = new ArrayList<AttributeData>();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            stack.m_41638_(slot).forEach((attribute, modifier) -> l.add(new AttributeData(slot, (AttributeModifier)modifier, (Attribute)attribute)));
        }
        return l;
    }

    public static int getColor(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag == null || !tag.m_128441_(NBT_CHILD_DISPLAY) || !tag.m_128469_(NBT_CHILD_DISPLAY).m_128441_("color") ? 10511680 : tag.m_128469_(NBT_CHILD_DISPLAY).m_128451_("color");
    }

    public static String getCustomTag(ItemStack stack, String key, String defaultValue) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return defaultValue;
        }
        return tag.m_128441_(key) ? tag.m_128461_(key) : defaultValue;
    }

    public static List<Tuple<Enchantment, Integer>> getEnchantments(ItemStack stack) {
        return ItemUtils.getEnchantments(stack, false);
    }

    public static List<Tuple<Enchantment, Integer>> getEnchantments(ItemStack stack, boolean book) {
        LinkedTreeMap map = new LinkedTreeMap((e1, e2) -> e2.m_44704_().compareToIgnoreCase(e1.m_44704_()));
        Registry.f_122825_.forEach(e -> map.put(e, (Object)0));
        String key = book ? NBT_CHILD_BOOK_ENCHANTMENTS : NBT_CHILD_ENCHANTMENTS;
        ListTag list = stack.m_41783_() != null && stack.m_41783_().m_128441_(key) ? stack.m_41783_().m_128437_(key, 10) : new ListTag();
        for (int i = 0; i < list.size(); ++i) {
            Enchantment ench;
            CompoundTag tag = list.m_128728_(i);
            if (!tag.m_128441_("id") || (ench = (Enchantment)Registry.f_122825_.m_7745_(ResourceLocation.m_135820_((String)tag.m_128461_("id")))) == null) continue;
            map.put((Object)ench, (Object)(tag.m_128441_("lvl") ? tag.m_128451_("lvl") : 0));
        }
        ArrayList<Tuple<Enchantment, Integer>> result = new ArrayList<Tuple<Enchantment, Integer>>();
        map.keySet().forEach(e -> result.add(new Tuple<Enchantment, Integer>((Enchantment)e, (Integer)map.get(e))));
        return result;
    }

    public static ExplosionInformation getExplosionInformation(@Nullable CompoundTag explosion) {
        return explosion == null ? new ExplosionInformation() : new ExplosionInformation(explosion);
    }

    public static ItemStack getFromGiveCode(String code) {
        if (code == null || code.isEmpty()) {
            return null;
        }
        return ITEM_READER.readItem(code);
    }

    public static String getGiveCode(ItemStack itemStack) {
        return ItemUtils.getGiveCode(itemStack, true);
    }

    public static String getGiveCode(ItemStack itemStack, boolean showCount) {
        boolean noTag;
        boolean bl = noTag = itemStack.m_41783_() != null && !itemStack.m_41783_().m_128456_();
        return itemStack == null ? "" : Registry.f_122827_.m_7981_((Object)itemStack.m_41720_()).toString() + (noTag ? itemStack.m_41783_().toString() : "") + (String)(itemStack.m_41613_() == 1 && showCount ? "" : " " + itemStack.m_41613_());
    }

    public static ItemStack getHead(ItemStack is, String name) throws IOException, CommandSyntaxException, NoSuchElementException {
        CompoundTag skullOwner = is.m_41698_("SkullOwner");
        String uuid = (String)((Tuple)ItemUtils.getUUIDByNames((String[])new String[]{name}).stream().findFirst().get()).b;
        skullOwner.m_128391_(ItemUtils.getSkinInformationFromUUID(uuid));
        skullOwner.m_128359_("Name", name);
        skullOwner.m_128359_("Id", ItemUtils.addHyphen(uuid));
        return is;
    }

    public static ItemStack getHead(ItemStack is, String uuid, String url, String name) {
        CompoundTag skullOwner = is.m_41698_("SkullOwner");
        skullOwner.m_128359_("Id", ItemUtils.addHyphen(uuid.replaceAll("-", "")));
        ListTag textures = new ListTag();
        CompoundTag texture = new CompoundTag();
        texture.m_128359_("Value", Base64.getEncoder().encodeToString(("{\"textures\":{\"SKIN\":{\"url\":\"" + url + "\"}}}").getBytes()));
        textures.add((Object)texture);
        ItemUtils.getOrCreateSubCompound(skullOwner, "Properties").m_128365_("textures", (Tag)textures);
        if (name != null) {
            skullOwner.m_128359_("Name", name);
        } else if (skullOwner.m_128441_("Name")) {
            skullOwner.m_128473_("Name");
        }
        return is;
    }

    public static ItemStack getHead(String name) throws IOException, CommandSyntaxException, NoSuchElementException {
        return ItemUtils.getHead(new ItemStack((ItemLike)Items.f_42680_, 1), name);
    }

    public static ItemStack getHead(String uuid, String url, String name) {
        return ItemUtils.getHead(new ItemStack((ItemLike)Items.f_42680_, 1), uuid, url, name);
    }

    public static List<ItemStack> getHeads(Collection<Player> players) throws IOException, CommandSyntaxException, NoSuchElementException {
        return ItemUtils.getHeads((String[])players.stream().map(Player::m_6302_).toArray(String[]::new));
    }

    public static List<ItemStack> getHeads(String ... names) throws IOException, CommandSyntaxException, NoSuchElementException {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ItemUtils.getUUIDByNames(names).stream().forEach(tuple -> {
            try {
                ItemStack stack = new ItemStack((ItemLike)Items.f_42680_, 1);
                CompoundTag skullOwner = stack.m_41698_("SkullOwner");
                String uuid = (String)tuple.b;
                skullOwner.m_128391_(ItemUtils.getSkinInformationFromUUID(uuid));
                skullOwner.m_128359_("Name", (String)tuple.a);
                skullOwner.m_128359_("Id", ItemUtils.addHyphen(uuid));
                stacks.add(stack);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return stacks;
    }

    public static String[] getLore(ItemStack stack) {
        CompoundTag display = stack.m_41698_(NBT_CHILD_DISPLAY);
        ListTag nbtTagList = display.m_128437_("Lore", 8);
        String[] array = new String[nbtTagList.size()];
        for (int j = 0; j < nbtTagList.size(); ++j) {
            String s = nbtTagList.m_128778_(j);
            array[j] = "";
            try {
                MutableComponent MutableComponent1 = Component.Serializer.m_130701_((String)s);
                if (MutableComponent1 == null) continue;
                array[j] = MutableComponent1.getString();
                continue;
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
        }
        return array;
    }

    private static CompoundTag getOrCreateSubCompound(CompoundTag compound, String key) {
        if (compound.m_128425_(key, 10)) {
            return compound.m_128469_(key);
        }
        CompoundTag nbttagcompound = new CompoundTag();
        compound.m_128365_(key, (Tag)nbttagcompound);
        return nbttagcompound;
    }

    public static PotionInformation getPotionInformation(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        List customEffects = PotionUtils.m_43573_((CompoundTag)tag);
        return new PotionInformation(tag != null && tag.m_128441_("CustomPotionColor") ? OptionalInt.of(tag.m_128451_("CustomPotionColor")) : OptionalInt.empty(), PotionUtils.m_43577_((CompoundTag)tag), customEffects);
    }

    public static ItemStack getRandomFireworks() {
        CompoundTag fwt = new CompoundTag();
        int flight = RANDOM.nextInt(3);
        fwt.m_128405_("Flight", flight + 1);
        ListTag explosions = new ListTag();
        int exp = RANDOM.nextInt(7 - flight) + 1;
        for (int i = 0; i < exp; ++i) {
            explosions.add((Object)ItemUtils.getExplosionInformation(null).getTag());
        }
        fwt.m_128365_(NBT_CHILD_EXPLOSIONS, (Tag)explosions);
        ItemStack fw = new ItemStack((ItemLike)Items.f_42688_);
        CompoundTag tag = new CompoundTag();
        tag.m_128365_(NBT_CHILD_FIREWORKS, (Tag)fwt);
        fw.m_41751_(tag);
        List list = ForgeRegistries.ENTITIES.getValues().stream().filter(EntityType::m_20654_).collect(Collectors.toList());
        fw.m_41714_((Component)new TranslatableComponent(((EntityType)list.get(RANDOM.nextInt(list.size()))).m_20675_()).m_130940_(ChatFormatting.values()[RANDOM.nextInt(16)]).m_130946_(" " + CommandUtils.getRandomElement(RANDOM_CHAR) + RANDOM.nextInt(1000)));
        ItemUtils.setLore(fw, new String[]{ChatFormatting.YELLOW + ChatFormatting.ITALIC + I18n.m_118938_((String)"cmd.act.rfw", (Object[])new Object[0])});
        return fw;
    }

    public static CompoundTag getSkinInformationFromUUID(String uuid) throws IOException, CommandSyntaxException {
        if (SKIN_CACHE.containsKey(uuid) && (Long)ItemUtils.SKIN_CACHE.get((Object)uuid).a + 60000L > System.currentTimeMillis()) {
            return ((CompoundTag)ItemUtils.SKIN_CACHE.get((Object)uuid).b).m_6426_();
        }
        CompoundTag requestCompound = TagParser.m_129359_((String)ItemUtils.sendRequest("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid.replaceAll("-", ""), null, null, null));
        CompoundTag newTag = new CompoundTag();
        if (requestCompound.m_128425_("properties", 9)) {
            ListTag properties = requestCompound.m_128437_("properties", 10);
            ListTag textures = new ListTag();
            properties.forEach(base -> {
                CompoundTag tex = (CompoundTag)base;
                CompoundTag newTex = new CompoundTag();
                if (tex.m_128425_("value", 8)) {
                    newTex.m_128359_("Value", tex.m_128461_("value"));
                }
                textures.add((Object)newTex);
            });
            newTag.m_128365_("Properties", (Tag)new CompoundTag());
            newTag.m_128359_("Id", ItemUtils.addHyphen(uuid.replaceAll("-", "")));
            newTag.m_128469_("Properties").m_128365_("textures", (Tag)textures);
        }
        SKIN_CACHE.put(uuid, new Tuple<Long, CompoundTag>(System.currentTimeMillis(), newTag.m_6426_()));
        return newTag;
    }

    public static List<Tuple<String, String>> getUUIDByNames(String ... names) throws IOException, CommandSyntaxException {
        CompoundTag tag;
        ArrayList<Tuple<String, String>> list = new ArrayList<Tuple<String, String>>();
        String query = Arrays.stream(names).map(n -> {
            if (UUID_CACHE.containsKey(n) && (Long)ItemUtils.UUID_CACHE.get((Object)n).a + 60000L > System.currentTimeMillis()) {
                list.add(new Tuple<String, String>((String)n, (String)ItemUtils.UUID_CACHE.get((Object)n).b));
                return null;
            }
            return "\"" + n + "\"";
        }).filter(s -> s != null).collect(Collectors.joining(","));
        if (!query.isEmpty() && (tag = TagParser.m_129359_((String)("{data:" + ItemUtils.sendRequest("https://api.mojang.com/profiles/minecraft", "POST", "application/json", "[" + query + "]") + "}"))).m_128425_("data", 9)) {
            tag.m_128437_("data", 10).forEach(base -> {
                CompoundTag data = (CompoundTag)base;
                if (data.m_128425_("id", 8) && data.m_128425_("name", 8)) {
                    String name = data.m_128461_("name");
                    String id = data.m_128461_("id");
                    list.add(new Tuple<String, String>(name, id));
                    UUID_CACHE.put(name, new Tuple<Long, String>(System.currentTimeMillis(), id));
                }
            });
        }
        return list;
    }

    public static void give(ItemStack stack) {
        ItemUtils.give(Minecraft.m_91087_(), stack);
    }

    public static void give(ItemStack stack, int slot) {
        ItemUtils.give(Minecraft.m_91087_(), stack, slot);
    }

    public static void give(List<ItemStack> stacks) {
        ItemUtils.give(Minecraft.m_91087_(), stacks);
    }

    @Deprecated
    public static void give(Minecraft mc, ItemStack stack) {
        if (mc.f_91074_ != null && mc.f_91074_.m_7500_()) {
            if (stack != null) {
                for (int i = 0; i < 9; ++i) {
                    if (!((ItemStack)mc.f_91074_.m_150109_().f_35974_.get(i)).m_41619_()) continue;
                    ItemUtils.give(mc, stack, 36 + i);
                    ChatUtils.itemStack(stack);
                    return;
                }
            }
            ChatUtils.error(I18n.m_118938_((String)"gui.act.give.fail", (Object[])new Object[0]));
        } else {
            ChatUtils.error(I18n.m_118938_((String)"gui.act.nocreative", (Object[])new Object[0]));
        }
    }

    @Deprecated
    public static void give(Minecraft mc, ItemStack stack, int slot) {
        if (mc.f_91074_.m_7500_()) {
            mc.f_91072_.m_105241_(stack, slot);
        } else {
            ChatUtils.error(I18n.m_118938_((String)"gui.act.nocreative", (Object[])new Object[0]));
        }
    }

    @Deprecated
    public static void give(Minecraft mc, List<ItemStack> stacks) {
        if (mc.f_91074_ != null && mc.f_91074_.m_7500_()) {
            int i = 0;
            block0: for (int j = 0; j < stacks.size(); ++j) {
                ItemStack is = stacks.get(j);
                while (i < 9) {
                    if (((ItemStack)mc.f_91074_.m_150109_().f_35974_.get(i)).m_41619_()) {
                        ItemUtils.give(mc, is, 36 + i);
                        ChatUtils.itemStack(is);
                        ++i;
                        continue block0;
                    }
                    ++i;
                }
                ChatUtils.error(I18n.m_118938_((String)"gui.act.give.fail", (Object[])new Object[0]));
                return;
            }
        } else {
            ChatUtils.error(I18n.m_118938_((String)"gui.act.nocreative", (Object[])new Object[0]));
        }
    }

    public static boolean isUnbreakable(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128471_("Unbreakable");
    }

    private static String sendRequest(String url, String method, String contentType, String content) throws IOException {
        String line;
        Proxy proxy;
        Proxy proxy2 = proxy = Minecraft.m_91087_() == null ? null : Minecraft.m_91087_().m_91096_();
        if (proxy == null) {
            proxy = Proxy.NO_PROXY;
        }
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection(proxy);
        if (method != null) {
            connection.setRequestMethod(method);
        }
        if (contentType != null) {
            connection.setRequestProperty("Content-Type", contentType);
        }
        connection.setRequestProperty("Content-Language", "en-US");
        connection.setDoOutput(true);
        if (content != null) {
            connection.setRequestProperty("Content-Length", "" + content.getBytes().length);
            connection.setUseCaches(false);
            connection.setDoInput(true);
            DataOutputStream output = new DataOutputStream(connection.getOutputStream());
            output.writeBytes(content);
            output.flush();
            output.close();
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuffer buffer = new StringBuffer();
        while ((line = bufferedReader.readLine()) != null) {
            buffer.append("\n" + line);
        }
        return buffer.length() > 0 ? buffer.toString().substring(1) : "";
    }

    public static ItemStack setAttributes(List<AttributeData> attributes, ItemStack stack) {
        attributes.forEach(data -> stack.m_41643_(data.attribute, data.modifier, data.slot));
        return stack;
    }

    public static ItemStack setColor(ItemStack stack, int color) {
        if (stack.m_41783_() == null) {
            stack.m_41751_(new CompoundTag());
        }
        CompoundTag display = stack.m_41698_(NBT_CHILD_DISPLAY);
        if (color != 10511680) {
            display.m_128405_("color", color);
        } else if (display.m_128441_("color")) {
            display.m_128473_("color");
        }
        return stack;
    }

    public static ItemStack setCustomTag(ItemStack stack, String key, String value) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
            stack.m_41751_(tag);
        }
        tag.m_128359_(key, value);
        return stack;
    }

    public static ItemStack setEnchantments(List<Tuple<Enchantment, Integer>> enchantments, ItemStack stack) {
        return ItemUtils.setEnchantments(enchantments, stack, false);
    }

    public static ItemStack setEnchantments(List<Tuple<Enchantment, Integer>> enchantments, ItemStack stack, boolean book) {
        ListTag nbttaglist = new ListTag();
        enchantments.forEach(tuple -> {
            if ((Integer)tuple.b == 0) {
                return;
            }
            CompoundTag nbttagcompound = new CompoundTag();
            nbttagcompound.m_128359_("id", ((Enchantment)tuple.a).getRegistryName().toString());
            nbttagcompound.m_128405_("lvl", ((Integer)tuple.b).intValue());
            nbttaglist.add((Object)nbttagcompound);
        });
        stack.m_41784_().m_128365_(book ? NBT_CHILD_BOOK_ENCHANTMENTS : NBT_CHILD_ENCHANTMENTS, (Tag)nbttaglist);
        return stack;
    }

    public static ItemStack setItem(Item item, ItemStack stack) {
        ItemStack is = new ItemStack((ItemLike)item, stack.m_41613_());
        is.m_41751_(stack.m_41783_());
        return is;
    }

    public static ItemStack setLore(ItemStack stack, String[] lore) {
        ListTag nbtTagList = new ListTag();
        for (String l : lore) {
            nbtTagList.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)new TextComponent(l))));
        }
        CompoundTag display = stack.m_41698_(NBT_CHILD_DISPLAY);
        display.m_128365_("Lore", (Tag)nbtTagList);
        return stack;
    }

    public static ItemStack setPotionInformation(ItemStack stack, PotionInformation info) {
        ListTag nbttaglist = new ListTag();
        info.getCustomEffects().forEach(effect -> nbttaglist.add((Object)effect.m_19555_(new CompoundTag())));
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("Potion", info.getMain().getRegistryName().toString());
        if (info.customColor.isPresent()) {
            tag.m_128405_("CustomPotionColor", info.customColor.getAsInt());
        } else if (tag.m_128441_("CustomPotionColor")) {
            tag.m_128473_("CustomPotionColor");
        }
        tag.m_128365_("CustomPotionEffects", (Tag)nbttaglist);
        return stack;
    }

    public static ItemStack setUnbreakable(ItemStack stack, boolean value) {
        if (value) {
            stack.m_41784_().m_128379_("Unbreakable", true);
        } else {
            CompoundTag tag = stack.m_41783_();
            if (tag != null) {
                tag.m_128473_("Unbreakable");
            }
        }
        return stack;
    }

    public static final class ExplosionInformation
    implements Cloneable {
        private int[] colors;
        private int[] fadeColors;
        private boolean trail;
        private boolean flicker;
        private FireworkRocketItem.Shape type;

        public ExplosionInformation() {
            this(CommandUtils.getRandomElement(FireworkRocketItem.Shape.values()), RANDOM.nextBoolean(), RANDOM.nextBoolean(), new int[RANDOM.nextInt(6) + 1], new int[RANDOM.nextInt(7)]);
            int i;
            this.colors = new int[RANDOM.nextInt(6 - ((this.trail ? 1 : 0) + (this.flicker ? 1 : 0))) + 1];
            for (i = 0; i < this.colors.length; ++i) {
                this.colors[i] = DyeColor.values()[RANDOM.nextInt(DyeColor.values().length)].m_41070_();
            }
            for (i = 0; i < this.fadeColors.length; ++i) {
                this.fadeColors[i] = DyeColor.values()[RANDOM.nextInt(DyeColor.values().length)].m_41070_();
            }
        }

        public ExplosionInformation(int type, boolean trail, boolean flicker, int[] colors, int[] fadeColors) {
            this(FireworkRocketItem.Shape.m_41237_((int)type), trail, flicker, colors, fadeColors);
        }

        public ExplosionInformation(FireworkRocketItem.Shape type, boolean trail, boolean flicker, int[] colors, int[] fadeColors) {
            this.type = type;
            this.trail = trail;
            this.flicker = flicker;
            this.colors = colors;
            this.fadeColors = fadeColors;
        }

        public ExplosionInformation(CompoundTag explosion) {
            this(explosion.m_128445_("Type"), explosion.m_128471_("Trail"), explosion.m_128471_("Flicker"), explosion.m_128465_("Colors"), explosion.m_128465_("FadeColors"));
        }

        public ExplosionInformation clone() {
            return new ExplosionInformation(this.type, this.trail, this.flicker, this.colors, this.fadeColors);
        }

        public ExplosionInformation colors(int[] colors) {
            this.colors = colors;
            return this;
        }

        public ExplosionInformation fadeColors(int[] fadeColors) {
            this.fadeColors = fadeColors;
            return this;
        }

        public ExplosionInformation flicker(boolean flicker) {
            this.flicker = flicker;
            return this;
        }

        public int[] getColors() {
            return this.colors;
        }

        public int[] getFadeColors() {
            return this.fadeColors;
        }

        public CompoundTag getTag() {
            CompoundTag tag = new CompoundTag();
            tag.m_128344_("Type", (byte)this.type.m_41236_());
            if (this.trail) {
                tag.m_128379_("Trail", true);
            }
            if (this.flicker) {
                tag.m_128379_("Flicker", true);
            }
            if (this.colors.length != 0) {
                tag.m_128385_("Colors", this.colors);
            }
            if (this.fadeColors.length != 0) {
                tag.m_128385_("FadeColors", this.fadeColors);
            }
            return tag;
        }

        public FireworkRocketItem.Shape getType() {
            return this.type;
        }

        public boolean isFlicker() {
            return this.flicker;
        }

        public boolean isTrail() {
            return this.trail;
        }

        public ExplosionInformation trail(boolean trail) {
            this.trail = trail;
            return this;
        }

        public ExplosionInformation type(FireworkRocketItem.Shape type) {
            this.type = type;
            return this;
        }
    }

    public static final class PotionInformation {
        private OptionalInt customColor;
        private List<MobEffectInstance> customEffects;
        private Potion main;

        public PotionInformation(OptionalInt customColor, Potion main, List<MobEffectInstance> customEffects) {
            this.customColor = customColor;
            this.main = main;
            this.customEffects = customEffects;
        }

        public OptionalInt getCustomColor() {
            return this.customColor;
        }

        public List<MobEffectInstance> getCustomEffects() {
            return this.customEffects;
        }

        public Potion getMain() {
            return this.main;
        }

        public PotionInformation customColor(OptionalInt customColor) {
            this.customColor = customColor;
            return this;
        }

        public PotionInformation customEffects(List<MobEffectInstance> customEffects) {
            this.customEffects = customEffects;
            return this;
        }

        public PotionInformation main(Potion main) {
            this.main = main;
            return this;
        }
    }

    public static class AttributeData {
        private EquipmentSlot slot;
        private AttributeModifier modifier;
        private Attribute attribute;

        public AttributeData(EquipmentSlot slot, AttributeModifier modifier, Attribute attribute) {
            this.slot = slot;
            this.modifier = modifier;
            this.attribute = attribute;
        }

        public void setSlot(EquipmentSlot slot) {
            this.slot = slot;
        }

        public void setModifier(AttributeModifier modifier) {
            this.modifier = modifier;
        }

        public void setAttribute(Attribute attribute) {
            this.attribute = attribute;
        }

        public Attribute getAttribute() {
            return this.attribute;
        }

        public AttributeModifier getModifier() {
            return this.modifier;
        }

        public EquipmentSlot getSlot() {
            return this.slot;
        }
    }

    public static class AttributeModifierBuilder {
        private static final List<AttributeModifierBuilder> BUILDERS_INTERNAL = new ArrayList<AttributeModifierBuilder>();
        public static final List<AttributeModifierBuilder> BUILDERS = Collections.unmodifiableList(BUILDERS_INTERNAL);
        public static final AttributeModifierBuilder ARMOR;
        public static final AttributeModifierBuilder ARMOR_TOUGHNESS;
        public static final AttributeModifierBuilder KNOCKBACK_RESISTANCE;
        public static final AttributeModifierBuilder TOOL_ATTACK_DAMAGE;
        public static final AttributeModifierBuilder TOOL_ATTACK_SPEED;
        public static final AttributeModifierBuilder SWORD_ATTACK_DAMAGE;
        public static final AttributeModifierBuilder SWORD_ATTACK_SPEED;
        private AttributeModifier clone;
        private Attribute attribute;

        private AttributeModifierBuilder(Attribute attribute, AttributeModifier modifier) {
            this.clone = modifier;
            this.attribute = attribute;
            BUILDERS_INTERNAL.add(this);
        }

        public UUID getId() {
            return this.clone.m_22209_();
        }

        public String getName() {
            return this.clone.m_22214_();
        }

        public AttributeModifier build(double val, AttributeModifier.Operation op) {
            return new AttributeModifier(this.clone.m_22209_(), this.clone.m_22214_(), val, op);
        }

        public String getDescriptionId() {
            return this.attribute.m_22087_();
        }

        public AttributeData buildData(EquipmentSlot slot, double val, AttributeModifier.Operation op) {
            return new AttributeData(slot, this.build(val, op), this.attribute);
        }

        static {
            ArmorItem armor = (ArmorItem)Items.f_42481_;
            DiggerItem tool = (DiggerItem)Items.f_42395_;
            SwordItem sword = (SwordItem)Items.f_42393_;
            Multimap poolArmor = armor.m_7167_(armor.m_40402_());
            Multimap poolTool = tool.m_7167_(EquipmentSlot.MAINHAND);
            Multimap poolSword = sword.m_7167_(EquipmentSlot.MAINHAND);
            ARMOR = new AttributeModifierBuilder(Attributes.f_22284_, (AttributeModifier)poolArmor.get((Object)Attributes.f_22284_).stream().findAny().get());
            ARMOR_TOUGHNESS = new AttributeModifierBuilder(Attributes.f_22285_, (AttributeModifier)poolArmor.get((Object)Attributes.f_22285_).stream().findAny().get());
            KNOCKBACK_RESISTANCE = new AttributeModifierBuilder(Attributes.f_22278_, (AttributeModifier)poolArmor.get((Object)Attributes.f_22278_).stream().findAny().get());
            TOOL_ATTACK_DAMAGE = new AttributeModifierBuilder(Attributes.f_22281_, (AttributeModifier)poolTool.get((Object)Attributes.f_22281_).stream().findAny().get());
            TOOL_ATTACK_SPEED = new AttributeModifierBuilder(Attributes.f_22283_, (AttributeModifier)poolTool.get((Object)Attributes.f_22283_).stream().findAny().get());
            SWORD_ATTACK_DAMAGE = new AttributeModifierBuilder(Attributes.f_22281_, (AttributeModifier)poolSword.get((Object)Attributes.f_22281_).stream().findAny().get());
            SWORD_ATTACK_SPEED = new AttributeModifierBuilder(Attributes.f_22283_, (AttributeModifier)poolSword.get((Object)Attributes.f_22283_).stream().findAny().get());
        }
    }
}

