/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act;

import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import fr.atesab.act.AdvancedCreativeTab;
import fr.atesab.act.StringModifier;
import fr.atesab.act.command.ModdedCommand;
import fr.atesab.act.command.ModdedCommandACT;
import fr.atesab.act.command.ModdedCommandGamemode;
import fr.atesab.act.command.ModdedCommandGamemodeQuick;
import fr.atesab.act.config.Configuration;
import fr.atesab.act.gui.GuiACT;
import fr.atesab.act.gui.GuiGiver;
import fr.atesab.act.gui.GuiMenu;
import fr.atesab.act.gui.modifier.GuiItemStackModifier;
import fr.atesab.act.gui.modifier.GuiModifier;
import fr.atesab.act.gui.modifier.nbt.GuiNBTModifier;
import fr.atesab.act.gui.selector.GuiButtonListSelector;
import fr.atesab.act.utils.CommandUtils;
import fr.atesab.act.utils.GuiUtils;
import fr.atesab.act.utils.ItemUtils;
import fr.atesab.act.utils.Tuple;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.SuggestionProviders;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.GameType;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.gui.GuiModList;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.registries.GameData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="act")
public class ACTMod {
    public static final ACTState MOD_STATE = ACTState.RELEASE;
    public static final String MOD_ID = "act";
    public static final String MOD_NAME = "Advanced Creative 2";
    public static final String MOD_VERSION = "2.3";
    public static final String MOD_LITTLE_NAME = "ACT-Mod";
    public static final String MOD_FACTORY = "fr.atesab.act.gui.ModGuiFactory";
    public static final ModdedCommandACT ACT_COMMAND = new ModdedCommandACT();
    public static final AdvancedCreativeTab ADVANCED_CREATIVE_TAB = new AdvancedCreativeTab();
    public static final String TEMPLATE_TAG_NAME = "TemplateData";
    public static final Random RANDOM = new Random();
    public static final String[] DEFAULT_CUSTOM_ITEMS = new String[]{ItemUtils.getGiveCode(ItemUtils.buildStack(Blocks.field_196562_aR, 42, TextFormatting.LIGHT_PURPLE + "Pink verity", new String[]{"" + TextFormatting.GOLD + TextFormatting.BOLD + "42 is life", "" + TextFormatting.GOLD + TextFormatting.BOLD + "wait what ?"}, new Tuple[0]))};
    public static final Logger LOGGER = LogManager.getLogger((String)"act".toUpperCase());
    private static KeyBinding giver;
    private static KeyBinding menu;
    private static KeyBinding edit;
    private static List<ItemStack> templates;
    private static HashSet<IAttribute> attributes;
    private static Map<String, Map<String, Consumer<StringModifier>>> stringModifier;
    private static Configuration config;
    private static CommandDispatcher<CommandSource> dispatcher;
    private static Set<String> commandSet;
    private static CommandDispatcher<ISuggestionProvider> suggestionProvider;

    public static boolean doesDisableToolTip() {
        return config.doesDisableToolTip();
    }

    private static <T> void forEachMatchIn(Object obj, Class<T> cls, Consumer<T> consumer) {
        for (Field field : obj.getClass().getDeclaredFields()) {
            if (!field.getType().equals(cls)) continue;
            field.setAccessible(true);
            try {
                consumer.accept(field.get(obj));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static HashSet<IAttribute> getAttributes() {
        return attributes;
    }

    public static List<String> getCustomItems() {
        return config.getCustomitems();
    }

    public static CommandDispatcher<CommandSource> getDispatcher() {
        return dispatcher;
    }

    public static Map<String, Map<String, Consumer<StringModifier>>> getStringModifier() {
        return stringModifier;
    }

    public static String getTemplateData(ItemStack template) {
        return ItemUtils.getCustomTag(template, TEMPLATE_TAG_NAME, null);
    }

    public static Stream<ItemStack> getTemplates() {
        return templates.stream().map(is -> {
            String lang = ItemUtils.getCustomTag(is, "TemplateDataLang", null);
            TextComponentTranslation display = lang != null ? new TextComponentTranslation(lang, new Object[0]) : is.func_200301_q();
            display.func_150256_b().func_150238_a(TextFormatting.AQUA);
            return is.func_77946_l().func_200302_a((ITextComponent)display);
        });
    }

    public static void openGiver() {
        Minecraft mc = Minecraft.func_71410_x();
        int slot = mc.field_71439_g.field_71071_by.field_70461_c;
        GuiUtils.displayScreen(new GuiItemStackModifier(null, mc.field_71439_g.func_184614_ca().func_77946_l(), is -> ItemUtils.give(is, 36 + slot)));
    }

    public static void registerCommand(ModdedCommand command) {
        commandSet.addAll(command.getAliases());
        command.register(dispatcher);
    }

    public static void registerStringModifier(String name, Consumer<StringModifier> modifier) {
        ACTMod.registerStringModifier(name, "", modifier);
    }

    public static void registerStringModifier(String name, String category, Consumer<StringModifier> modifier) {
        Map<String, Consumer<StringModifier>> map = stringModifier.get(category);
        if (map == null) {
            map = new HashMap<String, Consumer<StringModifier>>();
            stringModifier.put(category, map);
        }
        map.put(name, modifier);
    }

    public static void registerTemplate(String lang, ItemStack icon, String data) {
        templates.add(ItemUtils.setCustomTag(ItemUtils.setCustomTag(icon.func_77946_l(), TEMPLATE_TAG_NAME, data), "TemplateDataLang", lang));
    }

    public static void saveConfigs() {
        config.save();
    }

    public static void setDoesDisableToolTip(boolean doesDisableToolTip) {
        config.setDoesDisableToolTip(doesDisableToolTip);
    }

    public ACTMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        config = new Configuration();
        config.sync(FMLPaths.CONFIGDIR.get().resolve("act.toml").toFile());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void checkModList(GuiScreen screen) {
        boolean value;
        Optional op;
        ModInfo info;
        if (screen instanceof GuiModList && (info = this.getFirstFieldOfTypeInto(ModInfo.class, screen)) != null && (op = ModList.get().getModContainerById(info.getModId())).isPresent() && (value = ((ModContainer)op.get()).getCustomExtension(ExtensionPoint.CONFIGGUIFACTORY).isPresent())) {
            String config = I18n.func_135052_a((String)"fml.menu.mods.config", (Object[])new Object[0]);
            for (IGuiEventListener b : screen.func_195074_b()) {
                if (!(b instanceof GuiButton) || !((GuiButton)b).field_146126_j.equals(config)) continue;
                ((GuiButton)b).field_146124_l = value;
            }
        }
    }

    private void commandSetup() {
        ACTMod.registerCommand(new ModdedCommandACT());
        ACTMod.registerCommand(new ModdedCommandGamemode("gm"));
        ACTMod.registerCommand(new ModdedCommandGamemodeQuick("gmc", GameType.CREATIVE));
        ACTMod.registerCommand(new ModdedCommandGamemodeQuick("gma", GameType.ADVENTURE));
        ACTMod.registerCommand(new ModdedCommandGamemodeQuick("gms", GameType.SURVIVAL));
        ACTMod.registerCommand(new ModdedCommandGamemodeQuick("gmsp", GameType.SPECTATOR));
        LOGGER.info("Commands registered.");
    }

    private void commonSetup(FMLCommonSetupEvent ev) {
        ModList.get().getModContainerById(MOD_ID).ifPresent(con -> con.registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (mc, parent) -> new GuiMenu((GuiScreen)parent)));
        this.commandSetup();
        giver = new KeyBinding("key.act.giver", 89, MOD_NAME);
        ClientRegistry.registerKeyBinding((KeyBinding)giver);
        menu = new KeyBinding("key.act.menu", 78, MOD_NAME);
        ClientRegistry.registerKeyBinding((KeyBinding)menu);
        edit = new KeyBinding("key.act.edit", 72, MOD_NAME);
        ClientRegistry.registerKeyBinding((KeyBinding)edit);
        attributes.add(SharedMonsterAttributes.field_188791_g);
        attributes.add(SharedMonsterAttributes.field_189429_h);
        attributes.add(SharedMonsterAttributes.field_111264_e);
        attributes.add(SharedMonsterAttributes.field_188790_f);
        attributes.add(SharedMonsterAttributes.field_193334_e);
        attributes.add(SharedMonsterAttributes.field_111265_b);
        attributes.add(SharedMonsterAttributes.field_111266_c);
        attributes.add(SharedMonsterAttributes.field_188792_h);
        attributes.add(SharedMonsterAttributes.field_111267_a);
        attributes.add(SharedMonsterAttributes.field_111263_d);
        ACTMod.registerTemplate("gui.act.menu.template.empty", new ItemStack((IItemProvider)Items.field_151121_aF), "");
        ACTMod.registerTemplate("gui.act.menu.template.stone", new ItemStack((IItemProvider)Blocks.field_150348_b), ItemUtils.getGiveCode(new ItemStack((IItemProvider)Blocks.field_150348_b)));
        ACTMod.registerTemplate("gui.act.menu.template.potion", new ItemStack((IItemProvider)Items.field_151068_bn), ItemUtils.getGiveCode(new ItemStack((IItemProvider)Items.field_151068_bn)));
        ACTMod.registerTemplate("gui.act.menu.template.fireworks", new ItemStack((IItemProvider)Items.field_196152_dE), ItemUtils.getGiveCode(new ItemStack((IItemProvider)Items.field_196152_dE)));
        ACTMod.registerTemplate(Items.field_196184_dx.func_77658_a(), new ItemStack((IItemProvider)Items.field_196184_dx), ItemUtils.getGiveCode(new ItemStack((IItemProvider)Items.field_196184_dx)));
        ACTMod.registerTemplate("gui.act.menu.template.command", new ItemStack((IItemProvider)Blocks.field_150483_bI), ItemUtils.getGiveCode(new ItemStack((IItemProvider)Blocks.field_150483_bI)));
        ACTMod.registerTemplate(Items.field_151110_aK.func_77658_a(), new ItemStack((IItemProvider)Items.field_151110_aK), ItemUtils.getGiveCode(new ItemStack((IItemProvider)Items.field_151110_aK)));
        IRegistry.field_212630_s.forEach(i -> {
            ACTMod.registerStringModifier(i.func_77658_a() + ".name", "registry.items", sm -> sm.setString(i.getRegistryName().toString()));
            if (i.getCreativeTabs() == null || i.getCreativeTabs().isEmpty() || i.func_77640_w() == null) {
                ADVANCED_CREATIVE_TAB.addSubitem((Item)i);
            } else {
                NonNullList sub = NonNullList.func_191196_a();
                i.func_150895_a(ItemGroup.field_78027_g, sub);
                if (!sub.stream().filter(is -> is.func_77973_b().equals(i) && (is.func_77978_p() == null || is.func_77978_p().isEmpty())).findFirst().isPresent()) {
                    ADVANCED_CREATIVE_TAB.addSubitem((Item)i);
                }
            }
        });
        IRegistry.field_212618_g.forEach(b -> ACTMod.registerStringModifier(b.func_200291_n().func_150261_e() + ".name", "registry.blocks", sm -> sm.setString(b.getRegistryName().toString())));
        IRegistry.field_212621_j.forEach(p -> ACTMod.registerStringModifier(p.func_185174_b(""), "registry.potions", sm -> sm.setString(p.getRegistryName().toString())));
        IRegistry.field_212624_m.forEach(b -> ACTMod.registerStringModifier(b.func_205403_k().func_150261_e(), "registry.biomes", sm -> sm.setString(b.getRegistryName().toString())));
        IRegistry.field_212633_v.forEach(s -> ACTMod.registerStringModifier(s.func_187503_a().toString(), "registry.sounds", sm -> sm.setString(s.func_187503_a().toString())));
        GameData.getWrapper(VillagerRegistry.VillagerProfession.class).forEach(vp -> {
            ACTMod.registerStringModifier(vp.getRegistryName().toString(), "registry.villagerProfessions", sm -> sm.setString(vp.getRegistryName().toString()));
            ACTMod.forEachMatchIn(vp, List.class, list -> {
                try {
                    list.forEach(vc -> ACTMod.registerStringModifier(vp.getRegistryName().toString() + " - " + vc.getName(), "registry.villagerProfessions", sm -> sm.setString(vc.getName())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        });
        IRegistry.field_212629_r.forEach(ee -> ACTMod.registerStringModifier(ee.func_210760_d(), "registry.entities", sm -> sm.setString(ee.getRegistryName().toString())));
        attributes.forEach(at -> ACTMod.registerStringModifier("attribute.name." + at.func_111108_a(), "attributes", sm -> sm.setString(at.func_111108_a())));
        for (EntityEquipmentSlot slot : (EntityEquipmentSlot[])EntityEquipmentSlot.class.getEnumConstants()) {
            ACTMod.registerStringModifier("item.modifiers." + slot.func_188450_d(), "attributes.slot", sm -> sm.setString(slot.func_188450_d()));
        }
        ACTMod.registerStringModifier("gui.act.modifier.string.giver", "", sm -> sm.setNextScreen(new GuiGiver(sm.getNextScreen(), sm.getString(), sm::setString, false)));
        ACTMod.registerStringModifier("gui.act.modifier.string.nbt", "", sm -> {
            try {
                sm.setNextScreen(new GuiNBTModifier(sm.getNextScreen(), nbt -> sm.setString(nbt.toString()), JsonToNBT.func_180713_a((String)sm.getString())));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        ACTMod.registerStringModifier("gui.act.modifier.string.players", "", sm -> {
            List<String> plr;
            try {
                plr = CommandUtils.getPlayerList();
            }
            catch (Exception e) {
                plr = new ArrayList<String>();
                plr.add(Minecraft.func_71410_x().func_110432_I().func_111285_a());
            }
            ArrayList btn = new ArrayList();
            plr.forEach(pn -> btn.add(new Tuple<String, String>((String)pn, (String)pn)));
            sm.setNextScreen(new GuiButtonListSelector<String>(sm.getNextScreen(), btn, s -> {
                sm.setString((String)s);
                return null;
            }));
        });
        ACTMod.registerStringModifier("gui.act.modifier.string.b64.encode", "b64", sm -> {
            try {
                sm.setString(new String(Base64.getEncoder().encode(sm.getString().getBytes())));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ACTMod.registerStringModifier("gui.act.modifier.string.b64.decode", "b64", sm -> {
            try {
                sm.setString(new String(Base64.getDecoder().decode(sm.getString().getBytes())));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void createSuggestion(CommandNode<CommandSource> dispatcher, CommandNode<ISuggestionProvider> rootCommandNode, CommandSource player, Map<CommandNode<CommandSource>, CommandNode<ISuggestionProvider>> suggestions) {
        for (CommandNode child : dispatcher.getChildren()) {
            RequiredArgumentBuilder requiredargumentbuilder;
            ArgumentBuilder argumentbuilder = child.createBuilder();
            argumentbuilder.requires(ctx -> true);
            if (argumentbuilder.getCommand() != null) {
                argumentbuilder.executes(ctx -> 0);
            }
            if (argumentbuilder instanceof RequiredArgumentBuilder && (requiredargumentbuilder = (RequiredArgumentBuilder)argumentbuilder).getSuggestionsProvider() != null) {
                requiredargumentbuilder.suggests(SuggestionProviders.func_197496_b((SuggestionProvider)requiredargumentbuilder.getSuggestionsProvider()));
            }
            if (argumentbuilder.getRedirect() != null) {
                argumentbuilder.redirect(suggestions.get(argumentbuilder.getRedirect()));
            }
            CommandNode commandnode1 = argumentbuilder.build();
            suggestions.put((CommandNode<CommandSource>)child, (CommandNode<ISuggestionProvider>)commandnode1);
            rootCommandNode.addChild(commandnode1);
            if (child.getChildren().isEmpty()) continue;
            this.createSuggestion((CommandNode<CommandSource>)child, (CommandNode<ISuggestionProvider>)commandnode1, player, suggestions);
        }
    }

    private <T> T getFirstFieldOfTypeInto(Class<T> cls, Object obj) {
        for (Field f : obj.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            if (f.getType() != cls) continue;
            try {
                return (T)f.get(obj);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    private void injectSuggestions() {
        CommandDispatcher current;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && mc.field_71439_g.field_71174_a != null && (current = mc.field_71439_g.field_71174_a.func_195515_i()) != suggestionProvider) {
            suggestionProvider = current;
            if (current != null) {
                HashMap map = Maps.newHashMap();
                RootCommandNode root = suggestionProvider.getRoot();
                map.put(dispatcher.getRoot(), root);
                this.createSuggestion((CommandNode<CommandSource>)dispatcher.getRoot(), (CommandNode<ISuggestionProvider>)root, mc.field_71439_g.func_195051_bN(), map);
            }
        }
    }

    @SubscribeEvent
    public void onChatMessage(ClientChatEvent ev) {
        String msg = ev.getMessage();
        if (!msg.startsWith("/")) {
            return;
        }
        String command = msg.substring(1);
        if (!commandSet.contains(command.split(" ", 2)[0])) {
            return;
        }
        ev.setCanceled(true);
        Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146239_a(msg);
        StringReader reader = new StringReader(msg);
        if (reader.canRead()) {
            reader.skip();
        }
        CommandSource source = Minecraft.func_71410_x().field_71439_g.func_195051_bN();
        try {
            ParseResults parse = dispatcher.parse(reader, (Object)source);
            dispatcher.execute(parse);
        }
        catch (CommandException e) {
            source.func_197021_a(e.func_197003_a());
        }
        catch (CommandSyntaxException e) {
            source.func_197021_a(TextComponentUtils.func_202465_a((Message)e.getRawMessage()));
            if (e.getInput() != null && e.getCursor() >= 0) {
                int messageSize = Math.min(e.getInput().length(), e.getCursor());
                ITextComponent error = new TextComponentString("").func_211708_a(TextFormatting.GRAY).func_211710_a(style -> style.func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, msg)));
                if (messageSize > 10) {
                    error.func_150258_a("...");
                }
                error.func_150258_a(e.getInput().substring(Math.max(0, messageSize - 10), messageSize));
                if (messageSize < e.getInput().length()) {
                    ITextComponent itextcomponent2 = new TextComponentString(e.getInput().substring(messageSize)).func_211709_a(new TextFormatting[]{TextFormatting.RED, TextFormatting.UNDERLINE});
                    error.func_150257_a(itextcomponent2);
                }
                error.func_150257_a(new TextComponentTranslation("command.context.here", new Object[0]).func_211709_a(new TextFormatting[]{TextFormatting.RED, TextFormatting.ITALIC}));
                source.func_197021_a(error);
            }
        }
        catch (Exception e) {
            TextComponentString error = new TextComponentString(e.getMessage() == null ? e.getClass().getName() : e.getMessage());
            if (LOGGER.isDebugEnabled()) {
                StackTraceElement[] trace = e.getStackTrace();
                for (int j = 0; j < Math.min(trace.length, 3); ++j) {
                    error.func_150258_a("\n\n").func_150258_a(trace[j].getMethodName()).func_150258_a("\n ").func_150258_a(trace[j].getFileName()).func_150258_a(":").func_150258_a(String.valueOf(trace[j].getLineNumber()));
                }
            }
            source.func_197021_a(new TextComponentTranslation("command.failed", new Object[0]).func_211710_a(arg_0 -> ACTMod.lambda$onChatMessage$37((ITextComponent)error, arg_0)));
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent ev) {
        if (ev.phase == TickEvent.Phase.END) {
            this.checkModList(Minecraft.func_71410_x().field_71462_r);
        }
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post ev) {
        if (ev.getGui() instanceof GuiACT && MOD_STATE.isShow()) {
            Minecraft.func_71410_x().field_71466_p.func_211126_b("Warning! Currently in " + MOD_STATE.getColor() + MOD_STATE.name(), 5.0f, 5.0f, -1);
        }
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post ev) {
        this.injectSuggestions();
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent ev) {
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        if (giver.func_151468_f()) {
            GuiUtils.displayScreen(new GuiGiver(null));
        } else if (menu.func_151468_f()) {
            GuiUtils.displayScreen(new GuiMenu(null));
        } else if (edit.func_151468_f()) {
            ACTMod.openGiver();
        }
    }

    @SubscribeEvent
    public void onRenderTooltip(ItemTooltipEvent ev) {
        Minecraft mc = Minecraft.func_71410_x();
        if ((mc.field_71462_r instanceof GuiGiver || mc.field_71462_r instanceof GuiModifier || giver.getKey().func_197937_c() == 0 || !InputMappings.func_197956_a((int)340)) && mc.field_71462_r instanceof GuiMenu) {
            ev.getToolTip().add(ModdedCommand.createPrefix(I18n.func_135052_a((String)"gui.act.leftClick", (Object[])new Object[0]), TextFormatting.YELLOW, TextFormatting.GOLD).func_150257_a(ModdedCommand.createText(I18n.func_135052_a((String)(InputMappings.func_197956_a((int)340) ? "gui.act.give.copy" : "gui.act.give.editor"), (Object[])new Object[0]), TextFormatting.YELLOW)));
            if (InputMappings.func_197956_a((int)340)) {
                ev.getToolTip().add(ModdedCommand.createPrefix(I18n.func_135052_a((String)"gui.act.rightClick", (Object[])new Object[0]), TextFormatting.YELLOW, TextFormatting.GOLD).func_150257_a(ModdedCommand.createText(I18n.func_135052_a((String)"gui.act.delete", (Object[])new Object[0]), TextFormatting.YELLOW)));
            } else if (mc.field_71439_g != null && mc.field_71439_g.func_184812_l_()) {
                ev.getToolTip().add(ModdedCommand.createPrefix(I18n.func_135052_a((String)"gui.act.rightClick", (Object[])new Object[0]), TextFormatting.YELLOW, TextFormatting.GOLD).func_150257_a(ModdedCommand.createText(I18n.func_135052_a((String)"gui.act.give.give", (Object[])new Object[0]), TextFormatting.YELLOW)));
            }
        }
        if (config.doesDisableToolTip() && !ev.getFlags().func_194127_a()) {
            return;
        }
        if (InputMappings.func_197956_a((int)340)) {
            double maxdmg;
            int dmg;
            String s;
            NBTTagCompound compound = ev.getItemStack().func_77978_p();
            String string = s = !ev.getFlags().func_194127_a() ? ev.getItemStack().func_77973_b().getRegistryName().toString() : "";
            if (!(mc.field_71462_r != null && mc.field_71462_r instanceof GuiContainerCreative && ((GuiContainerCreative)mc.field_71462_r).func_147056_g() == ItemGroup.field_78027_g.func_78021_a() || ev.getItemStack().func_77973_b().getCreativeTabs() == null)) {
                s = s + TextFormatting.WHITE + (s.isEmpty() ? "" : " ") + ev.getItemStack().func_77973_b().getCreativeTabs().stream().filter(Objects::nonNull).map(i -> I18n.func_135052_a((String)i.func_78024_c(), (Object[])new Object[0])).collect(Collectors.joining(", "));
            }
            if (!s.isEmpty()) {
                ev.getToolTip().add(new TextComponentString(s));
            }
            if (compound != null && compound.func_150297_b("CustomPotionColor", 99)) {
                ev.getToolTip().add(ModdedCommand.createText(I18n.func_135052_a((String)"item.color", (Object[])new Object[]{TextFormatting.YELLOW + String.format("#%06X", compound.func_74762_e("CustomPotionColor"))}), TextFormatting.GOLD));
            }
            if (!ev.getFlags().func_194127_a()) {
                if (ev.getToolTip().size() != 0) {
                    ev.getToolTip().set(0, ((ITextComponent)ev.getToolTip().get(0)).func_150258_a(" (#" + Item.func_150891_b((Item)ev.getItemStack().func_77973_b()) + (ev.getItemStack().func_77952_i() != 0 && !ev.getItemStack().func_77951_h() ? "/" + ev.getItemStack().func_77952_i() : "") + ")").func_150255_a(new Style().func_150238_a(TextFormatting.WHITE)));
                }
                if (compound != null && compound.func_150297_b("display", 10) && compound.func_74775_l("display").func_150297_b("color", 99)) {
                    ev.getToolTip().add(ModdedCommand.createText(I18n.func_135052_a((String)"item.color", (Object[])new Object[]{TextFormatting.YELLOW + String.format("#%06X", compound.func_74775_l("display").func_74762_e("color"))}), TextFormatting.GOLD));
                }
                if (ev.getItemStack().func_77951_h()) {
                    dmg = Math.abs(ev.getItemStack().func_77952_i() - ev.getItemStack().func_77958_k()) + 1;
                    maxdmg = ev.getItemStack().func_77958_k() + 1;
                    ev.getToolTip().add(ModdedCommand.createText("RepairCost: ", TextFormatting.YELLOW).func_150257_a(ModdedCommand.createText(String.valueOf(dmg), dmg < (int)(0.1 * maxdmg) ? TextFormatting.DARK_GREEN : (dmg < (int)(0.25 * maxdmg) ? TextFormatting.GREEN : (dmg < (int)(0.5 * maxdmg) ? TextFormatting.GOLD : (dmg < (int)(0.75 * maxdmg) ? TextFormatting.RED : (dmg < (int)(1.0 * maxdmg) ? TextFormatting.DARK_RED : TextFormatting.DARK_GREEN)))))));
                    ev.getToolTip().add(ModdedCommand.createText(I18n.func_135052_a((String)"item.durability", (Object[])new Object[]{(dmg < (int)(0.1 * maxdmg) ? TextFormatting.DARK_GREEN : (dmg < (int)(0.25 * maxdmg) ? TextFormatting.GREEN : (dmg < (int)(0.5 * maxdmg) ? TextFormatting.GOLD : (dmg < (int)(0.75 * maxdmg) ? TextFormatting.RED : (dmg < (int)(1.0 * maxdmg) ? TextFormatting.DARK_RED : TextFormatting.DARK_GREEN))))).toString() + dmg, ev.getItemStack().func_77958_k() + 1}), TextFormatting.YELLOW));
                }
            }
            if (compound != null && compound.func_186856_d() != 0) {
                if (ev.getItemStack().func_77978_p().func_74764_b("RepairCost")) {
                    dmg = ev.getItemStack().func_77978_p().func_74762_e("RepairCost");
                    maxdmg = 31.0;
                    ev.getToolTip().add(ModdedCommand.createText("RepairCost: ", TextFormatting.YELLOW).func_150257_a(ModdedCommand.createText(String.valueOf(dmg), dmg < (int)(0.1 * maxdmg) ? TextFormatting.DARK_GREEN : (dmg < (int)(0.25 * maxdmg) ? TextFormatting.GREEN : (dmg < (int)(0.5 * maxdmg) ? TextFormatting.GOLD : (dmg < (int)(0.75 * maxdmg) ? TextFormatting.RED : (dmg < (int)(1.0 * maxdmg) ? TextFormatting.DARK_RED : TextFormatting.DARK_GREEN)))))));
                }
                ITextComponent tags = ModdedCommand.createText(I18n.func_135052_a((String)"gui.act.tags", (Object[])new Object[0]) + "(" + compound.func_186856_d() + "): ", TextFormatting.GOLD);
                int count = 0;
                for (String tag : compound.func_150296_c()) {
                    if (count != 0) {
                        tags.func_150257_a(ModdedCommand.createText(", ", TextFormatting.GOLD));
                    }
                    tags.func_150257_a(ModdedCommand.createText("" + tag, TextFormatting.YELLOW));
                    ++count;
                }
                ev.getToolTip().add(tags);
            }
        }
        if (!(mc.field_71462_r instanceof GuiGiver) && !(mc.field_71462_r instanceof GuiModifier) && InputMappings.func_197956_a((int)340)) {
            if (giver.getKey().func_197937_c() != 0) {
                if (InputMappings.func_197956_a((int)giver.getKey().func_197937_c())) {
                    mc.func_147108_a((GuiScreen)new GuiGiver(mc.field_71462_r, ev.getItemStack()));
                }
                ev.getToolTip().add(ModdedCommand.createText("[", TextFormatting.GOLD).func_150257_a(ModdedCommand.createText(giver.getKey().func_197936_a(), TextFormatting.YELLOW)).func_150257_a(ModdedCommand.createText("] ", TextFormatting.GOLD)).func_150257_a(ModdedCommand.createText(I18n.func_135052_a((String)"cmd.act.opengiver", (Object[])new Object[0]), TextFormatting.YELLOW)));
            }
            if (menu.getKey().func_197937_c() != 0) {
                if (InputMappings.func_197956_a((int)menu.getKey().func_197937_c())) {
                    ACTMod.getCustomItems().add(ItemUtils.getGiveCode(ev.getItemStack()));
                    mc.func_147108_a((GuiScreen)new GuiMenu(mc.field_71462_r));
                }
                ev.getToolTip().add(new TextComponentString("[").func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)).func_150258_a(menu.getKey().func_197936_a()).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)).func_150258_a("] ").func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)).func_150258_a(I18n.func_135052_a((String)"gui.act.save", (Object[])new Object[0])).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
            }
        }
        if (!InputMappings.func_197956_a((int)340)) {
            ev.getToolTip().add(new TextComponentString("SHIFT").func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)).func_150258_a(" " + I18n.func_135052_a((String)"gui.act.shift", (Object[])new Object[0])).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)));
        }
    }

    private static /* synthetic */ void lambda$onChatMessage$37(ITextComponent error, Style style) {
        style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, error));
    }

    static {
        templates = new ArrayList<ItemStack>();
        attributes = new HashSet();
        stringModifier = new HashMap<String, Map<String, Consumer<StringModifier>>>();
        dispatcher = new CommandDispatcher();
        commandSet = new HashSet<String>();
    }

    public static enum ACTState {
        RELEASE(null),
        BETA(TextFormatting.GOLD),
        ALPHA(TextFormatting.DARK_RED);

        private TextFormatting color;

        private ACTState(TextFormatting color) {
            this.color = color;
        }

        public TextFormatting getColor() {
            return this.color;
        }

        public boolean isShow() {
            return this.color != null;
        }
    }
}

