/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui.modifier;

import fr.atesab.act.gui.modifier.GuiModifier;
import fr.atesab.act.utils.GuiUtils;
import fr.atesab.act.utils.ItemUtils;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;

public class GuiHeadModifier
extends GuiModifier<ItemStack> {
    private ItemStack stack;
    private GuiTextField name;
    private GuiTextField uuid;
    private GuiTextField link;
    private GuiButton save;
    private GuiButton loadName;
    private GuiButton loadLink;
    private Thread saveThread = null;
    private AtomicReference<String> errType = new AtomicReference<Object>(null);
    private AtomicReference<String> err = new AtomicReference<Object>(null);

    public GuiHeadModifier(GuiScreen parent, Consumer<ItemStack> setter, ItemStack stack) {
        super(parent, setter);
        this.stack = stack.func_77946_l();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        boolean flagName;
        this.func_146276_q_();
        ArrayList<String> err = new ArrayList<String>();
        boolean flagLink = (this.link.func_146179_b().isEmpty() || !this.link.func_146179_b().matches("http://textures.minecraft.net/texture/[a-zA-Z0-9]+")) && !this.link.func_146179_b().isEmpty();
        boolean flagUuid = (this.uuid.func_146179_b().isEmpty() || !this.uuid.func_146179_b().matches("[0-9A-Fa-f]+-[0-9A-Fa-f]+-[0-9A-Fa-f]+-[0-9A-Fa-f]+-[0-9A-Fa-f]+")) && !this.uuid.func_146179_b().isEmpty();
        boolean bl = flagName = (this.name.func_146179_b().isEmpty() || !this.name.func_146179_b().matches("([0-9A-Za-z_]|(-))+")) && !this.name.func_146179_b().isEmpty();
        if (flagLink) {
            err.add(I18n.func_135052_a((String)"gui.act.modifier.head.link.warning", (Object[])new Object[0]));
        }
        if (flagUuid) {
            err.add(I18n.func_135052_a((String)"gui.act.modifier.head.uuid.warning", (Object[])new Object[0]));
        }
        if (flagName) {
            err.add(I18n.func_135052_a((String)"gui.act.modifier.head.name.warning", (Object[])new Object[0]));
        }
        if (this.err.get() != null) {
            err.add(this.err.get());
        }
        if (this.errType.get() != null) {
            err.add(this.errType.get() + ": ");
        }
        for (int i = 0; i < err.size(); ++i) {
            GuiUtils.drawCenterString(this.field_146289_q, (String)err.get(i), this.field_146294_l / 2, this.name.field_146210_g - 2 - (this.field_146289_q.field_78288_b + 1) * (i + 1), Color.RED.getRGB());
        }
        this.field_146289_q.func_211126_b(I18n.func_135052_a((String)"gui.act.config.name", (Object[])new Object[0]) + " : ", (float)(this.field_146294_l / 2 - 178), (float)(this.name.field_146210_g + 10 - this.field_146289_q.field_78288_b / 2), (flagName ? Color.RED : Color.WHITE).getRGB());
        this.field_146289_q.func_211126_b(I18n.func_135052_a((String)"gui.act.uuid", (Object[])new Object[0]) + " : ", (float)(this.field_146294_l / 2 - 178), (float)(this.uuid.field_146210_g + 10 - this.field_146289_q.field_78288_b / 2), (flagUuid ? Color.RED : Color.WHITE).getRGB());
        this.field_146289_q.func_211126_b(I18n.func_135052_a((String)"gui.act.link", (Object[])new Object[0]) + " : ", (float)(this.field_146294_l / 2 - 178), (float)(this.link.field_146210_g + 10 - this.field_146289_q.field_78288_b / 2), (flagLink ? Color.RED : Color.WHITE).getRGB());
        this.name.func_195608_a(mouseX, mouseY, partialTicks);
        this.uuid.func_195608_a(mouseX, mouseY, partialTicks);
        this.link.func_195608_a(mouseX, mouseY, partialTicks);
        GuiUtils.drawItemStack(this.field_146296_j, this.field_73735_i, this, this.stack, this.uuid.field_146209_f + this.uuid.field_146218_h + 10, this.uuid.field_146210_g + this.uuid.field_146219_i / 2 - 8);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (GuiUtils.isHover(this.uuid.field_146209_f + this.uuid.field_146218_h + 10, this.uuid.field_146210_g + this.uuid.field_146219_i / 2 - 8, 16, 16, mouseX, mouseY)) {
            this.func_146285_a(this.stack, mouseX, mouseY);
        }
    }

    public void func_73866_w_() {
        int l = Math.max(this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"gui.act.config.name", (Object[])new Object[0]) + " : "), Math.max(this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"gui.act.uuid", (Object[])new Object[0]) + " : "), this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"gui.act.link", (Object[])new Object[0]) + " : "))) + 3;
        this.name = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 178 + l, this.field_146295_m / 2 - 61, 356 - l, 16);
        this.uuid = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 178 + l, this.field_146295_m / 2 - 40, 356 - l, 16);
        this.link = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 178 + l, this.field_146295_m / 2 - 19, 356 - l, 16);
        this.name.func_146203_f(16);
        this.link.func_146203_f(Integer.MAX_VALUE);
        this.uuid.func_146203_f(Integer.MAX_VALUE);
        this.func_189646_b(new GuiButton(2, this.field_146294_l / 2 - 180, this.field_146295_m / 2, 180, 20, I18n.func_135052_a((String)"gui.act.modifier.head.me", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiHeadModifier.this.name.func_146180_a(GuiHeadModifier.this.field_146297_k.func_110432_I().func_111285_a());
                super.func_194829_a(mouseX, mouseY);
            }
        });
        this.save = new GuiButton(5, this.field_146294_l / 2 + 1, this.field_146295_m / 2, 179, 20, I18n.func_135052_a((String)"gui.act.modifier.head.saveSkin", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                if (GuiHeadModifier.this.saveThread == null || !GuiHeadModifier.this.saveThread.isAlive()) {
                    (GuiHeadModifier.this.saveThread = new Thread(() -> {
                        JFileChooser fileChooser = new JFileChooser();
                        fileChooser.setFileFilter(new FileFilter(){

                            @Override
                            public boolean accept(File f) {
                                return f.isDirectory() || f.getName().endsWith(".png");
                            }

                            @Override
                            public String getDescription() {
                                return "skin (*.png)";
                            }
                        });
                        fileChooser.setSelectedFile(new File(GuiHeadModifier.this.name.func_146179_b().isEmpty() ? "skin.png" : GuiHeadModifier.this.name.func_146179_b() + ".png"));
                        if (fileChooser.showDialog(null, I18n.func_135052_a((String)"gui.act.save", (Object[])new Object[0])) == 0) {
                            try {
                                GuiHeadModifier.this.err.set(TextFormatting.GOLD + I18n.func_135052_a((String)"gui.act.modifier.head.loading", (Object[])new Object[0]) + "...");
                                URL url = new URL(GuiHeadModifier.this.link.func_146179_b());
                                InputStream stream = url.openStream();
                                byte[] buffer = new byte[stream.available()];
                                stream.read(buffer);
                                File f = fileChooser.getSelectedFile();
                                FileOutputStream writer = new FileOutputStream(f);
                                ((OutputStream)writer).write(buffer);
                                ((OutputStream)writer).close();
                                GuiHeadModifier.this.errType.set(TextFormatting.GREEN + I18n.func_135052_a((String)"gui.act.modifier.head.fileSaved", (Object[])new Object[0]));
                                String s = f.toString();
                                if (s.length() > 50) {
                                    s = s.substring(0, 50) + "...";
                                }
                                GuiHeadModifier.this.err.set(TextFormatting.GREEN + s);
                            }
                            catch (Exception e) {
                                GuiHeadModifier.this.errType.set(e instanceof FileNotFoundException ? I18n.func_135052_a((String)"gui.act.modifier.head.fileNotFound", (Object[])new Object[0]) : e.getClass().getSimpleName());
                                String s = e.getMessage();
                                if (s.length() > 50) {
                                    s = s.substring(0, 50) + "...";
                                }
                                GuiHeadModifier.this.err.set(s);
                            }
                        }
                    })).start();
                }
                super.func_194829_a(mouseX, mouseY);
            }
        };
        this.func_189646_b(this.save);
        this.loadName = new GuiButton(3, this.field_146294_l / 2 - 180, this.field_146295_m / 2 + 21, 180, 20, I18n.func_135052_a((String)"gui.act.modifier.head.load.name", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                try {
                    GuiHeadModifier.this.err.set(TextFormatting.GOLD + I18n.func_135052_a((String)"gui.act.modifier.head.loading", (Object[])new Object[0]) + "...");
                    ItemUtils.getHead(GuiHeadModifier.this.stack, GuiHeadModifier.this.name.func_146179_b());
                    GuiHeadModifier.this.loadHead();
                }
                catch (Exception e) {
                    GuiHeadModifier.this.errType.set(e.getClass().getSimpleName());
                    String s = e.getMessage();
                    if (s.length() > 50) {
                        s = s.substring(0, 50) + "...";
                    }
                    GuiHeadModifier.this.err.set(s);
                }
                super.func_194829_a(mouseX, mouseY);
            }
        };
        this.func_189646_b(this.loadName);
        this.loadLink = new GuiButton(4, this.field_146294_l / 2 + 1, this.field_146295_m / 2 + 21, 179, 20, I18n.func_135052_a((String)"gui.act.modifier.head.load.link", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiHeadModifier.this.err.set(TextFormatting.GOLD + I18n.func_135052_a((String)"gui.act.modifier.head.loading", (Object[])new Object[0]) + "...");
                ItemUtils.getHead(GuiHeadModifier.this.stack, GuiHeadModifier.this.uuid.func_146179_b(), GuiHeadModifier.this.link.func_146179_b(), GuiHeadModifier.this.name.func_146179_b().isEmpty() ? null : GuiHeadModifier.this.name.func_146179_b());
                GuiHeadModifier.this.loadHead();
                super.func_194829_a(mouseX, mouseY);
            }
        };
        this.func_189646_b(this.loadLink);
        if (this.setter != null) {
            this.func_189646_b(new GuiButton(1, this.field_146294_l / 2 - 180, this.field_146295_m / 2 + 42, 180, 20, I18n.func_135052_a((String)"gui.act.cancel", (Object[])new Object[0])){

                public void func_194829_a(double mouseX, double mouseY) {
                    GuiHeadModifier.this.field_146297_k.func_147108_a(GuiHeadModifier.this.parent);
                    super.func_194829_a(mouseX, mouseY);
                }
            });
        }
        this.func_189646_b(new GuiButton(0, this.field_146294_l / 2 + 1, this.field_146295_m / 2 + 42, 179, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiHeadModifier.this.set(GuiHeadModifier.this.stack);
                GuiHeadModifier.this.field_146297_k.func_147108_a(GuiHeadModifier.this.parent);
                super.func_194829_a(mouseX, mouseY);
            }
        });
        this.loadHead();
        super.func_73866_w_();
    }

    public boolean charTyped(char key, int modifiers) {
        return this.link.charTyped(key, modifiers) || this.name.charTyped(key, modifiers) || this.uuid.charTyped(key, modifiers) || super.charTyped(key, modifiers);
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        return this.link.keyPressed(key, scanCode, modifiers) || this.name.keyPressed(key, scanCode, modifiers) || this.uuid.keyPressed(key, scanCode, modifiers) || super.keyPressed(key, scanCode, modifiers);
    }

    private void loadHead() {
        NBTTagCompound tag = this.stack.func_190925_c("SkullOwner");
        if (tag.func_150297_b("Name", 8)) {
            this.name.func_146180_a(tag.func_74779_i("Name"));
        }
        if (tag.func_150297_b("Id", 8)) {
            this.uuid.func_146180_a(tag.func_74779_i("Id"));
            if (tag.func_150297_b("Properties", 10) && tag.func_74775_l("Properties").func_150297_b("textures", 9)) {
                NBTTagList list = tag.func_74775_l("Properties").func_150295_c("textures", 10);
                for (int i = 0; i < list.size(); ++i) {
                    NBTTagCompound text = list.func_150305_b(i);
                    if (!text.func_150297_b("Value", 8)) continue;
                    try {
                        String s = new String(Base64.getDecoder().decode(text.func_74779_i("Value")));
                        NBTTagCompound texCompound = JsonToNBT.func_180713_a((String)s);
                        if (texCompound.func_150297_b("profileName", 8)) {
                            this.name.func_146180_a(texCompound.func_74779_i("profileName"));
                        }
                        if (!texCompound.func_150297_b("textures", 10) || !texCompound.func_74775_l("textures").func_150297_b("SKIN", 10) || !texCompound.func_74775_l("textures").func_74775_l("SKIN").func_150297_b("url", 8)) continue;
                        this.link.func_146180_a(texCompound.func_74775_l("textures").func_74775_l("SKIN").func_74779_i("url"));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        this.err.set(null);
        this.errType.set(null);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.link.mouseClicked(mouseX, mouseY, mouseButton);
        this.uuid.mouseClicked(mouseX, mouseY, mouseButton);
        this.name.mouseClicked(mouseX, mouseY, mouseButton);
        if (GuiUtils.isHover(this.link, (int)mouseX, (int)mouseY) && mouseButton == 1) {
            this.link.func_146180_a("");
        }
        if (GuiUtils.isHover(this.uuid, (int)mouseX, (int)mouseY) && mouseButton == 1) {
            this.uuid.func_146180_a("");
        }
        if (GuiUtils.isHover(this.name, (int)mouseX, (int)mouseY) && mouseButton == 1) {
            this.name.func_146180_a("");
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void func_73876_c() {
        this.name.func_146178_a();
        this.uuid.func_146178_a();
        this.name.func_146178_a();
        this.loadName.field_146124_l = !this.name.func_146179_b().isEmpty();
        this.loadLink.field_146124_l = !this.uuid.func_146179_b().isEmpty() && !this.link.func_146179_b().isEmpty();
        this.save.field_146124_l = !this.link.func_146179_b().isEmpty();
        super.func_73876_c();
    }
}

