/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui.modifier;

import fr.atesab.act.gui.modifier.GuiBooleanButton;
import fr.atesab.act.gui.modifier.GuiColorModifier;
import fr.atesab.act.gui.modifier.GuiListModifier;
import fr.atesab.act.gui.selector.GuiButtonListSelector;
import fr.atesab.act.utils.GuiUtils;
import fr.atesab.act.utils.ItemUtils;
import fr.atesab.act.utils.Tuple;
import java.awt.Color;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.util.registry.IRegistry;

public class GuiPotionModifier
extends GuiListModifier<ItemUtils.PotionInformation> {
    private int customColor = -1;
    private PotionType main;
    private final Supplier<GuiListModifier.ListElement> supplier = () -> new CustomPotionListElement(this, new PotionEffect((Potion)IRegistry.field_212631_t.func_148754_a(1)));

    public GuiPotionModifier(GuiScreen parent, Consumer<ItemUtils.PotionInformation> setter, ItemUtils.PotionInformation info) {
        super(parent, new ArrayList<GuiListModifier.ListElement>(), setter, new Tuple[0]);
        this.customColor = info.getCustomColor();
        this.main = info.getMain();
        this.elements.add(new MainPotionListElement(this));
        info.getCustomEffects().forEach(t -> this.elements.add(new CustomPotionListElement(this, (PotionEffect)t)));
        this.elements.add(new GuiListModifier.AddElementList(this, this.supplier));
    }

    @Override
    protected ItemUtils.PotionInformation get() {
        ArrayList<PotionEffect> customEffects = new ArrayList<PotionEffect>();
        this.elements.stream().filter(le -> le instanceof CustomPotionListElement).map(le -> (CustomPotionListElement)le).forEach(cpl -> customEffects.add(cpl.getEffect()));
        return new ItemUtils.PotionInformation(this.customColor, this.main, customEffects);
    }

    private static class MainPotionListElement
    extends GuiListModifier.ListElement {
        private GuiPotionModifier parent;
        private GuiButton type;

        private static String getPotionName(PotionType pot) {
            String name = pot.func_185174_b("");
            return name + (pot.getRegistryName().toString().contains("long_") ? " (" + I18n.func_135052_a((String)"gui.act.modifier.meta.potion.long", (Object[])new Object[0]) + ")" : (pot.getRegistryName().toString().contains("strong_") ? " II" : ""));
        }

        public MainPotionListElement(final GuiPotionModifier parent) {
            super(400, 29);
            this.parent = parent;
            this.buttonList.add(new GuiButton(0, 0, 0, I18n.func_135052_a((String)"gui.act.modifier.meta.setColor", (Object[])new Object[0])){

                public void func_194829_a(double mouseX, double mouseY) {
                    mc.func_147108_a((GuiScreen)new GuiColorModifier(parent, i -> parent.customColor = i, parent.customColor, -1));
                    super.func_194829_a(mouseX, mouseY);
                }
            });
            this.type = new GuiButton(1, 201, 0, 199, 20, ""){

                public void func_194829_a(double mouseX, double mouseY) {
                    ArrayList pots = new ArrayList();
                    IRegistry.field_212621_j.forEach(type -> pots.add(new Tuple<String, PotionType>(MainPotionListElement.getPotionName(type), (PotionType)type)));
                    mc.func_147108_a(new GuiButtonListSelector<PotionType>(parent, pots, pot -> {
                        parent.main = pot;
                        this.defineButton();
                        return null;
                    }));
                    super.func_194829_a(mouseX, mouseY);
                }
            };
            this.buttonList.add(this.type);
            this.defineButton();
        }

        private void defineButton() {
            this.type.field_146126_j = I18n.func_135052_a((String)"gui.act.modifier.meta.potion.type", (Object[])new Object[0]) + " (" + MainPotionListElement.getPotionName(this.parent.main) + ")";
        }
    }

    private static class CustomPotionListElement
    extends GuiListModifier.ListElement {
        private GuiTextField duration;
        private GuiTextField amplifier;
        private Potion potion;
        private int durationTime;
        private int amplifierValue;
        private boolean ambient;
        private boolean showParticles;
        private boolean showIcon;
        private boolean errDur = false;
        private boolean errAmp = false;
        private GuiButton type;

        public CustomPotionListElement(final GuiPotionModifier parent, PotionEffect potionEffect) {
            super(400, 50);
            int l = 5 + Math.max(this.fontRenderer.func_78256_a(I18n.func_135052_a((String)"gui.act.modifier.meta.potion.duration", (Object[])new Object[0]) + " : "), this.fontRenderer.func_78256_a(I18n.func_135052_a((String)"gui.act.modifier.meta.potion.amplifier", (Object[])new Object[0]) + " : "));
            this.potion = potionEffect.func_188419_a();
            this.durationTime = potionEffect.func_76459_b();
            this.amplifierValue = potionEffect.func_76458_c();
            this.ambient = potionEffect.func_82720_e();
            this.showParticles = potionEffect.func_188418_e();
            this.showIcon = potionEffect.func_205348_f();
            this.duration = new GuiTextField(0, this.fontRenderer, l, 1, 150 - l, 18);
            this.duration.func_146180_a(String.valueOf(this.durationTime));
            this.amplifier = new GuiTextField(0, this.fontRenderer, l, 22, 150 - l, 18);
            this.amplifier.func_146180_a(String.valueOf(this.amplifierValue));
            this.type = new GuiButton(0, 153, 0, I18n.func_135052_a((String)"gui.act.modifier.meta.potion.type", (Object[])new Object[0])){

                public void func_194829_a(double mouseX, double mouseY) {
                    ArrayList pots = new ArrayList();
                    IRegistry.field_212631_t.forEach(pot -> pots.add(new Tuple<String, Potion>(I18n.func_135052_a((String)pot.func_76393_a(), (Object[])new Object[0]), (Potion)pot)));
                    mc.func_147108_a(new GuiButtonListSelector<Potion>(parent, pots, pot -> {
                        potion = pot;
                        this.setButtonText();
                        return null;
                    }));
                    super.func_194829_a(mouseX, mouseY);
                }
            };
            this.buttonList.add(this.type);
            this.buttonList.add(new GuiBooleanButton(1, 153, 21, 100, 20, I18n.func_135052_a((String)"gui.act.modifier.meta.potion.ambient", (Object[])new Object[0]), b -> {
                this.ambient = b;
            }, () -> this.ambient));
            this.buttonList.add(new GuiBooleanButton(2, 255, 21, 99, 20, I18n.func_135052_a((String)"gui.act.modifier.meta.potion.showParticles", (Object[])new Object[0]), b -> {
                this.showParticles = b;
            }, () -> this.showParticles));
            this.buttonList.add(new GuiListModifier.RemoveElementButton(parent, 355, 0, 20, 20, this));
            this.buttonList.add(new GuiListModifier.AddElementButton(parent, 377, 0, 20, 20, this, parent.supplier));
            this.buttonList.add(new GuiListModifier.AddElementButton(parent, 355, 21, 43, 20, I18n.func_135052_a((String)"gui.act.give.copy", (Object[])new Object[0]), (GuiListModifier.ListElement)this, () -> new CustomPotionListElement(parent, this.getEffect())));
            this.setButtonText();
        }

        @Override
        public void draw(int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
            GuiUtils.drawRelative(this.amplifier, offsetX, offsetY, mouseY, mouseY, partialTicks);
            GuiUtils.drawRelative(this.duration, offsetX, offsetY, mouseY, mouseY, partialTicks);
            GuiUtils.drawRightString(this.fontRenderer, I18n.func_135052_a((String)"gui.act.modifier.meta.potion.duration", (Object[])new Object[0]) + " : ", this.duration, (this.errDur ? Color.RED : Color.WHITE).getRGB(), offsetX, offsetY);
            GuiUtils.drawRightString(this.fontRenderer, I18n.func_135052_a((String)"gui.act.modifier.meta.potion.amplifier", (Object[])new Object[0]) + " : ", this.amplifier, (this.errAmp ? Color.RED : Color.WHITE).getRGB(), offsetX, offsetY);
            super.draw(offsetX, offsetY, mouseX, mouseY, partialTicks);
        }

        public PotionEffect getEffect() {
            return new PotionEffect(this.potion, this.durationTime, this.amplifierValue, this.ambient, this.showParticles, this.showIcon);
        }

        @Override
        public void init() {
            this.amplifier.func_146195_b(false);
            this.duration.func_146195_b(false);
            super.init();
        }

        @Override
        public boolean isFocused() {
            return this.amplifier.func_146206_l() || this.duration.func_146206_l();
        }

        @Override
        public boolean charTyped(char key, int modifiers) {
            return this.amplifier.charTyped(key, modifiers) || this.duration.charTyped(key, modifiers) || super.charTyped(key, modifiers);
        }

        @Override
        public boolean keyPressed(int key, int scanCode, int modifiers) {
            return this.amplifier.keyPressed(key, scanCode, modifiers) || this.duration.keyPressed(key, scanCode, modifiers) || super.keyPressed(key, scanCode, modifiers);
        }

        @Override
        public boolean match(String search) {
            return I18n.func_135052_a((String)this.potion.func_76393_a(), (Object[])new Object[0]).toLowerCase().contains(search.toLowerCase());
        }

        @Override
        public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
            this.amplifier.mouseClicked((double)mouseX, (double)mouseY, mouseButton);
            this.duration.mouseClicked((double)mouseX, (double)mouseY, mouseButton);
            super.mouseClicked(mouseX, mouseY, mouseButton);
        }

        private void setButtonText() {
            this.type.field_146126_j = I18n.func_135052_a((String)"gui.act.modifier.meta.potion.type", (Object[])new Object[0]) + " (" + I18n.func_135052_a((String)this.potion.func_76393_a(), (Object[])new Object[0]) + ")";
        }

        @Override
        public void update() {
            this.amplifier.func_146178_a();
            this.duration.func_146178_a();
            try {
                this.durationTime = Integer.valueOf(this.duration.func_146179_b());
                this.errDur = false;
            }
            catch (Exception e) {
                this.errDur = true;
            }
            try {
                int i = Integer.valueOf(this.amplifier.func_146179_b());
                this.errAmp = i < -128 || i > 127;
                if (!this.errAmp) {
                    this.amplifierValue = i;
                }
            }
            catch (Exception e) {
                this.errAmp = true;
            }
            super.update();
        }
    }
}

