/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.utils;

import fr.atesab.act.utils.Tuple;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class GuiUtils {
    public static void addToClipboard(String text) {
        StringSelection select = new StringSelection(text);
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        cb.setContents(select, select);
    }

    public static void displayScreen(GuiScreen screen) {
        GuiUtils.displayScreen(screen, false);
    }

    public static void displayScreen(GuiScreen screen, boolean forceDelay) {
        Minecraft mc = Minecraft.func_71410_x();
        if (forceDelay || mc.field_71462_r instanceof GuiChat) {
            new DelayScreen(screen, 20L);
        } else {
            mc.func_147108_a(screen);
        }
    }

    public static void drawCenterString(FontRenderer fontRenderer, String text, int x, int y, int color) {
        GuiUtils.drawCenterString(fontRenderer, text, x, y, color, fontRenderer.field_78288_b);
    }

    public static void drawCenterString(FontRenderer fontRenderer, String text, int x, int y, int color, int height) {
        GuiUtils.drawString(fontRenderer, text, x - fontRenderer.func_78256_a(text) / 2, y, color, height);
    }

    public static void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor, float zLevel) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)right, (double)top, (double)zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)top, (double)zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)bottom, (double)zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)bottom, (double)zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawGradientRect(int left, int top, int right, int bottom, int leftColor, int topColor, int rightColor, int bottomColor, float zLevel) {
        float f = (float)(leftColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(leftColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(leftColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(leftColor & 0xFF) / 255.0f;
        float f4 = (float)(topColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(topColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(topColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(topColor & 0xFF) / 255.0f;
        float f8 = (float)(rightColor >> 24 & 0xFF) / 255.0f;
        float f9 = (float)(rightColor >> 16 & 0xFF) / 255.0f;
        float f10 = (float)(rightColor >> 8 & 0xFF) / 255.0f;
        float f11 = (float)(rightColor & 0xFF) / 255.0f;
        float f12 = (float)(bottomColor >> 24 & 0xFF) / 255.0f;
        float f13 = (float)(bottomColor >> 16 & 0xFF) / 255.0f;
        float f14 = (float)(bottomColor >> 8 & 0xFF) / 255.0f;
        float f15 = (float)(bottomColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)right, (double)top, (double)zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)top, (double)zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)bottom, (double)zLevel).func_181666_a(f9, f10, f11, f8).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)bottom, (double)zLevel).func_181666_a(f13, f14, f15, f12).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawItemStack(ItemRenderer itemRender, float zLevel, GuiScreen gui, ItemStack itemstack, int x, int y) {
        if (itemstack == null || itemstack.func_190926_b()) {
            return;
        }
        GlStateManager.func_179126_j();
        itemRender.func_180450_b(itemstack, x, y);
        itemRender.func_180453_a(gui.field_146297_k.field_71466_p, itemstack, x, y, null);
        GlStateManager.func_179084_k();
        GlStateManager.func_179140_f();
    }

    public static void drawRelative(GuiTextField field, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        field.field_146209_f += offsetX;
        field.field_146210_g += offsetY;
        field.func_195608_a(mouseX, mouseY, partialTicks);
        field.field_146209_f -= offsetX;
        field.field_146210_g -= offsetY;
    }

    public static void drawRelative(Minecraft mc, GuiButton button, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        button.field_146128_h += offsetX;
        button.field_146129_i += offsetY;
        button.func_194828_a(mouseX + offsetX, mouseY + offsetY, partialTicks);
        button.field_146128_h -= offsetX;
        button.field_146129_i -= offsetY;
    }

    public static void drawRightString(FontRenderer fontRenderer, String text, GuiTextField field, int color) {
        GuiUtils.drawRightString(fontRenderer, text, field.field_146209_f, field.field_146210_g, color, field.field_146219_i);
    }

    public static void drawRightString(FontRenderer fontRenderer, String text, GuiTextField field, int color, int offsetX, int offsetY) {
        GuiUtils.drawRightString(fontRenderer, text, field.field_146209_f + offsetX, field.field_146210_g + offsetY, color, field.field_146219_i);
    }

    public static void drawRightString(FontRenderer fontRenderer, String text, int x, int y, int color) {
        GuiUtils.drawCenterString(fontRenderer, text, x, y, color, fontRenderer.field_78288_b);
    }

    public static void drawRightString(FontRenderer fontRenderer, String text, int x, int y, int color, int height) {
        GuiUtils.drawString(fontRenderer, text, x - fontRenderer.func_78256_a(text), y, color, height);
    }

    public static void drawString(FontRenderer fontRenderer, String text, int x, int y, int color, int height) {
        fontRenderer.func_211126_b(text, (float)x, (float)(y + height / 2 - fontRenderer.field_78288_b / 2), color);
    }

    public static Tuple<Integer, Integer> getRelativeBoxPos(int x, int y, int width, int height, int parentWidth, int parentHeight) {
        if (x + width > parentWidth) {
            if ((x -= width + 5) < 0) {
                x = 0;
            }
        } else {
            x += 12;
        }
        if (y + height > parentHeight) {
            if ((y -= height + 5) < 0) {
                y = 0;
            }
        } else {
            y += 12;
        }
        return new Tuple<Integer, Integer>(x, y);
    }

    public static void drawTextBox(FontRenderer fontRenderer, int x, int y, int parentWidth, int parentHeight, float zLevel, String ... args) {
        List<String> text = Arrays.asList(args);
        int width = text.size() == 0 ? 0 : text.stream().mapToInt(arg_0 -> ((FontRenderer)fontRenderer).func_78256_a(arg_0)).max().getAsInt();
        int height = text.size() * (1 + fontRenderer.field_78288_b);
        Tuple<Integer, Integer> pos = GuiUtils.getRelativeBoxPos(x, y, width, height, parentWidth, parentHeight);
        GuiUtils.drawBox((Integer)pos.a, (Integer)pos.b, width, height, zLevel);
        text.forEach(l -> {
            fontRenderer.func_211126_b(l, (float)((Integer)pos.a).intValue(), (float)((Integer)pos.b).intValue(), -1);
            pos.b = (Integer)pos.b + (1 + fontRenderer.field_78288_b);
        });
    }

    public static void drawBox(int x, int y, int width, int height, float zLevel) {
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GuiUtils.drawGradientRect(x - 3, y - 4, x + width + 3, y - 3, -267386864, -267386864, zLevel -= 50.0f);
        GuiUtils.drawGradientRect(x - 3, y + height + 3, x + width + 3, y + height + 4, -267386864, -267386864, zLevel);
        GuiUtils.drawGradientRect(x - 3, y - 3, x + width + 3, y + height + 3, -267386864, -267386864, zLevel);
        GuiUtils.drawGradientRect(x - 4, y - 3, x - 3, y + height + 3, -267386864, -267386864, zLevel);
        GuiUtils.drawGradientRect(x + width + 3, y - 3, x + width + 4, y + height + 3, -267386864, -267386864, zLevel);
        GuiUtils.drawGradientRect(x - 3, y - 3 + 1, x - 3 + 1, y + height + 3 - 1, 0x505000FF, 1344798847, zLevel);
        GuiUtils.drawGradientRect(x + width + 2, y - 3 + 1, x + width + 3, y + height + 3 - 1, 0x505000FF, 1344798847, zLevel);
        GuiUtils.drawGradientRect(x - 3, y - 3, x + width + 3, y - 3 + 1, 0x505000FF, 0x505000FF, zLevel);
        GuiUtils.drawGradientRect(x - 3, y + height + 2, x + width + 3, y + height + 3, 1344798847, 1344798847, zLevel);
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
        GlStateManager.func_179091_B();
    }

    public static int getRedGreen(boolean value) {
        return value ? -8913033 : -34953;
    }

    public static boolean isHover(GuiButton button, int mouseX, int mouseY) {
        return GuiUtils.isHover(button.field_146128_h, button.field_146129_i, button.field_146120_f, button.field_146121_g, mouseX, mouseY);
    }

    public static boolean isHover(GuiTextField field, int mouseX, int mouseY) {
        return GuiUtils.isHover(field.field_146209_f, field.field_146210_g, field.field_146218_h, field.field_146219_i, mouseX, mouseY);
    }

    public static boolean isHover(int X, int Y, int sizeX, int sizeY, int mouseX, int mouseY) {
        return mouseX >= X && mouseX <= X + sizeX && mouseY >= Y && mouseY <= Y + sizeY;
    }

    private static class DelayScreen {
        private GuiScreen screen;
        private long delay;

        DelayScreen(GuiScreen screen, long delay) {
            this.screen = screen;
            this.delay = delay;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void onTick(TickEvent ev) {
            if (this.delay < 0L) {
                Minecraft.func_71410_x().func_147108_a(this.screen);
                MinecraftForge.EVENT_BUS.unregister((Object)this);
            } else {
                --this.delay;
            }
        }
    }
}

