/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui;

import fr.atesab.act.ACTMod;
import fr.atesab.act.gui.GuiMenu;
import fr.atesab.act.gui.modifier.GuiItemStackModifier;
import fr.atesab.act.gui.modifier.GuiModifier;
import fr.atesab.act.utils.GuiUtils;
import fr.atesab.act.utils.ItemUtils;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;

public class GuiGiver
extends GuiModifier<String> {
    private Button giveButton;
    private Button saveButton;
    private Button doneButton;
    private TextFieldWidget code;
    private String preText;
    private ItemStack currentItemStack;
    private Consumer<String> setter;
    private boolean deleteButton;

    public GuiGiver(Screen parent) {
        super(parent, "gui.act.give", s -> {});
        if (this.mc.field_71439_g != null) {
            ItemStack mainHand = this.mc.field_71439_g.func_184586_b(Hand.MAIN_HAND);
            this.currentItemStack = mainHand != null ? mainHand : this.mc.field_71439_g.func_184586_b(Hand.OFF_HAND);
            this.preText = ItemUtils.getGiveCode(this.currentItemStack);
        }
    }

    public GuiGiver(Screen parent, ItemStack itemStack) {
        this(parent, itemStack, null, false);
    }

    public GuiGiver(Screen parent, ItemStack itemStack, Consumer<String> setter, boolean deleteButton) {
        super(parent, "gui.act.give", s -> {});
        this.preText = itemStack != null ? ItemUtils.getGiveCode(itemStack) : "";
        this.currentItemStack = itemStack;
        this.setter = setter;
        this.deleteButton = deleteButton;
    }

    public GuiGiver(Screen parent, String preText) {
        this(parent, preText, (String s) -> {}, false);
    }

    public GuiGiver(Screen parent, String preText, Consumer<String> setter, boolean deleteButton) {
        this(parent, preText != null && !preText.isEmpty() ? ItemUtils.getFromGiveCode(preText) : null);
        this.preText = preText;
    }

    @Override
    public boolean isPauseScreen() {
        return this.parent != null && this.parent.isPauseScreen();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.code.render(mouseX, mouseY, partialTicks);
        GuiUtils.drawCenterString(this.font, I18n.func_135052_a((String)"gui.act.give", (Object[])new Object[0]), this.width / 2, this.code.y - 21, Color.ORANGE.getRGB(), 20);
        super.render(mouseX, mouseY, partialTicks);
        if (this.currentItemStack != null) {
            GuiUtils.drawItemStack(this.itemRenderer, this, this.currentItemStack, this.code.x + this.code.getWidth() + 5, this.code.y - 2);
            if (GuiUtils.isHover(this.code.x + this.code.getWidth() + 5, this.code.y, 20, 20, mouseX, mouseY)) {
                this.renderTooltip(this.currentItemStack, mouseX, mouseY);
            }
        }
    }

    public void init() {
        boolean flag2;
        this.code = new TextFieldWidget(this.font, this.width / 2 - 178, this.height / 2 + 2, 356, 16, "");
        this.code.func_146203_f(Integer.MAX_VALUE);
        if (this.preText != null) {
            this.code.func_146180_a(this.preText.replaceAll(String.valueOf('\u00a7'), "&"));
        }
        int s1 = (flag2 = this.deleteButton) ? 120 : 180;
        int s2 = 120;
        this.giveButton = new Button(this.width / 2 - 180, this.height / 2 + 21, s1, 20, I18n.func_135052_a((String)"gui.act.give.give", (Object[])new Object[0]), b -> ItemUtils.give(this.currentItemStack));
        this.addButton((Widget)this.giveButton);
        this.addButton((Widget)new Button(this.width / 2 + s1 - 178, this.height / 2 + 21, s1 - 2, 20, I18n.func_135052_a((String)"gui.act.give.copy", (Object[])new Object[0]), b -> GuiUtils.addToClipboard(this.code.func_146179_b())));
        this.addButton((Widget)new Button(this.width / 2 - 180 + (flag2 ? 2 * s1 + 1 : 0), this.height / 2 + 21 + (flag2 ? 0 : 21), flag2 ? s1 - 1 : s2, 20, I18n.func_135052_a((String)"gui.act.give.editor", (Object[])new Object[0]), b -> this.getMinecraft().func_147108_a((Screen)new GuiItemStackModifier((Screen)this, this.currentItemStack, itemStack -> this.setCurrent((ItemStack)itemStack)))));
        this.doneButton = new Button(this.width / 2 - 179 + 2 * s2, this.height / 2 + 42, s2 - 1, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), b -> {
            if (this.setter != null && this.currentItemStack != null) {
                this.setter.accept(this.code.func_146179_b());
            }
            this.getMinecraft().func_147108_a(this.parent);
        });
        this.addButton((Widget)this.doneButton);
        if (this.setter != null) {
            this.addButton((Widget)new Button(this.width / 2 - 58, this.height / 2 + 42, s2 - 2, 20, I18n.func_135052_a((String)"gui.act.cancel", (Object[])new Object[0]), b -> this.getMinecraft().func_147108_a(this.parent)));
        } else {
            this.saveButton = new Button(this.width / 2 - 58, this.height / 2 + 42, s2 - 2, 20, I18n.func_135052_a((String)"gui.act.save", (Object[])new Object[0]), b -> {
                if (this.parent instanceof GuiMenu) {
                    ((GuiMenu)this.parent).get();
                }
                ACTMod.saveItem(this.code.func_146179_b());
                this.getMinecraft().func_147108_a((Screen)new GuiMenu(this.parent));
            });
            this.addButton((Widget)this.saveButton);
        }
        if (this.deleteButton) {
            this.addButton((Widget)new Button(this.width / 2 - 180, this.height / 2 + 42, s2, 20, I18n.func_135052_a((String)"gui.act.delete", (Object[])new Object[0]), b -> {
                this.setter.accept(null);
                this.getMinecraft().func_147108_a(this.parent);
            }));
        }
        super.init();
    }

    public boolean charTyped(char key, int modifiers) {
        return this.code.charTyped(key, modifiers);
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        return this.code.keyPressed(key, scanCode, modifiers) || super.keyPressed(key, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return this.code.mouseClicked(mouseX, mouseY, mouseButton) || super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    private void setCurrent(ItemStack currentItemStack) {
        this.currentItemStack = currentItemStack;
        this.preText = ItemUtils.getGiveCode(this.currentItemStack);
    }

    public void setCurrentItemStack(ItemStack currentItemStack) {
        this.currentItemStack = currentItemStack;
        this.preText = ItemUtils.getGiveCode(currentItemStack);
    }

    public void setPreText(String preText) {
        this.preText = preText;
        this.currentItemStack = preText != null && !preText.isEmpty() ? ItemUtils.getFromGiveCode(preText) : null;
    }

    public void tick() {
        this.code.func_146178_a();
        this.currentItemStack = ItemUtils.getFromGiveCode(this.code.func_146179_b().replaceAll("&", String.valueOf('\u00a7')));
        this.giveButton.active = this.currentItemStack != null && this.getMinecraft().field_71439_g != null && this.getMinecraft().field_71439_g.func_184812_l_();
        boolean bl = this.doneButton.active = this.setter != null && this.currentItemStack != null || this.setter == null;
        if (this.saveButton != null) {
            this.saveButton.active = this.currentItemStack != null;
        }
        super.tick();
    }
}

