/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui.modifier;

import com.mojang.blaze3d.platform.GlStateManager;
import fr.atesab.act.gui.ColorList;
import fr.atesab.act.gui.modifier.GuiBooleanButton;
import fr.atesab.act.gui.modifier.GuiListModifier;
import fr.atesab.act.gui.modifier.GuiModifier;
import fr.atesab.act.gui.selector.GuiButtonListSelector;
import fr.atesab.act.utils.GuiUtils;
import fr.atesab.act.utils.ItemUtils;
import fr.atesab.act.utils.Tuple;
import java.awt.Color;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.TextFormatting;

public class GuiFireworksModifer
extends GuiListModifier<CompoundNBT> {
    private FireworkMainListElement main;
    private Supplier<GuiListModifier.ListElement> builder = () -> new ExplosionListElement(this, null);

    public GuiFireworksModifer(Screen parent, Consumer<CompoundNBT> setter, CompoundNBT tag) {
        super(parent, "gui.act.modifier.meta.fireworks", new ArrayList<GuiListModifier.ListElement>(), setter, new Tuple[0]);
        this.main = new FireworkMainListElement(tag.func_74764_b("Flight") ? tag.func_74762_e("Flight") : 1);
        this.addListElement(this.main);
        tag.func_150295_c("Explosions", 10).forEach(base -> this.addListElement(new ExplosionListElement(this, (CompoundNBT)base)));
        this.addListElement(new GuiListModifier.AddElementList(this, this.builder));
    }

    @Override
    protected CompoundNBT get() {
        CompoundNBT newTag = new CompoundNBT();
        newTag.func_74768_a("Flight", this.main.value);
        ListNBT explosions = new ListNBT();
        this.getElements().stream().filter(le -> le instanceof ExplosionListElement).forEach(le -> explosions.add((Object)((ExplosionListElement)le).exp.getTag()));
        newTag.func_218657_a("Explosions", (INBT)explosions);
        return newTag;
    }

    public static class GuiExplosionModifier
    extends GuiModifier<ItemUtils.ExplosionInformation> {
        private ItemUtils.ExplosionInformation exp;
        private ColorList colors;
        private ColorList fadeColors;
        private Button type;

        public GuiExplosionModifier(Screen parent, Consumer<ItemUtils.ExplosionInformation> setter, ItemUtils.ExplosionInformation exp) {
            super(parent, "gui.act.modifier.meta.fireworks", setter);
            this.exp = exp.clone();
            this.colors = new ColorList(this, 0, 0, 6, exp.getColors(), I18n.func_135052_a((String)"gui.act.modifier.meta.explosion.color", (Object[])new Object[0]), 24);
            this.fadeColors = new ColorList(this, 0, 0, 6, exp.getFadeColors(), I18n.func_135052_a((String)"gui.act.modifier.meta.explosion.fadeColor", (Object[])new Object[0]), 24);
        }

        private void defineButton() {
            this.type.setMessage(I18n.func_135052_a((String)("item.minecraft.firework_star.shape." + this.exp.getType().func_196068_b()), (Object[])new Object[0]));
        }

        public void init() {
            this.colors.x = this.width / 2;
            this.colors.y = this.height / 2 - 42;
            this.fadeColors.x = this.width / 2 + 100;
            this.fadeColors.y = this.height / 2 - 42;
            this.type = new Button(this.width / 2 - 200, this.height / 2 - 42, 199, 20, I18n.func_135052_a((String)"", (Object[])new Object[0]), b -> {
                ArrayList elements = new ArrayList(FireworkRocketItem.Shape.values().length);
                for (FireworkRocketItem.Shape s2 : FireworkRocketItem.Shape.values()) {
                    elements.add(new Tuple<String, FireworkRocketItem.Shape>(I18n.func_135052_a((String)("item.minecraft.firework_star.shape." + s2.func_196068_b()), (Object[])new Object[0]), s2));
                }
                this.mc.func_147108_a(new GuiButtonListSelector<FireworkRocketItem.Shape>(this, "gui.act.modifier.meta.explosion.shape", elements, s -> {
                    this.exp.type((FireworkRocketItem.Shape)s);
                    this.defineButton();
                    return null;
                }));
            });
            this.addButton((Widget)this.type);
            this.addButton((Widget)new GuiBooleanButton(this.width / 2 - 200, this.height / 2 - 21, 199, 20, I18n.func_135052_a((String)"item.minecraft.firework_star.trail", (Object[])new Object[0]), this.exp::trail, this.exp::isTrail));
            this.addButton((Widget)new GuiBooleanButton(this.width / 2 - 200, this.height / 2, 199, 20, I18n.func_135052_a((String)"item.minecraft.firework_star.flicker", (Object[])new Object[0]), this.exp::flicker, this.exp::isFlicker));
            this.addButton((Widget)new Button(this.width / 2 - 100, this.height / 2 + 21, 99, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), b -> {
                this.set(this.exp.colors(this.colors.getColors()).fadeColors(this.fadeColors.getColors()));
                this.getMinecraft().func_147108_a(this.parent);
            }));
            this.addButton((Widget)new Button(this.width / 2 - 200, this.height / 2 + 21, 99, 20, I18n.func_135052_a((String)"gui.act.cancel", (Object[])new Object[0]), b -> this.getMinecraft().func_147108_a(this.parent)));
            this.defineButton();
            super.init();
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            this.renderBackground();
            this.colors.draw(mouseX, mouseY, this.getZLevel());
            this.fadeColors.draw(mouseX, mouseY, this.getZLevel());
            super.render(mouseX, mouseY, partialTicks);
            this.colors.drawNext(mouseX, mouseY, this.getZLevel());
            this.fadeColors.drawNext(mouseX, mouseY, this.getZLevel());
        }

        public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
            this.colors.mouseClick((int)mouseX, (int)mouseY, mouseButton);
            this.fadeColors.mouseClick((int)mouseX, (int)mouseY, mouseButton);
            return super.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }

    private static class ExplosionListElement
    extends GuiListModifier.ListElement {
        private ItemUtils.ExplosionInformation exp;
        private GuiFireworksModifer parent;

        public ExplosionListElement(GuiFireworksModifer parent, CompoundNBT expData) {
            super(204, 29);
            this.exp = ItemUtils.getExplosionInformation(expData);
            this.parent = parent;
            this.buttonList.add(new Button(0, 0, 100, 20, I18n.func_135052_a((String)"gui.act.modifier.meta.explosion", (Object[])new Object[0]), b -> this.mc.func_147108_a((Screen)new GuiExplosionModifier((Screen)parent, exp -> {
                this.exp = exp;
            }, this.exp))));
            this.buttonList.add(new GuiListModifier.RemoveElementButton(parent, 101, 0, 20, 20, this));
            this.buttonList.add(new GuiListModifier.AddElementButton(parent, 122, 0, 20, 20, this, parent.builder));
            this.buttonList.add(new GuiListModifier.AddElementButton(parent, 143, 0, 60, 20, I18n.func_135052_a((String)"gui.act.give.copy", (Object[])new Object[0]), (GuiListModifier.ListElement)this, () -> new ExplosionListElement(parent, this.exp.getTag())));
        }

        @Override
        public boolean match(String search) {
            String s = search.toLowerCase();
            return I18n.func_135052_a((String)"gui.act.modifier.type", (Object[])new Object[0]).toLowerCase().contains(s) || I18n.func_135052_a((String)("item.minecraft.firework_star.shape." + this.exp.getType().func_196068_b()), (Object[])new Object[0]).toLowerCase().contains(s) || I18n.func_135052_a((String)"item.minecraft.firework_star.trail", (Object[])new Object[0]).toLowerCase().contains(s) || I18n.func_135052_a((String)"item.minecraft.firework_star.flicker", (Object[])new Object[0]).toLowerCase().contains(s) || I18n.func_135052_a((String)"gui.act.modifier.meta.explosion.color", (Object[])new Object[0]).toLowerCase().contains(s) || I18n.func_135052_a((String)"gui.act.modifier.meta.explosion.fadeColor", (Object[])new Object[0]).toLowerCase().contains(s);
        }

        @Override
        public void drawNext(int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
            if (GuiUtils.isHover(0, 0, 200, 20, mouseX, mouseY)) {
                int j;
                int i;
                ArrayList<String> data = new ArrayList<String>();
                String type = I18n.func_135052_a((String)"gui.act.modifier.type", (Object[])new Object[0]) + " : " + TextFormatting.YELLOW + I18n.func_135052_a((String)("item.minecraft.firework_star.shape." + this.exp.getType().func_196068_b()), (Object[])new Object[0]);
                String trail = I18n.func_135052_a((String)"item.minecraft.firework_star.trail", (Object[])new Object[0]);
                String flicker = I18n.func_135052_a((String)"item.minecraft.firework_star.flicker", (Object[])new Object[0]);
                String color = I18n.func_135052_a((String)"gui.act.modifier.meta.explosion.color", (Object[])new Object[0]) + " : ";
                String fadeColor = I18n.func_135052_a((String)"gui.act.modifier.meta.explosion.fadeColor", (Object[])new Object[0]) + " : ";
                data.add(type);
                int width = this.font.func_78256_a(type);
                if (this.exp.isTrail()) {
                    data.add(trail);
                    width = Math.max(width, this.font.func_78256_a(trail));
                }
                if (this.exp.isFlicker()) {
                    data.add(flicker);
                    width = Math.max(width, this.font.func_78256_a(flicker));
                }
                if (this.exp.getColors().length != 0) {
                    data.add(color);
                    this.font.getClass();
                    width = Math.max(width, (9 + 1) * this.exp.getColors().length + this.font.func_78256_a(color));
                }
                if (this.exp.getFadeColors().length != 0) {
                    data.add(fadeColor);
                    this.font.getClass();
                    width = Math.max(width, (9 + 1) * this.exp.getFadeColors().length + this.font.func_78256_a(fadeColor));
                }
                int n = data.size();
                this.font.getClass();
                int height = n * (1 + 9) + 2;
                Tuple<Integer, Integer> pos = GuiUtils.getRelativeBoxPos(mouseX + offsetX, mouseY + offsetY, width += 2, height, this.parent.width, this.parent.height);
                GlStateManager.disableLighting();
                GlStateManager.disableAlphaTest();
                GlStateManager.disableDepthTest();
                GlStateManager.disableFog();
                GuiUtils.drawBox((Integer)pos.a, (Integer)pos.b, width, height, this.parent.getZLevel());
                Tuple<Integer, Integer> tuple = pos;
                Integer n2 = (Integer)tuple.a;
                tuple.a = (Integer)tuple.a + 1;
                Integer n3 = tuple.a;
                tuple = pos;
                tuple.b = (Integer)tuple.b + 2;
                for (i = 0; i < data.size(); ++i) {
                    String string = (String)data.get(i);
                    float f = ((Integer)pos.a).intValue();
                    int n4 = (Integer)pos.b;
                    this.font.getClass();
                    this.font.func_211126_b(string, f, (float)(n4 + i * (9 + 1)), -1);
                }
                if (this.exp.getFadeColors().length != 0) {
                    int x = (Integer)pos.a + this.font.func_78256_a(fadeColor);
                    int n5 = (Integer)pos.b;
                    this.font.getClass();
                    int y = n5 + --i * (9 + 1);
                    for (j = 0; j < this.exp.getFadeColors().length; ++j) {
                        this.font.getClass();
                        this.font.getClass();
                        GuiUtils.drawGradientRect(x, y, x + 9, y + 9, 0xFF000000 | this.exp.getFadeColors()[j], 0xFF000000 | this.exp.getFadeColors()[j], this.parent.getZLevel());
                        this.font.getClass();
                        x += 9 + 1;
                    }
                }
                if (this.exp.getColors().length != 0) {
                    int x = (Integer)pos.a + this.font.func_78256_a(color);
                    int n6 = (Integer)pos.b;
                    this.font.getClass();
                    int y = n6 + --i * (9 + 1);
                    for (j = 0; j < this.exp.getColors().length; ++j) {
                        this.font.getClass();
                        this.font.getClass();
                        GuiUtils.drawGradientRect(x, y, x + 9, y + 9, 0xFF000000 | this.exp.getColors()[j], 0xFF000000 | this.exp.getColors()[j], this.parent.getZLevel());
                        this.font.getClass();
                        x += 9 + 1;
                    }
                }
            }
            super.drawNext(offsetX, offsetY, mouseX, mouseY, partialTicks);
        }
    }

    private static class FireworkMainListElement
    extends GuiListModifier.ListElement {
        private TextFieldWidget flight;
        private int value;
        private boolean err;
        private String title = I18n.func_135052_a((String)"item.minecraft.firework_rocket.flight", (Object[])new Object[0]);

        public FireworkMainListElement(int flight) {
            super(200, 29);
            if (this.title.endsWith(":")) {
                this.title = this.title.substring(0, this.title.length() - 1);
            }
            this.title = this.title + " : ";
            int l = this.font.func_78256_a(this.title + " : ") + 5;
            this.flight = new TextFieldWidget(this.font, l, 2, 196 - l, 16, "");
            this.flight.func_146203_f(6);
            this.flight.func_146180_a("" + flight);
        }

        @Override
        public void init() {
            this.flight.func_146195_b(false);
            super.init();
        }

        @Override
        public boolean isFocused() {
            return this.flight.isFocused();
        }

        @Override
        public void draw(int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
            GuiUtils.drawRelative((Widget)this.flight, offsetX, offsetY, mouseY, mouseY, partialTicks);
            GuiUtils.drawString(this.font, this.title, offsetX, offsetY, (this.err ? Color.RED : Color.WHITE).getRGB(), this.flight.getHeight());
            super.draw(offsetX, offsetY, mouseX, mouseY, partialTicks);
        }

        @Override
        public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
            this.flight.mouseClicked((double)mouseX, (double)mouseY, mouseButton);
            if (GuiUtils.isHover(this.flight, mouseX, mouseY) && mouseButton == 1) {
                this.flight.func_146180_a("");
            }
            super.mouseClicked(mouseX, mouseY, mouseButton);
        }

        @Override
        public void update() {
            this.flight.func_146178_a();
            try {
                this.value = this.flight.func_146179_b().isEmpty() ? 0 : Integer.valueOf(this.flight.func_146179_b());
                this.err = false;
            }
            catch (NumberFormatException e) {
                this.err = true;
            }
            super.update();
        }

        @Override
        public boolean charTyped(char key, int modifiers) {
            return this.flight.charTyped(key, modifiers) || super.charTyped(key, modifiers);
        }

        @Override
        public boolean keyPressed(int key, int scanCode, int modifiers) {
            return this.flight.keyPressed(key, scanCode, modifiers) || super.keyPressed(key, scanCode, modifiers);
        }
    }
}

