/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui.modifier;

import com.mojang.blaze3d.platform.GlStateManager;
import fr.atesab.act.gui.GuiACT;
import fr.atesab.act.gui.GuiValueButton;
import fr.atesab.act.gui.modifier.GuiModifier;
import fr.atesab.act.utils.GuiUtils;
import fr.atesab.act.utils.Tuple;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public abstract class GuiListModifier<T>
extends GuiModifier<T> {
    private List<ListElement> elements;
    private List<ListElement> searchedElements = new ArrayList<ListElement>();
    private List<ListElement>[] visibleElements;
    private boolean doneButton;
    private boolean cancelButton;
    private int page;
    private int maxPage;
    private int sizeX;
    private Button lastPage;
    private Button nextPage;
    private TextFieldWidget search;
    protected Tuple<String, Tuple<Runnable, Runnable>>[] buttons;
    private boolean needRedefine = false;
    private int dSize = 42;
    private int paddingLeft = 0;
    private int paddingTop = 0;
    private boolean noAdaptativeSize = false;
    private boolean justStart = true;

    public GuiListModifier(Screen parent, String name, List<ListElement> elements, Consumer<T> setter, boolean doneButton, boolean cancelButton, Tuple<String, Tuple<Runnable, Runnable>>[] buttons) {
        super(parent, name, setter);
        this.elements = elements;
        this.buttons = buttons;
        this.doneButton = doneButton;
        this.cancelButton = cancelButton;
        this.setter = setter;
        this.parent = parent;
        this.search = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, 0, 0, 0, 0, "");
    }

    public GuiListModifier(Screen parent, String name, List<ListElement> elements, Consumer<T> setter, boolean doneButton, Tuple<String, Tuple<Runnable, Runnable>>[] buttons) {
        this(parent, name, elements, setter, doneButton, true, buttons);
    }

    public GuiListModifier(Screen parent, String name, List<ListElement> elements, Consumer<T> setter, Tuple<String, Tuple<Runnable, Runnable>>[] buttons) {
        this(parent, name, elements, setter, true, buttons);
    }

    public void addListElement(int i, ListElement elem) {
        this.elements.add(i, elem);
        this.needRedefine = true;
    }

    public void addListElement(ListElement elem) {
        this.elements.add(elem);
        this.needRedefine = true;
    }

    public boolean charTyped(char key, int modifiers) {
        boolean flag = false;
        block0: for (List<ListElement> lel : this.visibleElements) {
            for (ListElement le2 : lel) {
                if (!le2.isFocused()) continue;
                flag = true;
                continue block0;
            }
        }
        for (List<ListElement> lel : this.visibleElements) {
            lel.forEach(le -> le.charTyped(key, modifiers));
        }
        if (!flag && !this.justStart) {
            this.search.func_146195_b(true);
        } else {
            this.justStart = false;
        }
        if (this.search.isFocused()) {
            this.search.charTyped(key, modifiers);
            this.page = 0;
            this.define();
        }
        return super.charTyped(key, modifiers);
    }

    private void define() {
        int j;
        boolean add;
        block10: {
            this.searchedElements.clear();
            this.elements.stream().filter(le -> le.match(this.search.func_146179_b())).forEach(this.searchedElements::add);
            this.sizeX = this.searchedElements.stream().mapToInt(ListElement::getSizeX).max().orElse(this.width - 20 - this.paddingLeft) + this.paddingLeft;
            this.visibleElements = new ArrayList[Math.max(1, (this.width - 20) / this.sizeX)];
            for (int i = 0; i < this.visibleElements.length; ++i) {
                this.visibleElements[i] = new ArrayList<ListElement>();
            }
            this.maxPage = 0;
            int pageHeight = this.height - 63;
            int currentSize = 0;
            int i = 0;
            for (ListElement elm : this.searchedElements) {
                int sy = this.paddingTop + elm.sizeY;
                if (currentSize + sy > pageHeight) {
                    if ((i = (i + 1) % this.visibleElements.length) == 0) {
                        ++this.maxPage;
                    }
                    currentSize = sy;
                } else {
                    currentSize += sy;
                }
                if (this.page != this.maxPage) continue;
                this.visibleElements[i].add(elm);
            }
            this.maxPage = Math.max(1, this.maxPage + (currentSize == 0 ? 0 : 1));
            if (this.page >= this.maxPage) {
                this.page = this.maxPage - 1;
                this.define();
            }
            add = false;
            if (this.page == 0) {
                for (j = 0; j < this.visibleElements.length && !this.visibleElements[j].isEmpty(); ++j) {
                    for (ListElement le2 : this.visibleElements[j]) {
                        if (!(le2 instanceof AddElementList)) continue;
                        add = true;
                        break block10;
                    }
                }
            } else {
                j = this.visibleElements.length;
            }
        }
        this.dSize = (!add && !this.noAdaptativeSize && j == 1 && this.maxPage == 1 ? this.height / 2 - this.visibleElements[0].stream().mapToInt(ListElement::getSizeY).sum() / 2 : 42) + this.paddingTop;
        this.lastPage.active = this.page != 0;
        this.nextPage.active = this.page + 1 < this.maxPage;
    }

    protected abstract T get();

    public List<ListElement> getElements() {
        return Collections.unmodifiableList(this.elements);
    }

    private int getOffsetX() {
        int i;
        if (this.page == 0) {
            for (i = 0; i < this.visibleElements.length && !this.visibleElements[i].isEmpty(); ++i) {
            }
        } else {
            i = this.visibleElements.length;
        }
        return (this.width - this.sizeX * (i - 1) + this.paddingLeft) / 2;
    }

    public int getPaddingLeft() {
        return this.paddingLeft;
    }

    public int getPaddingTop() {
        return this.paddingTop;
    }

    public void init() {
        int i;
        this.page = 0;
        int l = this.doneButton ? 1 : 0;
        int d = (this.buttons.length + l + (this.cancelButton ? 1 : 0)) * 50;
        int dl = this.width / 2 - d;
        int dr = this.width / 2 + d;
        if (this.doneButton) {
            this.addButton((Widget)new Button(dl, this.height - 21, 99, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), b -> {
                this.set(this.get());
                this.getMinecraft().func_147108_a(this.parent);
            }));
        }
        for (i = 0; i < this.buttons.length; ++i) {
            this.addButton((Widget)new GuiValueButton(dl + 100 * (i + l), this.height - 21, 99, 20, (String)this.buttons[i].a, this.buttons[i].b, b -> ((Runnable)((Tuple)b.getValue()).a).run()));
        }
        if (this.cancelButton) {
            this.addButton((Widget)new Button(dl + 100 * (i + l), this.height - 21, 99, 20, I18n.func_135052_a((String)"gui.act.cancel", (Object[])new Object[0]), b -> this.getMinecraft().func_147108_a(this.parent)));
        }
        this.lastPage = new Button(dl - 21, this.height - 21, 20, 20, "<-", b -> {
            --this.page;
            this.define();
        }){

            public String getNarrationMessage() {
                return I18n.func_135052_a((String)"gui.narrate.button", (Object[])new Object[]{I18n.func_135052_a((String)"gui.act.leftArrow", (Object[])new Object[0])});
            }
        };
        this.addButton((Widget)this.lastPage);
        this.nextPage = new Button(dr, this.height - 21, 20, 20, "->", b -> {
            ++this.page;
            this.define();
        }){

            public String getNarrationMessage() {
                return I18n.func_135052_a((String)"gui.narrate.button", (Object[])new Object[]{I18n.func_135052_a((String)"gui.act.rightArrow", (Object[])new Object[0])});
            }
        };
        this.addButton((Widget)this.nextPage);
        int m = this.font.func_78256_a(I18n.func_135052_a((String)"gui.act.search", (Object[])new Object[0]) + " : ");
        int n = Math.min(600, this.width - 20);
        this.search.x = (this.width - n) / 2 + 6 + m;
        this.search.y = 18;
        this.search.setWidth(n - 18 - m);
        this.search.setHeight(18);
        this.elements.forEach(ListElement::init);
        this.define();
        super.init();
    }

    public boolean isNoAdaptativeSize() {
        return this.noAdaptativeSize;
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        boolean flag = false;
        block0: for (List<ListElement> lel : this.visibleElements) {
            for (ListElement le2 : lel) {
                if (!le2.isFocused()) continue;
                flag = true;
                continue block0;
            }
        }
        for (List<ListElement> lel : this.visibleElements) {
            lel.forEach(le -> le.keyPressed(key, scanCode, modifiers));
        }
        if (!flag) {
            this.search.func_146195_b(true);
        }
        if (this.search.isFocused()) {
            this.search.keyPressed(key, scanCode, modifiers);
            this.page = 0;
            this.define();
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        for (int i = 0; i < this.visibleElements.length; ++i) {
            int currentSize = this.dSize;
            for (ListElement le : this.visibleElements[i]) {
                int offsetX = this.getOffsetX() + this.sizeX * i - le.getSizeX() / 2;
                le.mouseClicked((int)mouseX - offsetX, (int)mouseY - currentSize, mouseButton);
                currentSize += le.getSizeY() + this.paddingTop;
            }
        }
        this.search.mouseClicked(mouseX, mouseY, mouseButton);
        if (mouseButton == 1) {
            if (GuiUtils.isHover(this.search.x, this.search.y, this.search.getWidth(), this.search.getHeight(), (int)mouseX, (int)mouseY)) {
                this.search.func_146180_a("");
                this.page = 0;
                this.define();
            } else {
                this.children.stream().filter(button -> button instanceof GuiValueButton && GuiUtils.isHover((Widget)((Button)button), (int)mouseX, (int)mouseY)).map(b -> (GuiValueButton)((Object)b)).forEach(b -> ((Runnable)((Tuple)b.getValue()).b).run());
            }
        }
        if (this.needRedefine) {
            this.needRedefine = false;
            this.define();
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void removeListElement(ListElement elem) {
        this.elements.remove(elem);
        this.needRedefine = true;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        int offsetX;
        int currentSize;
        int i;
        RenderHelper.func_74518_a();
        this.renderBackground();
        for (i = 0; i < this.visibleElements.length; ++i) {
            currentSize = this.dSize;
            for (ListElement le : this.visibleElements[i]) {
                offsetX = this.getOffsetX() + this.sizeX * i - le.getSizeX() / 2;
                le.draw(offsetX, currentSize, mouseX - offsetX, mouseY - currentSize, partialTicks);
                currentSize += le.getSizeY() + this.paddingTop;
            }
        }
        GlStateManager.color3f((float)0.0f, (float)1.0f, (float)1.0f);
        super.render(mouseX, mouseY, partialTicks);
        this.search.render(mouseX, mouseY, partialTicks);
        GuiUtils.drawCenterString(this.font, this.getStringTitle(), this.width / 2, 2, -1, 10);
        GuiUtils.drawRightString(this.font, I18n.func_135052_a((String)"gui.act.search", (Object[])new Object[0]) + " : ", this.search.x, this.search.y, Color.ORANGE.getRGB(), this.search.getHeight());
        if (this.getMinecraft().field_71462_r.equals(this)) {
            for (i = 0; i < this.visibleElements.length; ++i) {
                currentSize = this.dSize;
                for (ListElement le : this.visibleElements[i]) {
                    offsetX = this.getOffsetX() + this.sizeX * i - le.getSizeX() / 2;
                    le.drawNext(offsetX, currentSize, mouseX - offsetX, mouseY - currentSize, partialTicks);
                    currentSize += le.getSizeY() + this.paddingTop;
                }
            }
        }
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void setNoAdaptativeSize(boolean noAdaptativeSize) {
        this.noAdaptativeSize = noAdaptativeSize;
    }

    public void setPaddingLeft(int paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public void setPaddingTop(int paddingTop) {
        this.paddingTop = paddingTop;
    }

    public void tick() {
        this.search.func_146178_a();
        for (List<ListElement> lel : this.visibleElements) {
            lel.forEach(ListElement::update);
        }
        super.tick();
    }

    public static class RunElementButton
    extends Button {
        private Runnable left;
        private Runnable right;

        public RunElementButton(int x, int y, int widthIn, int heightIn, String text, Runnable left, Runnable right) {
            super(x, y, widthIn, heightIn, text, b -> {});
            this.left = left;
            this.right = right;
        }

        public Runnable getLeft() {
            return this.left;
        }

        public Runnable getRight() {
            return this.right;
        }
    }

    public static class RemoveElementButton
    extends RunElementButton {
        public RemoveElementButton(GuiListModifier<?> parent, int x, int y, int widthIn, int heightIn, ListElement element) {
            super(x, y, widthIn, heightIn, "-", () -> {
                ((GuiListModifier)parent).elements.remove(element);
                ((GuiListModifier)parent).needRedefine = true;
            }, null);
            this.setFGColor(TextFormatting.RED.func_211163_e());
        }

        public RemoveElementButton(GuiListModifier<?> parent, int x, int y, ListElement element) {
            this(parent, x, y, 200, 20, element);
        }

        protected String getNarrationMessage() {
            return I18n.func_135052_a((String)"gui.narrate.button", (Object[])new Object[]{I18n.func_135052_a((String)"gui.act.delete", (Object[])new Object[0])});
        }
    }

    public static abstract class ListElement {
        protected FontRenderer font;
        protected Minecraft mc;
        protected List<Widget> buttonList = new ArrayList<Widget>();
        protected List<TextFieldWidget> fieldList = new ArrayList<TextFieldWidget>();
        private int sizeX;
        private int sizeY;

        public ListElement(int sizeX, int sizeY) {
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.mc = Minecraft.func_71410_x();
            this.font = this.mc.field_71466_p;
        }

        public boolean charTyped(char key, int modifiers) {
            for (TextFieldWidget field : this.fieldList) {
                if (!field.func_146176_q() || !field.charTyped(key, modifiers)) continue;
                return true;
            }
            return false;
        }

        public void draw(int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
            this.buttonList.forEach(b -> GuiUtils.drawRelative(b, offsetX, offsetY, mouseX, mouseY, partialTicks));
            this.fieldList.stream().filter(TextFieldWidget::func_146176_q).forEach(tf -> GuiUtils.drawRelative((Widget)tf, offsetX, offsetY, mouseX, mouseY, partialTicks));
        }

        public void drawNext(int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
            this.buttonList.stream().filter(Widget::isHovered).forEach(b -> GuiUtils.drawRelativeToolTip(b, offsetX, offsetY, mouseX, mouseY, partialTicks));
        }

        public int getSizeX() {
            return this.sizeX;
        }

        public int getSizeY() {
            return this.sizeY;
        }

        public void init() {
            this.fieldList.forEach(tf -> tf.func_146195_b(false));
        }

        public boolean isFocused() {
            for (TextFieldWidget field : this.fieldList) {
                if (!field.isFocused()) continue;
                return true;
            }
            return false;
        }

        public boolean keyPressed(int key, int scanCode, int modifiers) {
            for (TextFieldWidget field : this.fieldList) {
                if (!field.func_146176_q() || !field.keyPressed(key, scanCode, modifiers)) continue;
                return true;
            }
            return false;
        }

        public boolean match(String search) {
            return true;
        }

        public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
            this.buttonList.forEach(b -> {
                if (GuiUtils.isHover(b, mouseX, mouseY)) {
                    if (b instanceof RunElementButton) {
                        if (((RunElementButton)((Object)b)).getLeft() != null && mouseButton == 0) {
                            GuiACT.playClick();
                            ((RunElementButton)((Object)b)).getLeft().run();
                        } else if (((RunElementButton)((Object)b)).getLeft() != null && mouseButton == 1) {
                            GuiACT.playClick();
                            ((RunElementButton)((Object)b)).getRight().run();
                        }
                    } else if (mouseButton == 0) {
                        GuiACT.playClick();
                        b.onClick((double)mouseX, (double)mouseY);
                    } else {
                        this.otherActionPerformed((Widget)b, mouseButton);
                    }
                }
            });
            this.fieldList.stream().filter(TextFieldWidget::func_146176_q).forEach(tf -> {
                if (mouseButton == 1 && GuiUtils.isHover(tf, mouseX, mouseY)) {
                    tf.func_146180_a("");
                    tf.func_146195_b(true);
                } else {
                    tf.mouseClicked((double)mouseX, (double)mouseY, mouseButton);
                }
            });
        }

        protected void otherActionPerformed(Widget button, int mouseButton) {
        }

        public void setSizeX(int sizeX) {
            this.sizeX = sizeX;
        }

        public void setSizeY(int sizeY) {
            this.sizeY = sizeY;
        }

        public void update() {
            this.fieldList.stream().filter(TextFieldWidget::func_146176_q).forEach(TextFieldWidget::func_146178_a);
        }
    }

    public static class ButtonElementList
    extends ListElement {
        private Runnable right;

        public ButtonElementList(int sizeX, int sizeY, int buttonSizeX, int buttonSizeY, String buttonText, Runnable leftAction, Runnable rightAction) {
            super(sizeX, sizeY);
            this.buttonList.add(new Button(0, 0, buttonSizeX, buttonSizeY, buttonText, b -> {
                if (leftAction != null) {
                    leftAction.run();
                }
            }));
            this.right = rightAction;
        }

        @Override
        protected void otherActionPerformed(Widget button, int mouseButton) {
            if (mouseButton == 1 && this.right != null) {
                this.right.run();
            }
            super.otherActionPerformed(button, mouseButton);
        }
    }

    public static class AddElementList
    extends ListElement {
        public AddElementList(GuiListModifier<?> parent, Supplier<ListElement> builder) {
            this(parent, builder, Math.min(200, ((GuiListModifier)parent).elements.stream().mapToInt(ListElement::getSizeX).max().orElse(100)), 21);
        }

        public AddElementList(GuiListModifier<?> parent, Supplier<ListElement> builder, int sizeX, int sizeY) {
            super(sizeX, Math.max(21, sizeY));
            this.buttonList.add(new AddElementButton(parent, 0, (this.getSizeY() - 20) / 2, this.getSizeX(), 20, this, builder));
        }
    }

    public static class AddElementButton
    extends RunElementButton {
        public AddElementButton(GuiListModifier<?> parent, int x, int y, int widthIn, int heightIn, ListElement element, Supplier<ListElement> builder) {
            this(parent, x, y, widthIn, heightIn, "+", element, builder);
        }

        public AddElementButton(GuiListModifier<?> parent, int x, int y, int widthIn, int heightIn, String text, ListElement element, Function<Integer, ListElement> builder) {
            super(x, y, widthIn, heightIn, text, () -> {
                for (int i = 0; i < ((GuiListModifier)parent).elements.size(); ++i) {
                    if (!((ListElement)((GuiListModifier)parent).elements.get(i)).equals(element)) continue;
                    ListElement elm = (ListElement)builder.apply(i);
                    if (elm == null) break;
                    parent.addListElement(i, elm);
                    break;
                }
            }, null);
            this.setFGColor(TextFormatting.GREEN.func_211163_e());
        }

        public AddElementButton(GuiListModifier<?> parent, int x, int y, int widthIn, int heightIn, String text, ListElement element, Supplier<ListElement> builder) {
            this(parent, x, y, widthIn, heightIn, text, element, (Integer i) -> (ListElement)builder.get());
        }

        protected String getNarrationMessage() {
            return I18n.func_135052_a((String)"gui.narrate.button", (Object[])new Object[]{I18n.func_135052_a((String)"gui.act.new", (Object[])new Object[0])});
        }
    }
}

