/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui.modifier;

import fr.atesab.act.gui.modifier.GuiModifier;
import fr.atesab.act.utils.GuiUtils;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;

public class GuiStringModifier
extends GuiModifier<String> {
    private TextFieldWidget field;
    private String value;

    public GuiStringModifier(Screen parent, String name, String value, Consumer<String> setter) {
        super(parent, name, setter);
        this.value = value;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.field.render(mouseX, mouseY, partialTicks);
        GuiUtils.drawRightString(this.font, I18n.func_135052_a((String)"gui.act.text", (Object[])new Object[0]) + " : ", this.field.x, this.field.y, Color.ORANGE.getRGB(), this.field.getHeight());
        super.render(mouseX, mouseY, partialTicks);
    }

    public void init() {
        this.field = new TextFieldWidget(this.font, this.width / 2 - 99, this.height / 2 - 20, 198, 18, "");
        this.field.func_146203_f(Integer.MAX_VALUE);
        this.field.func_146180_a(this.value.replaceAll(String.valueOf('\u00a7'), "&"));
        this.field.func_146195_b(true);
        this.field.func_146205_d(false);
        this.addButton((Widget)new Button(this.width / 2 - 100, this.height / 2, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), b -> {
            this.value = this.field.func_146179_b().replaceAll("&", String.valueOf('\u00a7'));
            this.set(this.value);
            this.getMinecraft().func_147108_a(this.parent);
        }));
        this.addButton((Widget)new Button(this.width / 2 - 100, this.height / 2 + 21, 200, 20, I18n.func_135052_a((String)"gui.act.cancel", (Object[])new Object[0]), b -> this.getMinecraft().func_147108_a(this.parent)));
        super.init();
    }

    public boolean charTyped(char key, int modifiers) {
        return this.field.charTyped(key, modifiers) || super.charTyped(key, modifiers);
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        return this.field.keyPressed(key, scanCode, modifiers) || super.keyPressed(key, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.field.mouseClicked(mouseX, mouseY, mouseButton);
        if (GuiUtils.isHover(this.field, (int)mouseX, (int)mouseY) && mouseButton == 1) {
            this.field.func_146180_a("");
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void tick() {
        this.value = this.field.func_146179_b();
        this.field.func_146178_a();
        super.tick();
    }
}

