/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui;

import fr.atesab.act.utils.GuiUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.item.ItemStack;

public class ItemStackButtonWidget
extends AbstractButton {
    private ItemStack stack;
    private ITooltipRenderer parent;
    private IItemStackPressable pressable;

    public ItemStackButtonWidget(ITooltipRenderer parent, int x, int y, ItemStack stack, IItemStackPressable pressable) {
        super(x, y, 18, 18, stack.func_200301_q().func_150261_e());
        this.stack = stack;
        this.parent = parent;
        this.pressable = pressable;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void onPress() {
        this.pressable.onPress(this);
    }

    public void renderButton(int mouseX, int mouseY, float partialTick) {
        GuiUtils.drawItemStack(Minecraft.func_71410_x().func_175599_af(), this.stack, this.x + 1, this.y + 1);
        if (this.isHovered()) {
            GuiUtils.drawRect(this.x, this.y, this.x + 18, this.y + 18, 0x55CCCCCC);
        }
    }

    public void renderToolTip(int mouseX, int mouseY) {
        this.parent.renderTooltip(this.getStack(), mouseX, mouseY);
        super.renderToolTip(mouseX, mouseY);
    }

    public static interface ITooltipRenderer {
        public void renderTooltip(ItemStack var1, int var2, int var3);
    }

    @FunctionalInterface
    public static interface IItemStackPressable {
        public void onPress(ItemStackButtonWidget var1);
    }
}

