/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui.modifier;

import fr.atesab.act.utils.GuiUtils;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;

public class GuiBooleanButton
extends Button {
    private Consumer<Boolean> setter;
    private Supplier<Boolean> getter;
    private String text;

    public GuiBooleanButton(int x, int y, int widthIn, int heightIn, String buttonText, Consumer<Boolean> setter, Supplier<Boolean> getter) {
        super(x, y, widthIn, heightIn, buttonText, GuiUtils.EMPTY_PRESS);
        this.setter = setter;
        this.getter = getter;
        this.text = buttonText;
        this.updateDisplay();
    }

    public GuiBooleanButton(int x, int y, String buttonText, Consumer<Boolean> setter, Supplier<Boolean> getter) {
        super(x, y, 200, 20, buttonText, GuiUtils.EMPTY_PRESS);
        this.setter = setter;
        this.getter = getter;
        this.text = buttonText;
        this.updateDisplay();
    }

    private void updateDisplay() {
        boolean v = this.getter.get();
        this.packedFGColor = GuiUtils.getRedGreen(v);
        this.setMessage(this.text + " (" + I18n.func_135052_a((String)(v ? "gui.act.yes" : "gui.act.no"), (Object[])new Object[0]) + ")");
    }

    public void onPress() {
        boolean newValue = this.getter.get() == false;
        this.setter.accept(newValue);
        this.updateDisplay();
    }
}

