/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui.modifier;

import com.mojang.blaze3d.systems.RenderSystem;
import fr.atesab.act.gui.modifier.GuiModifier;
import fr.atesab.act.utils.GuiUtils;
import java.awt.image.BufferedImage;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.gui.widget.Slider;

public class GuiColorModifier
extends GuiModifier<Integer> {
    private final ResourceLocation PICKER = new ResourceLocation("textures/gui/picker.png");
    private BufferedImage pickerImage;
    private int color;
    private boolean drag;
    private boolean advanced = false;
    private Button advButton;
    private TextFieldWidget tfr;
    private TextFieldWidget tfg;
    private TextFieldWidget tfb;
    private TextFieldWidget intColor;
    private TextFieldWidget hexColor;
    private Slider r;
    private Slider g;
    private Slider b;
    private int defaultColor;

    public GuiColorModifier(Screen parent, Consumer<Integer> setter, int color) {
        this(parent, setter, color, 10511680);
    }

    public GuiColorModifier(Screen parent, Consumer<Integer> setter, int color, int defaultColor) {
        super(parent, "gui.act.modifier.meta.setColor", setter);
        this.color = color > 0xFFFFFF ? color - -16777216 : color;
        this.defaultColor = defaultColor;
        try {
            this.pickerImage = ImageIO.read(Minecraft.func_71410_x().func_195551_G().func_199002_a(this.PICKER).func_199027_b());
        }
        catch (Exception e) {
            this.pickerImage = new BufferedImage(200, 200, 2);
        }
    }

    public void tick() {
        this.tfr.func_146178_a();
        this.tfg.func_146178_a();
        this.tfb.func_146178_a();
        this.hexColor.func_146178_a();
        this.intColor.func_146178_a();
        this.g.visible = this.b.visible = this.advanced;
        this.r.visible = this.b.visible;
        this.advButton.setFGColor(this.b.visible ? -1 : -5592406);
        super.tick();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        if (!this.advanced) {
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.getMinecraft().func_110434_K().func_110577_a(this.PICKER);
            GuiUtils.drawScaledCustomSizeModalRect(this.width / 2 - 100, this.height / 2 - 80, 0.0f, 0.0f, 200, 200, 200, 160, 200.0f, 200.0f);
        } else {
            GuiUtils.drawRect(this.width / 2 - 100, this.height / 2 - 80, this.width / 2 + 100, this.height / 2 + 80, -1728053248);
        }
        if (this.advanced) {
            GuiUtils.drawString(this.font, I18n.func_135052_a((String)"gui.act.red", (Object[])new Object[0]) + ":", this.r.x + 1, this.r.y - 10, -1, 10);
            this.tfr.render(mouseX, mouseY, partialTicks);
            GuiUtils.drawString(this.font, I18n.func_135052_a((String)"gui.act.green", (Object[])new Object[0]) + ":", this.g.x + 1, this.g.y - 10, -1, 10);
            this.tfg.render(mouseX, mouseY, partialTicks);
            GuiUtils.drawString(this.font, I18n.func_135052_a((String)"gui.act.blue", (Object[])new Object[0]) + ":", this.b.x + 1, this.b.y - 10, -1, 10);
            this.tfb.render(mouseX, mouseY, partialTicks);
            GuiUtils.drawString(this.font, I18n.func_135052_a((String)"gui.act.modifier.meta.setColor.intColor", (Object[])new Object[0]) + ":", this.intColor.x - 1, this.intColor.y - 11, -1, 10);
            GuiUtils.drawString(this.font, I18n.func_135052_a((String)"gui.act.modifier.meta.setColor.hexColor", (Object[])new Object[0]) + ":", this.hexColor.x - 1, this.hexColor.y - 11, -1, 10);
            this.intColor.render(mouseX, mouseY, partialTicks);
            this.hexColor.render(mouseX, mouseY, partialTicks);
        }
        if (this.color >= 0) {
            GuiUtils.drawRect(this.width / 2 - 120, this.height / 2 - 100, this.width / 2 + 120, this.height / 2 - 80, this.color + -16777216);
        }
        Runnable show = () -> {};
        for (int i = 0; i < DyeColor.values().length; ++i) {
            int x = this.width / 2 - 120 + i % 2 * 220;
            int y = this.height / 2 - 80 + i / 2 * 20;
            GuiUtils.drawRect(x, y, x + 20, y + 20, 0xFF000000 | DyeColor.values()[i].func_196060_f());
            if (GuiUtils.isHover(x, y, 20, 20, mouseX, mouseY)) {
                int j = i;
                show = () -> GuiUtils.drawTextBox(this.font, mouseX, mouseY, this.width, this.height, this.getZLevel(), I18n.func_135052_a((String)("item.minecraft.firework_star." + DyeColor.values()[j].func_176762_d()), (Object[])new Object[0]));
            }
            GuiUtils.drawItemStack(this.itemRenderer, this, new ItemStack((IItemProvider)DyeItem.func_195961_a((DyeColor)DyeColor.values()[i])), x + 2, y + 2);
        }
        super.render(mouseX, mouseY, partialTicks);
        show.run();
    }

    public void init() {
        this.addButton((Widget)new Button(this.width / 2 - 120, this.height / 2 + 81, 80, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), b -> {
            this.set(this.color);
            this.getMinecraft().func_147108_a(this.parent);
        }));
        this.advButton = new Button(this.width / 2 - 38, this.height / 2 + 81, 80, 20, I18n.func_135052_a((String)"gui.act.advanced", (Object[])new Object[0]), b -> {
            this.advanced = !this.advanced;
        });
        this.addButton((Widget)this.advButton);
        this.addButton((Widget)new Button(this.width / 2 + 43, this.height / 2 + 81, 79, 20, I18n.func_135052_a((String)"gui.act.cancel", (Object[])new Object[0]), b -> this.getMinecraft().func_147108_a(this.parent)));
        this.r = new Slider(this.width / 2 - 99, this.height / 2 - 70, 158, 20, I18n.func_135052_a((String)"gui.act.red", (Object[])new Object[0]), "", 0.0, 255.0, (double)(this.color >> 16 & 0xFF), false, false, b -> {}, new Slider.ISlider(){

            public void onChangeSliderValue(Slider slider) {
                GuiColorModifier.this.updateRed(slider.getValueInt());
            }
        });
        this.addButton((Widget)this.r);
        this.tfr = new TextFieldWidget(this.font, this.r.x + this.r.getWidth() + 2, this.r.y + 1, 36, 18, "");
        this.g = new Slider(this.width / 2 - 99, this.height / 2 - 38, 158, 20, I18n.func_135052_a((String)"gui.act.green", (Object[])new Object[0]), "", 0.0, 255.0, (double)(this.color >> 8 & 0xFF), false, false, b -> {}, new Slider.ISlider(){

            public void onChangeSliderValue(Slider slider) {
                GuiColorModifier.this.updateGreen(slider.getValueInt());
            }
        });
        this.addButton((Widget)this.g);
        this.tfg = new TextFieldWidget(this.font, this.g.x + this.g.getWidth() + 2, this.g.y + 1, 36, 18, "");
        this.b = new Slider(this.width / 2 - 99, this.height / 2 - 3, 158, 20, I18n.func_135052_a((String)"gui.act.blue", (Object[])new Object[0]), "", 0.0, 255.0, (double)(this.color >> 0 & 0xFF), false, false, b -> {}, new Slider.ISlider(){

            public void onChangeSliderValue(Slider slider) {
                GuiColorModifier.this.updateBlue(slider.getValueInt());
            }
        });
        this.addButton((Widget)this.b);
        this.tfb = new TextFieldWidget(this.font, this.b.x + this.b.getWidth() + 2, this.b.y + 1, 36, 18, "");
        this.intColor = new TextFieldWidget(this.font, this.width / 2 - 97, this.height / 2 + 28, 194, 18, "");
        this.hexColor = new TextFieldWidget(this.font, this.width / 2 - 97, this.height / 2 + 60, 194, 18, "");
        this.tfr.func_146203_f(4);
        this.tfg.func_146203_f(4);
        this.tfb.func_146203_f(4);
        this.b.visible = false;
        this.g.visible = false;
        this.r.visible = false;
        this.updateColor(this.color);
        super.init();
    }

    public boolean charTyped(char key, int modifiers) {
        if (this.advanced) {
            this.tfr.charTyped(key, modifiers);
            this.tfg.charTyped(key, modifiers);
            this.tfb.charTyped(key, modifiers);
            this.hexColor.charTyped(key, modifiers);
            this.intColor.charTyped(key, modifiers);
            if (this.tfr.isFocused()) {
                try {
                    this.updateRed(this.tfr.func_146179_b().isEmpty() ? 0 : Integer.valueOf(this.tfr.func_146179_b()));
                }
                catch (Exception exception) {}
            } else if (this.tfg.isFocused()) {
                try {
                    this.updateGreen(this.tfg.func_146179_b().isEmpty() ? 0 : Integer.valueOf(this.tfg.func_146179_b()));
                }
                catch (Exception exception) {}
            } else if (this.tfb.isFocused()) {
                try {
                    this.updateBlue(this.tfb.func_146179_b().isEmpty() ? 0 : Integer.valueOf(this.tfb.func_146179_b()));
                }
                catch (Exception exception) {}
            } else if (this.hexColor.isFocused()) {
                try {
                    String s = this.hexColor.func_146179_b().substring(1);
                    this.updateColor(s.isEmpty() ? 0 : Integer.valueOf(s, 16));
                }
                catch (Exception exception) {}
            } else if (this.intColor.isFocused()) {
                try {
                    this.updateColor(this.intColor.func_146179_b().isEmpty() ? 0 : Integer.valueOf(this.intColor.func_146179_b()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return super.charTyped(key, modifiers);
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (this.advanced) {
            this.tfr.keyPressed(key, scanCode, modifiers);
            this.tfg.keyPressed(key, scanCode, modifiers);
            this.tfb.keyPressed(key, scanCode, modifiers);
            this.hexColor.keyPressed(key, scanCode, modifiers);
            this.intColor.keyPressed(key, scanCode, modifiers);
            if (this.tfr.isFocused()) {
                try {
                    this.updateRed(this.tfr.func_146179_b().isEmpty() ? 0 : Integer.valueOf(this.tfr.func_146179_b()));
                }
                catch (Exception exception) {}
            } else if (this.tfg.isFocused()) {
                try {
                    this.updateGreen(this.tfg.func_146179_b().isEmpty() ? 0 : Integer.valueOf(this.tfg.func_146179_b()));
                }
                catch (Exception exception) {}
            } else if (this.tfb.isFocused()) {
                try {
                    this.updateBlue(this.tfb.func_146179_b().isEmpty() ? 0 : Integer.valueOf(this.tfb.func_146179_b()));
                }
                catch (Exception exception) {}
            } else if (this.hexColor.isFocused()) {
                try {
                    String s = this.hexColor.func_146179_b().substring(1);
                    this.updateColor(s.isEmpty() ? 0 : Integer.valueOf(s, 16));
                }
                catch (Exception exception) {}
            } else if (this.intColor.isFocused()) {
                try {
                    this.updateColor(this.intColor.func_146179_b().isEmpty() ? 0 : Integer.valueOf(this.intColor.func_146179_b()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.advanced) {
            if (mouseButton == 1) {
                if (GuiUtils.isHover(this.tfr, (int)mouseX, (int)mouseY)) {
                    this.tfr.func_146180_a("");
                } else if (GuiUtils.isHover(this.tfg, (int)mouseX, (int)mouseY)) {
                    this.tfg.func_146180_a("");
                } else if (GuiUtils.isHover(this.tfb, (int)mouseX, (int)mouseY)) {
                    this.tfb.func_146180_a("");
                } else if (GuiUtils.isHover(this.intColor, (int)mouseX, (int)mouseY)) {
                    this.intColor.func_146180_a("");
                } else if (GuiUtils.isHover(this.hexColor, (int)mouseX, (int)mouseY)) {
                    this.hexColor.func_146180_a("#");
                }
            }
            this.tfr.mouseClicked(mouseX, mouseY, mouseButton);
            this.tfg.mouseClicked(mouseX, mouseY, mouseButton);
            this.tfb.mouseClicked(mouseX, mouseY, mouseButton);
            this.intColor.mouseClicked(mouseX, mouseY, mouseButton);
            this.hexColor.mouseClicked(mouseX, mouseY, mouseButton);
        }
        this.drag = false;
        if (!this.advanced && GuiUtils.isHover(this.width / 2 - 100, this.height / 2 - 80, 200, 160, (int)mouseX, (int)mouseY)) {
            this.setColor((int)mouseX, (int)mouseY);
            this.drag = true;
        } else if (GuiUtils.isHover(this.width / 2 - 120, this.height / 2 - 100, 240, 20, (int)mouseX, (int)mouseY)) {
            this.updateColor(this.defaultColor);
        } else {
            for (int i = 0; i < DyeColor.values().length; ++i) {
                if (!GuiUtils.isHover(this.width / 2 - 120 + i % 2 * 220, this.height / 2 - 80 + i / 2 * 20, 20, 20, (int)mouseX, (int)mouseY)) continue;
                this.updateColor(DyeColor.values()[i].func_196060_f());
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int clickedMouseButton, double dx, double dy) {
        if (this.drag) {
            this.setColor((int)mouseX, (int)mouseY);
        }
        return super.mouseDragged(mouseX, mouseY, clickedMouseButton, dx, dy);
    }

    private void updateColor(int value) {
        this.color = value == this.defaultColor ? value : MathHelper.func_76125_a((int)value, (int)0, (int)0xFFFFFF);
        int r = this.color >> 16 & 0xFF;
        int g = this.color >> 8 & 0xFF;
        int b = this.color >> 0 & 0xFF;
        this.r.setValue((double)r);
        this.g.setValue((double)g);
        this.b.setValue((double)b);
        this.tfr.func_146180_a("" + r);
        this.tfg.func_146180_a("" + g);
        this.tfb.func_146180_a("" + b);
        this.intColor.func_146180_a("" + this.color);
        String s = Integer.toHexString(this.color);
        this.hexColor.func_146180_a("#" + s);
    }

    private void setColor(int mouseX, int mouseY) {
        int rx = MathHelper.func_76125_a((int)(mouseX - (this.width / 2 - 100)), (int)0, (int)199);
        int ry = MathHelper.func_76125_a((int)(MathHelper.func_76125_a((int)(mouseY - (this.height / 2 - 100)), (int)0, (int)160) * 20 / 16), (int)0, (int)199);
        int[] data = new int[3];
        this.pickerImage.getRaster().getPixel(rx, ry, data);
        this.updateColor((data[0] & 0xFF) << 16 | (data[1] & 0xFF) << 8 | (data[2] & 0xFF) << 0);
    }

    private void updateRed(int v) {
        v = MathHelper.func_76125_a((int)v, (int)0, (int)255);
        this.updateColor((v & 0xFF) << 16 | (this.color >> 8 & 0xFF & 0xFF) << 8 | (this.color >> 0 & 0xFF & 0xFF) << 0);
    }

    private void updateGreen(int v) {
        v = MathHelper.func_76125_a((int)v, (int)0, (int)255);
        this.updateColor((this.color >> 16 & 0xFF & 0xFF) << 16 | (v & 0xFF) << 8 | (this.color >> 0 & 0xFF & 0xFF) << 0);
    }

    private void updateBlue(int v) {
        v = MathHelper.func_76125_a((int)v, (int)0, (int)255);
        this.updateColor((this.color >> 16 & 0xFF & 0xFF) << 16 | (this.color >> 8 & 0xFF & 0xFF) << 8 | (v & 0xFF) << 0);
    }
}

