/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui.modifier;

import fr.atesab.act.gui.modifier.GuiListModifier;
import fr.atesab.act.utils.GuiUtils;
import fr.atesab.act.utils.Tuple;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;

public class GuiEnchModifier
extends GuiListModifier<List<Tuple<Enchantment, Integer>>> {
    public GuiEnchModifier(Screen parent, List<Tuple<Enchantment, Integer>> ench, Consumer<List<Tuple<Enchantment, Integer>>> setter) {
        super(parent, "gui.act.modifier.ench", new ArrayList<GuiListModifier.ListElement>(), setter, null);
        this.buttons = new Tuple[]{new Tuple<String, Tuple<Runnable, Runnable>>(I18n.func_135052_a((String)"gui.act.modifier.ench.max", (Object[])new Object[0]), new Tuple<Runnable, Runnable>(() -> this.getElements().stream().map(le -> (EnchListElement)le).forEach(ele -> ((EnchListElement)ele).textField.func_146180_a(String.valueOf(((EnchListElement)ele).level = ((EnchListElement)ele).enchantment.func_77325_b()))), () -> this.getElements().stream().map(le -> (EnchListElement)le).forEach(ele -> {
            ((EnchListElement)ele).textField.func_146180_a("");
            ((EnchListElement)ele).level = 0;
        })))};
        ench.forEach(e -> this.addListElement(new EnchListElement((Enchantment)e.a, (int)((Integer)e.b))));
    }

    @Override
    protected List<Tuple<Enchantment, Integer>> get() {
        ArrayList<Tuple<Enchantment, Integer>> list = new ArrayList<Tuple<Enchantment, Integer>>();
        this.getElements().forEach(le -> {
            EnchListElement ele = (EnchListElement)le;
            list.add(new Tuple<Enchantment, Integer>(ele.enchantment, ele.level));
        });
        return list;
    }

    static class EnchListElement
    extends GuiListModifier.ListElement {
        private Enchantment enchantment;
        private int level;
        private TextFieldWidget textField;
        private boolean err = false;

        public EnchListElement(Enchantment enchantment, int level) {
            super(200, 21);
            this.enchantment = enchantment;
            this.level = level;
            this.textField = new TextFieldWidget(this.font, 112, 1, 46, 18, "");
            this.textField.func_146203_f(6);
            this.textField.func_146180_a(String.valueOf(level == 0 ? "" : Integer.valueOf(level)));
            this.buttonList.add(new Button(160, 0, 40, 20, I18n.func_135052_a((String)"gui.act.modifier.ench.max", (Object[])new Object[0]), b -> this.textField.func_146180_a(String.valueOf(enchantment.func_77325_b()))));
        }

        @Override
        public void draw(int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
            GuiUtils.drawRelative((Widget)this.textField, offsetX, offsetY, mouseY, mouseY, partialTicks);
            GuiUtils.drawRightString(this.font, I18n.func_135052_a((String)this.enchantment.func_77320_a(), (Object[])new Object[0]) + " : ", offsetX + this.textField.x, offsetY + this.textField.y, (this.err ? Color.RED : (this.level == 0 ? Color.GRAY : Color.WHITE)).getRGB(), this.textField.getHeight());
            super.draw(offsetX, offsetY, mouseX, mouseY, partialTicks);
        }

        @Override
        public void init() {
            this.textField.func_146195_b(false);
        }

        @Override
        public boolean isFocused() {
            return this.textField.isFocused();
        }

        @Override
        public boolean charTyped(char key, int modifiers) {
            return this.textField.charTyped(key, modifiers) || super.charTyped(key, modifiers);
        }

        @Override
        public boolean keyPressed(int key, int scanCode, int modifiers) {
            return this.textField.keyPressed(key, scanCode, modifiers) || super.keyPressed(key, scanCode, modifiers);
        }

        @Override
        public boolean match(String search) {
            return I18n.func_135052_a((String)this.enchantment.func_77320_a(), (Object[])new Object[0]).toLowerCase().contains(search.toLowerCase());
        }

        @Override
        public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
            this.textField.mouseClicked((double)mouseX, (double)mouseY, mouseButton);
            if (mouseButton == 1 && GuiUtils.isHover(this.textField, mouseX, mouseY)) {
                this.textField.func_146180_a("");
            }
            super.mouseClicked(mouseX, mouseY, mouseButton);
        }

        @Override
        public void update() {
            this.textField.func_146178_a();
            try {
                this.level = this.textField.func_146179_b().isEmpty() ? 0 : Integer.valueOf(this.textField.func_146179_b());
                this.err = false;
            }
            catch (NumberFormatException e) {
                this.err = true;
            }
            super.update();
        }
    }
}

