/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui.modifier;

import fr.atesab.act.gui.modifier.GuiModifier;
import fr.atesab.act.utils.GuiUtils;
import fr.atesab.act.utils.ItemUtils;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.TextFormatting;

public class GuiHeadModifier
extends GuiModifier<ItemStack> {
    private ItemStack stack;
    private TextFieldWidget name;
    private TextFieldWidget uuid;
    private TextFieldWidget link;
    private Button save;
    private Button loadName;
    private Button loadLink;
    private Thread saveThread = null;
    private AtomicReference<String> errType = new AtomicReference<Object>(null);
    private AtomicReference<String> err = new AtomicReference<Object>(null);

    public GuiHeadModifier(Screen parent, Consumer<ItemStack> setter, ItemStack stack) {
        super(parent, "gui.act.modifier.head", setter);
        this.stack = stack.func_77946_l();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        boolean flagName;
        this.renderBackground();
        ArrayList<String> err = new ArrayList<String>();
        boolean flagLink = (this.link.func_146179_b().isEmpty() || !this.link.func_146179_b().matches("http://textures.minecraft.net/texture/[a-zA-Z0-9]+")) && !this.link.func_146179_b().isEmpty();
        boolean flagUuid = (this.uuid.func_146179_b().isEmpty() || !this.uuid.func_146179_b().matches("[0-9A-Fa-f]+-[0-9A-Fa-f]+-[0-9A-Fa-f]+-[0-9A-Fa-f]+-[0-9A-Fa-f]+")) && !this.uuid.func_146179_b().isEmpty();
        boolean bl = flagName = (this.name.func_146179_b().isEmpty() || !this.name.func_146179_b().matches("([0-9A-Za-z_]|(-))+")) && !this.name.func_146179_b().isEmpty();
        if (flagLink) {
            err.add(I18n.func_135052_a((String)"gui.act.modifier.head.link.warning", (Object[])new Object[0]));
        }
        if (flagUuid) {
            err.add(I18n.func_135052_a((String)"gui.act.modifier.head.uuid.warning", (Object[])new Object[0]));
        }
        if (flagName) {
            err.add(I18n.func_135052_a((String)"gui.act.modifier.head.name.warning", (Object[])new Object[0]));
        }
        if (this.err.get() != null) {
            err.add(this.err.get());
        }
        if (this.errType.get() != null) {
            err.add(this.errType.get() + ": ");
        }
        for (int i = 0; i < err.size(); ++i) {
            String string = (String)err.get(i);
            int n = this.width / 2;
            int n2 = this.name.y - 2;
            this.font.getClass();
            GuiUtils.drawCenterString(this.font, string, n, n2 - (9 + 1) * (i + 1), Color.RED.getRGB());
        }
        String string = I18n.func_135052_a((String)"gui.act.config.name", (Object[])new Object[0]) + " : ";
        float f = this.width / 2 - 178;
        int n = this.name.y + 10;
        this.font.getClass();
        this.font.func_211126_b(string, f, (float)(n - 9 / 2), (flagName ? Color.RED : Color.WHITE).getRGB());
        String string2 = I18n.func_135052_a((String)"gui.act.uuid", (Object[])new Object[0]) + " : ";
        float f2 = this.width / 2 - 178;
        int n3 = this.uuid.y + 10;
        this.font.getClass();
        this.font.func_211126_b(string2, f2, (float)(n3 - 9 / 2), (flagUuid ? Color.RED : Color.WHITE).getRGB());
        String string3 = I18n.func_135052_a((String)"gui.act.link", (Object[])new Object[0]) + " : ";
        float f3 = this.width / 2 - 178;
        int n4 = this.link.y + 10;
        this.font.getClass();
        this.font.func_211126_b(string3, f3, (float)(n4 - 9 / 2), (flagLink ? Color.RED : Color.WHITE).getRGB());
        this.name.render(mouseX, mouseY, partialTicks);
        this.uuid.render(mouseX, mouseY, partialTicks);
        this.link.render(mouseX, mouseY, partialTicks);
        GuiUtils.drawItemStack(this.itemRenderer, this, this.stack, this.uuid.x + this.uuid.getWidth() + 10, this.uuid.y + this.uuid.getHeight() / 2 - 8);
        super.render(mouseX, mouseY, partialTicks);
        if (GuiUtils.isHover(this.uuid.x + this.uuid.getWidth() + 10, this.uuid.y + this.uuid.getHeight() / 2 - 8, 16, 16, mouseX, mouseY)) {
            this.renderTooltip(this.stack, mouseX, mouseY);
        }
    }

    public void init() {
        int l = Math.max(this.font.func_78256_a(I18n.func_135052_a((String)"gui.act.config.name", (Object[])new Object[0]) + " : "), Math.max(this.font.func_78256_a(I18n.func_135052_a((String)"gui.act.uuid", (Object[])new Object[0]) + " : "), this.font.func_78256_a(I18n.func_135052_a((String)"gui.act.link", (Object[])new Object[0]) + " : "))) + 3;
        this.name = new TextFieldWidget(this.font, this.width / 2 - 178 + l, this.height / 2 - 61, 356 - l, 16, "");
        this.uuid = new TextFieldWidget(this.font, this.width / 2 - 178 + l, this.height / 2 - 40, 356 - l, 16, "");
        this.link = new TextFieldWidget(this.font, this.width / 2 - 178 + l, this.height / 2 - 19, 356 - l, 16, "");
        this.name.func_146203_f(16);
        this.link.func_146203_f(Integer.MAX_VALUE);
        this.uuid.func_146203_f(Integer.MAX_VALUE);
        this.addButton((Widget)new Button(this.width / 2 - 180, this.height / 2, 180, 20, I18n.func_135052_a((String)"gui.act.modifier.head.me", (Object[])new Object[0]), b -> this.name.func_146180_a(this.getMinecraft().func_110432_I().func_111285_a())));
        this.save = new Button(this.width / 2 + 1, this.height / 2, 179, 20, I18n.func_135052_a((String)"gui.act.modifier.head.saveSkin", (Object[])new Object[0]), b -> {
            if (this.saveThread == null || !this.saveThread.isAlive()) {
                this.saveThread = new Thread(() -> {
                    JFileChooser fileChooser = new JFileChooser();
                    fileChooser.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            return f.isDirectory() || f.getName().endsWith(".png");
                        }

                        @Override
                        public String getDescription() {
                            return "skin (*.png)";
                        }
                    });
                    fileChooser.setSelectedFile(new File(this.name.func_146179_b().isEmpty() ? "skin.png" : this.name.func_146179_b() + ".png"));
                    if (fileChooser.showDialog(null, I18n.func_135052_a((String)"gui.act.save", (Object[])new Object[0])) == 0) {
                        try {
                            this.err.set(TextFormatting.GOLD + I18n.func_135052_a((String)"gui.act.modifier.head.loading", (Object[])new Object[0]) + "...");
                            URL url = new URL(this.link.func_146179_b());
                            InputStream stream = url.openStream();
                            byte[] buffer = new byte[stream.available()];
                            stream.read(buffer);
                            File f = fileChooser.getSelectedFile();
                            FileOutputStream writer = new FileOutputStream(f);
                            ((OutputStream)writer).write(buffer);
                            ((OutputStream)writer).close();
                            this.errType.set(TextFormatting.GREEN + I18n.func_135052_a((String)"gui.act.modifier.head.fileSaved", (Object[])new Object[0]));
                            String s = f.toString();
                            if (s.length() > 50) {
                                s = s.substring(0, 50) + "...";
                            }
                            this.err.set(TextFormatting.GREEN + s);
                        }
                        catch (Exception e) {
                            this.errType.set(e instanceof FileNotFoundException ? I18n.func_135052_a((String)"gui.act.modifier.head.fileNotFound", (Object[])new Object[0]) : e.getClass().getSimpleName());
                            String s = e.getMessage();
                            if (s.length() > 50) {
                                s = s.substring(0, 50) + "...";
                            }
                            this.err.set(s);
                        }
                    }
                });
                this.saveThread.start();
            }
        });
        this.addButton((Widget)this.save);
        this.loadName = new Button(this.width / 2 - 180, this.height / 2 + 21, 180, 20, I18n.func_135052_a((String)"gui.act.modifier.head.load.name", (Object[])new Object[0]), b -> {
            try {
                this.err.set(TextFormatting.GOLD + I18n.func_135052_a((String)"gui.act.modifier.head.loading", (Object[])new Object[0]) + "...");
                ItemUtils.getHead(this.stack, this.name.func_146179_b());
                this.loadHead();
            }
            catch (Exception e) {
                this.errType.set(e.getClass().getSimpleName());
                String s = e.getMessage();
                if (s.length() > 50) {
                    s = s.substring(0, 50) + "...";
                }
                this.err.set(s);
            }
        });
        this.addButton((Widget)this.loadName);
        this.loadLink = new Button(this.width / 2 + 1, this.height / 2 + 21, 179, 20, I18n.func_135052_a((String)"gui.act.modifier.head.load.link", (Object[])new Object[0]), b -> {
            this.err.set(TextFormatting.GOLD + I18n.func_135052_a((String)"gui.act.modifier.head.loading", (Object[])new Object[0]) + "...");
            ItemUtils.getHead(this.stack, this.uuid.func_146179_b(), this.link.func_146179_b(), this.name.func_146179_b().isEmpty() ? null : this.name.func_146179_b());
            this.loadHead();
        });
        this.addButton((Widget)this.loadLink);
        if (this.setter != null) {
            this.addButton((Widget)new Button(this.width / 2 - 180, this.height / 2 + 42, 180, 20, I18n.func_135052_a((String)"gui.act.cancel", (Object[])new Object[0]), b -> this.getMinecraft().func_147108_a(this.parent)));
        }
        this.addButton((Widget)new Button(this.width / 2 + 1, this.height / 2 + 42, 179, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), b -> {
            this.set(this.stack);
            this.getMinecraft().func_147108_a(this.parent);
        }));
        this.loadHead();
        super.init();
    }

    public boolean charTyped(char key, int modifiers) {
        return this.link.charTyped(key, modifiers) || this.name.charTyped(key, modifiers) || this.uuid.charTyped(key, modifiers) || super.charTyped(key, modifiers);
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        return this.link.keyPressed(key, scanCode, modifiers) || this.name.keyPressed(key, scanCode, modifiers) || this.uuid.keyPressed(key, scanCode, modifiers) || super.keyPressed(key, scanCode, modifiers);
    }

    private void loadHead() {
        CompoundNBT tag = this.stack.func_190925_c("SkullOwner");
        if (tag.func_150297_b("Name", 8)) {
            this.name.func_146180_a(tag.func_74779_i("Name"));
        }
        if (tag.func_150297_b("Id", 8)) {
            this.uuid.func_146180_a(tag.func_74779_i("Id"));
            if (tag.func_150297_b("Properties", 10) && tag.func_74775_l("Properties").func_150297_b("textures", 9)) {
                ListNBT list = tag.func_74775_l("Properties").func_150295_c("textures", 10);
                for (int i = 0; i < list.size(); ++i) {
                    CompoundNBT text = list.func_150305_b(i);
                    if (!text.func_150297_b("Value", 8)) continue;
                    try {
                        String s = new String(Base64.getDecoder().decode(text.func_74779_i("Value")));
                        CompoundNBT texCompound = JsonToNBT.func_180713_a((String)s);
                        if (texCompound.func_150297_b("profileName", 8)) {
                            this.name.func_146180_a(texCompound.func_74779_i("profileName"));
                        }
                        if (!texCompound.func_150297_b("textures", 10) || !texCompound.func_74775_l("textures").func_150297_b("SKIN", 10) || !texCompound.func_74775_l("textures").func_74775_l("SKIN").func_150297_b("url", 8)) continue;
                        this.link.func_146180_a(texCompound.func_74775_l("textures").func_74775_l("SKIN").func_74779_i("url"));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        this.err.set(null);
        this.errType.set(null);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.link.mouseClicked(mouseX, mouseY, mouseButton);
        this.uuid.mouseClicked(mouseX, mouseY, mouseButton);
        this.name.mouseClicked(mouseX, mouseY, mouseButton);
        if (GuiUtils.isHover(this.link, (int)mouseX, (int)mouseY) && mouseButton == 1) {
            this.link.func_146180_a("");
        }
        if (GuiUtils.isHover(this.uuid, (int)mouseX, (int)mouseY) && mouseButton == 1) {
            this.uuid.func_146180_a("");
        }
        if (GuiUtils.isHover(this.name, (int)mouseX, (int)mouseY) && mouseButton == 1) {
            this.name.func_146180_a("");
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void tick() {
        this.name.func_146178_a();
        this.uuid.func_146178_a();
        this.name.func_146178_a();
        this.loadName.active = !this.name.func_146179_b().isEmpty();
        this.loadLink.active = !this.uuid.func_146179_b().isEmpty() && !this.link.func_146179_b().isEmpty();
        this.save.active = !this.link.func_146179_b().isEmpty();
        super.tick();
    }
}

