/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui.modifier;

import com.mojang.blaze3d.systems.RenderSystem;
import fr.atesab.act.gui.GuiValueButton;
import fr.atesab.act.gui.modifier.GuiModifier;
import fr.atesab.act.utils.GuiUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class GuiStringArrayModifier
extends GuiModifier<String[]> {
    private ArrayList<String> values = new ArrayList();
    private TextFieldWidget[] tfs;
    private Button next;
    private Button last;
    private GuiValueButton<Integer>[] btsDel;
    private GuiValueButton<Integer>[] btsAdd;
    private int elms;
    private int page = 0;

    public GuiStringArrayModifier(Screen parent, String name, String[] values, Consumer<String[]> setter) {
        super(parent, name, setter);
        for (String v : values) {
            this.values.add(v.replaceAll(String.valueOf('\u00a7'), "&"));
        }
    }

    private void defineMenu() {
        int i;
        this.children.clear();
        this.buttons.clear();
        this.addButton((Widget)new Button(this.width / 2 - 100, this.height - 21, 100, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), b -> {
            String[] result = new String[this.values.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.values.get(i).replaceAll("&", String.valueOf('\u00a7'));
            }
            this.set(result);
            this.mc.func_147108_a(this.parent);
        }));
        this.addButton((Widget)new Button(this.width / 2 + 1, this.height - 21, 99, 20, I18n.func_135052_a((String)"gui.act.cancel", (Object[])new Object[0]), b -> this.mc.func_147108_a(this.parent)));
        this.last = new Button(this.width / 2 - 121, this.height - 21, 20, 20, "<-", b -> {
            --this.page;
            b.active = this.page != 0;
            this.next.active = this.page + 1 <= this.values.size() / this.elms;
        }){

            public String getNarrationMessage() {
                return I18n.func_135052_a((String)"gui.narrate.button", (Object[])new Object[]{I18n.func_135052_a((String)"gui.act.leftArrow", (Object[])new Object[0])});
            }
        };
        this.addButton((Widget)this.last);
        this.next = new Button(this.width / 2 + 101, this.height - 21, 20, 20, "->", b -> {
            ++this.page;
            this.last.active = this.page != 0;
            b.active = this.page + 1 <= this.values.size() / this.elms;
        }){

            public String getNarrationMessage() {
                return I18n.func_135052_a((String)"gui.narrate.button", (Object[])new Object[]{I18n.func_135052_a((String)"gui.act.rightArrow", (Object[])new Object[0])});
            }
        };
        this.addButton((Widget)this.next);
        this.last.active = this.page != 0;
        this.next.active = this.page + 1 <= this.values.size() / this.elms;
        this.tfs = new TextFieldWidget[this.values.size()];
        this.btsDel = new GuiValueButton[this.values.size()];
        this.btsAdd = new GuiValueButton[this.values.size() + 1];
        for (i = 0; i < this.values.size(); ++i) {
            this.tfs[i] = new TextFieldWidget(this.font, this.width / 2 - 178, 21 + 21 * i % (this.elms * 21) + 2, 340, 16, "");
            this.tfs[i].func_146203_f(Integer.MAX_VALUE);
            this.tfs[i].func_146180_a(this.values.get(i));
            this.btsDel[i] = new GuiValueButton<Integer>(this.width / 2 + 165, 21 + 21 * i % (this.elms * 21), 20, 20, "-", Integer.valueOf(i), b -> {
                this.values.remove((Integer)b.getValue());
                this.defineMenu();
            }){

                protected String getNarrationMessage() {
                    return I18n.func_135052_a((String)"gui.narrate.button", (Object[])new Object[]{I18n.func_135052_a((String)"gui.act.delete", (Object[])new Object[0])});
                }
            };
            this.addButton((Widget)this.btsDel[i]);
            this.btsDel[i].setFGColor(TextFormatting.RED.func_211163_e());
            this.btsAdd[i] = new GuiValueButton<Integer>(this.width / 2 + 187, 21 + 21 * i % (this.elms * 21), 20, 20, "+", Integer.valueOf(i), b -> {
                this.values.add((Integer)b.getValue(), "");
                this.defineMenu();
            }){

                protected String getNarrationMessage() {
                    return I18n.func_135052_a((String)"gui.narrate.button", (Object[])new Object[]{I18n.func_135052_a((String)"gui.act.new", (Object[])new Object[0])});
                }
            };
            this.addButton((Widget)this.btsAdd[i]);
            this.btsAdd[i].setFGColor(TextFormatting.GREEN.func_211163_e());
            this.children.add(this.tfs[i]);
        }
        this.btsAdd[i] = new GuiValueButton<Integer>(this.width / 2 - 100, 21 + 21 * i % (this.elms * 21), 200, 20, "+", Integer.valueOf(i), b -> {
            this.values.add((Integer)b.getValue(), "");
            this.defineMenu();
        }){

            protected String getNarrationMessage() {
                return I18n.func_135052_a((String)"gui.narrate.button", (Object[])new Object[]{I18n.func_135052_a((String)"gui.act.new", (Object[])new Object[0])});
            }
        };
        this.addButton((Widget)this.btsAdd[i]);
        this.btsAdd[i].setFGColor(TextFormatting.GREEN.func_211163_e());
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = this.page * this.elms; i < (this.page + 1) * this.elms && i < this.tfs.length; ++i) {
            TextFieldWidget tf = this.tfs[i];
            GuiUtils.drawRightString(this.font, i + " : ", tf.x, tf.y, Color.WHITE.getRGB(), tf.getHeight());
            tf.render(mouseX, mouseY, partialTicks);
        }
    }

    public void init() {
        this.elms = (this.height - 42) / 21;
        this.defineMenu();
        super.init();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        for (int i = this.page * this.elms; i < (this.page + 1) * this.elms && i < this.values.size(); ++i) {
            this.tfs[i].func_146195_b(false);
            if (mouseButton != 1 || !GuiUtils.isHover(this.tfs[i], (int)mouseX, (int)mouseY)) continue;
            this.tfs[i].func_146180_a("");
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void tick() {
        int i;
        for (i = this.page * this.elms; i < (this.page + 1) * this.elms && i < this.values.size(); ++i) {
            this.values.set(i, this.tfs[i].func_146179_b());
        }
        for (i = 0; i < this.btsAdd.length; ++i) {
            if (i < (this.page + 1) * this.elms && i >= this.page * this.elms) {
                if (this.btsAdd[i] != null) {
                    this.btsAdd[i].visible = true;
                }
                if (i >= this.btsDel.length || this.btsDel[i] == null) continue;
                this.btsDel[i].visible = true;
                continue;
            }
            if (this.btsAdd[i] != null) {
                this.btsAdd[i].visible = false;
            }
            if (i >= this.btsDel.length || this.btsDel[i] == null) continue;
            this.btsDel[i].visible = false;
        }
        super.tick();
    }
}

