/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.utils;

import fr.atesab.act.ACTMod;
import fr.atesab.act.utils.ItemUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class ChatUtils {
    public static final char MODIFIER = '\u00a7';

    public static void error(String error) {
        ChatUtils.send(ChatUtils.getErrorPrefix().func_150258_a(error));
    }

    public static ITextComponent getErrorPrefix() {
        return ChatUtils.getPrefix(new StringTextComponent(I18n.func_135052_a((String)"gui.act.error", (Object[])new Object[0])).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), TextFormatting.WHITE);
    }

    public static ITextComponent getPrefix() {
        return ChatUtils.getPrefix(null, null);
    }

    private static ITextComponent getPrefix(ITextComponent notif, TextFormatting endColor) {
        ITextComponent p = new StringTextComponent("").func_150255_a(new Style().func_150238_a(endColor != null ? endColor : TextFormatting.WHITE)).func_150257_a(new StringTextComponent("[").func_150255_a(new Style().func_150238_a(TextFormatting.RED)).func_150257_a(new StringTextComponent("ACT-Mod").func_150255_a(new Style().func_150238_a(TextFormatting.GOLD))));
        if (notif != null) {
            p.func_150257_a(new StringTextComponent("/").func_150255_a(new Style().func_150238_a(TextFormatting.WHITE))).func_150257_a(notif);
        }
        return p.func_150257_a(new StringTextComponent("]").func_150255_a(new Style().func_150238_a(TextFormatting.RED))).func_150257_a((ITextComponent)new StringTextComponent(" "));
    }

    public static void itemStack(ItemStack itemStack) {
        if (itemStack != null) {
            CompoundNBT item = new CompoundNBT();
            item.func_74778_a("id", itemStack.func_77973_b().getRegistryName().toString());
            item.func_74768_a("Count", itemStack.func_190916_E());
            if (itemStack.func_77978_p() != null) {
                item.func_218657_a("tag", (INBT)itemStack.func_77978_p());
            }
            ChatUtils.send(ChatUtils.getPrefix().func_150257_a(new TranslationTextComponent("gui.act.give.msg", new Object[0]).func_150258_a(": ").func_211710_a(s -> s.func_150238_a(TextFormatting.GOLD)).func_150257_a(itemStack.func_200301_q().func_212638_h().func_211710_a(style -> {
                style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (ITextComponent)new StringTextComponent(item.toString())));
                style.func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + ACTMod.ACT_COMMAND.getName() + " " + ACTMod.ACT_COMMAND.SC_OPEN_GIVER.getName() + " " + ItemUtils.getGiveCode(itemStack)));
            }))));
        } else {
            ChatUtils.error(I18n.func_135052_a((String)"gui.act.give.fail2", (Object[])new Object[0]));
        }
    }

    public static void send(ITextComponent message) {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            Minecraft.func_71410_x().field_71439_g.func_145747_a(message);
        }
    }

    public static void show(String message) {
        ChatUtils.send(ChatUtils.getPrefix().func_150258_a(message));
    }
}

