/*
 * Decompiled with CFR 0.152.
 */
package com.ATE.ATEHUD.superclass;

import java.util.Arrays;

public class Explosion {
    private int Flicker = 0;
    private int Trail = 0;
    private int Type = 0;
    private int[] Colors = new int[]{0};
    private int[] FadeColors = new int[0];

    public String toString() {
        return "Explosion [Flicker=" + this.Flicker + ", Trail=" + this.Trail + ", Type=" + this.Type + ", Colors=" + Arrays.toString(this.Colors) + ", FadeColors=" + Arrays.toString(this.FadeColors) + "]";
    }

    public void setFlicker(int flicker) {
        this.Flicker = flicker;
    }

    public void setTrail(int trail) {
        this.Trail = trail;
    }

    public void setType(int type) {
        this.Type = type;
    }

    public void setColors(int[] colors) {
        this.Colors = colors;
    }

    public void setFadeColors(int[] fadecolors) {
    }

    public int getFlicker() {
        return this.Flicker;
    }

    public int getTrail() {
        return this.Trail;
    }

    public int getType() {
        return this.Type;
    }

    public int[] getColors() {
        return this.Colors;
    }

    public int[] getFadeColors() {
        return this.FadeColors;
    }

    public Explosion(int flicker, int trail, int type, int[] colors, int[] fadecolors) {
        this.Flicker = flicker;
        this.Trail = trail;
        this.Type = type;
        this.Colors = colors == new int[0] ? new int[]{Explosion.getColorWithRGB(255, 255, 255)} : colors;
        this.FadeColors = fadecolors;
    }

    public Explosion() {
        this.Flicker = 0;
        this.Trail = 0;
        this.Type = 0;
        this.Colors = new int[]{0xF0F0F0};
        this.FadeColors = new int[0];
    }

    public static int getColorWithRGB(int red, int green, int blue) {
        return blue + 256 * green + 65536 * red;
    }

    public static int hex2Rgb(String colorStr) {
        return Explosion.getColorWithRGB(Integer.valueOf(colorStr.substring(1, 3), 16), Integer.valueOf(colorStr.substring(3, 5), 16), Integer.valueOf(colorStr.substring(5, 7), 16));
    }

    public String getNBTExplosion() {
        if (this.Colors.length == 0) {
            this.Colors = new int[]{Explosion.getColorWithRGB(255, 255, 255)};
        }
        String outColors = "Colors:[" + this.Colors[0];
        for (int i = 1; i < this.Colors.length; ++i) {
            outColors = outColors + "," + this.Colors[i] + "";
        }
        outColors = outColors + "]";
        String outFadeColors = "";
        if (this.FadeColors.length != 0) {
            outFadeColors = ", FadeColors:[" + this.FadeColors[0];
            for (int j = 1; j < this.FadeColors.length; ++j) {
                outFadeColors = outFadeColors + "," + this.Colors[j] + "";
            }
            outFadeColors = outFadeColors + "]";
        }
        return "{Type:" + this.Type + ",Trail:" + this.Trail + ",Flicker:" + this.Flicker + ", " + outColors + outFadeColors + "}";
    }
}

