/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui.modifier;

import fr.atesab.act.ACTMod;
import fr.atesab.act.gui.modifier.GuiListModifier;
import fr.atesab.act.gui.selector.GuiButtonListSelector;
import fr.atesab.act.utils.GuiUtils;
import fr.atesab.act.utils.Tuple;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.text.translation.I18n;

public class GuiAttributeModifier
extends GuiListModifier<List<Tuple<EntityEquipmentSlot, AttributeModifier>>> {
    private final Supplier<GuiListModifier.ListElement> supplier = () -> new AttributeListElement(this, new Tuple<Object, AttributeModifier>(null, new AttributeModifier(SharedMonsterAttributes.field_188791_g.func_111108_a(), 0.0, 0)));

    public GuiAttributeModifier(GuiScreen parent, List<Tuple<EntityEquipmentSlot, AttributeModifier>> attr, Consumer<List<Tuple<EntityEquipmentSlot, AttributeModifier>>> setter) {
        super(parent, new ArrayList<GuiListModifier.ListElement>(), setter, new Tuple[0]);
        attr.forEach(tuple -> this.elements.add(new AttributeListElement(this, (Tuple<EntityEquipmentSlot, AttributeModifier>)tuple)));
        this.elements.add(new GuiListModifier.AddElementList(this, this.supplier));
    }

    @Override
    protected List<Tuple<EntityEquipmentSlot, AttributeModifier>> get() {
        ArrayList<Tuple<EntityEquipmentSlot, AttributeModifier>> result = new ArrayList<Tuple<EntityEquipmentSlot, AttributeModifier>>();
        this.elements.stream().filter(le -> le instanceof AttributeListElement).map(le -> (AttributeListElement)le).forEach(ale -> result.add(new Tuple<EntityEquipmentSlot, AttributeModifier>(((AttributeListElement)ale).slot, ((AttributeListElement)ale).getModifier())));
        return result;
    }

    static class AttributeListElement
    extends GuiListModifier.ListElement {
        private GuiTextField amount;
        private boolean errAmount = false;
        private double amountValue;
        private int operationValue;
        private String name;
        private EntityEquipmentSlot slot;
        private GuiListModifier<?> parent;
        private GuiButton slotButton;
        private GuiButton typeButton;
        private GuiButton operationButton;

        public AttributeListElement(GuiAttributeModifier parent, Tuple<EntityEquipmentSlot, AttributeModifier> tuple) {
            super(400, 50);
            this.parent = parent;
            this.slot = (EntityEquipmentSlot)tuple.a;
            this.name = ((AttributeModifier)tuple.b).func_111166_b();
            int l = 5 + this.fontRenderer.func_78256_a(net.minecraft.client.resources.I18n.func_135052_a((String)"gui.act.modifier.attr.amount", (Object[])new Object[0]) + " : ");
            this.amount = new GuiTextField(0, this.fontRenderer, 202 + l, 1, 154 - l, 18);
            this.amount.func_146203_f(8);
            this.amountValue = ((AttributeModifier)tuple.b).func_111164_d();
            this.amount.func_146180_a(String.valueOf(this.amountValue));
            this.operationValue = ((AttributeModifier)tuple.b).func_111169_c();
            this.slotButton = new GuiButton(0, 2, 0, 198, 20, "");
            this.buttonList.add(this.slotButton);
            this.typeButton = new GuiButton(1, 2, 21, 198, 20, "");
            this.buttonList.add(this.typeButton);
            this.operationButton = new GuiButton(2, 202, 21, 157, 20, "");
            this.buttonList.add(this.operationButton);
            this.buttonList.add(new GuiListModifier.RemoveElementButton(parent, 359, 0, 20, 20, this));
            this.buttonList.add(new GuiListModifier.AddElementButton(parent, 381, 0, 20, 20, this, parent.supplier));
            this.buttonList.add(new GuiListModifier.AddElementButton(parent, 359, 21, 43, 20, net.minecraft.client.resources.I18n.func_135052_a((String)"gui.act.give.copy", (Object[])new Object[0]), (GuiListModifier.ListElement)this, () -> new AttributeListElement(parent, new Tuple<EntityEquipmentSlot, AttributeModifier>(this.slot, this.getModifier()))));
            this.defineButtonText();
        }

        @Override
        protected void actionPerformed(GuiButton button) {
            switch (button.field_146127_k) {
                case 0: {
                    ArrayList slots = new ArrayList();
                    slots.add(new Tuple<String, Object>(net.minecraft.client.resources.I18n.func_135052_a((String)"gui.act.none", (Object[])new Object[0]), null));
                    for (EntityEquipmentSlot slot2 : (EntityEquipmentSlot[])EntityEquipmentSlot.class.getEnumConstants()) {
                        String s = I18n.func_74838_a((String)("item.modifiers." + slot2.func_188450_d()));
                        slots.add(new Tuple<String, EntityEquipmentSlot>(s.endsWith(":") ? s.substring(0, s.length() - 1) : s, slot2));
                    }
                    this.mc.func_147108_a(new GuiButtonListSelector<EntityEquipmentSlot>(this.parent, slots, slot -> {
                        this.slot = slot;
                        this.defineButtonText();
                        return null;
                    }));
                    break;
                }
                case 1: {
                    ArrayList attributes = new ArrayList();
                    ACTMod.getAttributes().forEach(atr -> attributes.add(new Tuple<String, IAttribute>(net.minecraft.client.resources.I18n.func_135052_a((String)("attribute.name." + atr.func_111108_a()), (Object[])new Object[0]), (IAttribute)atr)));
                    this.mc.func_147108_a(new GuiButtonListSelector<IAttribute>(this.parent, attributes, atr -> {
                        this.name = atr.func_111108_a();
                        this.defineButtonText();
                        return null;
                    }));
                    break;
                }
                case 2: {
                    ArrayList operations = new ArrayList();
                    operations.add(new Tuple<String, Integer>(net.minecraft.client.resources.I18n.func_135052_a((String)"gui.act.modifier.attr.operation.0", (Object[])new Object[0]) + " (0)", 0));
                    operations.add(new Tuple<String, Integer>(net.minecraft.client.resources.I18n.func_135052_a((String)"gui.act.modifier.attr.operation.1", (Object[])new Object[0]) + " (1)", 1));
                    operations.add(new Tuple<String, Integer>(net.minecraft.client.resources.I18n.func_135052_a((String)"gui.act.modifier.attr.operation.2", (Object[])new Object[0]) + " (2)", 2));
                    this.mc.func_147108_a(new GuiButtonListSelector<Integer>(this.parent, operations, i -> {
                        this.operationValue = i;
                        this.defineButtonText();
                        return null;
                    }));
                }
            }
            super.actionPerformed(button);
        }

        private void defineButtonText() {
            String s = this.slot == null ? net.minecraft.client.resources.I18n.func_135052_a((String)"gui.act.none", (Object[])new Object[0]) : I18n.func_74838_a((String)("item.modifiers." + this.slot.func_188450_d()));
            this.slotButton.field_146126_j = net.minecraft.client.resources.I18n.func_135052_a((String)"gui.act.modifier.attr.slot", (Object[])new Object[0]) + " - " + (s.endsWith(":") ? s.substring(0, s.length() - 1) : s);
            this.typeButton.field_146126_j = net.minecraft.client.resources.I18n.func_135052_a((String)"gui.act.modifier.attr.type", (Object[])new Object[0]) + " - " + net.minecraft.client.resources.I18n.func_135052_a((String)("attribute.name." + this.name), (Object[])new Object[0]);
            this.operationButton.field_146126_j = net.minecraft.client.resources.I18n.func_135052_a((String)"gui.act.modifier.attr.operation", (Object[])new Object[0]) + " - " + net.minecraft.client.resources.I18n.func_135052_a((String)("gui.act.modifier.attr.operation." + this.operationValue), (Object[])new Object[0]) + " (" + this.operationValue + ")";
        }

        @Override
        public void draw(int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
            GuiUtils.drawRelative(this.amount, offsetX, offsetY);
            GuiUtils.drawRightString(this.fontRenderer, net.minecraft.client.resources.I18n.func_135052_a((String)"gui.act.modifier.attr.amount", (Object[])new Object[0]) + " : ", this.amount, (this.errAmount ? Color.RED : Color.WHITE).getRGB(), offsetX, offsetY);
            super.draw(offsetX, offsetY, mouseX, mouseY, partialTicks);
        }

        private AttributeModifier getModifier() {
            return new AttributeModifier(this.name, this.amountValue, this.operationValue);
        }

        @Override
        public void init() {
            this.amount.func_146195_b(false);
        }

        @Override
        public boolean isFocused() {
            return this.amount.func_146206_l();
        }

        @Override
        public void keyTyped(char typedChar, int keyCode) {
            this.amount.func_146201_a(typedChar, keyCode);
            super.keyTyped(typedChar, keyCode);
        }

        @Override
        public boolean match(String search) {
            return this.slotButton.field_146126_j.toLowerCase().contains(search.toLowerCase()) || this.typeButton.field_146126_j.toLowerCase().contains(search.toLowerCase()) || this.operationButton.field_146126_j.toLowerCase().contains(search.toLowerCase());
        }

        @Override
        public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
            this.amount.func_146192_a(mouseX, mouseY, mouseButton);
            if (mouseButton == 1 && GuiUtils.isHover(this.amount, mouseX, mouseY)) {
                this.amount.func_146180_a("");
            }
            super.mouseClicked(mouseX, mouseY, mouseButton);
        }

        @Override
        public void update() {
            this.amount.func_146178_a();
            try {
                this.amountValue = this.amount.func_146179_b().isEmpty() ? 0.0 : Double.parseDouble(this.amount.func_146179_b());
                this.errAmount = false;
            }
            catch (NumberFormatException e) {
                this.errAmount = true;
            }
            super.update();
        }
    }
}

