/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui.modifier;

import fr.atesab.act.gui.modifier.GuiModifier;
import fr.atesab.act.utils.GuiUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.config.GuiSlider;

public class GuiColorModifier
extends GuiModifier<Integer> {
    private final ResourceLocation PICKER = new ResourceLocation("textures/gui/picker.png");
    private BufferedImage pickerImage;
    private int color;
    private boolean drag;
    private boolean advanced = false;
    private GuiButton advButton;
    private GuiTextField tfr;
    private GuiTextField tfg;
    private GuiTextField tfb;
    private GuiTextField intColor;
    private GuiTextField hexColor;
    private GuiSlider r;
    private GuiSlider g;
    private GuiSlider b;
    private int defaultColor;

    public GuiColorModifier(GuiScreen parent, Consumer<Integer> setter, int color) {
        this(parent, setter, color, 10511680);
    }

    public GuiColorModifier(GuiScreen parent, Consumer<Integer> setter, int color, int defaultColor) {
        super(parent, setter);
        this.color = color > 0xFFFFFF ? color - -16777216 : color;
        this.defaultColor = defaultColor;
        try {
            this.pickerImage = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(this.PICKER).func_110527_b());
        }
        catch (Exception e) {
            this.pickerImage = new BufferedImage(200, 200, 2);
        }
    }

    public void func_73876_c() {
        this.tfr.func_146178_a();
        this.tfg.func_146178_a();
        this.tfb.func_146178_a();
        this.hexColor.func_146178_a();
        this.intColor.func_146178_a();
        this.g.field_146125_m = this.b.field_146125_m = this.advanced;
        this.r.field_146125_m = this.b.field_146125_m;
        this.advButton.packedFGColour = this.b.field_146125_m ? -1 : -5592406;
        super.func_73876_c();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 0: {
                this.set(this.color);
            }
            case 1: {
                this.field_146297_k.func_147108_a(this.parent);
                break;
            }
            case 2: {
                this.advanced = !this.advanced;
            }
        }
        super.func_146284_a(button);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        if (!this.advanced) {
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(this.PICKER);
            GuiColorModifier.func_152125_a((int)(this.field_146294_l / 2 - 100), (int)(this.field_146295_m / 2 - 80), (float)0.0f, (float)0.0f, (int)200, (int)200, (int)200, (int)160, (float)200.0f, (float)200.0f);
        } else {
            GuiColorModifier.func_73734_a((int)(this.field_146294_l / 2 - 100), (int)(this.field_146295_m / 2 - 80), (int)(this.field_146294_l / 2 + 100), (int)(this.field_146295_m / 2 + 80), (int)-1728053248);
        }
        if (this.advanced) {
            GuiUtils.drawString(this.field_146289_q, I18n.func_135052_a((String)"gui.act.red", (Object[])new Object[0]) + ":", this.r.field_146128_h + 1, this.r.field_146129_i - 10, -1, 10);
            this.tfr.func_146194_f();
            GuiUtils.drawString(this.field_146289_q, I18n.func_135052_a((String)"gui.act.green", (Object[])new Object[0]) + ":", this.g.field_146128_h + 1, this.g.field_146129_i - 10, -1, 10);
            this.tfg.func_146194_f();
            GuiUtils.drawString(this.field_146289_q, I18n.func_135052_a((String)"gui.act.blue", (Object[])new Object[0]) + ":", this.b.field_146128_h + 1, this.b.field_146129_i - 10, -1, 10);
            this.tfb.func_146194_f();
            GuiUtils.drawString(this.field_146289_q, I18n.func_135052_a((String)"gui.act.modifier.meta.setColor.intColor", (Object[])new Object[0]) + ":", this.intColor.field_146209_f - 1, this.intColor.field_146210_g - 11, -1, 10);
            GuiUtils.drawString(this.field_146289_q, I18n.func_135052_a((String)"gui.act.modifier.meta.setColor.hexColor", (Object[])new Object[0]) + ":", this.hexColor.field_146209_f - 1, this.hexColor.field_146210_g - 11, -1, 10);
            this.intColor.func_146194_f();
            this.hexColor.func_146194_f();
        }
        if (this.color >= 0) {
            GuiColorModifier.func_73734_a((int)(this.field_146294_l / 2 - 120), (int)(this.field_146295_m / 2 - 100), (int)(this.field_146294_l / 2 + 120), (int)(this.field_146295_m / 2 - 80), (int)(this.color + -16777216));
        }
        Runnable show = () -> {};
        for (int i = 0; i < ItemDye.field_150922_c.length; ++i) {
            int x = this.field_146294_l / 2 - 120 + i % 2 * 220;
            int y = this.field_146295_m / 2 - 80 + i / 2 * 20;
            GuiColorModifier.func_73734_a((int)x, (int)y, (int)(x + 20), (int)(y + 20), (int)(-16777216 + ItemDye.field_150922_c[i]));
            if (GuiUtils.isHover(x, y, 20, 20, mouseX, mouseY)) {
                int j = i;
                show = () -> GuiUtils.drawTextBox(this.field_146289_q, mouseX, mouseY, this.field_146294_l, this.field_146295_m, this.field_73735_i, I18n.func_135052_a((String)("item.fireworksCharge." + EnumDyeColor.func_176766_a((int)j).func_176762_d()), (Object[])new Object[0]));
            }
            GuiUtils.drawItemStack(this.field_146296_j, this.field_73735_i, this, new ItemStack(Items.field_151100_aR, 1, i), x + 2, y + 2);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        show.run();
    }

    public void func_73866_w_() {
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 120, this.field_146295_m / 2 + 81, 80, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.advButton = new GuiButton(2, this.field_146294_l / 2 - 38, this.field_146295_m / 2 + 81, 80, 20, I18n.func_135052_a((String)"gui.act.advanced", (Object[])new Object[0]));
        this.field_146292_n.add(this.advButton);
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 43, this.field_146295_m / 2 + 81, 79, 20, I18n.func_135052_a((String)"gui.act.cancel", (Object[])new Object[0])));
        GuiSlider.ISlider changer = new GuiSlider.ISlider(){

            public void onChangeSliderValue(GuiSlider slider) {
                switch (slider.field_146127_k) {
                    case 3: {
                        GuiColorModifier.this.updateRed(slider.getValueInt());
                        break;
                    }
                    case 4: {
                        GuiColorModifier.this.updateGreen(slider.getValueInt());
                        break;
                    }
                    case 5: {
                        GuiColorModifier.this.updateBlue(slider.getValueInt());
                    }
                }
            }
        };
        this.r = new GuiSlider(3, this.field_146294_l / 2 - 99, this.field_146295_m / 2 - 70, 158, 20, I18n.func_135052_a((String)"gui.act.red", (Object[])new Object[0]), "", 0.0, 255.0, (double)(this.color >> 16 & 0xFF), false, false, changer);
        this.field_146292_n.add(this.r);
        this.tfr = new GuiTextField(0, this.field_146289_q, this.r.field_146128_h + this.r.field_146120_f + 2, this.r.field_146129_i + 1, 36, 18);
        this.g = new GuiSlider(4, this.field_146294_l / 2 - 99, this.field_146295_m / 2 - 38, 158, 20, I18n.func_135052_a((String)"gui.act.green", (Object[])new Object[0]), "", 0.0, 255.0, (double)(this.color >> 8 & 0xFF), false, false, changer);
        this.field_146292_n.add(this.g);
        this.tfg = new GuiTextField(0, this.field_146289_q, this.g.field_146128_h + this.g.field_146120_f + 2, this.g.field_146129_i + 1, 36, 18);
        this.b = new GuiSlider(5, this.field_146294_l / 2 - 99, this.field_146295_m / 2 - 3, 158, 20, I18n.func_135052_a((String)"gui.act.blue", (Object[])new Object[0]), "", 0.0, 255.0, (double)(this.color >> 0 & 0xFF), false, false, changer);
        this.field_146292_n.add(this.b);
        this.tfb = new GuiTextField(0, this.field_146289_q, this.b.field_146128_h + this.b.field_146120_f + 2, this.b.field_146129_i + 1, 36, 18);
        this.intColor = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 97, this.field_146295_m / 2 + 28, 194, 18);
        this.hexColor = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 97, this.field_146295_m / 2 + 60, 194, 18);
        this.tfr.func_146203_f(4);
        this.tfg.func_146203_f(4);
        this.tfb.func_146203_f(4);
        this.b.field_146125_m = false;
        this.g.field_146125_m = false;
        this.r.field_146125_m = false;
        this.updateColor(this.color);
        super.func_73866_w_();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.advanced) {
            this.tfr.func_146201_a(typedChar, keyCode);
            this.tfg.func_146201_a(typedChar, keyCode);
            this.tfb.func_146201_a(typedChar, keyCode);
            this.hexColor.func_146201_a(typedChar, keyCode);
            this.intColor.func_146201_a(typedChar, keyCode);
            if (this.tfr.func_146206_l()) {
                try {
                    this.updateRed(this.tfr.func_146179_b().isEmpty() ? 0 : Integer.valueOf(this.tfr.func_146179_b()));
                }
                catch (Exception exception) {}
            } else if (this.tfg.func_146206_l()) {
                try {
                    this.updateGreen(this.tfg.func_146179_b().isEmpty() ? 0 : Integer.valueOf(this.tfg.func_146179_b()));
                }
                catch (Exception exception) {}
            } else if (this.tfb.func_146206_l()) {
                try {
                    this.updateBlue(this.tfb.func_146179_b().isEmpty() ? 0 : Integer.valueOf(this.tfb.func_146179_b()));
                }
                catch (Exception exception) {}
            } else if (this.hexColor.func_146206_l()) {
                try {
                    String s = this.hexColor.func_146179_b().substring(1);
                    this.updateColor(s.isEmpty() ? 0 : Integer.valueOf(s, 16));
                }
                catch (Exception exception) {}
            } else if (this.intColor.func_146206_l()) {
                try {
                    this.updateColor(this.intColor.func_146179_b().isEmpty() ? 0 : Integer.valueOf(this.intColor.func_146179_b()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.advanced) {
            if (mouseButton == 1) {
                if (GuiUtils.isHover(this.tfr, mouseX, mouseY)) {
                    this.tfr.func_146180_a("");
                } else if (GuiUtils.isHover(this.tfg, mouseX, mouseY)) {
                    this.tfg.func_146180_a("");
                } else if (GuiUtils.isHover(this.tfb, mouseX, mouseY)) {
                    this.tfb.func_146180_a("");
                } else if (GuiUtils.isHover(this.intColor, mouseX, mouseY)) {
                    this.intColor.func_146180_a("");
                } else if (GuiUtils.isHover(this.hexColor, mouseX, mouseY)) {
                    this.hexColor.func_146180_a("#");
                }
            }
            this.tfr.func_146192_a(mouseX, mouseY, mouseButton);
            this.tfg.func_146192_a(mouseX, mouseY, mouseButton);
            this.tfb.func_146192_a(mouseX, mouseY, mouseButton);
            this.intColor.func_146192_a(mouseX, mouseY, mouseButton);
            this.hexColor.func_146192_a(mouseX, mouseY, mouseButton);
        }
        this.drag = false;
        if (!this.advanced && GuiUtils.isHover(this.field_146294_l / 2 - 100, this.field_146295_m / 2 - 80, 200, 160, mouseX, mouseY)) {
            this.setColor(mouseX, mouseY);
            this.drag = true;
        } else if (GuiUtils.isHover(this.field_146294_l / 2 - 120, this.field_146295_m / 2 - 100, 240, 20, mouseX, mouseY)) {
            this.updateColor(this.defaultColor);
        } else {
            for (int i = 0; i < ItemDye.field_150922_c.length; ++i) {
                if (!GuiUtils.isHover(this.field_146294_l / 2 - 120 + i % 2 * 220, this.field_146295_m / 2 - 80 + i / 2 * 20, 20, 20, mouseX, mouseY)) continue;
                this.updateColor(ItemDye.field_150922_c[i]);
            }
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.drag) {
            this.setColor(mouseX, mouseY);
        }
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    private void updateColor(int value) {
        this.color = value == this.defaultColor ? value : MathHelper.func_76125_a((int)value, (int)0, (int)0xFFFFFF);
        int r = this.color >> 16 & 0xFF;
        int g = this.color >> 8 & 0xFF;
        int b = this.color >> 0 & 0xFF;
        this.r.setValue((double)r);
        this.g.setValue((double)g);
        this.b.setValue((double)b);
        this.tfr.func_146180_a("" + r);
        this.tfg.func_146180_a("" + g);
        this.tfb.func_146180_a("" + b);
        this.intColor.func_146180_a("" + this.color);
        String s = Integer.toHexString(this.color);
        this.hexColor.func_146180_a("#" + s);
    }

    private void setColor(int mouseX, int mouseY) {
        int rx = MathHelper.func_76125_a((int)(mouseX - (this.field_146294_l / 2 - 100)), (int)0, (int)199);
        int ry = MathHelper.func_76125_a((int)(MathHelper.func_76125_a((int)(mouseY - (this.field_146295_m / 2 - 100)), (int)0, (int)160) * 20 / 16), (int)0, (int)199);
        int[] data = new int[3];
        this.pickerImage.getRaster().getPixel(rx, ry, data);
        this.updateColor((data[0] & 0xFF) << 16 | (data[1] & 0xFF) << 8 | (data[2] & 0xFF) << 0);
    }

    private void updateRed(int v) {
        v = MathHelper.func_76125_a((int)v, (int)0, (int)255);
        this.updateColor((v & 0xFF) << 16 | (this.color >> 8 & 0xFF & 0xFF) << 8 | (this.color >> 0 & 0xFF & 0xFF) << 0);
    }

    private void updateGreen(int v) {
        v = MathHelper.func_76125_a((int)v, (int)0, (int)255);
        this.updateColor((this.color >> 16 & 0xFF & 0xFF) << 16 | (v & 0xFF) << 8 | (this.color >> 0 & 0xFF & 0xFF) << 0);
    }

    private void updateBlue(int v) {
        v = MathHelper.func_76125_a((int)v, (int)0, (int)255);
        this.updateColor((this.color >> 16 & 0xFF & 0xFF) << 16 | (this.color >> 8 & 0xFF & 0xFF) << 8 | (v & 0xFF) << 0);
    }
}

