/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.command.node;

import fr.atesab.act.command.node.SubCommand;
import fr.atesab.act.utils.ChatUtils;
import fr.atesab.act.utils.CommandUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public abstract class MainCommand
implements ICommand {
    public List<SubCommand> subCommands = new ArrayList<SubCommand>();
    public String defaultCommand;

    public MainCommand(List<SubCommand> subCommands2, String defaultCommand) {
        this.subCommands = subCommands2;
        this.defaultCommand = defaultCommand;
    }

    public boolean canCommandSenderUseCommand(ICommandSender sender) {
        return true;
    }

    public int compareTo(ICommand p_compareTo_1_) {
        return this.func_71517_b().compareTo(p_compareTo_1_.func_71517_b());
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        Minecraft mc = Minecraft.func_71410_x();
        if (args.length == 0) {
            args = new String[]{this.defaultCommand};
        }
        for (int i = 0; i < this.subCommands.size(); ++i) {
            ArrayList<String> alias = this.subCommands.get(i).getAlias();
            alias = alias == null ? new ArrayList<String>() : alias;
            if (!alias.contains(this.subCommands.get(i).getName())) {
                alias.add(this.subCommands.get(i).getName());
            }
            for (int j = 0; j < alias.size(); ++j) {
                if (!args[0].equals(alias.get(j))) continue;
                String[] SCargs = new String[args.length - 1];
                System.arraycopy(args, 1, SCargs, 0, SCargs.length);
                this.subCommands.get(i).processSubCommand(sender, SCargs, this);
                return;
            }
        }
        ChatUtils.send(new TextComponentString(I18n.func_135052_a((String)"cmd.act.mc.invalid", (Object[])new Object[]{"/" + this.func_71517_b() + " " + this.defaultCommand}).replaceAll("::", " ")).func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + this.func_71517_b() + " " + this.defaultCommand)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new TextComponentString(I18n.func_135052_a((String)"cmd.act.help.do", (Object[])new Object[0])).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE)))).func_150238_a(TextFormatting.RED)));
    }

    public abstract List<String> func_71514_a();

    public abstract String func_71517_b();

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        int j;
        List<String> alias;
        int i;
        ArrayList<String> ls = new ArrayList<String>();
        this.subCommands.sort(new Comparator<SubCommand>(){

            @Override
            public int compare(SubCommand o1, SubCommand o2) {
                return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
            }
        });
        for (i = 0; i < this.subCommands.size(); ++i) {
            alias = this.subCommands.get(i).getAlias();
            if (!alias.contains(this.subCommands.get(i).getName())) {
                alias.add(this.subCommands.get(i).getName());
            }
            for (j = 0; j < alias.size(); ++j) {
                if (!args[0].equals(alias.get(j))) continue;
                String[] SCargs = new String[args.length - 1];
                System.arraycopy(args, 1, SCargs, 0, SCargs.length);
                return this.subCommands.get(i).addTabCompletionOptions(sender, SCargs, targetPos);
            }
        }
        for (i = 0; i < this.subCommands.size(); ++i) {
            alias = this.subCommands.get(i).getAlias();
            if (!alias.contains(this.subCommands.get(i).getName())) {
                alias.add(this.subCommands.get(i).getName());
            }
            for (j = 0; j < alias.size(); ++j) {
                ls.add(alias.get(j));
            }
        }
        if (args.length == 1) {
            return CommandUtils.getTabCompletion(ls, args);
        }
        return new ArrayList<String>();
    }

    public abstract String func_71518_a(ICommandSender var1);

    public boolean func_82358_a(String[] args, int index) {
        return index > 1;
    }

    public void registerSubCommand(SubCommand SubCommand2) {
        this.subCommands.add(SubCommand2);
    }

    public void sort() {
        this.subCommands.sort(SubCommand::compareTo);
    }

    public void unregisterSubCommand(SubCommand SubCommand2) {
        this.subCommands.remove(SubCommand2);
    }
}

