/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui.modifier;

import fr.atesab.act.gui.modifier.GuiColorModifier;
import fr.atesab.act.gui.modifier.GuiListModifier;
import fr.atesab.act.gui.selector.GuiButtonListSelector;
import fr.atesab.act.utils.GuiUtils;
import fr.atesab.act.utils.ItemUtils;
import fr.atesab.act.utils.Tuple;
import java.awt.Color;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;

public class GuiPotionModifier
extends GuiListModifier<ItemUtils.PotionInformation> {
    private int customColor = -1;
    private PotionType main;
    private final Supplier<GuiListModifier.ListElement> supplier = () -> new CustomPotionListElement(this, new PotionEffect((Potion)Potion.field_188414_b.func_148754_a(1)));

    public GuiPotionModifier(GuiScreen parent, Consumer<ItemUtils.PotionInformation> setter, ItemUtils.PotionInformation info) {
        super(parent, new ArrayList<GuiListModifier.ListElement>(), setter, new Tuple[0]);
        this.customColor = info.getCustomColor();
        this.main = info.getMain();
        this.elements.add(new MainPotionListElement(this));
        info.getCustomEffects().forEach(t -> this.elements.add(new CustomPotionListElement(this, (PotionEffect)t)));
        this.elements.add(new GuiListModifier.AddElementList(this, this.supplier));
    }

    @Override
    protected ItemUtils.PotionInformation get() {
        ArrayList<PotionEffect> customEffects = new ArrayList<PotionEffect>();
        this.elements.stream().filter(le -> le instanceof CustomPotionListElement).map(le -> (CustomPotionListElement)le).forEach(cpl -> customEffects.add(cpl.getEffect()));
        return new ItemUtils.PotionInformation(this.customColor, this.main, customEffects);
    }

    private static class MainPotionListElement
    extends GuiListModifier.ListElement {
        private GuiPotionModifier parent;
        private GuiButton type;

        private static String getPotionName(PotionType pot) {
            String name = pot.func_185174_b("");
            return name + (pot.getRegistryName().toString().contains("long_") ? " (" + I18n.func_135052_a((String)"gui.act.modifier.meta.potion.long", (Object[])new Object[0]) + ")" : (pot.getRegistryName().toString().contains("strong_") ? " II" : ""));
        }

        public MainPotionListElement(GuiPotionModifier parent) {
            super(400, 29);
            this.parent = parent;
            this.buttonList.add(new GuiButton(0, 0, 0, I18n.func_135052_a((String)"gui.act.modifier.meta.setColor", (Object[])new Object[0])));
            this.type = new GuiButton(1, 201, 0, 199, 20, "");
            this.buttonList.add(this.type);
            this.defineButton();
        }

        @Override
        protected void actionPerformed(GuiButton button) {
            switch (button.field_146127_k) {
                case 0: {
                    this.mc.func_147108_a((GuiScreen)new GuiColorModifier(this.parent, i -> this.parent.customColor = i, this.parent.customColor, -1));
                    break;
                }
                case 1: {
                    ArrayList pots = new ArrayList();
                    PotionType.field_185176_a.forEach(type -> pots.add(new Tuple<String, PotionType>(MainPotionListElement.getPotionName(type), (PotionType)type)));
                    this.mc.func_147108_a(new GuiButtonListSelector<PotionType>(this.parent, pots, pot -> {
                        this.parent.main = pot;
                        this.defineButton();
                        return null;
                    }));
                }
            }
            super.actionPerformed(button);
        }

        private void defineButton() {
            this.type.field_146126_j = I18n.func_135052_a((String)"gui.act.modifier.meta.potion.type", (Object[])new Object[0]) + " (" + MainPotionListElement.getPotionName(this.parent.main) + ")";
        }
    }

    private static class CustomPotionListElement
    extends GuiListModifier.ListElement {
        private GuiPotionModifier parent;
        private PotionEffect effect;
        private GuiTextField duration;
        private GuiTextField amplifier;
        private boolean errDur = false;
        private boolean errAmp = false;
        private GuiButton type;
        private GuiButton ambient;
        private GuiButton showParticles;

        public CustomPotionListElement(GuiPotionModifier parent, PotionEffect effect) {
            super(400, 50);
            this.parent = parent;
            this.effect = effect;
            int l = 5 + Math.max(this.fontRenderer.func_78256_a(I18n.func_135052_a((String)"gui.act.modifier.meta.potion.duration", (Object[])new Object[0]) + " : "), this.fontRenderer.func_78256_a(I18n.func_135052_a((String)"gui.act.modifier.meta.potion.amplifier", (Object[])new Object[0]) + " : "));
            this.duration = new GuiTextField(0, this.fontRenderer, l, 1, 150 - l, 18);
            this.duration.func_146180_a(String.valueOf(effect.func_76459_b()));
            this.amplifier = new GuiTextField(0, this.fontRenderer, l, 22, 150 - l, 18);
            this.amplifier.func_146180_a(String.valueOf(effect.func_76458_c()));
            this.type = new GuiButton(0, 153, 0, I18n.func_135052_a((String)"gui.act.modifier.meta.potion.type", (Object[])new Object[0]));
            this.buttonList.add(this.type);
            this.ambient = new GuiButton(1, 153, 21, 100, 20, I18n.func_135052_a((String)"gui.act.modifier.meta.potion.ambient", (Object[])new Object[0]));
            this.buttonList.add(this.ambient);
            this.showParticles = new GuiButton(2, 255, 21, 99, 20, I18n.func_135052_a((String)"gui.act.modifier.meta.potion.showParticles", (Object[])new Object[0]));
            this.buttonList.add(this.showParticles);
            this.buttonList.add(new GuiListModifier.RemoveElementButton(parent, 355, 0, 20, 20, this));
            this.buttonList.add(new GuiListModifier.AddElementButton(parent, 377, 0, 20, 20, this, parent.supplier));
            this.buttonList.add(new GuiListModifier.AddElementButton(parent, 355, 21, 43, 20, I18n.func_135052_a((String)"gui.act.give.copy", (Object[])new Object[0]), (GuiListModifier.ListElement)this, () -> new CustomPotionListElement(parent, this.getEffect())));
            this.setButtonText();
        }

        @Override
        protected void actionPerformed(GuiButton button) {
            switch (button.field_146127_k) {
                case 0: {
                    ArrayList pots = new ArrayList();
                    Potion.field_188414_b.forEach(pot -> pots.add(new Tuple<String, Potion>(I18n.func_135052_a((String)pot.func_76393_a(), (Object[])new Object[0]), (Potion)pot)));
                    this.mc.func_147108_a(new GuiButtonListSelector<Potion>(this.parent, pots, pot -> {
                        this.effect = new PotionEffect(pot, this.effect.func_76459_b(), this.effect.func_76458_c(), this.effect.func_82720_e(), this.effect.func_188418_e());
                        this.setButtonText();
                        return null;
                    }));
                    break;
                }
                case 1: {
                    this.effect = new PotionEffect(this.effect.func_188419_a(), this.effect.func_76459_b(), this.effect.func_76458_c(), !this.effect.func_82720_e(), this.effect.func_188418_e());
                    break;
                }
                case 2: {
                    this.effect = new PotionEffect(this.effect.func_188419_a(), this.effect.func_76459_b(), this.effect.func_76458_c(), this.effect.func_82720_e(), !this.effect.func_188418_e());
                }
            }
            this.setButtonText();
            super.actionPerformed(button);
        }

        @Override
        public void draw(int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
            GuiUtils.drawRelative(this.amplifier, offsetX, offsetY);
            GuiUtils.drawRelative(this.duration, offsetX, offsetY);
            GuiUtils.drawRightString(this.fontRenderer, I18n.func_135052_a((String)"gui.act.modifier.meta.potion.duration", (Object[])new Object[0]) + " : ", this.duration, (this.errDur ? Color.RED : Color.WHITE).getRGB(), offsetX, offsetY);
            GuiUtils.drawRightString(this.fontRenderer, I18n.func_135052_a((String)"gui.act.modifier.meta.potion.amplifier", (Object[])new Object[0]) + " : ", this.amplifier, (this.errAmp ? Color.RED : Color.WHITE).getRGB(), offsetX, offsetY);
            super.draw(offsetX, offsetY, mouseX, mouseY, partialTicks);
        }

        public PotionEffect getEffect() {
            return new PotionEffect(this.effect);
        }

        @Override
        public void init() {
            this.amplifier.func_146195_b(false);
            this.duration.func_146195_b(false);
            super.init();
        }

        @Override
        public boolean isFocused() {
            return this.amplifier.func_146206_l() || this.duration.func_146206_l();
        }

        @Override
        public void keyTyped(char typedChar, int keyCode) {
            this.amplifier.func_146201_a(typedChar, keyCode);
            this.duration.func_146201_a(typedChar, keyCode);
            super.keyTyped(typedChar, keyCode);
        }

        @Override
        public boolean match(String search) {
            return I18n.func_135052_a((String)this.effect.func_188419_a().func_76393_a(), (Object[])new Object[0]).toLowerCase().contains(search.toLowerCase());
        }

        @Override
        public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
            this.amplifier.func_146192_a(mouseX, mouseY, mouseButton);
            this.duration.func_146192_a(mouseX, mouseY, mouseButton);
            super.mouseClicked(mouseX, mouseY, mouseButton);
        }

        private void setButtonText() {
            this.type.field_146126_j = I18n.func_135052_a((String)"gui.act.modifier.meta.potion.type", (Object[])new Object[0]) + " (" + I18n.func_135052_a((String)this.effect.func_188419_a().func_76393_a(), (Object[])new Object[0]) + ")";
            this.ambient.packedFGColour = GuiUtils.getRedGreen(this.effect.func_82720_e());
            this.showParticles.packedFGColour = GuiUtils.getRedGreen(this.effect.func_188418_e());
        }

        @Override
        public void update() {
            this.amplifier.func_146178_a();
            this.duration.func_146178_a();
            int dur = this.effect.func_76459_b();
            int amp = this.effect.func_76458_c();
            try {
                dur = Integer.valueOf(this.duration.func_146179_b());
                this.errAmp = false;
            }
            catch (Exception e) {
                this.errAmp = true;
            }
            try {
                int i = Integer.valueOf(this.amplifier.func_146179_b());
                this.errAmp = i < -128 || i > 127;
                if (!this.errAmp) {
                    amp = i;
                }
            }
            catch (Exception e) {
                this.errAmp = true;
            }
            this.effect = new PotionEffect(this.effect.func_188419_a(), dur, amp, this.effect.func_82720_e(), this.effect.func_188418_e());
            super.update();
        }
    }
}

