/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act;

import fr.atesab.act.AdvancedCreativeTab;
import fr.atesab.act.AdvancedItem;
import fr.atesab.act.StringModifier;
import fr.atesab.act.command.ACTCommand;
import fr.atesab.act.command.SimpleCommand;
import fr.atesab.act.gui.GuiGiver;
import fr.atesab.act.gui.GuiMenu;
import fr.atesab.act.gui.modifier.GuiModifier;
import fr.atesab.act.gui.modifier.nbt.GuiNBTModifier;
import fr.atesab.act.gui.selector.GuiButtonListSelector;
import fr.atesab.act.utils.ChatUtils;
import fr.atesab.act.utils.CommandUtils;
import fr.atesab.act.utils.ItemUtils;
import fr.atesab.act.utils.Tuple;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;

@Mod(name="Advanced Creative 2", version="2.1", canBeDeactivated=false, guiFactory="fr.atesab.act.gui.ModGuiFactory", modid="act", clientSideOnly=true, acceptedMinecraftVersions="[1.12.2]")
public class ACTMod {
    public static final String MOD_ID = "act";
    public static final String MOD_NAME = "Advanced Creative 2";
    public static final String MOD_VERSION = "2.1";
    public static final String MOD_LITTLE_NAME = "ACT-Mod";
    public static final String MOD_FACTORY = "fr.atesab.act.gui.ModGuiFactory";
    public static final ACTCommand ACT_COMMAND = new ACTCommand();
    public static final AdvancedItem ADVANCED_ITEM = new AdvancedItem();
    public static final AdvancedCreativeTab ADVANCED_CREATIVE_TAB = new AdvancedCreativeTab();
    public static final String TEMPLATE_TAG_NAME = "TemplateData";
    public static final String[] DEFAULT_CUSTOM_ITEMS = new String[]{ItemUtils.getGiveCode(ItemUtils.buildStack(Blocks.field_150325_L, 42, 2, TextFormatting.LIGHT_PURPLE + "Pink verity", new String[]{"" + TextFormatting.GOLD + TextFormatting.BOLD + "42 is life", "" + TextFormatting.GOLD + TextFormatting.BOLD + "wait what ?"}, new Tuple[0]))};
    private static final Logger LOGGER = LogManager.getLogger((String)"act".toUpperCase());
    private static KeyBinding giver;
    private static KeyBinding menu;
    private static KeyBinding edit;
    private static List<String> customItems;
    private static List<ItemStack> templates;
    private static HashSet<IAttribute> attributes;
    private static Map<String, Map<String, Consumer<StringModifier>>> stringModifier;
    private static Configuration config;

    private static <T> void forEachMatchIn(Object obj, Class<T> cls, Consumer<T> consumer) {
        for (Field field : obj.getClass().getDeclaredFields()) {
            if (!field.getType().equals(cls)) continue;
            field.setAccessible(true);
            try {
                consumer.accept(field.get(obj));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static HashSet<IAttribute> getAttributes() {
        return attributes;
    }

    public static List<String> getCustomItems() {
        return customItems;
    }

    public static Map<String, Map<String, Consumer<StringModifier>>> getStringModifier() {
        return stringModifier;
    }

    public static String getTemplateData(ItemStack template) {
        return ItemUtils.getCustomTag(template, TEMPLATE_TAG_NAME, null);
    }

    public static Stream<ItemStack> getTemplates() {
        return templates.stream().map(is -> {
            String lang = ItemUtils.getCustomTag(is, "TemplateDataLang", null);
            return is.func_77946_l().func_151001_c(TextFormatting.AQUA + (lang != null ? I18n.func_135052_a((String)lang, (Object[])new Object[0]) : is.func_82833_r()));
        });
    }

    public static void registerStringModifier(String name, Consumer<StringModifier> modifier) {
        ACTMod.registerStringModifier(name, "", modifier);
    }

    public static void registerStringModifier(String name, String category, Consumer<StringModifier> modifier) {
        Map<String, Consumer<StringModifier>> map = stringModifier.get(category);
        if (map == null) {
            map = new HashMap<String, Consumer<StringModifier>>();
            stringModifier.put(category, map);
        }
        map.put(name, modifier);
    }

    public static void registerTemplate(String lang, ItemStack icon, String data) {
        templates.add(ItemUtils.setCustomTag(ItemUtils.setCustomTag(icon.func_77946_l(), TEMPLATE_TAG_NAME, data), "TemplateDataLang", lang));
    }

    public static void saveConfigs() {
        config.get("general", "customItems", DEFAULT_CUSTOM_ITEMS).set(customItems.toArray(new String[customItems.size()]));
        config.save();
    }

    public static void syncConfigs() {
        customItems = new ArrayList<String>(Arrays.asList(config.getStringList("customItems", "general", DEFAULT_CUSTOM_ITEMS, "", null, "config.act.custom")));
        config.save();
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent ev) {
        if (giver.func_151468_f()) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiGiver(null));
        } else if (menu.func_151468_f()) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiMenu(null));
        } else if (edit.func_151468_f()) {
            try {
                ACTMod.ACT_COMMAND.SC_EDIT.processSubCommand(null, null, null);
            }
            catch (CommandException e) {
                ChatUtils.error(((Object)((Object)e)).getClass().getName() + ": " + e.getMessage());
            }
        }
    }

    @SubscribeEvent
    public void onRenderTooltip(ItemTooltipEvent ev) {
        Minecraft mc = Minecraft.func_71410_x();
        if ((mc.field_71462_r instanceof GuiGiver || mc.field_71462_r instanceof GuiModifier || giver.func_151463_i() == 0 || !Keyboard.isKeyDown((int)42)) && mc.field_71462_r instanceof GuiMenu) {
            ev.getToolTip().add(TextFormatting.GOLD + "[" + TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.act.leftClick", (Object[])new Object[0]) + TextFormatting.GOLD + "] " + TextFormatting.YELLOW + I18n.func_135052_a((String)(Keyboard.isKeyDown((int)42) ? "gui.act.give.copy" : "gui.act.give.editor"), (Object[])new Object[0]));
            if (Keyboard.isKeyDown((int)42)) {
                ev.getToolTip().add(TextFormatting.GOLD + "[" + TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.act.rightClick", (Object[])new Object[0]) + TextFormatting.GOLD + "] " + TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.act.delete", (Object[])new Object[0]));
            } else if (mc.field_71439_g != null && mc.field_71439_g.func_184812_l_()) {
                ev.getToolTip().add(TextFormatting.GOLD + "[" + TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.act.rightClick", (Object[])new Object[0]) + TextFormatting.GOLD + "] " + TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.act.give.give", (Object[])new Object[0]));
            }
        }
        if (Keyboard.isKeyDown((int)42)) {
            double maxdmg;
            int dmg;
            String s;
            NBTTagCompound compound = ev.getItemStack().func_77978_p();
            String string = s = !ev.getFlags().func_194127_a() ? ev.getItemStack().func_77973_b().getRegistryName().toString() : "";
            if (!(mc.field_71462_r != null && mc.field_71462_r instanceof GuiContainerCreative && ((GuiContainerCreative)mc.field_71462_r).func_147056_g() == CreativeTabs.field_78027_g.func_78021_a() || ev.getItemStack().func_77973_b().func_77640_w() == null)) {
                s = s + TextFormatting.WHITE + (s.isEmpty() ? "" : " ") + "(" + I18n.func_135052_a((String)ev.getItemStack().func_77973_b().func_77640_w().func_78024_c(), (Object[])new Object[0]) + ")";
            }
            if (!s.isEmpty()) {
                ev.getToolTip().add(s);
            }
            if (compound != null && compound.func_150297_b("CustomPotionColor", 99)) {
                ev.getToolTip().add(TextFormatting.GOLD + net.minecraft.util.text.translation.I18n.func_74837_a((String)"item.color", (Object[])new Object[]{TextFormatting.YELLOW + String.format("#%06X", compound.func_74762_e("CustomPotionColor"))}));
            }
            if (!ev.getFlags().func_194127_a()) {
                if (ev.getToolTip().size() != 0) {
                    ev.getToolTip().set(0, (String)ev.getToolTip().get(0) + TextFormatting.WHITE + " (#" + Item.func_150891_b((Item)ev.getItemStack().func_77973_b()) + (ev.getItemStack().func_77960_j() != 0 && !ev.getItemStack().func_77951_h() ? "/" + ev.getItemStack().func_77960_j() : "") + ")" + TextFormatting.WHITE);
                }
                if (compound != null && compound.func_150297_b("display", 10) && compound.func_74775_l("display").func_150297_b("color", 99)) {
                    ev.getToolTip().add(TextFormatting.GOLD + net.minecraft.util.text.translation.I18n.func_74837_a((String)"item.color", (Object[])new Object[]{TextFormatting.YELLOW + String.format("#%06X", compound.func_74775_l("display").func_74762_e("color"))}));
                }
                if (ev.getItemStack().func_77951_h()) {
                    dmg = Math.abs(ev.getItemStack().func_77952_i() - ev.getItemStack().func_77958_k()) + 1;
                    maxdmg = ev.getItemStack().func_77958_k() + 1;
                    ev.getToolTip().add(TextFormatting.YELLOW + I18n.func_135052_a((String)"item.durability", (Object[])new Object[]{'\u00a7' + (dmg < (int)(1.0 * maxdmg) ? "2" : (dmg < (int)(0.75 * maxdmg) ? "a" : (dmg < (int)(0.5 * maxdmg) ? "6" : (dmg < (int)(0.25 * maxdmg) ? "c" : (dmg < (int)(0.1 * maxdmg) ? "4" : "2"))))) + dmg, ev.getItemStack().func_77958_k() + 1}));
                }
            }
            if (compound != null && compound.func_186856_d() != 0) {
                if (ev.getItemStack().func_77978_p().func_74764_b("RepairCost")) {
                    dmg = ev.getItemStack().func_77978_p().func_74762_e("RepairCost");
                    maxdmg = 31.0;
                    ev.getToolTip().add("\u00a7e" + ("RepairCost: " + ('\u00a7' + (dmg < (int)(0.1 * maxdmg) ? "2" : (dmg < (int)(0.25 * maxdmg) ? "a" : (dmg < (int)(0.5 * maxdmg) ? "6" : (dmg < (int)(0.75 * maxdmg) ? "c" : (dmg < (int)(1.0 * maxdmg) ? "4" : "2")))))) + String.valueOf(dmg)));
                }
                ev.getToolTip().add(TextFormatting.GOLD + I18n.func_135052_a((String)"gui.act.tags", (Object[])new Object[0]) + "(" + compound.func_186856_d() + "): " + TextFormatting.YELLOW + compound.func_150296_c().stream().collect(Collectors.joining(TextFormatting.GOLD + ", " + TextFormatting.YELLOW)));
            }
        }
        if (!(mc.field_71462_r instanceof GuiGiver) && !(mc.field_71462_r instanceof GuiModifier) && giver.func_151463_i() != 0 && Keyboard.isKeyDown((int)42)) {
            if (Keyboard.isKeyDown((int)giver.func_151463_i())) {
                mc.func_147108_a((GuiScreen)new GuiGiver(mc.field_71462_r, ev.getItemStack()));
            }
            ev.getToolTip().add(TextFormatting.GOLD + "[" + TextFormatting.YELLOW + Keyboard.getKeyName((int)giver.func_151463_i()) + TextFormatting.GOLD + "] " + TextFormatting.YELLOW + I18n.func_135052_a((String)"cmd.act.opengiver", (Object[])new Object[0]));
            if (menu.func_151463_i() != 0 && menu.func_151463_i() != 0) {
                if (Keyboard.isKeyDown((int)menu.func_151463_i())) {
                    customItems.add(ItemUtils.getGiveCode(ev.getItemStack()));
                    mc.func_147108_a((GuiScreen)new GuiMenu(mc.field_71462_r));
                }
                ev.getToolTip().add(TextFormatting.GOLD + "[" + TextFormatting.YELLOW + Keyboard.getKeyName((int)menu.func_151463_i()) + TextFormatting.GOLD + "] " + TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.act.save", (Object[])new Object[0]));
            }
        }
        if (!Keyboard.isKeyDown((int)42)) {
            ev.getToolTip().add(TextFormatting.YELLOW + Keyboard.getKeyName((int)42) + TextFormatting.GOLD + " " + I18n.func_135052_a((String)"gui.act.shift", (Object[])new Object[0]));
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent ev) {
        Item.field_150901_e.forEach(i -> {
            ACTMod.registerStringModifier(i.func_77658_a() + ".name", "registry.items", sm -> sm.setString(i.getRegistryName().toString()));
            if (i.equals((Object)ADVANCED_ITEM)) {
                return;
            }
            if (i.func_77640_w() == null) {
                ADVANCED_ITEM.addSubitem((Item)i);
            } else {
                NonNullList sub = NonNullList.func_191196_a();
                for (CreativeTabs tab : i.getCreativeTabs()) {
                    i.func_150895_a(tab, sub);
                }
                if (!sub.stream().filter(is -> is.func_77973_b().equals(i) && is.func_77960_j() == 0 && (is.func_77978_p() == null || is.func_77978_p().func_82582_d())).findFirst().isPresent()) {
                    ADVANCED_ITEM.addSubitem((Item)i);
                }
            }
        });
        ForgeRegistries.BLOCKS.forEach(b -> ACTMod.registerStringModifier(b.func_149739_a() + ".name", "registry.blocks", sm -> sm.setString(b.getRegistryName().toString())));
        ForgeRegistries.POTION_TYPES.forEach(p -> ACTMod.registerStringModifier(p.func_185174_b(""), "registry.potions", sm -> sm.setString(p.getRegistryName().toString())));
        ForgeRegistries.BIOMES.forEach(b -> ACTMod.registerStringModifier(b.func_185359_l(), "registry.biomes", sm -> sm.setString(b.getRegistryName().toString())));
        ForgeRegistries.SOUND_EVENTS.forEach(s -> ACTMod.registerStringModifier(s.func_187503_a().toString(), "registry.sounds", sm -> sm.setString(s.func_187503_a().toString())));
        ForgeRegistries.VILLAGER_PROFESSIONS.forEach(vp -> {
            ACTMod.registerStringModifier(vp.getRegistryName().toString(), "registry.villagerProfessions", sm -> sm.setString(vp.getRegistryName().toString()));
            ACTMod.forEachMatchIn(vp, List.class, list -> {
                try {
                    list.forEach(vc -> ACTMod.registerStringModifier(vp.getRegistryName().toString() + " - " + vc.getName(), "registry.villagerProfessions", sm -> sm.setString(vc.getName())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        });
        ForgeRegistries.ENTITIES.forEach(ee -> ACTMod.registerStringModifier(ee.getEgg() != null ? "entity." + ee.getName() + ".name" : ee.getName(), "registry.entities", sm -> sm.setString(ee.getRegistryName().toString())));
        attributes.forEach(at -> ACTMod.registerStringModifier("attribute.name." + at.func_111108_a(), "attributes", sm -> sm.setString(at.func_111108_a())));
        for (EntityEquipmentSlot slot : (EntityEquipmentSlot[])EntityEquipmentSlot.class.getEnumConstants()) {
            ACTMod.registerStringModifier("item.modifiers." + slot.func_188450_d(), "attributes.slot", sm -> sm.setString(slot.func_188450_d()));
        }
        ACTMod.registerStringModifier("gui.act.modifier.string.giver", "", sm -> sm.setNextScreen(new GuiGiver(sm.getNextScreen(), sm.getString(), sm::setString, false)));
        ACTMod.registerStringModifier("gui.act.modifier.string.nbt", "", sm -> {
            try {
                sm.setNextScreen(new GuiNBTModifier(sm.getNextScreen(), nbt -> sm.setString(nbt.toString()), JsonToNBT.func_180713_a((String)sm.getString())));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        ACTMod.registerStringModifier("gui.act.modifier.string.players", "", sm -> {
            List<String> plr;
            try {
                plr = CommandUtils.getPlayerList();
            }
            catch (Exception e) {
                plr = new ArrayList<String>();
                plr.add(Minecraft.func_71410_x().func_110432_I().func_111285_a());
            }
            ArrayList btn = new ArrayList();
            plr.forEach(pn -> btn.add(new Tuple<String, String>((String)pn, (String)pn)));
            sm.setNextScreen(new GuiButtonListSelector<String>(sm.getNextScreen(), btn, s -> {
                sm.setString((String)s);
                return null;
            }));
        });
        ACTMod.registerStringModifier("gui.act.modifier.string.b64.encode", "b64", sm -> {
            try {
                sm.setString(new String(Base64.getEncoder().encode(sm.getString().getBytes())));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ACTMod.registerStringModifier("gui.act.modifier.string.b64.decode", "b64", sm -> {
            try {
                sm.setString(new String(Base64.getDecoder().decode(sm.getString().getBytes())));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent ev) {
        config = new Configuration(ev.getSuggestedConfigurationFile());
        ACTMod.syncConfigs();
        try {
            ClientCommandHandler.instance.func_71560_a((ICommand)ACT_COMMAND);
            ClientCommandHandler.instance.func_71560_a((ICommand)new SimpleCommand("gm", "gm", args -> Minecraft.func_71410_x().field_71439_g.func_71165_d("/gamemode " + CommandBase.func_180529_a((String[])args, (int)0)), new String[0]));
            ClientCommandHandler.instance.func_71560_a((ICommand)new SimpleCommand("gmc", "gmc", args -> Minecraft.func_71410_x().field_71439_g.func_71165_d("/gamemode 1"), new String[0]));
            ClientCommandHandler.instance.func_71560_a((ICommand)new SimpleCommand("gms", "gms", args -> Minecraft.func_71410_x().field_71439_g.func_71165_d("/gamemode 0"), new String[0]));
            LOGGER.info("Commands register.");
        }
        catch (Throwable e) {
            LOGGER.error("Can't register ATEHUD command\n" + e.getMessage());
        }
        giver = new KeyBinding("key.act.giver", 21, MOD_NAME);
        ClientRegistry.registerKeyBinding((KeyBinding)giver);
        menu = new KeyBinding("key.act.menu", 49, MOD_NAME);
        ClientRegistry.registerKeyBinding((KeyBinding)menu);
        edit = new KeyBinding("key.act.edit", 35, MOD_NAME);
        ClientRegistry.registerKeyBinding((KeyBinding)edit);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        attributes.add(SharedMonsterAttributes.field_188791_g);
        attributes.add(SharedMonsterAttributes.field_189429_h);
        attributes.add(SharedMonsterAttributes.field_111264_e);
        attributes.add(SharedMonsterAttributes.field_188790_f);
        attributes.add(SharedMonsterAttributes.field_111265_b);
        attributes.add(SharedMonsterAttributes.field_111266_c);
        attributes.add(SharedMonsterAttributes.field_188792_h);
        attributes.add(SharedMonsterAttributes.field_111267_a);
        attributes.add(SharedMonsterAttributes.field_111263_d);
        ACTMod.registerTemplate("gui.act.menu.template.empty", new ItemStack(Items.field_151121_aF), "");
        ACTMod.registerTemplate("gui.act.menu.template.stone", new ItemStack(Blocks.field_150348_b), ItemUtils.getGiveCode(new ItemStack(Blocks.field_150348_b)));
        ACTMod.registerTemplate("gui.act.menu.template.potion", new ItemStack((Item)Items.field_151068_bn), ItemUtils.getGiveCode(new ItemStack((Item)Items.field_151068_bn)));
        ACTMod.registerTemplate("gui.act.menu.template.fireworks", new ItemStack(Items.field_151152_bP), ItemUtils.getGiveCode(new ItemStack(Items.field_151152_bP)));
        ACTMod.registerTemplate("item.skull.char.name", new ItemStack(Items.field_151144_bL, 1, 3), ItemUtils.getGiveCode(new ItemStack(Items.field_151144_bL, 1, 3)));
        ACTMod.registerTemplate("gui.act.menu.template.command", new ItemStack(Blocks.field_150483_bI), ItemUtils.getGiveCode(new ItemStack(Blocks.field_150483_bI)));
        ACTMod.registerTemplate("item.egg.name", new ItemStack(Items.field_151063_bx), ItemUtils.getGiveCode(new ItemStack(Items.field_151063_bx)));
    }

    @SubscribeEvent
    public void register(RegistryEvent.Register<Item> ev) {
        ev.getRegistry().register((IForgeRegistryEntry)ADVANCED_ITEM);
    }

    static {
        customItems = new ArrayList<String>(Arrays.asList(DEFAULT_CUSTOM_ITEMS));
        templates = new ArrayList<ItemStack>();
        attributes = new HashSet();
        stringModifier = new HashMap<String, Map<String, Consumer<StringModifier>>>();
    }
}

