/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui;

import fr.atesab.act.gui.modifier.GuiColorModifier;
import fr.atesab.act.gui.modifier.GuiModifier;
import fr.atesab.act.utils.GuiUtils;
import fr.atesab.act.utils.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class ColorList {
    private GuiScreen parent;
    private Minecraft mc;
    private FontRenderer fontRenderer;
    private List<Integer> list;
    private String title;
    private int maxElement;
    private int sizeX;
    public int x;
    public int y;

    public ColorList(GuiScreen parent, int x, int y, int sizeX, int[] list, String title, int maxElement) {
        this.list = new ArrayList<Integer>(list.length);
        Arrays.stream(list).forEach(this.list::add);
        this.title = title;
        if (maxElement < 1) {
            throw new IllegalArgumentException("maxElement must be positive");
        }
        this.maxElement = maxElement;
        this.sizeX = sizeX;
        this.x = x;
        this.y = y;
        this.mc = Minecraft.func_71410_x();
        this.fontRenderer = this.mc.field_71466_p;
        this.parent = parent;
    }

    public int[] getColors() {
        return this.list.stream().mapToInt(i -> i).toArray();
    }

    public void drawNext(int mouseX, int mouseY, float zLevel) {
        this.drawNext(mouseX, mouseY, zLevel, 0, 0);
    }

    public void drawNext(int mouseX, int mouseY, float zLevel, int offsetX, int offsetY) {
        offsetX += this.x;
        offsetY += this.y + this.fontRenderer.field_78288_b + 1;
        for (int i = 0; i < this.list.size(); ++i) {
            int x = offsetX + 16 * (i % this.sizeX);
            int y = offsetY + 16 * (i / this.sizeX);
            if (!GuiUtils.isHover(x, y, 15, 15, mouseX, mouseY)) continue;
            List<String> text = Arrays.asList(TextFormatting.GOLD + "[" + TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.act.leftClick", (Object[])new Object[0]) + TextFormatting.GOLD + "] " + TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.act.edit", (Object[])new Object[0]), TextFormatting.GOLD + "[" + TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.act.rightClick", (Object[])new Object[0]) + TextFormatting.GOLD + "] " + TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.act.delete", (Object[])new Object[0]));
            int width = text.stream().mapToInt(arg_0 -> ((FontRenderer)this.fontRenderer).func_78256_a(arg_0)).max().getAsInt();
            int height = text.size() * (this.fontRenderer.field_78288_b + 1);
            Tuple<Integer, Integer> pos = GuiUtils.getRelativeBoxPos(mouseX, mouseY, width, height, this.parent.field_146294_l, this.parent.field_146295_m);
            GuiUtils.drawBox((Integer)pos.a, (Integer)pos.b, width, height, zLevel);
            Tuple<Integer, Integer> tuple = pos;
            Integer.valueOf((Integer)tuple.b + 1);
            tuple.b = tuple.b;
            text.forEach(s -> {
                this.fontRenderer.func_78276_b(s, ((Integer)pos.a).intValue(), ((Integer)pos.b).intValue(), -1);
                pos.b = (Integer)pos.b + (1 + this.fontRenderer.field_78288_b);
            });
        }
    }

    public void draw(int mouseX, int mouseY, float zLevel) {
        this.draw(mouseX, mouseY, zLevel, 0, 0);
    }

    public void draw(int mouseX, int mouseY, float zLevel, int offsetX, int offsetY) {
        int y;
        int x;
        int i;
        GuiUtils.drawCenterString(this.fontRenderer, this.title, (offsetX += this.x) + this.sizeX * 16 / 2, offsetY += this.y, -1);
        offsetY += this.fontRenderer.field_78288_b + 1;
        for (i = 0; i < this.list.size(); ++i) {
            x = offsetX + 16 * (i % this.sizeX);
            y = offsetY + 16 * (i / this.sizeX);
            int c = this.list.get(i) + -16777216;
            GuiUtils.drawGradientRect(x, y, x + 15, y + 15, c, c, zLevel);
        }
        if (i < this.maxElement) {
            x = offsetX + 16 * (i % this.sizeX);
            y = offsetY + 16 * (i / this.sizeX);
            boolean flag = GuiUtils.isHover(x, y, 15, 15, mouseX, mouseY);
            int c = flag ? -4473925 : -6710887;
            GuiUtils.drawGradientRect(x, y, x + 15, y + 15, c, c, zLevel);
            GuiUtils.drawCenterString(this.fontRenderer, "+", x + 8, y, flag ? -16711936 : -16733696, 16);
        }
    }

    public void mouseClick(int mouseX, int mouseY, int mouseButton) {
        int y;
        int x;
        int i;
        for (i = 0; i < this.list.size(); ++i) {
            x = this.x + 16 * (i % this.sizeX);
            y = this.y + this.fontRenderer.field_78288_b + 1 + 16 * (i / this.sizeX);
            int c = this.list.get(i);
            if (!GuiUtils.isHover(x, y, 15, 15, mouseX, mouseY)) continue;
            if (mouseButton == 0) {
                int fi = i;
                this.mc.func_147108_a((GuiScreen)new GuiColorModifier(this.parent, nc -> this.list.set(fi, (Integer)nc), c, 0xFFFFFF));
            } else if (mouseButton == 1) {
                this.list.remove(i);
            } else {
                return;
            }
            GuiModifier.playClick();
            return;
        }
        if (i < this.maxElement && mouseButton == 0 && GuiUtils.isHover(x = this.x + 16 * (i % this.sizeX), y = this.y + this.fontRenderer.field_78288_b + 1 + 16 * (i / this.sizeX), 15, 15, mouseX, mouseY)) {
            GuiModifier.playClick();
            this.list.add(0xFF000000 | new Random().nextInt(0x1000000));
        }
    }
}

