/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui.modifier.nbtelement;

import fr.atesab.act.gui.modifier.GuiListModifier;
import fr.atesab.act.gui.modifier.GuiStringModifier;
import fr.atesab.act.gui.modifier.nbt.GuiNBTModifier;
import fr.atesab.act.gui.modifier.nbtelement.NBTByteElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTDoubleElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTFloatElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTIntArrayElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTIntegerElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTListElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTLongArrayElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTLongElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTShortElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTStringElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTTagElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTUnknownElement;
import fr.atesab.act.utils.GuiUtils;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.TextFormatting;

public abstract class NBTElement
extends GuiListModifier.ListElement
implements Cloneable {
    protected String key;
    protected GuiListModifier<?> parent;

    private static boolean isList(Object object) {
        return object.getClass().isAnnotationPresent(GuiNBTList.class);
    }

    public NBTElement(GuiListModifier<?> parent, String key, int sizeX, int sizeY) {
        super(sizeX + 82, Math.max(NBTElement.isList(parent) ? 22 : 43, sizeY));
        this.key = key;
        this.parent = parent;
        this.buttonList.add(new GuiListModifier.RemoveElementButton(parent, sizeX + 1, 0, 20, 20, this));
        this.buttonList.add(new GuiListModifier.AddElementButton(parent, sizeX + 22, 0, 20, 20, TextFormatting.GREEN + "+", (GuiListModifier.ListElement)this, i -> {
            GuiNBTModifier.ADD_ELEMENT.accept((Integer)i, parent);
            return null;
        }));
        this.buttonList.add(new GuiListModifier.AddElementButton(parent, sizeX + 43, 0, 37, 20, I18n.func_135052_a((String)"gui.act.give.copy", (Object[])new Object[0]), (GuiListModifier.ListElement)this, i -> {
            parent.addListElement((int)i, NBTElement.getElementByBase(parent, key, this.get()));
            return null;
        }));
        if (!NBTElement.isList(parent)) {
            this.buttonList.add(new GuiListModifier.RunElementButton(sizeX + 1, 21, 79, 20, I18n.func_135052_a((String)"gui.act.config.name", (Object[])new Object[0]), () -> this.mc.func_147108_a((GuiScreen)new GuiStringModifier(parent, this.getKey(), nk -> {
                this.key = nk;
            })), null));
        }
    }

    public abstract NBTElement clone();

    @Override
    public void draw(int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        GuiUtils.drawGradientRect(offsetX - 2, offsetY - (6 + this.fontRenderer.field_78288_b), offsetX + this.getSizeX() - 1, offsetY - 2, -1998725667, -2002081110, this.parent.getZLevel());
        GuiUtils.drawGradientRect(offsetX - 2, offsetY - 2, offsetX + this.getSizeX() - 1, offsetY + this.getSizeY() + 2, -2013265920, -2013265920, this.parent.getZLevel());
        String s = this.getType();
        if (!NBTElement.isList(this.parent)) {
            s = this.key + " (" + s + ")";
        }
        GuiUtils.drawString(this.fontRenderer, s, offsetX + 2, offsetY - this.fontRenderer.field_78288_b - 4, -1, this.fontRenderer.field_78288_b + 2);
        super.draw(offsetX, offsetY, mouseX, mouseY, partialTicks);
    }

    public abstract NBTBase get();

    public String getKey() {
        return this.key;
    }

    public abstract String getType();

    @Override
    public boolean match(String search) {
        return (this.key + " (" + I18n.func_135052_a((String)("gui.act.modifier.tag.editor." + this.getType()), (Object[])new Object[0]) + ")").toLowerCase().contains(search.toLowerCase());
    }

    public static NBTElement getElementByBase(GuiListModifier<?> parent, String key, NBTBase base) {
        switch (base.func_74732_a()) {
            case 0: {
                return new NBTTagElement(parent, key, new NBTTagCompound());
            }
            case 1: {
                return new NBTByteElement(parent, key, ((NBTTagByte)base).func_150290_f());
            }
            case 2: {
                return new NBTShortElement(parent, key, ((NBTTagShort)base).func_150289_e());
            }
            case 3: {
                return new NBTIntegerElement(parent, key, ((NBTTagInt)base).func_150287_d());
            }
            case 4: {
                return new NBTLongElement(parent, key, ((NBTTagLong)base).func_150291_c());
            }
            case 5: {
                return new NBTFloatElement(parent, key, Float.valueOf(((NBTTagFloat)base).func_150288_h()));
            }
            case 6: {
                return new NBTDoubleElement(parent, key, ((NBTTagDouble)base).func_150286_g());
            }
            case 8: {
                return new NBTStringElement(parent, key, ((NBTTagString)base).func_150285_a_());
            }
            case 9: {
                return new NBTListElement(parent, key, (NBTTagList)base);
            }
            case 10: {
                return new NBTTagElement(parent, key, (NBTTagCompound)base);
            }
            case 11: {
                return new NBTIntArrayElement(parent, key, (NBTTagIntArray)base);
            }
            case 12: {
                return new NBTLongArrayElement(parent, key, (NBTTagLongArray)base);
            }
        }
        return new NBTUnknownElement(parent, key, base);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface GuiNBTList {
    }
}

