/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act;

import fr.atesab.act.AdvancedCreativeTab;
import fr.atesab.act.AdvancedItem;
import fr.atesab.act.StringModifier;
import fr.atesab.act.command.ACTCommand;
import fr.atesab.act.command.SimpleCommand;
import fr.atesab.act.gui.GuiGiver;
import fr.atesab.act.gui.GuiMenu;
import fr.atesab.act.gui.modifier.GuiModifier;
import fr.atesab.act.gui.modifier.nbt.GuiNBTModifier;
import fr.atesab.act.gui.selector.GuiButtonListSelector;
import fr.atesab.act.utils.ChatUtils;
import fr.atesab.act.utils.CommandUtils;
import fr.atesab.act.utils.GuiUtils;
import fr.atesab.act.utils.ItemUtils;
import fr.atesab.act.utils.Tuple;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundRegistry;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;

@Mod(name="Advanced Creative 2", version="2.1", canBeDeactivated=false, guiFactory="fr.atesab.act.gui.ModGuiFactory", modid="act", clientSideOnly=true, acceptedMinecraftVersions="[1.8.8]")
public class ACTMod {
    public static final String MOD_ID = "act";
    public static final String MOD_NAME = "Advanced Creative 2";
    public static final String MOD_VERSION = "2.1";
    public static final String MOD_LITTLE_NAME = "ACT-Mod";
    public static final String MOD_FACTORY = "fr.atesab.act.gui.ModGuiFactory";
    public static final ACTCommand ACT_COMMAND = new ACTCommand();
    public static final AdvancedItem ADVANCED_ITEM = new AdvancedItem();
    public static final AdvancedCreativeTab ADVANCED_CREATIVE_TAB = new AdvancedCreativeTab();
    public static final String TEMPLATE_TAG_NAME = "TemplateData";
    public static final String[] DEFAULT_CUSTOM_ITEMS = new String[]{ItemUtils.getGiveCode(ItemUtils.buildStack(Blocks.field_150325_L, 42, 2, EnumChatFormatting.LIGHT_PURPLE + "Pink verity", new String[]{"" + EnumChatFormatting.GOLD + EnumChatFormatting.BOLD + "42 is life", "" + EnumChatFormatting.GOLD + EnumChatFormatting.BOLD + "wait what ?"}, new Tuple[0]))};
    private static final Logger LOGGER = LogManager.getLogger((String)"act".toUpperCase());
    private static KeyBinding giver;
    private static KeyBinding menu;
    private static KeyBinding edit;
    private static List<String> customItems;
    private static List<ItemStack> templates;
    private static HashSet<IAttribute> attributes;
    private static long outdatedTime;
    private static Map<String, Map<String, Consumer<StringModifier>>> stringModifier;
    private static Configuration config;
    @Mod.Instance
    public static ACTMod instance;

    private static <T> void forEachMatchIn(Object obj, Class<T> cls, Consumer<T> consumer) {
        for (Field field : obj.getClass().getDeclaredFields()) {
            if (!field.getType().equals(cls)) continue;
            field.setAccessible(true);
            try {
                consumer.accept(field.get(obj));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static HashSet<IAttribute> getAttributes() {
        return attributes;
    }

    public static List<String> getCustomItems() {
        return customItems;
    }

    public static Map<String, Map<String, Consumer<StringModifier>>> getStringModifier() {
        return stringModifier;
    }

    public static String getTemplateData(ItemStack template) {
        return ItemUtils.getCustomTag(template, TEMPLATE_TAG_NAME, null);
    }

    public static Stream<ItemStack> getTemplates() {
        return templates.stream().map(is -> {
            String lang = ItemUtils.getCustomTag(is, "TemplateDataLang", null);
            return is.func_77946_l().func_151001_c(EnumChatFormatting.AQUA + (lang != null ? I18n.func_135052_a((String)lang, (Object[])new Object[0]) : is.func_82833_r()));
        });
    }

    public static void registerStringModifier(String name, Consumer<StringModifier> modifier) {
        ACTMod.registerStringModifier(name, "", modifier);
    }

    public static void registerStringModifier(String name, String category, Consumer<StringModifier> modifier) {
        Map<String, Consumer<StringModifier>> map = stringModifier.get(category);
        if (map == null) {
            map = new HashMap<String, Consumer<StringModifier>>();
            stringModifier.put(category, map);
        }
        map.put(name, modifier);
    }

    public static void registerTemplate(String lang, ItemStack icon, String data) {
        templates.add(ItemUtils.setCustomTag(ItemUtils.setCustomTag(icon.func_77946_l(), TEMPLATE_TAG_NAME, data), "TemplateDataLang", lang));
    }

    public static void saveConfigs() {
        config.get("general", "customItems", DEFAULT_CUSTOM_ITEMS).set(customItems.toArray(new String[customItems.size()]));
        config.get("ihate18", "outdated", String.valueOf(outdatedTime)).set(String.valueOf(outdatedTime));
        config.save();
    }

    public static void syncConfigs() {
        customItems = new ArrayList<String>(Arrays.asList(config.getStringList("customItems", "general", DEFAULT_CUSTOM_ITEMS, "", null, "config.act.custom")));
        try {
            outdatedTime = Long.parseLong(config.getString("outdated", "ihate18", String.valueOf(outdatedTime), ""));
        }
        catch (NumberFormatException e) {
            outdatedTime = 0L;
        }
        config.save();
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent ev) {
        if (giver.func_151468_f()) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiGiver(null));
        } else if (menu.func_151468_f()) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiMenu(null));
        } else if (edit.func_151468_f()) {
            try {
                ACTMod.ACT_COMMAND.SC_EDIT.processSubCommand(null, null, null);
            }
            catch (CommandException e) {
                ChatUtils.error(((Object)((Object)e)).getClass().getName() + ": " + e.getMessage());
            }
        }
    }

    @SubscribeEvent
    public void onRenderTooltip(ItemTooltipEvent ev) {
        Minecraft mc = Minecraft.func_71410_x();
        if ((mc.field_71462_r instanceof GuiGiver || mc.field_71462_r instanceof GuiModifier || giver.func_151463_i() == 0 || !Keyboard.isKeyDown((int)42)) && mc.field_71462_r instanceof GuiMenu) {
            ev.toolTip.add(EnumChatFormatting.GOLD + "[" + EnumChatFormatting.YELLOW + I18n.func_135052_a((String)"gui.act.leftClick", (Object[])new Object[0]) + EnumChatFormatting.GOLD + "] " + EnumChatFormatting.YELLOW + I18n.func_135052_a((String)(Keyboard.isKeyDown((int)42) ? "gui.act.give.copy" : "gui.act.give.editor"), (Object[])new Object[0]));
            if (Keyboard.isKeyDown((int)42)) {
                ev.toolTip.add(EnumChatFormatting.GOLD + "[" + EnumChatFormatting.YELLOW + I18n.func_135052_a((String)"gui.act.rightClick", (Object[])new Object[0]) + EnumChatFormatting.GOLD + "] " + EnumChatFormatting.YELLOW + I18n.func_135052_a((String)"gui.act.delete", (Object[])new Object[0]));
            } else if (mc.field_71439_g != null && mc.field_71439_g.field_71075_bZ.field_75098_d) {
                ev.toolTip.add(EnumChatFormatting.GOLD + "[" + EnumChatFormatting.YELLOW + I18n.func_135052_a((String)"gui.act.rightClick", (Object[])new Object[0]) + EnumChatFormatting.GOLD + "] " + EnumChatFormatting.YELLOW + I18n.func_135052_a((String)"gui.act.give.give", (Object[])new Object[0]));
            }
        }
        if (Keyboard.isKeyDown((int)42)) {
            double maxdmg;
            int dmg;
            String s;
            NBTTagCompound compound = ev.itemStack.func_77978_p();
            String string = s = !ev.showAdvancedItemTooltips ? ev.itemStack.func_77973_b().func_77658_a().toString() : "";
            if (!(mc.field_71462_r != null && mc.field_71462_r instanceof GuiContainerCreative && ((GuiContainerCreative)mc.field_71462_r).func_147056_g() == CreativeTabs.field_78027_g.func_78021_a() || ev.itemStack.func_77973_b().func_77640_w() == null)) {
                s = s + EnumChatFormatting.WHITE + (s.isEmpty() ? "" : " ") + "(" + I18n.func_135052_a((String)ev.itemStack.func_77973_b().func_77640_w().func_78024_c(), (Object[])new Object[0]) + ")";
            }
            if (!s.isEmpty()) {
                ev.toolTip.add(s);
            }
            if (compound != null && compound.func_150297_b("CustomPotionColor", 99)) {
                ev.toolTip.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.color", (Object[])new Object[]{EnumChatFormatting.YELLOW + String.format("#%06X", compound.func_74762_e("CustomPotionColor"))}));
            }
            if (!ev.showAdvancedItemTooltips) {
                if (ev.toolTip.size() != 0) {
                    ev.toolTip.set(0, (String)ev.toolTip.get(0) + EnumChatFormatting.WHITE + " (#" + Item.func_150891_b((Item)ev.itemStack.func_77973_b()) + (ev.itemStack.func_77960_j() != 0 && !ev.itemStack.func_77951_h() ? "/" + ev.itemStack.func_77960_j() : "") + ")" + EnumChatFormatting.WHITE);
                }
                if (compound != null && compound.func_150297_b("display", 10) && compound.func_74775_l("display").func_150297_b("color", 99)) {
                    ev.toolTip.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.color", (Object[])new Object[]{EnumChatFormatting.YELLOW + String.format("#%06X", compound.func_74775_l("display").func_74762_e("color"))}));
                }
                if (ev.itemStack.func_77951_h()) {
                    dmg = Math.abs(ev.itemStack.func_77952_i() - ev.itemStack.func_77958_k()) + 1;
                    maxdmg = ev.itemStack.func_77958_k() + 1;
                    ev.toolTip.add(EnumChatFormatting.YELLOW + I18n.func_135052_a((String)"item.durability", (Object[])new Object[]{'\u00a7' + (dmg < (int)(1.0 * maxdmg) ? "2" : (dmg < (int)(0.75 * maxdmg) ? "a" : (dmg < (int)(0.5 * maxdmg) ? "6" : (dmg < (int)(0.25 * maxdmg) ? "c" : (dmg < (int)(0.1 * maxdmg) ? "4" : "2"))))) + dmg, ev.itemStack.func_77958_k() + 1}));
                }
            }
            if (compound != null && compound.func_150296_c().size() != 0) {
                if (ev.itemStack.func_77978_p().func_74764_b("RepairCost")) {
                    dmg = ev.itemStack.func_77978_p().func_74762_e("RepairCost");
                    maxdmg = 31.0;
                    ev.toolTip.add("\u00a7e" + ("RepairCost: " + ('\u00a7' + (dmg < (int)(0.1 * maxdmg) ? "2" : (dmg < (int)(0.25 * maxdmg) ? "a" : (dmg < (int)(0.5 * maxdmg) ? "6" : (dmg < (int)(0.75 * maxdmg) ? "c" : (dmg < (int)(1.0 * maxdmg) ? "4" : "2")))))) + String.valueOf(dmg)));
                }
                ev.toolTip.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"gui.act.tags", (Object[])new Object[0]) + "(" + compound.func_150296_c().size() + "): " + EnumChatFormatting.YELLOW + compound.func_150296_c().stream().collect(Collectors.joining(EnumChatFormatting.GOLD + ", " + EnumChatFormatting.YELLOW)));
            }
        }
        if (!(mc.field_71462_r instanceof GuiGiver) && !(mc.field_71462_r instanceof GuiModifier) && giver.func_151463_i() != 0 && Keyboard.isKeyDown((int)42)) {
            if (Keyboard.isKeyDown((int)giver.func_151463_i())) {
                mc.func_147108_a((GuiScreen)new GuiGiver(mc.field_71462_r, ev.itemStack));
            }
            ev.toolTip.add(EnumChatFormatting.GOLD + "[" + EnumChatFormatting.YELLOW + Keyboard.getKeyName((int)giver.func_151463_i()) + EnumChatFormatting.GOLD + "] " + EnumChatFormatting.YELLOW + I18n.func_135052_a((String)"cmd.act.opengiver", (Object[])new Object[0]));
            if (menu.func_151463_i() != 0 && menu.func_151463_i() != 0) {
                if (Keyboard.isKeyDown((int)menu.func_151463_i())) {
                    customItems.add(ItemUtils.getGiveCode(ev.itemStack));
                    mc.func_147108_a((GuiScreen)new GuiMenu(mc.field_71462_r));
                }
                ev.toolTip.add(EnumChatFormatting.GOLD + "[" + EnumChatFormatting.YELLOW + Keyboard.getKeyName((int)menu.func_151463_i()) + EnumChatFormatting.GOLD + "] " + EnumChatFormatting.YELLOW + I18n.func_135052_a((String)"gui.act.save", (Object[])new Object[0]));
            }
        }
        if (!Keyboard.isKeyDown((int)42)) {
            ev.toolTip.add(EnumChatFormatting.YELLOW + Keyboard.getKeyName((int)42) + EnumChatFormatting.GOLD + " " + I18n.func_135052_a((String)"gui.act.shift", (Object[])new Object[0]));
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent ev) {
        FMLControlledNamespacedRegistry professions;
        Item.field_150901_e.func_148742_b().forEach(c -> {
            Item i = (Item)Item.field_150901_e.func_82594_a(c);
            ACTMod.registerStringModifier(i.func_77658_a() + ".name", "registry.items", sm -> sm.setString(c.toString()));
            if (i.equals((Object)ADVANCED_ITEM)) {
                return;
            }
            if (i.func_77640_w() == null) {
                ADVANCED_ITEM.addSubitem(i);
            } else {
                ArrayList sub = new ArrayList();
                for (CreativeTabs tab : i.getCreativeTabs()) {
                    i.func_150895_a(i, tab, sub);
                }
                if (!sub.stream().filter(is -> is.func_77973_b().equals(i) && is.func_77960_j() == 0 && (is.func_77978_p() == null || is.func_77978_p().func_82582_d())).findFirst().isPresent()) {
                    ADVANCED_ITEM.addSubitem(i);
                }
            }
        });
        for (int i = 0; i < 32; ++i) {
            ItemStack is = new ItemStack((Item)Items.field_151068_bn, 1, i);
            is.func_77982_d(new NBTTagCompound());
            is.func_77978_p().func_74782_a("CustomPotionEffects", (NBTBase)new NBTTagList());
            ADVANCED_ITEM.addSubitemStack(is);
        }
        Block.field_149771_c.func_148742_b().forEach(b -> ACTMod.registerStringModifier(((Block)Block.field_149771_c.func_82594_a(b)).func_149739_a() + ".name", "registry.blocks", sm -> sm.setString(b.toString())));
        for (BiomeGenBase b2 : BiomeGenBase.func_150565_n()) {
            if (b2 == null) continue;
            ACTMod.registerStringModifier(b2.field_76791_y, "registry.biomes", sm -> sm.setString(b.field_76791_y.toString()));
        }
        SoundRegistry soundRegistry = this.getObject(SoundRegistry.class, Minecraft.func_71410_x().func_147118_V());
        if (soundRegistry != null) {
            soundRegistry.func_148742_b().forEach(rl -> ACTMod.registerStringModifier(rl.toString(), "registry.sounds", sm -> sm.setString(rl.toString())));
        }
        if ((professions = this.getObject(FMLControlledNamespacedRegistry.class, VillagerRegistry.instance())) != null) {
            professions.func_148742_b().forEach(rl -> {
                VillagerRegistry.VillagerProfession vp = (VillagerRegistry.VillagerProfession)professions.getObject(rl);
                ACTMod.registerStringModifier(rl.toString(), "registry.villagerProfessions", sm -> sm.setString(rl.toString()));
                ACTMod.forEachMatchIn(vp, List.class, list -> {
                    try {
                        list.forEach(vc -> {
                            String name = String.valueOf(this.getObject(String.class, vc));
                            ACTMod.registerStringModifier(name, "registry.villagerProfessions", sm -> sm.setString(name));
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            });
        }
        EntityList.func_180124_b().forEach(ee -> ACTMod.registerStringModifier(EntityList.field_75627_a.get(EntityList.func_180122_a((String)ee)) != null ? "entity." + ee + ".name" : ee, "registry.entities", sm -> sm.setString((String)ee)));
        attributes.forEach(at -> ACTMod.registerStringModifier("attribute.name." + at.func_111108_a(), "attributes", sm -> sm.setString(at.func_111108_a())));
        ACTMod.registerStringModifier("gui.act.modifier.string.giver", "", sm -> sm.setNextScreen(new GuiGiver(sm.getNextScreen(), sm.getString(), sm::setString, false)));
        ACTMod.registerStringModifier("gui.act.modifier.string.nbt", "", sm -> {
            try {
                sm.setNextScreen(new GuiNBTModifier(sm.getNextScreen(), nbt -> sm.setString(nbt.toString()), ItemUtils.toJson(sm.getString())));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        ACTMod.registerStringModifier("gui.act.modifier.string.players", "", sm -> {
            List<String> plr;
            try {
                plr = CommandUtils.getPlayerList();
            }
            catch (Exception e) {
                plr = new ArrayList<String>();
                plr.add(Minecraft.func_71410_x().func_110432_I().func_111285_a());
            }
            ArrayList btn = new ArrayList();
            plr.forEach(pn -> btn.add(new Tuple<String, String>((String)pn, (String)pn)));
            sm.setNextScreen(new GuiButtonListSelector<String>(sm.getNextScreen(), btn, s -> {
                sm.setString((String)s);
                return null;
            }));
        });
        ACTMod.registerStringModifier("gui.act.modifier.string.b64.encode", "b64", sm -> {
            try {
                sm.setString(new String(Base64.getEncoder().encode(sm.getString().getBytes())));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ACTMod.registerStringModifier("gui.act.modifier.string.b64.decode", "b64", sm -> {
            try {
                sm.setString(new String(Base64.getDecoder().decode(sm.getString().getBytes())));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private <T> T getObject(Class<T> cls, Object object) {
        for (Field f : object.getClass().getDeclaredFields()) {
            try {
                f.setAccessible(true);
                if (!f.getType().equals(cls)) continue;
                return (T)f.get(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent ev) {
        config = new Configuration(ev.getSuggestedConfigurationFile());
        ACTMod.syncConfigs();
        try {
            ClientCommandHandler.instance.func_71560_a((ICommand)ACT_COMMAND);
            ClientCommandHandler.instance.func_71560_a((ICommand)new SimpleCommand("gm", "gm", args -> Minecraft.func_71410_x().field_71439_g.func_71165_d("/gamemode " + CommandBase.func_180529_a((String[])args, (int)0)), new String[0]));
            ClientCommandHandler.instance.func_71560_a((ICommand)new SimpleCommand("gmc", "gmc", args -> Minecraft.func_71410_x().field_71439_g.func_71165_d("/gamemode 1"), new String[0]));
            ClientCommandHandler.instance.func_71560_a((ICommand)new SimpleCommand("gms", "gms", args -> Minecraft.func_71410_x().field_71439_g.func_71165_d("/gamemode 0"), new String[0]));
            LOGGER.info("Commands register.");
        }
        catch (Throwable e) {
            LOGGER.error("Can't register ATEHUD command\n" + e.getMessage());
        }
        giver = new KeyBinding("key.act.giver", 21, MOD_NAME);
        ClientRegistry.registerKeyBinding((KeyBinding)giver);
        menu = new KeyBinding("key.act.menu", 49, MOD_NAME);
        ClientRegistry.registerKeyBinding((KeyBinding)menu);
        edit = new KeyBinding("key.act.edit", 35, MOD_NAME);
        ClientRegistry.registerKeyBinding((KeyBinding)edit);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        attributes.add(SharedMonsterAttributes.field_111264_e);
        attributes.add(SharedMonsterAttributes.field_111265_b);
        attributes.add(SharedMonsterAttributes.field_111266_c);
        attributes.add(SharedMonsterAttributes.field_111267_a);
        attributes.add(SharedMonsterAttributes.field_111263_d);
        ACTMod.registerTemplate("gui.act.menu.template.empty", new ItemStack(Items.field_151121_aF), "");
        ACTMod.registerTemplate("gui.act.menu.template.stone", new ItemStack(Blocks.field_150348_b), ItemUtils.getGiveCode(new ItemStack(Blocks.field_150348_b)));
        ACTMod.registerTemplate("gui.act.menu.template.potion", new ItemStack((Item)Items.field_151068_bn), ItemUtils.getGiveCode(new ItemStack((Item)Items.field_151068_bn)));
        ACTMod.registerTemplate("gui.act.menu.template.fireworks", new ItemStack(Items.field_151152_bP), ItemUtils.getGiveCode(new ItemStack(Items.field_151152_bP)));
        ACTMod.registerTemplate("item.skull.char.name", new ItemStack(Items.field_151144_bL, 1, 3), ItemUtils.getGiveCode(new ItemStack(Items.field_151144_bL, 1, 3)));
        ACTMod.registerTemplate("gui.act.menu.template.command", new ItemStack(Blocks.field_150483_bI), ItemUtils.getGiveCode(new ItemStack(Blocks.field_150483_bI)));
        ACTMod.registerTemplate("item.egg.name", new ItemStack(Items.field_151063_bx), ItemUtils.getGiveCode(new ItemStack(Items.field_151063_bx)));
        GameRegistry.registerItem((Item)ADVANCED_ITEM, (String)"adv_it", (String)MOD_ID);
    }

    @SubscribeEvent
    public void onInitGui(final GuiScreenEvent.InitGuiEvent ev) {
        if (ev.gui instanceof GuiMainMenu && (System.currentTimeMillis() > outdatedTime + 432000000L || System.currentTimeMillis() - 432000000L > outdatedTime || new Random().nextInt(50) == 42)) {
            ev.gui.field_146297_k.func_147108_a(new GuiScreen(){
                int y = 0;
                int psx = 0;

                protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
                    if (GuiUtils.isHover(this.field_146294_l / 2 - this.psx / 2, this.y, this.psx, 20, mouseX, mouseY)) {
                        outdatedTime = System.currentTimeMillis();
                        ACTMod.saveConfigs();
                        this.field_146297_k.func_147108_a(ev.gui);
                    } else if (GuiUtils.isHover(this.field_146294_l / 2 - this.psx / 2, this.y + 24, this.psx, 20, mouseX, mouseY)) {
                        this.field_146297_k.func_71400_g();
                    }
                    super.func_73864_a(mouseX, mouseY, mouseButton);
                }

                public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
                    this.func_146276_q_();
                    int y = this.field_146295_m / 2 - (this.field_146289_q.field_78288_b + 1) * 4;
                    String[] words = I18n.func_135052_a((String)"gui.act.bad", (Object[])new Object[]{ACTMod.MOD_LITTLE_NAME}).split(" ");
                    boolean sx = false;
                    String line = "";
                    for (int i = 0; i < words.length; ++i) {
                        if (!line.isEmpty()) {
                            if (this.field_146289_q.func_78256_a(line + " " + words[i]) > 400) {
                                GuiUtils.drawCenterString(this.field_146289_q, line, this.field_146294_l / 2, y, -2285022);
                                y += this.field_146289_q.field_78288_b + 1;
                                line = "";
                            } else {
                                line = line + " ";
                            }
                        }
                        line = line + words[i];
                    }
                    if (!line.isEmpty()) {
                        GuiUtils.drawCenterString(this.field_146289_q, line, this.field_146294_l / 2, y, -2285022);
                        y += this.field_146289_q.field_78288_b + 1;
                    }
                    GuiUtils.drawCenterString(this.field_146289_q, "ATE47 " + EnumChatFormatting.LIGHT_PURPLE + "\u2764", this.field_146294_l / 2, y += 4, -2285022);
                    y += this.field_146289_q.field_78288_b + 1;
                    this.y = y += 10;
                    String s = I18n.func_135052_a((String)"gui.act.bad.skip", (Object[])new Object[0]);
                    this.psx = this.field_146289_q.func_78256_a(s) + 10;
                    int c = GuiUtils.isHover(this.field_146294_l / 2 - this.psx / 2, y, this.psx, 20, mouseX, mouseY) ? -56798 : -1;
                    int c2 = GuiUtils.isHover(this.field_146294_l / 2 - this.psx / 2, y + 24, this.psx, 20, mouseX, mouseY) ? -14483678 : -1;
                    GuiUtils.drawBox(this.field_146294_l / 2 - this.psx / 2, y, this.field_146294_l / 2 + this.psx / 2, y + 20, c);
                    GuiUtils.drawCenterString(this.field_146289_q, s, this.field_146294_l / 2, y, c, 20);
                    GuiUtils.drawBox(this.field_146294_l / 2 - this.psx / 2, y + 24, this.field_146294_l / 2 + this.psx / 2, y + 44, c2);
                    GuiUtils.drawCenterString(this.field_146289_q, I18n.func_135052_a((String)"menu.quit", (Object[])new Object[0]), this.field_146294_l / 2, y + 24, c2, 20);
                    super.func_73863_a(mouseX, mouseY, partialTicks);
                }
            });
        }
    }

    static {
        customItems = new ArrayList<String>(Arrays.asList(DEFAULT_CUSTOM_ITEMS));
        templates = new ArrayList<ItemStack>();
        attributes = new HashSet();
        outdatedTime = 0L;
        stringModifier = new HashMap<String, Map<String, Consumer<StringModifier>>>();
    }
}

