/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.command;

import fr.atesab.act.command.node.MainCommand;
import fr.atesab.act.command.node.SubCommand;
import fr.atesab.act.utils.ChatUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class SCHelp
extends SubCommand {
    private final List<String> aliases;
    private final String title;
    private final int elm;

    public static IChatComponent getCommandPage(String commandName, int page, int maxPage) {
        ChatComponentText c = new ChatComponentText("\n");
        if (page != 1) {
            c.func_150257_a(new ChatComponentText("<--").func_150255_a(new ChatStyle().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + commandName + " " + (page - 1))).func_150238_a(EnumChatFormatting.RED)));
        } else {
            c.func_150257_a(new ChatComponentText("<--").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.DARK_GRAY)));
        }
        c.func_150257_a(new ChatComponentText(" | ").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GRAY)));
        if (page != maxPage) {
            c.func_150257_a(new ChatComponentText("-->").func_150255_a(new ChatStyle().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + commandName + " " + (page + 1))).func_150238_a(EnumChatFormatting.RED)));
        } else {
            c.func_150257_a(new ChatComponentText("-->").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.DARK_GRAY)));
        }
        return c;
    }

    public static IChatComponent getHelp(String commandName, SubCommand cmd, ICommandSender sender) {
        ChatComponentText c = new ChatComponentText("\n");
        ChatStyle cs = new ChatStyle().func_150238_a(EnumChatFormatting.GOLD);
        switch (cmd.getClickOption()) {
            case suggestCommand: {
                cs.func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/" + commandName + " " + cmd.getName() + " ")).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ChatComponentText(I18n.func_135052_a((String)"cmd.act.help.click", (Object[])new Object[0])).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW))));
                break;
            }
            default: {
                cs.func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + commandName + " " + cmd.getName())).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ChatComponentText(I18n.func_135052_a((String)"cmd.act.help.do", (Object[])new Object[0])).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW))));
            }
        }
        c.func_150257_a(new ChatComponentText("/" + commandName + " " + cmd.getSubCommandUsage(sender)).func_150255_a(cs));
        c.func_150257_a(new ChatComponentText(" : ").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GRAY)));
        c.func_150257_a(new ChatComponentText(cmd.getDescription()).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.WHITE)));
        return c;
    }

    public SCHelp(String title, int elementByPage) {
        super("help", I18n.func_135052_a((String)"cmd.act.help.cmd", (Object[])new Object[0]), SubCommand.CommandClickOption.suggestCommand);
        this.title = title;
        this.elm = elementByPage;
        this.aliases = new ArrayList<String>();
        this.aliases.add(this.getName());
        this.aliases.add("?");
    }

    @Override
    public List<String> addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) {
        return new ArrayList<String>();
    }

    @Override
    public List<String> getAlias() {
        return this.aliases;
    }

    @Override
    public String getDescription() {
        return I18n.func_135052_a((String)"cmd.act.help.cmd", (Object[])new Object[0]);
    }

    @Override
    public String getSubCommandUsage(ICommandSender sender) {
        return this.getName() + " (" + I18n.func_135052_a((String)"cmd.act.ui.page", (Object[])new Object[0]) + ")";
    }

    public ArrayList<SubCommand> getVisibleSubCommand(MainCommand mainCommand) {
        ArrayList<SubCommand> sc = new ArrayList<SubCommand>();
        for (int i = 0; i < mainCommand.subCommands.size(); ++i) {
            if (!mainCommand.subCommands.get(i).isDisplayInHelp()) continue;
            sc.add(mainCommand.subCommands.get(i));
        }
        return sc;
    }

    @Override
    public void processSubCommand(ICommandSender sender, String[] args, MainCommand mainCommand) throws CommandException {
        ArrayList<SubCommand> sc = this.getVisibleSubCommand(mainCommand);
        int page = 0;
        int maxPage = mainCommand.subCommands.size() / this.elm;
        if (args.length == 1) {
            try {
                page = Integer.valueOf(args[0]) - 1;
                if (page > maxPage) {
                    page = maxPage;
                } else if (page < 0) {
                    page = 0;
                }
            }
            catch (Exception e) {
                ChatUtils.error(I18n.func_135052_a((String)"cmd.act.NaN", (Object[])new Object[]{'\"' + args[0] + '\"'}));
                return;
            }
        }
        IChatComponent help = new ChatComponentText("-- " + I18n.func_135052_a((String)"cmd.act.help", (Object[])new Object[]{this.title}) + " (" + (page + 1) + " / " + (maxPage + 1) + ") --").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED));
        for (int i = page * this.elm; i < (page + 1) * this.elm && i < mainCommand.subCommands.size(); ++i) {
            help.func_150257_a(SCHelp.getHelp(mainCommand.func_71517_b(), mainCommand.subCommands.get(i), sender));
        }
        if (maxPage != 0) {
            help.func_150257_a(SCHelp.getCommandPage(mainCommand.func_71517_b() + " " + this.getName(), page + 1, maxPage + 1));
        }
        ChatUtils.send(help);
    }
}

