/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.command.node;

import fr.atesab.act.command.node.MainCommand;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.BlockPos;

public abstract class SubCommand {
    private String name;
    private String description;
    private CommandClickOption clickOption;
    private boolean displayInHelp;

    public SubCommand(String name, String description, CommandClickOption clickOption) {
        this(name, description, clickOption, true);
    }

    public SubCommand(String name, String description, CommandClickOption clickOption, boolean displayInHelp) {
        this.name = name;
        this.description = description;
        this.clickOption = clickOption;
        this.displayInHelp = displayInHelp;
    }

    public abstract List<String> addTabCompletionOptions(ICommandSender var1, String[] var2, BlockPos var3);

    public int compareTo(SubCommand sub) {
        return this.name.compareToIgnoreCase(sub.getName());
    }

    public abstract List<String> getAlias();

    public CommandClickOption getClickOption() {
        return this.clickOption;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public abstract String getSubCommandUsage(ICommandSender var1);

    public boolean isDisplayInHelp() {
        return this.displayInHelp;
    }

    public abstract void processSubCommand(ICommandSender var1, String[] var2, MainCommand var3) throws CommandException;

    public static enum CommandClickOption {
        doCommand,
        suggestCommand;

    }
}

