/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui.modifier;

import fr.atesab.act.gui.GuiValueButton;
import fr.atesab.act.gui.modifier.GuiArrayModifierTitle;
import fr.atesab.act.gui.modifier.GuiModifier;
import fr.atesab.act.utils.GuiUtils;
import fr.atesab.act.utils.Tuple;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;

public abstract class GuiListModifier<T>
extends GuiModifier<T> {
    protected List<ListElement> elements;
    protected List<ListElement> searchedElements = new ArrayList<ListElement>();
    protected List<ListElement>[] visibleElements;
    private boolean doneButton;
    private boolean cancelButton;
    private int page;
    private int maxPage;
    private int sizeX;
    private GuiButton lastPage;
    private GuiButton nextPage;
    private GuiTextField search;
    protected Tuple<String, Tuple<Runnable, Runnable>>[] buttons;
    private boolean needRedefine = false;
    private int dSize = 42;
    private int paddingLeft = 0;
    private int paddingTop = 0;
    private boolean noAdaptativeSize = false;

    private static int getOrDefault(OptionalInt opt, int defaultValue) {
        return opt.isPresent() ? opt.getAsInt() : defaultValue;
    }

    public void setNoAdaptativeSize(boolean noAdaptativeSize) {
        this.noAdaptativeSize = noAdaptativeSize;
    }

    public boolean isNoAdaptativeSize() {
        return this.noAdaptativeSize;
    }

    public int getPaddingLeft() {
        return this.paddingLeft;
    }

    public void setPaddingLeft(int paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public int getPaddingTop() {
        return this.paddingTop;
    }

    public void setPaddingTop(int paddingTop) {
        this.paddingTop = paddingTop;
    }

    public GuiListModifier(GuiScreen parent, List<ListElement> elements, Consumer<T> setter, boolean doneButton, boolean cancelButton, Tuple<String, Tuple<Runnable, Runnable>> ... buttons) {
        super(parent, setter);
        this.elements = elements;
        this.buttons = buttons;
        this.doneButton = doneButton;
        this.cancelButton = cancelButton;
        this.search = new GuiTextField(0, Minecraft.func_71410_x().field_71466_p, 0, 0, 0, 0);
    }

    public GuiListModifier(GuiScreen parent, List<ListElement> elements, Consumer<T> setter, boolean doneButton, Tuple<String, Tuple<Runnable, Runnable>> ... buttons) {
        this(parent, elements, setter, doneButton, true, buttons);
    }

    public GuiListModifier(GuiScreen parent, List<ListElement> elements, Consumer<T> setter, Tuple<String, Tuple<Runnable, Runnable>> ... buttons) {
        this(parent, elements, setter, true, buttons);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 0: {
                this.set(this.get());
                this.field_146297_k.func_147108_a(this.parent);
                break;
            }
            case 1: {
                this.field_146297_k.func_147108_a(this.parent);
                break;
            }
            case 2: {
                --this.page;
                this.define();
                break;
            }
            case 3: {
                ++this.page;
                this.define();
                break;
            }
            case 4: {
                ((Runnable)((Tuple)((GuiValueButton)button).getValue()).a).run();
            }
        }
        super.func_146284_a(button);
    }

    public void addListElement(ListElement elem) {
        this.elements.add(elem);
        this.needRedefine = true;
    }

    public void addListElement(int i, ListElement elem) {
        this.elements.add(i, elem);
        this.needRedefine = true;
    }

    private void define() {
        int j;
        boolean add;
        block10: {
            this.searchedElements.clear();
            this.elements.stream().filter(le -> le.match(this.search.func_146179_b())).forEach(this.searchedElements::add);
            this.sizeX = GuiListModifier.getOrDefault(this.searchedElements.stream().mapToInt(ListElement::getSizeX).max(), this.field_146294_l - 20 - this.paddingLeft) + this.paddingLeft;
            this.visibleElements = new ArrayList[Math.max(1, (this.field_146294_l - 20) / this.sizeX)];
            for (int i = 0; i < this.visibleElements.length; ++i) {
                this.visibleElements[i] = new ArrayList<ListElement>();
            }
            this.maxPage = 0;
            int pageHeight = this.field_146295_m - 63;
            int currentSize = 0;
            int i = 0;
            for (ListElement elm : this.searchedElements) {
                int sy = this.paddingTop + elm.sizeY;
                if (currentSize + sy > pageHeight) {
                    if ((i = (i + 1) % this.visibleElements.length) == 0) {
                        ++this.maxPage;
                    }
                    currentSize = sy;
                } else {
                    currentSize += sy;
                }
                if (this.page != this.maxPage) continue;
                this.visibleElements[i].add(elm);
            }
            this.maxPage = Math.max(1, this.maxPage + (currentSize == 0 ? 0 : 1));
            if (this.page >= this.maxPage) {
                this.page = this.maxPage - 1;
                this.define();
            }
            add = false;
            if (this.page == 0) {
                for (j = 0; j < this.visibleElements.length && !this.visibleElements[j].isEmpty(); ++j) {
                    for (ListElement le2 : this.visibleElements[j]) {
                        if (!(le2 instanceof AddElementList)) continue;
                        add = true;
                        break block10;
                    }
                }
            } else {
                j = this.visibleElements.length;
            }
        }
        this.dSize = (!add && !this.noAdaptativeSize && j == 1 && this.maxPage == 1 ? this.field_146295_m / 2 - this.visibleElements[0].stream().mapToInt(ListElement::getSizeY).sum() / 2 : 42) + this.paddingTop;
        this.lastPage.field_146124_l = this.page != 0;
        this.nextPage.field_146124_l = this.page + 1 < this.maxPage;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int offsetX;
        int currentSize;
        int i;
        RenderHelper.func_74518_a();
        this.func_146276_q_();
        for (i = 0; i < this.visibleElements.length; ++i) {
            currentSize = this.dSize;
            for (ListElement le : this.visibleElements[i]) {
                offsetX = this.getOffsetX() + this.sizeX * i - le.getSizeX() / 2;
                le.draw(offsetX, currentSize, mouseX - offsetX, mouseY - currentSize, partialTicks);
                currentSize += le.getSizeY() + this.paddingTop;
            }
        }
        GlStateManager.func_179124_c((float)0.0f, (float)1.0f, (float)1.0f);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.search.func_146194_f();
        if (this instanceof GuiArrayModifierTitle) {
            GuiUtils.drawCenterString(this.field_146289_q, ((GuiArrayModifierTitle)((Object)this)).getTitle(), this.field_146294_l / 2, 22, -1, 10);
        }
        GuiUtils.drawRightString(this.field_146289_q, I18n.func_135052_a((String)"gui.act.search", (Object[])new Object[0]) + " : ", this.search.field_146209_f, this.search.field_146210_g, Color.ORANGE.getRGB(), this.search.field_146219_i);
        if (this.field_146297_k.field_71462_r.equals((Object)this)) {
            for (i = 0; i < this.visibleElements.length; ++i) {
                currentSize = this.dSize;
                for (ListElement le : this.visibleElements[i]) {
                    offsetX = this.getOffsetX() + this.sizeX * i - le.getSizeX() / 2;
                    le.drawNext(offsetX, currentSize, mouseX - offsetX, mouseY - currentSize, partialTicks);
                    currentSize += le.getSizeY() + this.paddingTop;
                }
            }
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected abstract T get();

    private int getOffsetX() {
        int i;
        if (this.page == 0) {
            for (i = 0; i < this.visibleElements.length && !this.visibleElements[i].isEmpty(); ++i) {
            }
        } else {
            i = this.visibleElements.length;
        }
        return (this.field_146294_l - this.sizeX * (i - 1) + this.paddingLeft) / 2;
    }

    public void func_73866_w_() {
        int i;
        this.page = 0;
        int l = this.doneButton ? 1 : 0;
        int d = (this.buttons.length + l + (this.cancelButton ? 1 : 0)) * 50;
        int dl = this.field_146294_l / 2 - d;
        int dr = this.field_146294_l / 2 + d;
        if (this.doneButton) {
            this.field_146292_n.add(new GuiButton(0, dl, this.field_146295_m - 21, 99, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        }
        for (i = 0; i < this.buttons.length; ++i) {
            this.field_146292_n.add(new GuiValueButton(4, dl + 100 * (i + l), this.field_146295_m - 21, 99, 20, (String)this.buttons[i].a, this.buttons[i].b));
        }
        if (this.cancelButton) {
            this.field_146292_n.add(new GuiButton(1, dl + 100 * (i + l), this.field_146295_m - 21, 99, 20, I18n.func_135052_a((String)"gui.act.cancel", (Object[])new Object[0])));
        }
        this.lastPage = new GuiButton(2, dl - 21, this.field_146295_m - 21, 20, 20, "<-");
        this.field_146292_n.add(this.lastPage);
        this.nextPage = new GuiButton(3, dr, this.field_146295_m - 21, 20, 20, "->");
        this.field_146292_n.add(this.nextPage);
        int m = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"gui.act.search", (Object[])new Object[0]) + " : ");
        int n = Math.min(600, this.field_146294_l - 20);
        this.search.field_146209_f = (this.field_146294_l - n) / 2 + 6 + m;
        this.search.field_146210_g = this instanceof GuiArrayModifierTitle ? 2 : 18;
        this.search.field_146218_h = n - 18 - m;
        this.search.field_146219_i = 18;
        this.elements.forEach(ListElement::init);
        this.define();
        super.func_73866_w_();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        boolean flag = false;
        block0: for (List<ListElement> lel : this.visibleElements) {
            for (ListElement le2 : lel) {
                if (!le2.isFocused()) continue;
                flag = true;
                continue block0;
            }
        }
        for (List<ListElement> lel : this.visibleElements) {
            lel.forEach(le -> le.keyTyped(typedChar, keyCode));
        }
        if (!flag) {
            this.search.func_146195_b(true);
        }
        if (this.search.func_146206_l()) {
            this.search.func_146201_a(typedChar, keyCode);
            this.page = 0;
            this.define();
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        for (int i = 0; i < this.visibleElements.length; ++i) {
            int currentSize = this.dSize;
            for (ListElement le : this.visibleElements[i]) {
                int offsetX = this.getOffsetX() + this.sizeX * i - le.getSizeX() / 2;
                le.mouseClicked(mouseX - offsetX, mouseY - currentSize, mouseButton);
                currentSize += le.getSizeY() + this.paddingTop;
            }
        }
        this.search.func_146192_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 1) {
            if (GuiUtils.isHover(this.search.field_146209_f, this.search.field_146210_g, this.search.field_146218_h, this.search.field_146219_i, mouseX, mouseY)) {
                this.search.func_146180_a("");
                this.page = 0;
                this.define();
            } else {
                this.field_146292_n.stream().filter(button -> button.field_146127_k == 4 && GuiUtils.isHover(button, mouseX, mouseY)).map(b -> (GuiValueButton)((Object)b)).forEach(b -> ((Runnable)((Tuple)b.getValue()).b).run());
            }
        }
        if (this.needRedefine) {
            this.needRedefine = false;
            this.define();
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void removeListElement(ListElement elem) {
        this.elements.remove(elem);
        this.needRedefine = true;
    }

    public void func_73876_c() {
        this.search.func_146178_a();
        for (List<ListElement> lel : this.visibleElements) {
            lel.forEach(ListElement::update);
        }
        super.func_73876_c();
    }

    public List<ListElement> getElements() {
        return this.elements;
    }

    public static class RemoveElementButton
    extends RunElementButton {
        public RemoveElementButton(GuiListModifier<?> parent, int x, int y, int widthIn, int heightIn, ListElement element) {
            super(x, y, widthIn, heightIn, EnumChatFormatting.RED + "-", () -> {
                parent.elements.remove(element);
                ((GuiListModifier)parent).needRedefine = true;
            }, null);
        }

        public RemoveElementButton(GuiListModifier<?> parent, int x, int y, ListElement element) {
            this(parent, x, y, 200, 20, element);
        }
    }

    public static class ListElement {
        protected FontRenderer fontRenderer;
        protected Minecraft mc;
        protected List<GuiButton> buttonList = new ArrayList<GuiButton>();
        protected List<GuiTextField> fieldList = new ArrayList<GuiTextField>();
        private int sizeX;
        private int sizeY;

        public ListElement(int sizeX, int sizeY) {
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.mc = Minecraft.func_71410_x();
            this.fontRenderer = this.mc.field_71466_p;
        }

        protected void actionPerformed(GuiButton button) {
        }

        public void draw(int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
            this.buttonList.forEach(b -> GuiUtils.drawRelative(this.mc, b, offsetX, offsetY, mouseX, mouseY, partialTicks));
            this.fieldList.stream().filter(GuiTextField::func_146176_q).forEach(tf -> GuiUtils.drawRelative(tf, offsetX, offsetY));
        }

        public void drawNext(int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        }

        public int getSizeX() {
            return this.sizeX;
        }

        public int getSizeY() {
            return this.sizeY;
        }

        public void setSizeX(int sizeX) {
            this.sizeX = sizeX;
        }

        public void setSizeY(int sizeY) {
            this.sizeY = sizeY;
        }

        public void init() {
            this.fieldList.forEach(tf -> tf.func_146195_b(false));
        }

        public boolean isFocused() {
            for (GuiTextField field : this.fieldList) {
                if (!field.func_146206_l()) continue;
                return true;
            }
            return false;
        }

        public void keyTyped(char typedChar, int keyCode) {
            this.fieldList.stream().filter(GuiTextField::func_146176_q).forEach(tf -> tf.func_146201_a(typedChar, keyCode));
        }

        public boolean match(String search) {
            return true;
        }

        public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
            this.buttonList.forEach(b -> {
                if (b.func_146116_c(this.mc, mouseX, mouseY)) {
                    if (b instanceof RunElementButton) {
                        if (((RunElementButton)((Object)b)).getLeft() != null && mouseButton == 0) {
                            GuiModifier.playClick();
                            ((RunElementButton)((Object)b)).getLeft().run();
                        } else if (((RunElementButton)((Object)b)).getLeft() != null && mouseButton == 1) {
                            GuiModifier.playClick();
                            ((RunElementButton)((Object)b)).getRight().run();
                        }
                    } else if (mouseButton == 0) {
                        GuiModifier.playClick();
                        this.actionPerformed((GuiButton)b);
                    } else {
                        this.otherActionPerformed((GuiButton)b, mouseButton);
                    }
                }
            });
            this.fieldList.stream().filter(GuiTextField::func_146176_q).forEach(tf -> {
                if (mouseButton == 1 && GuiUtils.isHover(tf, mouseX, mouseY)) {
                    tf.func_146180_a("");
                    tf.func_146195_b(true);
                } else {
                    tf.func_146192_a(mouseX, mouseY, mouseButton);
                }
            });
        }

        protected void otherActionPerformed(GuiButton button, int mouseButton) {
        }

        public void update() {
            this.fieldList.stream().filter(GuiTextField::func_146176_q).forEach(GuiTextField::func_146178_a);
        }
    }

    public static class ButtonElementList
    extends ListElement {
        private Runnable left;
        private Runnable right;

        public ButtonElementList(int sizeX, int sizeY, int buttonSizeX, int buttonSizeY, String buttonText, Runnable leftAction, Runnable rightAction) {
            super(sizeX, sizeY);
            this.buttonList.add(new GuiButton(0, 0, 0, buttonSizeX, buttonSizeY, buttonText));
            this.left = leftAction;
            this.right = rightAction;
        }

        @Override
        protected void actionPerformed(GuiButton button) {
            if (this.left != null) {
                this.left.run();
            }
            super.actionPerformed(button);
        }

        @Override
        protected void otherActionPerformed(GuiButton button, int mouseButton) {
            if (mouseButton == 1 && this.right != null) {
                this.right.run();
            }
            super.otherActionPerformed(button, mouseButton);
        }
    }

    public static class AddElementList
    extends ListElement {
        private Supplier<ListElement> supplier;
        private GuiListModifier<?> parent;

        public AddElementList(GuiListModifier<?> parent, Supplier<ListElement> builder) {
            this(parent, builder, Math.min(200, GuiListModifier.getOrDefault(parent.elements.stream().mapToInt(ListElement::getSizeX).max(), 100)), 21);
        }

        public AddElementList(GuiListModifier<?> parent, Supplier<ListElement> builder, int sizeX, int sizeY) {
            super(sizeX, Math.max(21, sizeY));
            this.parent = parent;
            this.supplier = builder;
            this.buttonList.add(new GuiButton(0, 0, 0, this.getSizeX(), 20, EnumChatFormatting.GREEN + "+"));
        }

        @Override
        protected void actionPerformed(GuiButton button) {
            ListElement elm = this.supplier.get();
            if (elm != null) {
                this.parent.elements.add(this.parent.elements.size() - 1, this.supplier.get());
            }
            ((GuiListModifier)this.parent).needRedefine = true;
            ((GuiListModifier)this.parent).page = ((GuiListModifier)this.parent).maxPage - 1;
            super.actionPerformed(button);
        }
    }

    public static class AddElementButton
    extends RunElementButton {
        public AddElementButton(GuiListModifier<?> parent, int x, int y, int widthIn, int heightIn, ListElement element, Supplier<ListElement> builder) {
            this(parent, x, y, widthIn, heightIn, EnumChatFormatting.GREEN + "+", element, builder);
        }

        public AddElementButton(GuiListModifier<?> parent, int x, int y, int widthIn, int heightIn, String text, ListElement element, Supplier<ListElement> builder) {
            this(parent, x, y, widthIn, heightIn, text, element, (Integer i) -> (ListElement)builder.get());
        }

        public AddElementButton(GuiListModifier<?> parent, int x, int y, int widthIn, int heightIn, String text, ListElement element, Function<Integer, ListElement> builder) {
            super(x, y, widthIn, heightIn, text, () -> {
                for (int i = 0; i < parent.elements.size(); ++i) {
                    if (!parent.elements.get(i).equals(element)) continue;
                    ListElement elm = (ListElement)builder.apply(i);
                    if (elm == null) break;
                    parent.elements.add(i, elm);
                    break;
                }
                ((GuiListModifier)parent).needRedefine = true;
            }, null);
        }
    }

    public static class RunElementButton
    extends GuiButton {
        private Runnable left;
        private Runnable right;

        public RunElementButton(int x, int y, int widthIn, int heightIn, String text, Runnable left, Runnable right) {
            super(0, x, y, widthIn, heightIn, text);
            this.left = left;
            this.right = right;
        }

        public Runnable getLeft() {
            return this.left;
        }

        public Runnable getRight() {
            return this.right;
        }
    }
}

