/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui.modifier;

import fr.atesab.act.gui.ColorList;
import fr.atesab.act.gui.modifier.GuiListModifier;
import fr.atesab.act.gui.modifier.GuiModifier;
import fr.atesab.act.gui.selector.GuiButtonListSelector;
import fr.atesab.act.utils.GuiUtils;
import fr.atesab.act.utils.ItemUtils;
import fr.atesab.act.utils.Tuple;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;

public class GuiFireworksModifer
extends GuiListModifier<NBTTagCompound> {
    private FireworkMainListElement main;
    private Supplier<GuiListModifier.ListElement> builder = () -> new ExplosionListElement(this, null);

    public GuiFireworksModifer(GuiScreen parent, Consumer<NBTTagCompound> setter, NBTTagCompound tag) {
        super(parent, new ArrayList<GuiListModifier.ListElement>(), setter, new Tuple[0]);
        this.main = new FireworkMainListElement(tag.func_74764_b("Flight") ? tag.func_74762_e("Flight") : 1);
        this.elements.add(this.main);
        ItemUtils.forEachInNBTTagList(tag.func_150295_c("Explosions", 10), base -> this.elements.add(new ExplosionListElement(this, (NBTTagCompound)base)));
        this.elements.add(new GuiListModifier.AddElementList(this, this.builder));
    }

    @Override
    protected NBTTagCompound get() {
        NBTTagCompound newTag = new NBTTagCompound();
        newTag.func_74768_a("Flight", this.main.value);
        NBTTagList explosions = new NBTTagList();
        this.elements.stream().filter(le -> le instanceof ExplosionListElement).forEach(le -> explosions.func_74742_a((NBTBase)((ExplosionListElement)le).exp.getTag()));
        newTag.func_74782_a("Explosions", (NBTBase)explosions);
        return newTag;
    }

    public static class GuiExplosionModifier
    extends GuiModifier<ItemUtils.ExplosionInformation> {
        private ItemUtils.ExplosionInformation exp;
        private ColorList colors;
        private ColorList fadeColors;
        private GuiButton trail;
        private GuiButton flicker;
        private GuiButton type;

        public GuiExplosionModifier(GuiScreen parent, Consumer<ItemUtils.ExplosionInformation> setter, ItemUtils.ExplosionInformation exp) {
            super(parent, setter);
            this.exp = exp.clone();
            this.colors = new ColorList(this, 0, 0, 6, exp.getColors(), I18n.func_135052_a((String)"gui.act.modifier.meta.explosion.color", (Object[])new Object[0]), 24);
            this.fadeColors = new ColorList(this, 0, 0, 6, exp.getFadeColors(), I18n.func_135052_a((String)"gui.act.modifier.meta.explosion.fadeColor", (Object[])new Object[0]), 24);
        }

        private void defineButton() {
            this.type.field_146126_j = I18n.func_135052_a((String)("item.fireworksCharge.type." + this.exp.getType()), (Object[])new Object[0]);
        }

        public void func_73866_w_() {
            this.colors.x = this.field_146294_l / 2;
            this.colors.y = this.field_146295_m / 2 - 42;
            this.fadeColors.x = this.field_146294_l / 2 + 100;
            this.fadeColors.y = this.field_146295_m / 2 - 42;
            this.type = new GuiButton(2, this.field_146294_l / 2 - 200, this.field_146295_m / 2 - 42, 199, 20, I18n.func_135052_a((String)"", (Object[])new Object[0]));
            this.field_146292_n.add(this.type);
            this.trail = new GuiButton(3, this.field_146294_l / 2 - 200, this.field_146295_m / 2 - 21, 199, 20, I18n.func_135052_a((String)"item.fireworksCharge.trail", (Object[])new Object[0]));
            this.field_146292_n.add(this.trail);
            this.flicker = new GuiButton(4, this.field_146294_l / 2 - 200, this.field_146295_m / 2, 199, 20, I18n.func_135052_a((String)"item.fireworksCharge.flicker", (Object[])new Object[0]));
            this.field_146292_n.add(this.flicker);
            this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 100, this.field_146295_m / 2 + 21, 99, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
            this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 - 200, this.field_146295_m / 2 + 21, 99, 20, I18n.func_135052_a((String)"gui.act.cancel", (Object[])new Object[0])));
            this.defineButton();
            super.func_73866_w_();
        }

        protected void func_146284_a(GuiButton button) throws IOException {
            switch (button.field_146127_k) {
                case 0: {
                    this.exp.setColors(this.colors.getColors());
                    this.exp.setFadeColors(this.fadeColors.getColors());
                    this.set(this.exp);
                }
                case 1: {
                    this.field_146297_k.func_147108_a(this.parent);
                    break;
                }
                case 2: {
                    List elements = Arrays.asList(new Tuple<String, Integer>(I18n.func_135052_a((String)"item.fireworksCharge.type.0", (Object[])new Object[0]), 0), new Tuple<String, Integer>(I18n.func_135052_a((String)"item.fireworksCharge.type.1", (Object[])new Object[0]), 1), new Tuple<String, Integer>(I18n.func_135052_a((String)"item.fireworksCharge.type.2", (Object[])new Object[0]), 2), new Tuple<String, Integer>(I18n.func_135052_a((String)"item.fireworksCharge.type.3", (Object[])new Object[0]), 3), new Tuple<String, Integer>(I18n.func_135052_a((String)"item.fireworksCharge.type.4", (Object[])new Object[0]), 4));
                    this.field_146297_k.func_147108_a(new GuiButtonListSelector<Integer>(this, elements, t -> {
                        this.exp.setType((int)t);
                        this.defineButton();
                        return null;
                    }));
                    break;
                }
                case 3: {
                    this.exp.setTrail(!this.exp.isTrail());
                    break;
                }
                case 4: {
                    this.exp.setFlicker(!this.exp.isFlicker());
                }
            }
            super.func_146284_a(button);
        }

        public void func_73876_c() {
            this.trail.packedFGColour = GuiUtils.getRedGreen(this.exp.isTrail());
            this.flicker.packedFGColour = GuiUtils.getRedGreen(this.exp.isFlicker());
            super.func_73876_c();
        }

        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            this.func_146276_q_();
            this.colors.draw(mouseX, mouseY, this.field_73735_i);
            this.fadeColors.draw(mouseX, mouseY, this.field_73735_i);
            super.func_73863_a(mouseX, mouseY, partialTicks);
            this.colors.drawNext(mouseX, mouseY, this.field_73735_i);
            this.fadeColors.drawNext(mouseX, mouseY, this.field_73735_i);
        }

        protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
            this.colors.mouseClick(mouseX, mouseY, mouseButton);
            this.fadeColors.mouseClick(mouseX, mouseY, mouseButton);
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    private static class ExplosionListElement
    extends GuiListModifier.ListElement {
        private ItemUtils.ExplosionInformation exp;
        private GuiFireworksModifer parent;

        public ExplosionListElement(GuiFireworksModifer parent, NBTTagCompound expData) {
            super(204, 29);
            this.exp = ItemUtils.getExplosionInformation(expData);
            this.parent = parent;
            this.buttonList.add(new GuiButton(0, 0, 0, 100, 20, I18n.func_135052_a((String)"gui.act.modifier.meta.explosion", (Object[])new Object[0])));
            this.buttonList.add(new GuiListModifier.RemoveElementButton(parent, 101, 0, 20, 20, this));
            this.buttonList.add(new GuiListModifier.AddElementButton(parent, 122, 0, 20, 20, this, parent.builder));
            this.buttonList.add(new GuiListModifier.AddElementButton(parent, 143, 0, 60, 20, I18n.func_135052_a((String)"gui.act.give.copy", (Object[])new Object[0]), (GuiListModifier.ListElement)this, () -> new ExplosionListElement(parent, this.exp.getTag())));
        }

        @Override
        public boolean match(String search) {
            String s = search.toLowerCase();
            return I18n.func_135052_a((String)"gui.act.modifier.type", (Object[])new Object[0]).toLowerCase().contains(s) || I18n.func_135052_a((String)("item.fireworksCharge.type." + this.exp.getType()), (Object[])new Object[0]).toLowerCase().contains(s) || I18n.func_135052_a((String)"item.fireworksCharge.trail", (Object[])new Object[0]).toLowerCase().contains(s) || I18n.func_135052_a((String)"item.fireworksCharge.flicker", (Object[])new Object[0]).toLowerCase().contains(s) || I18n.func_135052_a((String)"gui.act.modifier.meta.explosion.color", (Object[])new Object[0]).toLowerCase().contains(s) || I18n.func_135052_a((String)"gui.act.modifier.meta.explosion.fadeColor", (Object[])new Object[0]).toLowerCase().contains(s);
        }

        @Override
        protected void actionPerformed(GuiButton button) {
            this.mc.func_147108_a((GuiScreen)new GuiExplosionModifier(this.parent, exp -> {
                this.exp = exp;
            }, this.exp));
            super.actionPerformed(button);
        }

        @Override
        public void drawNext(int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
            if (GuiUtils.isHover(0, 0, 200, 20, mouseX, mouseY)) {
                int j;
                int i;
                ArrayList<String> data = new ArrayList<String>();
                String type = I18n.func_135052_a((String)"gui.act.modifier.type", (Object[])new Object[0]) + " : " + TextFormatting.YELLOW + I18n.func_135052_a((String)("item.fireworksCharge.type." + this.exp.getType()), (Object[])new Object[0]);
                String trail = I18n.func_135052_a((String)"item.fireworksCharge.trail", (Object[])new Object[0]);
                String flicker = I18n.func_135052_a((String)"item.fireworksCharge.flicker", (Object[])new Object[0]);
                String color = I18n.func_135052_a((String)"gui.act.modifier.meta.explosion.color", (Object[])new Object[0]) + " : ";
                String fadeColor = I18n.func_135052_a((String)"gui.act.modifier.meta.explosion.fadeColor", (Object[])new Object[0]) + " : ";
                data.add(type);
                int width = this.fontRenderer.func_78256_a(type);
                if (this.exp.isTrail()) {
                    data.add(trail);
                    width = Math.max(width, this.fontRenderer.func_78256_a(trail));
                }
                if (this.exp.isFlicker()) {
                    data.add(flicker);
                    width = Math.max(width, this.fontRenderer.func_78256_a(flicker));
                }
                if (this.exp.getColors().length != 0) {
                    data.add(color);
                    width = Math.max(width, (this.fontRenderer.field_78288_b + 1) * this.exp.getColors().length + this.fontRenderer.func_78256_a(color));
                }
                if (this.exp.getFadeColors().length != 0) {
                    data.add(fadeColor);
                    width = Math.max(width, (this.fontRenderer.field_78288_b + 1) * this.exp.getFadeColors().length + this.fontRenderer.func_78256_a(fadeColor));
                }
                int height = data.size() * (1 + this.fontRenderer.field_78288_b) + 2;
                Tuple<Integer, Integer> pos = GuiUtils.getRelativeBoxPos(mouseX + offsetX, mouseY + offsetY, width += 2, height, this.parent.field_146294_l, this.parent.field_146295_m);
                GlStateManager.func_179140_f();
                GlStateManager.func_179118_c();
                GlStateManager.func_179097_i();
                GlStateManager.func_179106_n();
                GuiUtils.drawBox((Integer)pos.a, (Integer)pos.b, width, height, this.parent.field_73735_i);
                Tuple<Integer, Integer> tuple = pos;
                Integer n = (Integer)tuple.a;
                tuple.a = (Integer)tuple.a + 1;
                Integer n2 = tuple.a;
                tuple = pos;
                tuple.b = (Integer)tuple.b + 2;
                for (i = 0; i < data.size(); ++i) {
                    this.fontRenderer.func_78276_b((String)data.get(i), ((Integer)pos.a).intValue(), (Integer)pos.b + i * (this.fontRenderer.field_78288_b + 1), -1);
                }
                if (this.exp.getFadeColors().length != 0) {
                    int x = (Integer)pos.a + this.fontRenderer.func_78256_a(fadeColor);
                    int y = (Integer)pos.b + --i * (this.fontRenderer.field_78288_b + 1);
                    for (j = 0; j < this.exp.getFadeColors().length; ++j) {
                        GuiUtils.drawGradientRect(x, y, x + this.fontRenderer.field_78288_b, y + this.fontRenderer.field_78288_b, 0xFF000000 | this.exp.getFadeColors()[j], 0xFF000000 | this.exp.getFadeColors()[j], this.parent.field_73735_i);
                        x += this.fontRenderer.field_78288_b + 1;
                    }
                }
                if (this.exp.getColors().length != 0) {
                    int x = (Integer)pos.a + this.fontRenderer.func_78256_a(color);
                    int y = (Integer)pos.b + --i * (this.fontRenderer.field_78288_b + 1);
                    for (j = 0; j < this.exp.getColors().length; ++j) {
                        GuiUtils.drawGradientRect(x, y, x + this.fontRenderer.field_78288_b, y + this.fontRenderer.field_78288_b, 0xFF000000 | this.exp.getColors()[j], 0xFF000000 | this.exp.getColors()[j], this.parent.field_73735_i);
                        x += this.fontRenderer.field_78288_b + 1;
                    }
                }
            }
            super.drawNext(offsetX, offsetY, mouseX, mouseY, partialTicks);
        }
    }

    private static class FireworkMainListElement
    extends GuiListModifier.ListElement {
        private GuiTextField flight;
        private int value;
        private boolean err;
        private String title = I18n.func_135052_a((String)"item.fireworks.flight", (Object[])new Object[0]);

        public FireworkMainListElement(int flight) {
            super(200, 29);
            if (this.title.endsWith(":")) {
                this.title = this.title.substring(0, this.title.length() - 1);
            }
            this.title = this.title + " : ";
            int l = this.fontRenderer.func_78256_a(this.title + " : ") + 5;
            this.flight = new GuiTextField(0, this.fontRenderer, l, 2, 196 - l, 16);
            this.flight.func_146203_f(6);
            this.flight.func_146180_a("" + flight);
        }

        @Override
        public void init() {
            this.flight.func_146195_b(false);
            super.init();
        }

        @Override
        public boolean isFocused() {
            return this.flight.func_146206_l();
        }

        @Override
        public void draw(int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
            GuiUtils.drawRelative(this.flight, offsetX, offsetY);
            GuiUtils.drawString(this.fontRenderer, this.title, offsetX, offsetY, (this.err ? Color.RED : Color.WHITE).getRGB(), this.flight.field_146219_i);
            super.draw(offsetX, offsetY, mouseX, mouseY, partialTicks);
        }

        @Override
        public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
            this.flight.func_146192_a(mouseX, mouseY, mouseButton);
            if (GuiUtils.isHover(this.flight, mouseX, mouseY) && mouseButton == 1) {
                this.flight.func_146180_a("");
            }
            super.mouseClicked(mouseX, mouseY, mouseButton);
        }

        @Override
        public void update() {
            this.flight.func_146178_a();
            try {
                this.value = this.flight.func_146179_b().isEmpty() ? 0 : Integer.valueOf(this.flight.func_146179_b());
                this.err = false;
            }
            catch (NumberFormatException e) {
                this.err = true;
            }
            super.update();
        }

        @Override
        public void keyTyped(char typedChar, int keyCode) {
            this.flight.func_146201_a(typedChar, keyCode);
            super.keyTyped(typedChar, keyCode);
        }
    }
}

