/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.blocks;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.blocks.IWaterLoggable;
import com.endertech.minecraft.forge.blocks.RelatedBlock;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adchimneys.init.MaterialGroup;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class Container
extends RelatedBlock
implements ISmokeContainer,
IWaterLoggable {
    private final ColorARGB color;

    public Container(AbstractForgeMod mod, UnitConfig config, Properties<?> props) {
        super(mod, config, props.block(props.block.m_60977_().m_60955_()));
        this.color = UnitConfig.getColorARGB((UnitConfig)config, (String)this.getUnitCategory(), (String)"color", (ColorARGB)props.color, (String)"Defines a color in ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb) which will be applied to the smoke.\nThe alpha channel of this color (aa) determines probability of applying (ff - always, 7f - 1/2, 00 - never).\n");
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return IWaterLoggable.getFluidState((BlockState)state, (boolean)false);
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return Shapes.m_83144_();
    }

    public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        return true;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return IWaterLoggable.updateFluidPostPlacement((LevelAccessor)worldIn, (BlockPos)currentPos, (BlockState)stateIn);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return IWaterLoggable.getStateForPlacement((BlockPlaceContext)context, (BlockState)this.m_49966_());
    }

    public MaterialGroup getMaterialGroup() {
        String blockName = this.getRegistryName().m_135815_();
        if (blockName.contains("hardened_clay")) {
            return MaterialGroup.TERRACOTTA;
        }
        for (MaterialGroup group : MaterialGroup.values()) {
            if (!blockName.contains(group.getName())) continue;
            return group;
        }
        return MaterialGroup.OTHER;
    }

    public ColorARGB getColor() {
        return this.color;
    }

    public boolean isEnabled() {
        if (!this.isChimney() && !this.isOpaqueMaterial(this.m_49966_())) {
            return false;
        }
        return super.isEnabled() && this.getMaterialGroup().isEnabled();
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    public boolean isOpaqueMaterial(BlockState state) {
        return state.m_60767_().m_76337_() && state.m_60767_() != Material.f_76275_;
    }

    public String toString() {
        return Container.class.getSimpleName() + Args.group((Object[])new Object[]{Args.get((String)"color", (Object)this.getColor().getHexARGB()), Args.get((String)"relatedUnitId", (Object)this.getRelatedId())});
    }

    public static class Properties<T extends Properties<T>>
    extends RelatedBlock.Properties<T> {
        public ColorARGB color = ColorARGB.DEFAULT;

        protected Properties(Class<T> selfClass) {
            super(selfClass);
        }

        public static Properties<?> withId(UnitId id) {
            Properties<Properties> props = new Properties<Properties>(Properties.class);
            return (Properties)props.id(id);
        }

        public T color(int argb) {
            return this.color(ColorARGB.from((int)argb));
        }

        public T color(ColorARGB color) {
            this.color = color;
            return (T)((Object)((Properties)this.self));
        }
    }
}

