/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.blocks;

import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.blocks.ITiledBlock;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.ForgeEnergy;
import com.endertech.minecraft.forge.items.ItemGroup;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.tiles.ForgeTile;
import com.endertech.minecraft.forge.units.ITickableUnit;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import com.endertech.minecraft.mods.adchimneys.blocks.Container;
import com.endertech.minecraft.mods.adchimneys.blocks.Vent;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;

public class Pump
extends Vent
implements ITiledBlock<Tile> {
    public static final ItemGroup ITEM_GROUP = ItemGroup.labeled((String)"pumps").changeEvery(3.0f, 6.0f);
    public static boolean invertedRedstoneSignal;
    public static ForgeEnergy.StorageProps energyStorageProps;
    protected static final VoxelShape HOLES_TOP;
    protected static final VoxelShape SHAPE;

    public Pump(AbstractForgeMod mod, UnitConfig config, Container.Properties<?> props) {
        super(mod, config, props);
    }

    public Tile createTile(BlockPos pos, BlockState state) {
        return new Tile(pos, state);
    }

    public Class<Tile> getTileClass() {
        return Tile.class;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Override
    public boolean isActive(BlockGetter world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof Tile) {
            return ((Tile)tile).isActive();
        }
        return false;
    }

    @Override
    public ISmokeContainer.Type getType() {
        return ISmokeContainer.Type.PUMP;
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return this.isActive(world, pos) ? 1 : super.getLightEmission(state, world, pos);
    }

    static {
        HOLES_TOP = Shapes.m_83124_((VoxelShape)Pump.m_49796_((double)3.0, (double)13.0, (double)3.0, (double)13.0, (double)16.0, (double)6.0), (VoxelShape[])new VoxelShape[]{Pump.m_49796_((double)3.0, (double)13.0, (double)10.0, (double)13.0, (double)16.0, (double)13.0), Pump.m_49796_((double)3.0, (double)13.0, (double)3.0, (double)6.0, (double)16.0, (double)13.0), Pump.m_49796_((double)10.0, (double)13.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0)});
        VoxelShape hopper = Shapes.m_83124_((VoxelShape)Pump.m_49796_((double)3.0, (double)11.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0), (VoxelShape[])new VoxelShape[]{Pump.m_49796_((double)4.0, (double)7.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0), Pump.m_49796_((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0)});
        VoxelShape shape = Shapes.m_83148_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Shapes.m_83124_((VoxelShape)HOLE_CENTER, (VoxelShape[])new VoxelShape[]{HOLES_X, HOLES_Z, HOLES_TOP}), (BooleanOp)BooleanOp.f_82685_);
        SHAPE = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)hopper);
    }

    public static class Tile
    extends ForgeTile
    implements ITickableUnit {
        private final GameTime updateInterval = GameTime.second();
        protected final ForgeEnergy.Storage energyStorage = ForgeEnergy.Storage.with((ForgeEnergy.StorageProps)energyStorageProps);
        protected final LazyOptional<ForgeEnergy.Storage> energyStorageHolder = LazyOptional.of(() -> this.energyStorage);

        public Tile(BlockPos pos, BlockState state) {
            super(AdChimneys.getInstance().tiles.pump, pos, state);
        }

        protected boolean isEmitterConnected() {
            if (this.f_58857_ == null) {
                return false;
            }
            BlockPos checkPos = this.m_58899_().m_7494_();
            if (GameWorld.SmokeContainers.isChimney((LevelReader)this.f_58857_, (BlockPos)checkPos)) {
                checkPos = GameWorld.SmokeContainers.getTopmostChimney((LevelReader)this.f_58857_, (BlockPos)checkPos);
                checkPos = checkPos.m_7494_();
            }
            return AdChimneys.getInstance().emitters.get((LevelReader)this.f_58857_, checkPos).isPresent();
        }

        @Nullable
        public Level getWorldLevel() {
            return this.m_58904_();
        }

        public boolean isActive() {
            if (this.f_58857_ == null) {
                return false;
            }
            boolean powered = this.f_58857_.m_46753_(this.m_58899_());
            if (invertedRedstoneSignal) {
                boolean bl = powered = !powered;
            }
            if (this.energyStorage.isEnabled() && !this.energyStorage.hasEnoughEnergy()) {
                powered = false;
            }
            return powered;
        }

        public boolean exists() {
            return !this.m_58901_();
        }

        public GameTime getUpdateInterval() {
            return this.updateInterval;
        }

        public void onUpdate() {
            if (this.f_58857_ != null && GameWorld.isServerSide((LevelReader)this.f_58857_) && this.isActive()) {
                this.energyStorage.consumeEnergy();
                BlockPos outletPos = this.m_58899_().m_7494_();
                if (!(!this.f_58857_.m_46859_(outletPos) && Block.m_49863_((LevelReader)this.f_58857_, (BlockPos)outletPos, (Direction)Direction.DOWN) || this.isEmitterConnected())) {
                    List vents = GameWorld.SmokeContainers.getVentsAround((LevelReader)this.f_58857_, (BlockPos)this.m_58899_());
                    vents.add(this.m_58899_());
                    Vent.Pipe.build(this.f_58857_, vents, outletPos);
                }
            }
        }

        public void m_7651_() {
            super.m_7651_();
            this.energyStorageHolder.invalidate();
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            if (cap == CapabilityEnergy.ENERGY && this.energyStorage.isEnabled()) {
                return this.energyStorageHolder.cast();
            }
            return super.getCapability(cap, side);
        }

        public void readSharedData(CompoundTag compound) {
            this.energyStorage.readFrom(compound);
        }

        public CompoundTag writeSharedData(CompoundTag compound) {
            this.energyStorage.writeTo(compound);
            return compound;
        }
    }
}

