/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.blocks;

import com.endertech.minecraft.forge.blocks.IPollutant;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.blocks.IWaterLoggable;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.items.ItemGroup;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adchimneys.blocks.Container;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Vent
extends Container {
    public static final ItemGroup ITEM_GROUP = ItemGroup.labeled((String)"vents").changeEvery(3.0f, 6.0f);
    protected static final VoxelShape HOLE_CENTER = Vent.m_49796_((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    protected static final VoxelShape HOLES_Z = Shapes.m_83110_((VoxelShape)Vent.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)6.0, (double)13.0, (double)16.0), (VoxelShape)Vent.m_49796_((double)10.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0));
    protected static final VoxelShape HOLES_X = Shapes.m_83110_((VoxelShape)Vent.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)6.0), (VoxelShape)Vent.m_49796_((double)0.0, (double)3.0, (double)10.0, (double)16.0, (double)13.0, (double)13.0));
    protected static final VoxelShape HOLES_BOTTOM = Shapes.m_83124_((VoxelShape)Vent.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)6.0, (double)3.0, (double)6.0), (VoxelShape[])new VoxelShape[]{Vent.m_49796_((double)10.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)6.0), Vent.m_49796_((double)3.0, (double)0.0, (double)10.0, (double)6.0, (double)3.0, (double)13.0), Vent.m_49796_((double)10.0, (double)0.0, (double)10.0, (double)13.0, (double)3.0, (double)13.0)});
    protected static final VoxelShape SHAPE;

    public Vent(AbstractForgeMod mod, UnitConfig config, Container.Properties<?> props) {
        super(mod, config, props);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public ISmokeContainer.Type getType() {
        return ISmokeContainer.Type.VENT;
    }

    public boolean isActive(BlockGetter world, BlockPos pos) {
        return !IWaterLoggable.isWaterlogged((BlockState)world.m_8055_(pos));
    }

    static {
        VoxelShape core = Vent.m_49796_((double)3.0, (double)5.0, (double)3.0, (double)13.0, (double)11.0, (double)13.0);
        VoxelShape shape = Shapes.m_83148_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Shapes.m_83124_((VoxelShape)HOLE_CENTER, (VoxelShape[])new VoxelShape[]{HOLES_X, HOLES_Z, HOLES_BOTTOM}), (BooleanOp)BooleanOp.f_82685_);
        SHAPE = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)core);
    }

    public static class Pipe
    extends WorldSearch.BlockChain {
        private final BlockPos outletPos;

        protected Pipe(Level world, BlockPos startPos, BlockPos outletPos) {
            super((LevelAccessor)world, startPos, ((Integer)GameWorld.SmokeContainers.maxVentPipeLength.get()).intValue());
            this.outletPos = outletPos;
        }

        public static void build(Level world, List<BlockPos> startPositions, BlockPos outletPos) {
            ArrayList<Pipe> builtPipes = new ArrayList<Pipe>();
            block0: for (BlockPos pos : startPositions) {
                for (Pipe pipe : builtPipes) {
                    if (!pipe.getChain().contains(pos)) continue;
                    continue block0;
                }
                Pipe pipe = new Pipe(world, pos, outletPos);
                pipe.build();
                builtPipes.add(pipe);
            }
        }

        protected Collection<Direction> getDirections() {
            return GameWorld.Directions.of().all().shuffle().toList();
        }

        protected boolean isValidPath(BlockPos pos) {
            return GameWorld.SmokeContainers.isVent((LevelReader)this.world, (BlockPos)pos);
        }

        protected boolean isValidBlock(BlockPos pos) {
            return this.isValidPath(pos) || GameWorld.SmokeContainers.isPump((LevelReader)this.world, (BlockPos)pos);
        }

        protected boolean onValidFound(BlockPos foundPos) {
            ArrayList<Direction> directions = new ArrayList<Direction>();
            directions.add(Direction.DOWN);
            directions.addAll(GameWorld.Directions.of().horizontals().shuffle().toList());
            block0: for (Direction facing : directions) {
                for (int dist = 1; dist <= (Integer)GameWorld.SmokeContainers.ventInhaleDistance.get() && (facing != Direction.DOWN || dist <= 1 && !GameWorld.SmokeContainers.isPump((LevelReader)this.world, (BlockPos)foundPos)); ++dist) {
                    IPollutant pollutant;
                    BlockPos pos = foundPos.m_5484_(facing, dist);
                    BlockState state = this.world.m_8055_(pos);
                    if (GameWorld.isAirBlock((LevelReader)this.world, (BlockPos)pos)) continue;
                    if (state.m_60734_() instanceof IPollutant && (pollutant = (IPollutant)state.m_60734_()).getPollutantType() == IPollutant.Type.AIR) {
                        if (this.pumpOutletWith(pollutant, pos, state)) continue block0;
                        return false;
                    }
                    if (state.m_60783_((BlockGetter)this.world, pos, facing) || state.m_60783_((BlockGetter)this.world, pos, facing.m_122424_())) continue block0;
                }
            }
            return true;
        }

        private boolean pumpOutletWith(IPollutant pollutant, BlockPos pos, BlockState state) {
            int count = 0;
            if (GameWorld.SmokeContainers.isChimney((LevelReader)this.world, (BlockPos)this.outletPos) || pollutant.canPassThrough((LevelReader)this.world, this.outletPos, Direction.DOWN, Direction.UP)) {
                int amount = pollutant.getCarriedPollutionAmount(state);
                count += pollutant.pumpEntitiesAt(this.world, this.outletPos, amount);
            }
            if (count > 0) {
                pollutant.spend(this.world, pos, count);
            }
            return count > 0;
        }
    }
}

