/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.init;

import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.units.EmittersInit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adchimneys.smoke.Emitter;
import com.endertech.minecraft.mods.adchimneys.smoke.EmitterWithRandomColor;
import com.endertech.minecraft.mods.adchimneys.smoke.ISmokeEmitter;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class Emitters
extends EmittersInit<Emitter, BuiltInEmitters> {
    public Emitters(AbstractForgeMod mod) {
        super(mod, BuiltInEmitters.class);
    }

    public Emitter createCustomUnitFrom(UnitConfig config, String name) {
        UnitId id = UnitId.from((Path)config.getConfigFile().toPath());
        return new Emitter(config, (Emitter.Properties<?>)((Object)((Emitter.Properties)Emitter.Properties.with().id(id)).smoke(2, 1.0f)));
    }

    public Emitter createDefaultUnitFrom(UnitConfig config, BuiltInEmitters e) {
        return e.props.factory.orElse(Emitter::new).apply(config, e.props);
    }

    public Optional<Emitter> get(LevelReader reader, BlockPos pos) {
        BlockState state;
        Block block;
        if (reader.m_46805_(pos) && (block = (state = reader.m_8055_(pos)).m_60734_()) instanceof ISmokeEmitter) {
            return Optional.of(((ISmokeEmitter)block).getEmitter(reader, pos));
        }
        return super.get(reader, pos);
    }

    static enum BuiltInEmitters implements IForgeEnum
    {
        brickfurnace$brick_furnace((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f))).color(295063357))),
        brickfurnace$brick_blast_furnace((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.5f))).color(290795557))),
        brickfurnace$brick_smoker((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 0.5f))).color(295195714))),
        ceramics$kiln((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f))).color(298084176))),
        environmental$kiln((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f))).color(291981363))),
        jumbofurnace$jumbo_furnace((Emitter.Properties)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().metadata("[lit=true, x=1, y=1, z=0]")).smoke(3, 1.5f))).color(0x11808080).relatedBlocks(new String[]{"jumbofurnace:jumbo_furnace:*"})),
        immersiveengineering$alloy_smelter((Emitter.Properties)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().metadata("[active=true, multiblockslave=false]")).smoke(3, 1.2f))).color(293159744).relatedBlocks(new String[]{"immersiveengineering:alloy_smelter:[multiblockslave=true]"})),
        immersiveengineering$coke_oven((Emitter.Properties)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().metadata("[active=true, multiblockslave=false]")).smoke(3, 1.5f))).color(0x11333333).relatedBlocks(new String[]{"immersiveengineering:coke_oven:[multiblockslave=true]"})),
        immersiveengineering$blast_furnace((Emitter.Properties)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().metadata("[active=true, multiblockslave=false]")).smoke(3, 1.5f))).color(291450657).relatedBlocks(new String[]{"immersiveengineering:blast_furnace:[multiblockslave=true]"})),
        immersiveengineering$advanced_blast_furnace((Emitter.Properties)((Emitter.Properties)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().metadata("[active=true, multiblockslave=false]")).smoke(3, 1.5f))).color(291450657))).notEmitAside().relatedBlocks(new String[]{"immersiveengineering:advanced_blast_furnace:[multiblockslave=true]"})),
        industrialforegoing$biofuel_generator((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().activeTag("progressBar/Tick")).smoke(2, 1.0f))).color(293816094))),
        industrialforegoing$pitiful_generator((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().activeTag("progressBar/Tick")).smoke(2, 1.0f))).color(291257388))),
        ironfurnaces$iron_furnace((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f))).color(0x11727272))),
        ironfurnaces$silver_furnace((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.5f))).color(0x11818D8D))),
        ironfurnaces$copper_furnace((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.5f))).color(300061756))),
        ironfurnaces$gold_furnace((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.5f))).color(301382435))),
        ironfurnaces$diamond_furnace((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(3, 2.0f))).color(289201634))),
        ironfurnaces$emerald_furnace((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(3, 2.0f))).color(287359535))),
        ironfurnaces$obsidian_furnace((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(3, 2.0f))).color(287512370))),
        ironfurnaces$crystal_furnace((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(3, 2.5f))).color(287553270))),
        ironfurnaces$netherite_furnace((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(4, 4.0f))).color(287579679))),
        ironfurnaces$million_furnace((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f))).color(0x11FFFFFF))).customFactory(EmitterWithRandomColor::new))),
        mekanism$fuelwood_heater((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f))).color(293232211))),
        mekanismgenerators$gas_burning_generator((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f))).color(289291585))),
        mekanismgenerators$bio_generator((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 0.5f))).color(289291585))),
        mekanismgenerators$heat_generator((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.5f))).color(289291585))),
        minecraft$campfire((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().id("campfire:[lit=true, signal_fire=false]")).smoke(1, 0.1f))).color(587163136))).maxGapLength(2))),
        minecraft$campfire_signal((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().id("campfire:[lit=true, signal_fire=true]")).smoke(2, 0.5f))).color(-1140890112))).maxGapLength(2))),
        minecraft$soul_campfire((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().id("soul_campfire:[lit=true, signal_fire=false]")).smoke(1, 0.1f))).color(578614005))).maxGapLength(2))),
        minecraft$soul_campfire_signal((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().id("soul_campfire:[lit=true, signal_fire=true]")).smoke(2, 0.5f))).color(-1149439243))).maxGapLength(2))),
        minecraft$furnace((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f))).color(0x11808080))),
        minecraft$blast_furnace((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.5f))).color(289291585))),
        minecraft$smoker((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 0.5f))).color(291851819))),
        pneumaticcraft$air_compressor((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)((Object)Emitter.Properties.with().activeProperty("on"))).smoke(2, 1.0f))).color(0x11808080))),
        pneumaticcraft$advanced_air_compressor((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)((Object)Emitter.Properties.with().activeProperty("on"))).smoke(2, 1.0f))).color(0x11484848))),
        silents_mechanisms$coal_generator((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(3, 1.5f))).color(0x11707070))),
        silents_mechanisms$lava_generator((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 0.5f))).color(585140798))),
        silents_mechanisms$diesel_generator((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.5f))).color(299558467))),
        tconstruct$melter((Emitter.Properties)((Emitter.Properties)((Object)((Emitter.Properties)((Object)((Emitter.Properties)((Emitter.Properties)Emitter.Properties.with().stateActive()).activeTag("fuel")).notEmitWithoutChimney())).smoke(2, 1.0f))).color(0x11000000).relatedBlocks(new String[]{"#tconstruct:melter_tanks"})),
        tconstruct$smeltery_controller((Emitter.Properties)((Emitter.Properties)((Object)((Emitter.Properties)((Object)((Emitter.Properties)((Emitter.Properties)Emitter.Properties.with().stateActive()).activeTag("fuel")).notEmitWithoutChimney())).smoke(2, 1.0f))).color(298350922).relatedBlocks(new String[]{"#tconstruct:smeltery/wall", "#tconstruct:smeltery/floor"})),
        thermal$dynamo_stirling((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f))).color(291067735))),
        thermal$dynamo_compression((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f))).color(297588455))),
        thermal$dynamo_magmatic((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f))).color(295742885))),
        thermal$machine_furnace((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f))).color(296993474))),
        thermal$machine_smelter((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f))).color(296993474)));

        final Emitter.Properties<?> props;

        private BuiltInEmitters(Emitter.Properties<?> props) {
            this.props = (Emitter.Properties)props.emptyToEnumId(this, true);
        }
    }
}

